import 'dlo/js/services/profile.svc.js';
import { ServiceTypes } from 'ediscovery/common/js/constants.js';

import { commonPlanModule } from 'common/js/modules';

let planModule = commonPlanModule;

planModule.filter('arrayToString', function() {
	return function(value) {
		if (angular.isUndefined(value) || value.length == 0) {
			return '';
		}
		return value.join();
	};
});

planModule.directive('cvPlanDcpolicyFilefilters', [
	function() {
		return {
			restrict: 'E',
			templateUrl: appUtil.appRoot + 'modules/plan/partials/fileFilters.jsp',
			controllerAs: 'model',
			require: ['?^^cvSubmit', '?^^form'],
			bindToController: {
				ciPolicy: '=',
				targetApp: '=',
				planConfiguration: '=',
				readOnly: '@'
			},
			scope: {},
			link: function(scope, elem, attr, controllers) {
				scope.submitCtrl = controllers[0];
				scope.formCtrl = controllers[1];
			},
			controller: [
				'$scope',
				'$log',
				'cvLoc',
				'cvUtil',
				'profileService',
				function($scope, $log, cvLoc, cvUtil, profileService) {
					let self = this;
					this.ServiceTypes = ServiceTypes;
					this.$onInit = function() {
						self.maxDocSize = 50;
						//Additional settings to show 'Enable copy precedence'
						self.showCopyPrecedence =
							cv &&
							cv.additionalSettings &&
							cv.additionalSettings.AdminConsole &&
							cv.additionalSettings.AdminConsole.enableCopyPrecedence;

						//To make the options visible by default when CI is selected
						if (_.get(self, 'ciPolicy.detail.ciPolicy.opType') !== 'METADATA') {
							self.enableContentFilter = true;

							if (angular.isDefined(self.ciPolicy.detail.ciPolicy.copyPrecedence)) {
								self.copyPrecedence = self.ciPolicy.detail.ciPolicy.copyPrecedence;
							} else {
								self.copyPrecedence = 0;
								self.ciPolicy.detail.ciPolicy.copyPrecedence = 0;
							}
						}

						let filters = {
							fileFilters: {
								includeDocTypes:
									'*.doc,*.docx,*.xls,*.xlsx,*.ppt,*.pptx,*.msg,*.txt,*.rtf,*.eml,*.pdf,*.htm,*.html,*.csv,*.log,*.ods,*.odt,*.odg,*.odp,*.dot,*.pages,*.xmind',
								excludePaths: ['C:\\Program Files', 'C:\\Program Files (x86)', 'C:\\Windows'],
								minDocSize: 0,
								maxDocSize: 50
							}
						};

						self.enableFiltersChanged = function() {
							if (self.enableContentFilter) {
								angular.copy(filters, self.ciPolicy.detail.ciPolicy.filters);
							} else {
								angular.copy(self.ciPolicy.detail.ciPolicy.filters, filters);
								self.ciPolicy.detail.ciPolicy.filters = {};
								self.includeItemName = '';
								self.excludeItemName = '';
							}
							updateIncludeDocTypes();
						};

						self.copyPrecedenceChanged = function() {
							if (angular.isDefined(self.ciPolicy.detail) && angular.isDefined(self.ciPolicy.detail.ciPolicy)) {
								self.ciPolicy.detail.ciPolicy.copyPrecedence = self.copyPrecedence;
							}
						};
						const updateIncludeDocTypes = function() {
							if (angular.isDefined(self.ciPolicy.detail.ciPolicy.filters.fileFilters)) {
								if (self.ciPolicy.detail.ciPolicy.filters.fileFilters.includeDocTypes === '') {
									self.includeDocTypes = [];
								} else {
									self.includeDocTypes = self.ciPolicy.detail.ciPolicy.filters.fileFilters.includeDocTypes.split(',');
								}
							}
						};

						self.initialize = function() {
							if (
								angular.isDefined(self.ciPolicy.detail) &&
								angular.isDefined(self.ciPolicy.detail.ciPolicy) &&
								angular.isDefined(self.ciPolicy.detail.ciPolicy.filters) &&
								angular.isDefined(self.ciPolicy.detail.ciPolicy.filters.fileFilters) &&
								angular.isDefined(self.ciPolicy.detail.ciPolicy.filters.fileFilters.includeDocTypes)
							) {
								// Preserving the initial filter values to use in enable/disable
								angular.copy(self.ciPolicy.detail.ciPolicy.filters, filters);
								self.enableContentFilter = true;
								updateIncludeDocTypes();
							}
						};

						$scope.$watch('model.ciPolicy.detail.ciPolicy.filters.fileFilters.includeDocTypes', function(
							newValue,
							oldValue
						) {
							if (newValue !== oldValue) {
								self.enableContentFilter = angular.isDefined(newValue);
								updateIncludeDocTypes();
							}
						});

						$scope.$watchCollection('model.includeDocTypes', function(newValue, oldValue) {
							if (newValue !== oldValue && angular.isDefined(newValue)) {
								if (newValue.length == 0 && !self.enableContentFilter) {
									self.ciPolicy.detail.ciPolicy.filters.fileFilters.includeDocTypes = undefined;
								} else {
									self.ciPolicy.detail.ciPolicy.filters.fileFilters.includeDocTypes = newValue.toString();
								}
							}
						});

						self.addItem = function(type) {
							if (type === 'includes') {
								if (angular.isUndefined(self.includeItemName) || self.includeItemName === '') {
									self.includePathNotValid = true;
									self.includeErrorMessage = cvLoc('error.path');
									return;
								}
								self.includeErrorMessage = '';
								self.includePathNotValid = self.isPathNotValid(self.includeItemName);
								if (!self.includePathNotValid) {
									let itemToInclude = self.includeItemName.trim();
									let found = self.includeDocTypes.find(function(item) {
										return item === itemToInclude;
									});
									if (angular.isDefined(found)) {
										self.includePathNotValid = true;
										self.includeErrorMessage = cvLoc('error.duplicateItem');
										return;
									}
									self.includeDocTypes.push(itemToInclude);
									self.includeItemName = undefined;
								} else {
									self.includePathNotValid = true;
									self.includeErrorMessage = cvLoc('error.pathIsRequired');
								}
							} else if (type === 'excludes') {
								if (angular.isUndefined(self.excludeItemName) || self.excludeItemName === '') {
									self.excludePathNotValid = true;
									self.excludeErrorMessage = cvLoc('error.path');
									return;
								}
								self.excludeErrorMessage = '';
								self.excludePathNotValid = self.isPathNotValid(self.excludeItemName);
								if (!self.excludePathNotValid) {
									let itemToExclude = self.excludeItemName.trim();
									let found;
									if (angular.isDefined(self.ciPolicy.detail.ciPolicy.filters.fileFilters.excludePaths)) {
										found = self.ciPolicy.detail.ciPolicy.filters.fileFilters.excludePaths.find(function(item) {
											return item === itemToExclude;
										});
									} else {
										self.ciPolicy.detail.ciPolicy.filters.fileFilters.excludePaths = [];
									}
									if (angular.isDefined(found)) {
										self.excludePathNotValid = true;
										self.excludeErrorMessage = cvLoc('error.duplicateItem');
										return;
									}
									self.ciPolicy.detail.ciPolicy.filters.fileFilters.excludePaths.push(self.excludeItemName);
									self.excludeItemName = undefined;
								} else {
									self.excludePathNotValid = true;
									self.excludeErrorMessage = cvLoc('error.pathIsRequired');
								}
							}
						};

						self.removeItem = function(item, context) {
							if (context === 'includes') {
								let idx = self.includeDocTypes.indexOf(item);
								self.includeDocTypes.splice(idx, 1);
							} else if (context === 'excludes') {
								let idx = self.ciPolicy.detail.ciPolicy.filters.fileFilters.excludePaths.indexOf(item);
								self.ciPolicy.detail.ciPolicy.filters.fileFilters.excludePaths.splice(idx, 1);
							}
						};

						function isWildCard(string) {
							string = string.replace(/^\s+|\s+$/g, '');
							let lOrR = 'a';
							for (let i = 0; i < string.length; i++) {
								let c = string.charAt(i);
								if (c == '*' || c == '?') {
									return true;
								} else if (c == '[' || c == ']') {
									// both '[' and ']'
									if (lOrR == 'a') {
										lOrR = c;
									} else if (lOrR != c) {
										return true;
									}
								}
							}
							return false;
						}

						self.isPathNotValid = function(path) {
							let delim = '\\';
							if (path.charAt(0) == delim && path.charAt(1) == '%' && path.charAt(path.length - 1) == '%') {
								return false;
							}
							if (path.charAt(0) == '%' && path.charAt(path.length - 1) == '%') {
								return false;
							}
							if (isWildCard(path)) {
								return false;
							}
							if (delim == '\\') {
								let contPathWin = path;

								if (contPathWin == '') {
									return false;
								}

								if (contPathWin.charAt(0) != '\\' || contPathWin.charAt(1) != '\\') {
									if (!contPathWin.charAt(0).match(/^[a-zA-Z]/)) {
										return true;
									}
									if (!contPathWin.charAt(1).match(/^[:]/) || !contPathWin.charAt(2).match(/^[\\]/)) {
										return true;
									}
								}

								for (let k = 0; k < contPathWin.length; k++) {
									if (contPathWin.charAt(k) == '\\' && contPathWin.charAt(k + 1) == '\\') {
										return true;
									}
								}
							} else {
								let contPathLinux = path;

								if (contPathLinux == '') {
									return false;
								}

								for (let k = 0; k < contPathLinux.length; k++) {
									if (contPathLinux.charAt(k).match(/^[\\]$/)) {
										return true;
									}
								}
								if (contPathLinux.charAt(0) != '/') {
									return true;
								}
								if (contPathLinux.charAt(0) == '/' && contPathLinux.charAt(1) == '/') {
									return true;
								}

								for (let k = 0; k < contPathLinux.length; k++) {
									if (contPathLinux.charAt(k) == '/' && contPathLinux.charAt(k + 1) == '/') {
										return true;
									}
								}
							}
							return false;
						};

						self.initialize();
					};
				}
			]
		};
	}
]);

export default planModule;
