import { commonPlanModule } from 'common/js/modules';
import { ServiceTypes } from 'ediscovery/common/js/constants.js';
import 'ediscovery/components/schedule/js/schedule.js';

var planModule = commonPlanModule;

planModule.directive('cvPlanCiPolicy', [
	function() {
		// Runs during compile
		return {
			restrict: 'E',
			templateUrl: appUtil.appRoot + 'modules/plan/partials/ciPolicy.jsp',
			scope: {},
			bindToController: {
				ciPolicy: '=',
				readOnly: '@',
				planConfiguration: '=',
				targetApp: '=',
				schedule: '=?',
				updateSchedule: '&?',
				genericEntity: '=?'
			},
			controllerAs: 'model',
			controller: [
				'$scope',
				'cvUtil',
				'ediscoveryService',
				function($scope, cvUtil, ediscoveryService) {
					let self = this;
					self.inputLanguages = [];
					self.selectedLanguages = [];
					self.ServiceTypes = ServiceTypes;
					self.showExactSearch = _.get(cv, 'additionalSettings.Console.showExactSearch', false);
					this.$onInit = function() {
						$scope.localLang = cvUtil.getIStevenLocLabels();
						$scope.languageValidity = ocr => {
							if (ocr) {
								self.ciPolicy.detail.ciPolicy.ocrLanguages = [self.inputLanguages.find(lang => lang.selected).id];
							} else {
								delete self.ciPolicy.detail.ciPolicy.ocrLanguages;
							}
						};
						this.enableDCPlanSchedule =
							cvConfig.enableDCPlanSchedule &&
							this.targetApp !== ServiceTypes.CaseManager &&
							(this.readOnly || this.targetApp !== ServiceTypes.FileSystem);
						$scope.toggleOpType = () => {
							self.ciPolicy.detail.ciPolicy.opType =
								self.ciPolicy.detail.ciPolicy.opType === 'METADATA' ? 'METADATA_CONTENT' : 'METADATA';
						};
						ediscoveryService.getOCRLanguages().success(data => {
							self.inputLanguages = cvUtil.sortAscending(data, 'name');
							if (_.get(self, 'ciPolicy.detail.ciPolicy.ocrLanguages.length')) {
								self.inputLanguages.find(
									lang => lang.name.toUpperCase() === self.ciPolicy.detail.ciPolicy.ocrLanguages[0]
								).selected = true;
							} else {
								self.inputLanguages.find(lang => lang.id === 1).selected = true; // select English by default
							}
						});
						$scope.setLanguage = data => {
							self.ciPolicy.detail.ciPolicy.ocrLanguages = [data.id];
						};
						$scope.getLanguage = () => _.startCase(_.toLower(self.ciPolicy.detail.ciPolicy.ocrLanguages[0]));
					};

					$scope.updateSchedule = (schedule, successCallback, errorCallback) => {
						if (!_.isUndefined(schedule)) {
							if (typeof this.updateSchedule === 'function') {
								this.updateSchedule({ schedule, successCallback, errorCallback });
							} else {
								this.schedule = schedule.taskInfo;
								successCallback();
							}
						}
					};
				}
			]
		};
	}
]);

export default planModule;
