import { acAppExchangeModule } from 'common/js/modules';
import 'adminConsole/js/directives/acDirectives.js';
import 'adminConsole/js/controllers/security.ctrl.js';
import 'dlo/js/services/profile.svc.js';

const Constants = {
	PLAN_ENTITY_TYPE: 'PLAN_ENTITY',
	PLAN_SUB_TYPE: 'ExchangeUser'
};

//This controller is used for the settings page in Exchange PlanDetails.
class ExchangePlanSettingsController {
	constructor($stateParams, cvBreadcrumbsTabsFactory, cvUtil, cvLoc, securityFactory, profileService) {
		this.cvBreadcrumbsTabsFactory = cvBreadcrumbsTabsFactory;
		this.cvUtil = cvUtil;
		this.cvLoc = cvLoc;
		this.securityFactory = securityFactory;
		this.profileService = profileService;
		this.profileId = parseInt($stateParams.profileId);
		this.planDetails = {};
		this.genericEntity = {
			entityId: this.profileId
		};
		this.entityType = Constants.PLAN_ENTITY_TYPE;
		this.planSubType = Constants.PLAN_SUB_TYPE;
		this.planName = '';
		this.showEdit = false;
		this.isTenantAdmin = cv.isTenantAdmin;
		this.initialize();
	}

	initialize() {
		this.getPlanDetails();
	}

	addBreadCrumbs() {
		this.cvBreadcrumbsTabsFactory.addBreadCrumbs([
			{
				title: this.cvLoc('label.nav.profile'),
				link: '#profile'
			}
		]);

		if (Constants.PLAN_SUB_TYPE == this.planSubType) {
			this.cvBreadcrumbsTabsFactory.addBreadCrumbs([
				{
					title: this.planName,
					link: '#userMailboxPlanDetails/' + this.profileId
				}
			]);
		} else {
			this.cvBreadcrumbsTabsFactory.addBreadCrumbs([
				{
					title: this.planName,
					link: '#journalMailboxPlanDetails/' + this.profileId
				}
			]);
		}
	}

	//Gets the current plan details using the profile service
	getPlanDetails() {
		const self = this;

		this.profileService.getProfileDetails(this.profileId).then(
			response => {
				self.serverMessage = self.cvUtil.emptyMsg();
				self.planDetails = response.data;

				if (self.planDetails.permissions) {
					if (self.planDetails.permissions.Plan_Edit) {
						self.showEdit = true;
					}
				}

				var securityAssociations = self.planDetails.profile.securityAssociations;
				this.planSubType = self.planDetails.profile.summary.subtype;
				this.planName = self.planDetails.profile.summary.plan.planName;
				self.formattedSecurityAssociations = self.securityFactory.formatSecurityAssociationsObject(
					securityAssociations
				);
				self.associationsLoaded = true;
				this.addBreadCrumbs();
			},
			e => {
				self.serverMessage = {
					type: 'error',
					message: e
				};
			}
		);
	}
}

ExchangePlanSettingsController.$inject = [
	'$stateParams',
	'cvBreadcrumbsTabsFactory',
	'cvUtil',
	'cvLoc',
	'securityFactory',
	'profileService'
];
acAppExchangeModule.controller('ExchangePlanSettingsController', ExchangePlanSettingsController);

export default acAppExchangeModule;
