import 'modules/plan/js/controllers/createExchangeArchivingPlan.Ctrl.js';
import { exchangeConstants } from 'exchangeV2/js/constants/exchangeConstants.js';
import { acAppExchangeModule } from 'common/js/modules';
import 'dlo/js/services/profile.svc.js';

class selectExchangePlanController {
	constructor(cvBreadcrumbsTabsFactory, cvLoc, $modal, profileService, cvToaster) {
		this.cvLoc = cvLoc;
		this.$modal = $modal;
		this.cvToaster = cvToaster;
		this.profileService = profileService;
		this.exchangeConstants = exchangeConstants;
		cvBreadcrumbsTabsFactory.addBreadCrumbs([
			{
				title: cvLoc('label.nav.profile'),
				link: '#profile'
			}
		]);
	}

	configureArchivingExchangePlan() {
		this.$modal.open({
			templateUrl: 'modules/plan/partials/exchange/createUserMailboxPlan.jsp',
			backdrop: 'static',
			controller: 'createExchangePlanController as createExchArchivingPlanCtrl',
			resolve: {
				createNewPlanInline: () => {
					return false;
				},
				subtype: () => {
					return this.exchangeConstants.plan.SUBTYPE.EXCHANGEUSER;
				},
				masterDetails: async () => {
					try {
						const value = await this.profileService.getMasterProfile(
							this.exchangeConstants.plan.TYPE,
							this.exchangeConstants.plan.SUBTYPE.EXCHANGEUSER
						);
						const data = _.get(value, 'data.profile', {});
						_.set(data, 'eePolicy.detail.eePolicy.extractionPolicy', {});
						return data;
					} catch (error) {
						this.cvToaster.showErrorMessage({
							ttl: '10000',
							message: _.get(error, 'data', this.cvLoc('generic_error'))
						});
					}
				}
			}
		});
	}

	configureJournalingExchangePlan() {
		this.$modal.open({
			templateUrl: 'modules/plan/partials/exchange/createJournalMailboxPlan.jsp',
			backdrop: 'static',
			controller: 'createExchangePlanController as createExchJournalingPlanCtrl',
			resolve: {
				createNewPlanInline: () => {
					return false;
				},
				subtype: () => {
					return this.exchangeConstants.plan.SUBTYPE.EXCHANGEJOURNAL;
				},
				masterDetails: async () => {
					try {
						const value = await this.profileService.getMasterProfile(
							this.exchangeConstants.plan.TYPE,
							this.exchangeConstants.plan.SUBTYPE.EXCHANGEJOURNAL
						);
						const data = _.get(value, 'data.profile', {});
						_.set(data, 'eePolicy.detail.eePolicy.extractionPolicy', {});
						return data;
					} catch (error) {
						this.cvToaster.showErrorMessage({
							ttl: '10000',
							message: _.get(error, 'data', this.cvLoc('generic_error'))
						});
					}
				}
			}
		});
	}
}
selectExchangePlanController.$inject = [
	'cvBreadcrumbsTabsFactory',
	'cvLoc',
	'$uibModal',
	'profileService',
	'cvToaster'
];
acAppExchangeModule.controller('selectExchangePlanController', selectExchangePlanController);
export default acAppExchangeModule;
