import { acAppExchangeModule } from 'common/js/modules';
import 'dlo/js/services/profile.svc.js';
import 'modules/plan/js/directives/exchangePlanDirectives.js';

class createExchangeJournalingPlanController {
	constructor(
		$scope,
		$log,
		$modalInstance,
		$state,
		cvLoc,
		$stateParams,
		cvUtil,
		$location,
		$rootScope,
		$q,
		profileService,
		cvToaster
	) {
		this.$q = $q;
		this.$log = $log;
		this.cvLoc = cvLoc;
		this.cvUtil = cvUtil;
		this.$scope = $scope;
		this.$state = $state;
		this.$location = $location;
		this.cvToaster = cvToaster;
		this.$rootScope = $rootScope;
		this.profileService = profileService;
		this.$modalInstance = $modalInstance;
		this.$stateParams = $stateParams;
		this.getInitData();
	}

	cancel() {
		this.$modalInstance.dismiss();
	}

	getInitData() {
		this.planInfo = {
			summary: {
				plan: {
					planName: ''
				},
				type: 'EXCHANGE',
				subtype: 'ExchangeJournal'
			},
			exchange: {
				mbRetention: {
					policyType: 'EMAIL_POLICY_TYPE',
					detail: {
						emailPolicy: {
							emailPolicyType: 'RETENTION',
							retentionPolicy: {
								numOfDaysForMediaPruning: -1,
								numOfDaysForDeletedMediaPruning: -1
							}
						}
					}
				},
				mbJournal: {
					policyType: 'EMAIL_POLICY_TYPE',
					detail: {
						emailPolicy: {
							emailPolicyType: 'JOURNAL',
							journalPolicy: {
								contentIndexProps: {
									deferredDays: 0,
									enableContentIndex: false,
									enablePreviewGeneration: false,
									previewPathDir: {
										userAccount: {
											password: [],
											confirmPassword: []
										}
									}
								},
								exchMailboxOptions: {
									saveConversationMetaData: false
								},
								deleteArchivedMessages: true
							}
						}
					}
				}
			},
			eePolicy: {}
		};
		this.profileService.getMasterProfile('EXCHANGE', 'ExchangeJournal').then(
			resp => {
				this.planInfo = _.get(resp, 'data.profile', this.planInfo);
				this.planInfo.summary.plan.planName = '';
				this.planInfo.exchange.mbRetention.detail.emailPolicy.retentionPolicy = {
					numOfDaysForMediaPruning: -1,
					numOfDaysForDeletedMediaPruning: -1
				};
			},
			resp => {
				this.cvToaster.showErrorMessage({
					ttl: '10000',
					message: resp.data
				});
			}
		);
		this.showData = {
			showAllSearchEntity: true
		};
	}

	isNameAvailable() {
		var deferred = this.$q.defer();
		this.error = '';
		this.profileService.checkPlanName(encodeURIComponent(this.planInfo.summary.plan.planName)).then(
			resp => {
				if (angular.isDefined(resp.data.id)) {
					deferred.reject();
					this.error = this.cvLoc('error.nameExisted');
				} else {
					deferred.resolve();
				}
			},
			() => {
				deferred.reject();
			}
		);
		return deferred.promise;
	}

	create() {
		this.error = '';
		var sendData = angular.copy(this.planInfo);
		var stringPassword =
			sendData.exchange.mbJournal.detail.emailPolicy.journalPolicy.contentIndexProps.previewPathDir.userAccount
				.stringPassword;
		var stringConfirmPassword =
			sendData.exchange.mbJournal.detail.emailPolicy.journalPolicy.contentIndexProps.previewPathDir.userAccount
				.stringConfirmPassword;

		sendData.exchange.mbJournal.detail.emailPolicy.journalPolicy.contentIndexProps.previewPathDir.userAccount.password = angular.isString(
			stringPassword
		)
			? this.string2Bin(stringPassword)
			: [];
		sendData.exchange.mbJournal.detail.emailPolicy.journalPolicy.contentIndexProps.previewPathDir.userAccount.confirmPassword = angular.isString(
			stringConfirmPassword
		)
			? this.string2Bin(stringConfirmPassword)
			: [];
		return this.profileService.createPlan(sendData).then(
			resp => {
				this.planInfo.summary.plan.planId = resp.data;
				this.originalPlanInfo = angular.copy(this.planInfo);
				if (angular.isDefined(this.planInfo.eePolicy)) {
					var UpdatePlanEEPolicyInfo = {
						eePolicy: this.planInfo.eePolicy
					};
					this.profileService
						.editExchangePlan(this.planInfo.summary.plan.planId, sendData.exchange, UpdatePlanEEPolicyInfo)
						.then(
							data => {
								this.$state.go('journalMailboxPlanDetails', {
									planId: this.planInfo.summary.plan.planId
								});
							},
							resp => {
								this.cvToaster.showErrorMessage({
									ttl: '10000',
									message: resp.data
								});
							}
						);
				} else {
					this.$state.go('journalMailboxPlanDetails', {
						planId: resp.data
					});
				}
			},
			resp => {
				this.cvToaster.showErrorMessage({
					ttl: '10000',
					message: resp.data
				});
			}
		);
	}

	string2Bin(str) {
		let result = [];
		if (angular.isString(str)) {
			for (var i = 0; i < str.length; i++) {
				result.push(str.charCodeAt(i).toString(2));
			}
		}
		return result;
	}
}

createExchangeJournalingPlanController.$inject = [
	'$scope',
	'$log',
	'$uibModalInstance',
	'$state',
	'cvLoc',
	'$stateParams',
	'cvUtil',
	'$location',
	'$rootScope',
	'$q',
	'profileService',
	'cvToaster'
];
acAppExchangeModule.controller('createExchangeJournalingPlanController', createExchangeJournalingPlanController);
export default acAppExchangeModule;
