<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.network"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
</script>
<fmt:bundle basename="localization.network">
	<div  data-ng-controller="downloadFWSummaryController as dfc" data-ng-init="dfc.init(fdc.fwEnabledClients)">
		<div class="setup-title">
			<h1><fmt:message key="pageHeader.downloadFWSummary" /></h1>
		</div>
		<div class="setup-content">
		<span data-ng-show="dfc.uiModel.showFWClientsError" class="{{dfc.downloadMessage.type}} serverMessage">{{dfc.downloadMessage.message}}</span>
		<form name="downloadFWSummaryForm" novalidate data-cv-submit="dfc.downloadFWSummary(fdc.close)" autocomplete="off" class="bootstrap-wrapper modal-margin form-horizontal">
		
		<!--// start new// -->
		
		<div class="form-group">
			<label class="col-xs-12 col-md-4 col-lg-4" for="servers">Server</label>
			<div class="col-xs-12 col-md-8 col-lg-8">
				<isteven-multi-select
		                    input-model="dfc.uiModel.listFWEnabledClients"
		                    output-model="dfc.uiModel.selectedClient"
		                    item-label="displayName"
		                    button-label="displayName"
		                    tick-property="selected"
		                    class="isteven-multi-select user-group-select"
		                    id="fwEnabledClients"
		                    name="fwEnabledClients"
		                    helper-elements="filter"
		                    selection-mode="single"
		                    group-property="group"
		                    tick-property="ticked"
		                    translation="dfc.uiModel.translation">
		          </isteven-multi-select>
		          
		          <span class="cv-help-block" data-ng-show="dfc.uiModel.showError"><cv:msg key="error.selectclient" bundle="network" /></span>
			</div>
		</div>
		<!--// end new //-->
				<div class="button-container">
					<fmt:bundle basename="localization.messages">
				  		<button id="downloadFWSummary_button_#4001" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="fdc.close()"><cv:msg key="Cancel" /></button> 
				  		<button id="downloadFWSummary_button_#2345" type="submit" class="btn btn-primary cvBusyOnAjax" ><cv:msg key="label.download" bundle="network" /></button> 
				  	</fmt:bundle>
				</div>
			
			</form>
			
		</div>
	</div>
</fmt:bundle>