import { acAppNetworkTopologyModule } from 'common/js/modules';

acAppNetworkTopologyModule.service('NetworkTopologyService', [
	'$http',
	function($http) {
		this.getNWTopologies = function() {
			return $http.get(cv.contextPath + '/api/FirewallTopology');
		};

		this.deleteFWTopology = function(topologyId) {
			return $http.delete(cv.contextPath + '/api/FirewallTopology/' + topologyId);
		};

		this.pushFWTopology = function(topologyId) {
			return $http.post(cv.contextPath + '/api/FirewallTopology/' + topologyId + '/Push', {
				topologyId: topologyId
			});
		};

		this.saveTopology = function(topology) {
			return $http({
				method: 'POST',
				url: cv.contextPath + '/api/FirewallTopology',
				data: JSON.stringify(topology),
				headers: {
					'Content-Type': 'application/json',
					Accept: 'application/json'
				}
			});
		};

		this.updateTopology = function(topology) {
			return $http({
				method: 'PUT',
				url: cv.contextPath + '/api/FirewallTopology/' + topology.firewallTopology.topologyEntity.topologyId,
				data: JSON.stringify(topology),
				headers: {
					'Content-Type': 'application/json',
					Accept: 'application/json'
				}
			});
		};

		this.getFWTopologyDetails = function(topologyId) {
			return $http.get(cv.contextPath + '/api/FirewallTopology/' + topologyId);
		};

		this.getFWEnabledClients = function(topologyId) {
			return $http.get(cv.contextPath + '/api/GetFirewallEnabledEntities');
		};

		this.downloadFWSummaryForClient = function(clientId) {
			return $http.get(cv.contextPath + '/api/FirewallSummary/' + clientId);
		};

		this.fetchClientGroupNetworkProperties = function(clientGroupId) {
			var url = cv.contextPath + '/api/ClientGroupNetworkProperties';
			if (clientGroupId > 0) {
				url += '?clientGroupId=' + clientGroupId;
			}

			return $http.get(url);
		};
	}
]);

export default acAppNetworkTopologyModule;
