export const getNWTopologiesColumns = (actionClick, serviceVariables) => {
	return {
		'topologyEntity.topologyName': getTopologyNameColumn(serviceVariables.cvLoc),
		topologyType: getTopologyTypeColumn(
			serviceVariables.cvLoc,
			serviceVariables.NetworkTopologyFactory,
			serviceVariables.NW_TOPOLOGY_TYPE
		),
		clientType: getClientTypeColumn(serviceVariables.cvLoc, serviceVariables.NW_CLIENT_TYPE),
		actions: getActionsColumn(serviceVariables.cvLoc)
	};
};

let getTopologyNameColumn = cvLoc => ({
	title: cvLoc('tableHeader.nwTopologyName'),
	width: '30%',
	searchField: 'topologyEntity.topologyName',
	template: getTopologyNameTemplate()
});

let getTopologyTypeColumn = (cvLoc, NetworkTopologyFactory, NW_TOPOLOGY_TYPE) => ({
	type: 'string',
	width: '30%',
	filterType: 'checkboxmultiselect',
	data: _.map(NW_TOPOLOGY_TYPE, topologyType => ({
		value: topologyType.id,
		label: topologyType.name
	})),
	title: cvLoc('tableHeader.nwTopologyType'),
	template: getTopologyTypeTemplate.bind(undefined, NetworkTopologyFactory)
});

let getClientTypeColumn = (cvLoc, NW_CLIENT_TYPE) => ({
	type: 'string',
	width: '30%',
	filterType: 'checkboxmultiselect',
	data: _.map(NW_CLIENT_TYPE, topologyType => ({
		value: topologyType.name,
		label: topologyType.name
	})),
	title: cvLoc('tableHeader.nwClientType'),
	template: getClientTypeTemplate()
});

let getActionsColumn = cvLoc => ({
	type: 'string',
	sortable: false,
	width: '10%',
	disableColumnFilter: true,
	disableViewFiltering: true,
	title: cvLoc('label.actions'),
	template: getActionsTemplate()
});

let getTopologyNameTemplate = () => `<a class="k-grid-topologyname">#:topologyEntity.topologyName#</a>`;

let getTopologyTypeTemplate = (NetworkTopologyFactory, dataItem) => {
	let topologyType = NetworkTopologyFactory.getNWTopologyType(dataItem.topologyType);
	return `<span class="crop">${kendo.htmlEncode(topologyType)}</span>`;
};

let getClientTypeTemplate = () => `<span class="crop">#:clientType#</span>`;

let getActionsTemplate = () => `<div class="permittedActions"></div>`;
