<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<script>
		<cv:cvMessages bundle="localization.network"></cv:cvMessages>
</script>
<fmt:bundle basename="localization.network">
	<div class="setup-title">
		<h1>
			<fmt:message key="pageHeader.tempCertificate" />
		</h1>
	</div>
	<div class="setup-content" data-ng-controller="tempCertificateController as tempCertControl">
		<p ng-class="tempCertControl.configureTempCertMsg.type" class="serverMessage">{{tempCertControl.configureTempCertMsg.message}}</p>
		<div><span><fmt:message key="label.tempCertificateText"/></span></div>
		<form name="configureTempCertForm" novalidate
			data-cv-submit="tempCertControl.configureTempCertificate()" autocomplete="off">
			<div>
				<label for="clientName" class="select-label"><fmt:message key="label.clientNameFull" />
					<select id="certForClient" name="certForClient"
					data-ng-options="item as item.clientName for item in tempCertControl.clientList"
					data-ng-model="tempCertControl.currentClient"
					data-ng-change="tempCertControl.clientForCertificateChanged()"></select>
				</label>
				<textarea id="tempCertificate" data-ng-if="tempCertControl.currentTempCertificate" name="tempCertificate" data-ng-model="tempCertControl.currentTempCertificate" rows="20"></textarea>
			</div>
			<div class="button-container">
				<fmt:bundle basename="localization.messages">
					<button id="tempCertificate_button_#6632" cv-copy-to-clipboard type="button" data-help-text='<cv:msg key="action.CopyToClipboard" bundle="network"/>' data-use-icon="false" data-copytext="{{tempCertControl.currentTempCertificate}}" data-ng-if="tempCertControl.currentTempCertificate" class="btn btn-default cvBusyOnAjax setup-btn--hidden"> 
						<cv:msg key="action.CopyToClipboard" bundle="network"/>
					</button>
					<button id="tempCertificate_button_#9095" type="submit" class="btn btn-primary cvBusyOnAjax"> 
						<cv:msg key="action.create" bundle="network"/>
					</button>
					<button id="tempCertificate_button_#4877" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" 
						data-ng-click="dismissTempCertificateModal()">
						<fmt:message key="Cancel" />
					</button>
				</fmt:bundle>
			</div>
		</form>
	</div>
</fmt:bundle>