import { cvModuleNetworkModule } from 'common/js/modules';

var networkMod = cvModuleNetworkModule;

networkMod.service('certificateService', [
	'$http',
	'$q',
	function($http, $q) {
		this.getCertificates = function() {
			return $http.get('getCertificates.do');
		};

		this.certificateOperations = function(certificateParams) {
			return $http.post('certificateOperations.do', certificateParams);
		};

		this.certificatePageOperations = function(certificatePageParams) {
			return $http.post('certificatePageOperations.do', certificatePageParams);
		};

		this.generateCertificateForClient = function(clientId) {
			return $http.post('generateCertificateForClient.do', clientId);
		};
	}
]);

export default networkMod;
