import 'modules/network/js/constants/certificate.constant.js';

import { cvModuleNetworkModule } from 'common/js/modules';

/**
 * An angular factory having utility functions for dealing with certificate actions.
 */

cvModuleNetworkModule.factory('networkFactory', [
	'OPERATION_TYPES',
	'REVOKE_STATUS',
	'CONFIRMED_STATUS',
	'ACTIVE_STATUS',
	'UNCONFIRMED_STATUS',
	function(operationTypes, REVOKE_STATUS, CONFIRMED_STATUS, ACTIVE_STATUS, UNCONFIRMED_STATUS) {
		var CACount = 0,
			factory = {};

		factory.checkIfRevokeAllowed = function(selectedRows) {
			var showRevokeOption = true,
				CACountInSelectedCertificates = 0;

			if (selectedRows.length > 0) {
				angular.forEach(selectedRows, function(value, key) {
					if (
						value.status.toLowerCase() === REVOKE_STATUS.toLowerCase() ||
						(value.id === value.authority && CACount === 1)
					) {
						showRevokeOption = false;
						return;
					}
					if (
						value.client.clientId === 0 &&
						value.id === value.authority &&
						value.status.toLowerCase() === ACTIVE_STATUS.toLowerCase()
					) {
						// this means CA Cert and active
						CACountInSelectedCertificates++;
					}
				});
			} else {
				showRevokeOption = false;
			}
			if (CACount === CACountInSelectedCertificates) {
				showRevokeOption = false;
			}
			return showRevokeOption;
		};

		factory.getCACount = function() {
			return CACount;
		};

		factory.renderCertificateData = function(data) {
			var certificateData = data.certificateInfo.certificates;
			CACount = 0;
			angular.forEach(certificateData, function(value, key) {
				if (
					value.client.clientId === 0 &&
					value.id === value.authority &&
					value.status.toLowerCase() === CONFIRMED_STATUS.toLowerCase()
				) {
					// this means CA Cert and active
					CACount++;
				}
				if (
					value.status.toLowerCase() === CONFIRMED_STATUS.toLowerCase() ||
					value.status.toLowerCase() === UNCONFIRMED_STATUS.toLowerCase()
				) {
					certificateData[key].status =
						ACTIVE_STATUS.substring(0, 1).toUpperCase() + ACTIVE_STATUS.substring(1).toLowerCase();
				} else if (value.status.toLowerCase() === REVOKE_STATUS.toLowerCase()) {
					certificateData[key].status =
						value.status.substring(0, 1).toUpperCase() + value.status.substring(1).toLowerCase();
				}
				if (value.id === value.authority) {
					certificateData[key].client.displayName = 'CA';
				}
			});
			return certificateData;
		};

		return factory;
	}
]);
