import 'adminConsole/js/services/clientGroups.svc.js';
import 'modules/network/js/services/network.svc.js';
import 'modules/network/js/constants/certificate.constant.js';
import 'modules/network/js/factories/certificate.factory.js';

import { cvModuleNetworkModule } from 'common/js/modules';

var networkMod = cvModuleNetworkModule;

var controllers = {};

controllers.certificateController = [
	'$scope',
	'$uibModal',
	'certificateService',
	'cvTableOptions',
	'cvLoc',
	'$dialogs',
	'networkFactory',
	'cvUtil',
	'cvToaster',
	'uiGridConstants',
	'OPERATION_TYPES',
	'PAGINATION_SIZE',
	'PAGINATION_PAGE_SIZES',
	'cvBreadcrumbsTabsFactory',
	function(
		$scope,
		$modal,
		certificateService,
		cvTableOptions,
		cvLoc,
		$dialogs,
		networkFactory,
		cvUtil,
		cvToaster,
		uiGridConstants,
		operationTypes,
		PAGINATION_SIZE,
		PAGINATION_PAGE_SIZES,
		cvBreadcrumbsTabsFactory
	) {
		var modal = null,
			tempCertModal = null;

		$scope.getAllCertificateInfo = function() {
			certificateService
				.getCertificates()
				.success(function(data) {
					if (data && data.certificateInfo) {
						$scope.certificateData = networkFactory.renderCertificateData(data);
						$scope.serverMessage = cvUtil.emptyMsg();
						$scope.caRotation = data.certificateInfo.CACertificateRotation;
						$scope.clientRotation = data.certificateInfo.ClientCertificateRotation;
						$scope.forceClientAuth = data.certificateInfo.forceClientAuth ? 'enabled-activity' : 'disabled-activity';
					} else {
						$scope.serverMessage = {
							type: 'error',
							message: cvLoc('error.certificatelist')
						};
					}
				})
				.error(function(e) {
					$scope.serverMessage = {
						type: 'error',
						message: e
					};
				});
		};

		$scope.getAllCertificateInfo();

		// Add breadcumbs
		var breadCrumbs = [];
		breadCrumbs.push({
			title: cvLoc('label.nav.network'),
			link: '#nav/network'
		});
		cvBreadcrumbsTabsFactory.addBreadCrumbs(breadCrumbs);

		var globalGridOptions = angular.copy(cvTableOptions.commonNgGridOptions);

		angular.extend(globalGridOptions, {
			data: 'certificateData',
			multiSelect: true,
			enableRowSelection: true,
			enableSelectAll: true,
			paginationPageSize: PAGINATION_SIZE,
			paginationPageSizes: PAGINATION_PAGE_SIZES,
			showGridFooter: true,
			columnDefs: [
				{
					field: 'id',
					sort: {
						direction: 'asc',
						priority: 0
					},
					type: 'number',
					displayName: cvLoc('label.serialNumber'),
					enableHiding: false
				},
				{
					field: 'client.displayName',
					displayName: cvLoc('label.clientName'),
					enableHiding: false
				},
				{
					field: 'status',
					displayName: cvLoc('label.status'),
					enableHiding: true
				},
				{
					field: 'authority',
					displayName: cvLoc('label.signedBy'),
					enableHiding: true
				},
				{
					field: 'created.time',
					displayName: cvLoc('label.created'),
					cellTemplate: '<span class="crop">{{row.entity.created.time *1000 | date:\'medium\'}}</span>',
					enableHiding: true
				},
				{
					field: 'expiration.time',
					displayName: cvLoc('label.expiration'),
					cellTemplate: '<span class="crop">{{row.entity.expiration.time *1000 | date:\'medium\'}}</span>',
					enableHiding: true
				},
				{
					field: 'Action',
					cellTooltip: true,
					enableFiltering: false,
					enableHiding: false,
					displayName: cvLoc('header.actions'),
					cellTemplate:
						'<div class="btn-group" uib-dropdown><a href class="uib-dropdown-toggle" uib-dropdown-toggle ng-disabled="disabled"><span class="grid-action-icon"></span></a><ul uib-dropdown-menu class="dropdown-menu" role="menu">' +
						'<li> <a class="crop" data-ng-if="((row.entity.status != \'Revoked\') && ((row.entity.id != row.entity.authority) || grid.appScope.getCACount() > 1))" href="" data-ng-click="grid.appScope.certificateOperations(\'' +
						cvLoc('action.revoke') +
						'\',3,[row.entity.id])">' +
						cvLoc('action.revoke') +
						'</a></li><li> <a class="crop" href="" data-ng-click="grid.appScope.certificateOperations(\'' +
						cvLoc('action.renew') +
						'\', 2,[row.entity.id])">' +
						cvLoc('action.renew') +
						'</a></li></ul></div>',
					enableSorting: false
				}
			],
			onRegisterApi: function(gridApi) {
				gridApi.selection.on.rowSelectionChanged($scope, function() {
					$scope.showRenewOption = gridApi.selection.getSelectedRows().length > 0;
					$scope.showRevokeOption = networkFactory.checkIfRevokeAllowed(gridApi.selection.getSelectedRows());
				});

				gridApi.selection.on.rowSelectionChangedBatch($scope, function(rows) {
					$scope.showRenewOption = gridApi.selection.getSelectedRows().length > 0;
					$scope.showRevokeOption = networkFactory.checkIfRevokeAllowed(gridApi.selection.getSelectedRows());
				});

				$scope.getCACount = function() {
					return networkFactory.getCACount();
				};

				$scope.certificateOperations = function(operation, operationVal, selectedRows) {
					var callBackFunctions = {
						noFunction: function() {},
						yesFunction: function() {
							$scope.currentRows = [];
							if (selectedRows != undefined) {
								$scope.currentRows = selectedRows;
							} else {
								angular.forEach(gridApi.selection.getSelectedRows(), function(value, key) {
									$scope.currentRows.push(value.id);
								});
							}

							certificateService
								.certificateOperations({
									certificateIds: JSON.stringify($scope.currentRows),
									operation: operationVal
								})
								.success(function(data) {
									if (data && data.certificateInfo) {
										$scope.certificateData = networkFactory.renderCertificateData(data);
										$scope.serverMessage = cvUtil.emptyMsg();
										$scope.showRenewOption = false;
										$scope.showRevokeOption = false;
										var successMsg = '';
										if (operationVal === operationTypes.RENEW) {
											successMsg = cvLoc('success.renewSuccess');
										} else {
											successMsg = cvLoc('success.revokeSuccess');
										}
										cvToaster.showSuccessMessage({
											ttl: '10000',
											message: successMsg
										});
									} else {
										var errormessage = '';
										if (operationVal === operationTypes.RENEW) {
											errormessage = cvLoc('error.renewFailed');
										} else {
											errormessage = cvLoc('error.revokeFailed');
										}
										$dialogs.error(cvLoc('label.error'), errormessage);
										cvToaster.showErrorMessage({
											ttl: '10000',
											message: errormessage
										});
									}
								})
								.error(function(e) {
									$dialogs.error(cvLoc('label.error'), cvUtil.errMsg(e).message);
									cvToaster.showErrorMessage({
										ttl: '10000',
										message: e
									});
								});
						}
					};
					$dialogs.confirm(
						cvLoc('label.confirmOperation', operation),
						operationVal === operationTypes.RENEW
							? cvLoc('label.renewCertificates')
							: cvLoc('label.revokeCertificates'),
						callBackFunctions
					);
				};
			}
		});

		$scope.gridOptions = {
			cvPageLinks: [
				{
					label: cvLoc('action.renew'),
					show: 'showRenewOption',
					onclick: function() {
						$scope.certificateOperations(cvLoc('action.renew'), operationTypes.RENEW);
					}
				},
				{
					label: cvLoc('action.revoke'),
					show: 'showRevokeOption',
					onclick: function() {
						$scope.certificateOperations(cvLoc('action.revoke'), operationTypes.REVOKE);
					}
				}
			],
			cvGridDirectives: {
				uiGridSelection: true
			},
			cvGridCssClass: {
				'alerts-grid': true,
				'users-grid': true
			},
			cvOnGridEmpty: {
				message: cvLoc('error.noCertificatesFound')
			},
			cvGridTitle: cvLoc('tableHeader.certificates'),
			cvIsPageTitle: false,
			cvTableName: 'certificateAdministrationTable',
			cvSearchFields: ['id', 'client.clientName', 'status'],
			gridOptions: globalGridOptions
		};

		$scope.manageClientAuth = function() {
			var clientAuth = $scope.forceClientAuth === 'enabled-activity' ? false : true;
			var actionStr = $scope.forceClientAuth === 'enabled-activity' ? 'disable' : 'enable';
			certificateService
				.certificatePageOperations({
					clientAuth: clientAuth,
					caRotation: $scope.caRotation,
					clientRotation: $scope.clientRotation
				})
				.success(function(data) {
					if (data) {
						$scope.forceClientAuth = clientAuth ? 'enabled-activity' : 'disabled-activity';
					} else {
						cvToaster.showErrorMessage({
							ttl: '10000',
							message: cvLoc('error.forceClientAuthFailed', actionStr)
						});
					}
				})
				.error(function(e) {
					cvToaster.showErrorMessage({
						ttl: '10000',
						message: e
					});
				});
		};

		// Opens the modal for configuring the current user's email settings.
		$scope.openConfigureCertifcateRotationModal = function() {
			modal = $modal.open({
				templateUrl: appUtil.appRoot + 'modules/network/partials/certificateRotation.jsp',
				scope: $scope,
				backdrop: 'static',
				controller: 'certificateRotationController'
			});
		};

		$scope.dismissModal = function() {
			modal.dismiss();
		};

		$scope.$on('rotationChanged', function(event, model) {
			modal.close();
			$scope.caRotation = model.caRotation;
			$scope.clientRotation = model.clientRotation;
		});

		$scope.openConfigureTempCertificateModal = function() {
			tempCertModal = $modal.open({
				templateUrl: appUtil.appRoot + 'modules/network/partials/tempCertificate.jsp',
				scope: $scope,
				backdrop: 'static',
				controller: 'tempCertificateController'
			});
		};

		$scope.dismissTempCertificateModal = function() {
			tempCertModal.dismiss();
			$scope.getAllCertificateInfo();
		};
	}
];

controllers.certificateRotationController = [
	'$scope',
	'$uibModal',
	'certificateService',
	'cvLoc',
	'$dialogs',
	'networkFactory',
	'cvUtil',
	'cvToaster',
	function($scope, $modal, certificateService, cvLoc, $dialogs, networkFactory, cvUtil, cvToaster) {
		$scope.configureRotationMsg = {};
		$scope.model = {};
		$scope.model.caRotation = $scope.caRotation;
		$scope.model.clientRotation = $scope.clientRotation;

		$scope.configureCertificateRotation = function() {
			return certificateService
				.certificatePageOperations({
					clientAuth: $scope.forceClientAuth === 'enabled-activity' ? true : false,
					caRotation: this.model.caRotation,
					clientRotation: this.model.clientRotation
				})
				.success(function(data) {
					if (data) {
						$scope.$emit('rotationChanged', $scope.model);
						$scope.configureRotationMsg = cvUtil.emptyMsg();
					} else {
						$scope.configureRotationMsg = {
							type: 'error',
							message: cvLoc('error.rotationChangeFailed')
						};
					}
				})
				.error(function(e, a) {
					$scope.$emit('rotationChangeFailed');
					$scope.configureRotationMsg = {
						type: 'error',
						message: e
					};
				});
		};

		$scope.cancel = function() {
			$scope.$emit('rotationChanged');
		};
	}
];

controllers.tempCertificateController = [
	'$scope',
	'$uibModal',
	'certificateService',
	'clientGroupService',
	'cvLoc',
	'$dialogs',
	'networkFactory',
	'cvUtil',
	'cvToaster',
	function($scope, $modal, certificateService, clientGroupService, cvLoc, $dialogs, networkFactory, cvUtil, cvToaster) {
		var self = this;

		self.configureTempCertMsg = {};
		self.model = {};

		self.getClientList = function() {
			return clientGroupService
				.getClientsForClientGroup(0)
				.success(function(data) {
					if (data) {
						self.configureTempCertMsg = cvUtil.emptyMsg();
						if (data.length) {
							var clientList = [];
							data.forEach(function(entry) {
								clientList.push(entry.client.clientEntity);
							});
							self.clientList = cvUtil.sortAscending(clientList, 'clientName');
							self.currentClient = clientList[0];
						}
					} else {
						self.configureTempCertMsg = {
							type: 'error',
							message: cvLoc('error.FailedToFetchClientList')
						};
					}
				})
				.error(function(e, a) {
					self.configureTempCertMsg = {
						type: 'error',
						message: e
					};
				});
		};

		self.getClientList();

		self.clientForCertificateChanged = function() {
			self.currentTempCertificate = '';
		};

		self.configureTempCertificate = function() {
			return certificateService
				.generateCertificateForClient({
					clientId: self.currentClient.clientId
				})
				.success(function(data) {
					if (_.has(data, 'certificateInfo.tempCertificateInfo')) {
						self.currentTempCertificate = _.get(data, 'certificateInfo.tempCertificateInfo');
						self.configureTempCertMsg = cvUtil.emptyMsg();
					} else {
						self.configureTempCertMsg = {
							type: 'error',
							message: cvLoc('error.tempCertGenerationFailed')
						};
					}
				})
				.error(function(e, a) {
					self.configureTempCertMsg = {
						type: 'error',
						message: e
					};
				});
		};
	}
];

networkMod.controller(controllers);

export default networkMod;
