import { acAppNetworkTopologyModule } from 'common/js/modules';

acAppNetworkTopologyModule
	.constant('NW_TOPOLOGY_TYPE', {
		PROXIED: { name: 'Network gateway', id: 1 },
		ONEWAY: { name: 'One-Way', id: 2 },
		TWOWAY: { name: 'Two-Way', id: 3 },
		CASCADINGGATEWAY: { name: 'Cascading gateways', id: 4 }
	})
	.constant('NW_CLIENT_TYPE', {
		SERVER: { name: 'Server', id: 0 },
		LAPTOP: { name: 'Laptop', id: 1 }
	})
	.constant('SMART_TOPOLOGY_MNEMONICS', {
		MY_COMMSERVE: { name: 'My CommServe Computer', Id: -1 },
		MY_MEDIAAGENTS: { name: 'My MediaAgents', Id: -2 },
		MY_COMMSERVE_AND_MEDIAAGENTS: { name: 'My CommServe Computer and MediaAgents', Id: -3 }
	})
	.constant('FW_GROUP_TYPE', {
		INTERNAL: { name: 'Internal', id: 1 },
		EXTERNAL: { name: 'External', id: 2 },
		PROXIED: { name: 'Proxies', id: 3 },
		CASCADINGGATEWAY: { name: 'Cascading gateways', id: 4 }
	})
	.constant('NW_TOPOLOGY_PROTOCOL_TYPE', [
		{ name: 'Encrypted', id: 1 },
		{ name: 'Authenticated', id: 2 },
		{ name: 'Regular', id: 0 },
		{ name: 'Raw', id: 3 }
	]);
