(function() {
	'use strict';

	var settingsMod = angular.module('cvModule.settings');

	settingsMod.factory('globalSearchFactory', [
		'$location',
		'$window',
		'cvLoc',
		'backupAndRestoreFactory',
		'vmGroupsFactory',
		'vendorTypes',
		'vmFactory',
		'fileServersPageFactory',
		'devicesFactory',
		'backupService',
		'cvToaster',
		function(
			$location,
			$window,
			cvLoc,
			backupAndRestoreFactory,
			vmGroupsFactory,
			vendorTypes,
			vmFactory,
			fileServersPageFactory,
			devicesFactory,
			backupService,
			cvToaster
		) {
			var globalSearchFactoryObjectToReturn = {};

			const OPTYPE = {
				BACKUP: 'backup',
				RESTORE: 'restore'
			};

			globalSearchFactoryObjectToReturn.getDownloadURL = function(obj) {
				let downloadurl =
					'downloadSearchedFile.do?commCellNumb=' +
					obj.CommcellNumber +
					'&subclientId=' +
					obj.ApplicationId +
					'&path=' +
					encodeURIComponent(obj.FilePath) +
					'&name=' +
					encodeURIComponent(obj.FileName) +
					'&afId=' +
					obj.AchiveFileId +
					'&afOffset=' +
					obj.ArchiveFileOffset +
					'&appType=' +
					obj.AppType +
					'&objGuid=' +
					obj.CVTurboGUID;

				if (obj.isVersionItem && obj.version) {
					downloadurl += '&isVersionItem=' + obj.isVersionItem + '&version=' + obj.version;
				}

				return downloadurl;
			};

			globalSearchFactoryObjectToReturn.performBackupRestoreOperation = function(item, commandId) {
				let clientID = parseInt(item.id);
				let isIndexingV2VSA =
					_.get(item, 'detailedProperty.serverProperty.clientProperties.clientProps.isIndexingV2VSA') || false;
				let clientGUID = _.get(item, 'detailedProperty.serverProperty.clientProperties.client.clientEntity.clientGUID');
				let operationType;
				if (commandId === 6) {
					operationType = OPTYPE.BACKUP;
				} else {
					operationType = OPTYPE.RESTORE;
				}

				switch (item.type) {
					case 1:
						backupAndRestoreFactory.restoreOrBackupSubclient(
							clientID,
							undefined,
							operationType,
							null,
							isIndexingV2VSA,
							clientGUID,
							false
						);
						break;
					case 3:
						backupAndRestoreFactory.restoreOrBackupSubclient(clientID, 'hypervisors', operationType);
						break;
					case 4:
						let vendorName = vendorTypes.getVendorName(
							item.detailedProperty.vmGroupProperty.subClientProperties.vsaSubclientProp.vendorType
						);
						if (operationType === OPTYPE.BACKUP) {
							vmGroupsFactory.showBackupOptions(
								item.detailedProperty.vmGroupProperty.subClientProperties.subClientEntity.subclientId,
								vendorName,
								null,
								null,
								item.detailedProperty.vmGroupProperty.subClientProperties.fsSubClientProp &&
									item.detailedProperty.vmGroupProperty.subClientProperties.fsSubClientProp.extendStoragePolicyRetention
							);
						}
						if (operationType === OPTYPE.RESTORE) {
							let url = vmGroupsFactory.createRestoreURL(
								item.detailedProperty.vmGroupProperty.subClientProperties,
								true
							);
							$window.location.href = url;
						}
						break;
					case 5:
						let vmObj = item.detailedProperty.vmProperty.vmStatusInfoList;
						vmObj.vendor = vendorTypes.getVendorName(vmObj.vendor);
						if (operationType === OPTYPE.BACKUP) {
							vmFactory.showBackupOptions(vmObj);
						}
						if (operationType === OPTYPE.RESTORE) {
							vmFactory.vmRestore(vmObj, 'default');
						}
						break;
					case 14:
						if (operationType === OPTYPE.RESTORE) {
							devicesFactory.restoreAction(item.detailedProperty.deviceProperty.clientsFileSystem.subClient);
						}
						if (operationType === OPTYPE.BACKUP) {
							let isDeviceDeconfigured =
								item.detailedProperty.deviceProperty.clientsFileSystem.isClientDeconfigured === 1;
							backupService
								.showBackupOptions(
									item.detailedProperty.deviceProperty.clientsFileSystem.subClient.subclientId,
									undefined,
									undefined,
									undefined,
									undefined,
									undefined,
									isDeviceDeconfigured
								)
								.then(
									function(job) {
										cvToaster.showInfoMessage({
											ttl: '10000',
											message:
												cvLoc('notification.jobDetails') +
												" <a href='#jobs/" +
												job.jobSummary.jobId +
												"'>" +
												job.jobSummary.jobId +
												'</a>'
										});
									},
									function(resp) {
										cvToaster.showErrorMessage({
											ttl: '10000',
											message: resp
										});
									}
								);
						}
						break;
					case 25:
						if (operationType === OPTYPE.BACKUP) {
							fileServersPageFactory._backupClient(null, item.detailedProperty.fileServerProperty.clientProperties);
						}

						if (operationType === OPTYPE.RESTORE) {
							fileServersPageFactory._restoreClient(null, item.detailedProperty.fileServerProperty.clientProperties);
						}
						break;
				}
			};

			return globalSearchFactoryObjectToReturn;
		}
	]);
})();
