(function() {
	'use strict';
	var navigationMod = angular.module('cvModule.navigation');
	navigationMod.constant('SOLUTION_NAMES', {
		VSA: 'VSA',
		ADMIN_CONSOLE: 'ADMIN_CONSOLE',
		ENDPOINT: 'ENDPOINT',
		CASSANDRA: 'CASSANDRA',
		DBS: 'DBS',
		EXCHANGE: 'EXCHANGE',
		EXCHANGE_DAG: 'EXCHANGE_DAG',
		EXCHANGE_MAILBOX: 'EXCHANGE_MAILBOX',
		CAPPS: 'CAPPS',
		SALESFORCE: 'SALESFORCE',
		AMAZON_SQL: 'AMAZON_SQL',
		AZURE_SQL: 'AZURE_SQL',
		SHAREPOINT: 'SHAREPOINT',
		ACTIVE_DIRECTORY: 'ACTIVE_DIRECTORY',
		ARCHIVING: 'ARCHIVING',
		ARCHIVE: 'ARCHIVE',
		EBS: 'EBS',
		COMPLIANCE: 'COMPLIANCE',
		GSUITE: 'GSUITE',
		OFFICE365: 'OFFICE365',
		VNA: 'VNA',
		BIG_DATA_APPS: 'BIG_DATA_APPS',
		NOTES_DATABASE: 'NOTES_DATABASE',
		KUBERNETES: 'KUBERNETES',
		REPLICATION: 'REPLICATION',
		OBJECT_STORAGE: 'OBJECT_STORAGE',
		EPIC: 'EPIC',
		DYNAMICS365: 'DYNAMICS365'
	});

	navigationMod.constant('LIST_STATENAMES', {
		VM_GROUPS: 'vmGroups',
		COMPANY: 'subscriptions',
		ROLES: 'roles',
		GATEWAY: 'clientGroupDetails',
		PLAN: 'profile',
		USERS: 'users',
		USER_GROUPS: 'userGroups',
		HYPERVISOR: 'hypervisors',
		SERVER_GROUP: 'serverGroups',
		LAPTOP: 'devices',
		FS_SERVER: 'fsServersList',
		CLUSTER: 'clusters',
		APPLICATION_GROUPS: 'applicationGroups',
		APPLICATIONS: 'applications'
	});

	navigationMod.constant('DETAILS_STATENAMES', {
		SERVER_GROUP_DETAILS: 'clientGroupDetails',
		NAS_CLIENT_DETAILS: 'nasClientDetails',
		USER_GROUPS: 'userGroupDetails',
		USERS: 'userDetails'
	});

	navigationMod.constant('PERMISSIONS', {
		REGISTER_DISTRIBUTED_STORAGE: 259,
		MANAGE_DISTRIBUTED_STORAGE: 260,
		MANAGE_INSTALLATION: 7, // Install rights on commcell
		USER_MANAGEMENT: 101, //Manage user rights on commcell or company
		USER_GROUP_MANAGEMENT: 102, //Manage user group rights on commcell / company
		CREATE_PLAN: 156, //create plan permission on commcell or create plan on company
		CREATE_CLIENT_GROUP: 179, //Create Client Group rights on commcell
		CREATE_ROLE: 241, //Create role permission on commcell
		ADD_DOMAIN: 249, // Add domain permission on commcell
		INSTALL_CLIENT: 65,
		TAG_MANAGEMENT: 27,
		EDIT: 34,
		AGENT_MANAGEMENT: 2,
		CREATE_COMPANY: 255
	});
})();
