import 'modules/navCustomization/js/services/customization.svc.js';
import 'vsa/js/services/subscriptions.svc.js';
import 'dlo/js/services/customization.svc.js';
import 'modules/navCustomization/js/factory/customization.factory.js';
import { navCustomizationModule } from 'common/js/modules';

class NavSetting {
	constructor(userRole, deniedNavItems, includeNavItems) {
		this.userRole = userRole;
		this.deniedNavItems = deniedNavItems;
		this.includeNavItems = includeNavItems;
	}
}

class UpdateNavItemsReq {
	constructor(navSettings) {
		this.navSettings = navSettings;
	}
}

class navSettings {
	constructor(globalSettings, companySettings) {
		this.globalSettings = globalSettings;
		this.companySettings = companySettings;
	}
}

var navCustomizationMod = navCustomizationModule;
navCustomizationMod.controller('navigationPreferencesController', [
	'$log',
	'$dialogs',
	'cvLoc',
	'cvTableOptions',
	'$stateParams',
	'customizationService',
	'cvBreadcrumbsTabsFactory',
	'cvToaster',
	'subscriptionService',
	'tabService',
	'customizationFactory',
	'$q',
	function(
		$log,
		$dialogs,
		cvLoc,
		cvTableOptions,
		$stateParams,
		customizationService,
		cvBreadcrumbsTabsFactory,
		cvToaster,
		subscriptionService,
		tabService,
		customizationFactory,
		$q
	) {
		var self = this;
		self.userRole = cv.userRole;
		self.navsToShow = []; // This is the data-model which is created for setting the content in Customization Page
		self.navsToShowForCompany = []; // This data model is used for companyPage
		self.isTenantAdmin = cv.isTenantAdmin;
		self.subscriptionId = angular.isDefined($stateParams.subscriptionId)
			? $stateParams.subscriptionId
			: self.isTenantAdmin
			? cv.orgId
			: $stateParams.companyId;
		self.subscriptionName = $stateParams.subscriptionName;
		self.MSPCompanyMode = !self.isTenantAdmin && !_.isNil(self.subscriptionId) && parseInt(self.subscriptionId) > 0;
		self.TenantCompanyMode = self.isTenantAdmin && !_.isNil(self.subscriptionId) && parseInt(self.subscriptionId) > 0;
		self.MSPGlobalMode = !self.MSPCompanyMode && !self.TenantCompanyMode;
		let navs = [];
		let routes = [];
		let defaultNavs = [];
		let navSettingsFromAPI = null;
		let isGlobalNavSettingPresent = false;
		let roleToDeniedNavs = null;
		const PLAN_USER_ROLE = {
			MSP_ADMIN: 'Role_Msp_Admin',
			MSP_USER: 'Role_MSP_User',
			TENANT_ADMIN: 'Role_Tenant_Admin',
			TENANT_USER: 'Role_Tenant_User',
			RESTRICTED_USER: 'Role_Restricted_User'
		};
		const globalPersonaToDeniedNavsStatesMap = new Map();
		const companyPersonaToIncludeNavsStateMap = new Map(); // This will be updated from getHideNavSettings api company navsetting
		const companyPersonaToDeniedNavsStateMap = new Map(); // This will be updated from getHideNavSettings api company navsetting
		const aggregateCompanyPersonaToDeniedNavsStateMap = new Map();
		const rolesToDeniedStateMap = new Map(); // This map holds the information of json information.
		const companyResetToDefaultDeniedStateMap = new Map(); // This will be used in case of company reset to default.
		let companyDeniedLeftNavTreeSet = new Set();
		//Utility Functions

		// Defaulting the roles to false. The roles will
		const resetRoles = function(navItem) {
			navItem.CommcellAdmin = false;
			navItem.CommcellUser = false;
			navItem.TenantAdmin = false;
			navItem.TenantUser = false;
			navItem.RestrictedUser = false;
		};
		/*
			Helper Function to set roles of NavItem 
			@param => navItem : navObject from json
			@param => role : PLAN_USER_ROLE 
		*/

		const setRoles = function(navItem, role) {
			switch (role) {
				case PLAN_USER_ROLE.MSP_ADMIN:
					navItem.CommcellAdmin = true;
					break;
				case PLAN_USER_ROLE.MSP_USER:
					navItem.CommcellUser = true;
					break;
				case PLAN_USER_ROLE.TENANT_ADMIN:
					navItem.TenantAdmin = true;
					break;
				case PLAN_USER_ROLE.TENANT_USER:
					navItem.TenantUser = true;
					break;
				case PLAN_USER_ROLE.RESTRICTED_USER:
					navItem.RestrictedUser = true;
					break;
				default:
					navItem.CommcellAdmin = true;
					navItem.CommcellUser = true;
					navItem.TenantAdmin = true;
					navItem.TenantUser = true;
					navItem.RestrictedUser = true;
			}
		};

		/**
		 *
		 * @param {*} map : takes one of the map and intializes it with empy set {PLAN_USER_ROLE.TENANT_ADMIN : new Set() , PLAN_USER_ROLE.TENANT_USER : new Set()}
		 */
		const initializeCompanyMaps = map => {
			for (const property in PLAN_USER_ROLE) {
				if (
					PLAN_USER_ROLE[property] === PLAN_USER_ROLE.TENANT_ADMIN ||
					PLAN_USER_ROLE[property] === PLAN_USER_ROLE.TENANT_USER
				) {
					map.set(PLAN_USER_ROLE[property], new Set());
				}
			}
		};

		/**
		 * Initializes global map with empty setup
		 */
		const intializeGlobalMaps = () => {
			// This will be updated either from getHideNavSettings api or AppContext personaToDeniedNavsStateMap
			for (const property in PLAN_USER_ROLE) {
				globalPersonaToDeniedNavsStatesMap.set(PLAN_USER_ROLE[property], new Set());
			}
		};

		const initializeTabs = () => {
			tabService.init({
				tabs: customizationFactory.getTabsForState('navigationPreferences', self.subscriptionId, self.subscriptionName)
			});
		};

		intializeGlobalMaps();
		if (self.subscriptionId) {
			initializeCompanyMaps(companyPersonaToIncludeNavsStateMap);
			initializeCompanyMaps(companyPersonaToDeniedNavsStateMap);
			initializeCompanyMaps(aggregateCompanyPersonaToDeniedNavsStateMap);
			initializeCompanyMaps(companyResetToDefaultDeniedStateMap);
		}
		initializeTabs();

		//Both GlobalNavSettingPresent and RoleTodeniedNavs are obtained from AppContext and LoginContext hence no actual API calls are made here.

		let promises = [];
		promises.push(
			customizationService.getHideNavsList(angular.isDefined(self.subscriptionId) ? parseInt(self.subscriptionId) : 0)
		);
		promises.push(customizationService.getRoleToDeniedNavs());
		promises.push(
			customizationService.getNavList(angular.isDefined(self.subscriptionId) ? parseInt(self.subscriptionId) : 0)
		);

		$q.all(promises)
			.then(function(results) {
				navSettingsFromAPI = results[0].data.navSettings;
				roleToDeniedNavs = results[1].data;
				navs = results[2].data.routes;
				updateDeniedNavsMaps();
				preProcessNavs();
				addRemoveRolesOnNavsBasedOnDeniedNavsInformation();
				setupDefaultModelNew();
				parentElementTicksHandler();
			})
			.catch(function(data) {
				$log.error('Error loading denied navs');
			});

		/**
		 * This function does 2 things:
		 * 	1. updates aggregateCompanyPersonaToDeniedNavsStateMap : Global denied - company include + company denied
		 *  2. updates companyResetToDefaultDeniedStateMap
		 *
		 */

		const computeAggregateCompanyPersonaToDeniedNavsStateMap = () => {
			let aggregateTenantAdminDeniedNavs = new Set(globalPersonaToDeniedNavsStatesMap.get(PLAN_USER_ROLE.TENANT_ADMIN));
			let aggregateTenantUserDeniedNavs = new Set(globalPersonaToDeniedNavsStatesMap.get(PLAN_USER_ROLE.TENANT_USER));
			companyDeniedLeftNavTreeSet = new Set(globalPersonaToDeniedNavsStatesMap.get(PLAN_USER_ROLE.TENANT_ADMIN));

			// If MSP ADMIN resets to default from company navigation preferences : We reset to global persona information for TA and TU
			if (!self.isTenantAdmin) {
				companyResetToDefaultDeniedStateMap.set(PLAN_USER_ROLE.TENANT_ADMIN, new Set(aggregateTenantAdminDeniedNavs));
				companyResetToDefaultDeniedStateMap.set(PLAN_USER_ROLE.TENANT_USER, new Set(aggregateTenantUserDeniedNavs));
			}

			if (!_.isNil(companyPersonaToIncludeNavsStateMap)) {
				const companyTenantAdminIncludeNavsState = companyPersonaToIncludeNavsStateMap.get(PLAN_USER_ROLE.TENANT_ADMIN);
				const companyTenantUserIncludeNavsState = companyPersonaToIncludeNavsStateMap.get(PLAN_USER_ROLE.TENANT_USER);
				if (!_.isNil(companyTenantAdminIncludeNavsState)) {
					angular.forEach(companyTenantAdminIncludeNavsState, function(nav) {
						if (!_.isNil(companyDeniedLeftNavTreeSet) && companyDeniedLeftNavTreeSet.has(nav)) {
							companyDeniedLeftNavTreeSet.delete(nav);
						}
						if (!_.isNil(aggregateTenantAdminDeniedNavs) && aggregateTenantAdminDeniedNavs.has(nav)) {
							aggregateTenantAdminDeniedNavs.delete(nav);
						}
					});
				}

				if (!_.isNil(companyTenantUserIncludeNavsState)) {
					angular.forEach(companyTenantUserIncludeNavsState, function(nav) {
						if (!_.isNil(aggregateTenantUserDeniedNavs) && aggregateTenantUserDeniedNavs.has(nav)) {
							aggregateTenantUserDeniedNavs.delete(nav);
						}
					});
				}
			}
			// If Tenant Admin clicks reset to defauilt, its default will be global denied for TA and TU - company include for TA and TU
			if (self.isTenantAdmin) {
				companyResetToDefaultDeniedStateMap.set(PLAN_USER_ROLE.TENANT_ADMIN, new Set(aggregateTenantAdminDeniedNavs));
				companyResetToDefaultDeniedStateMap.set(PLAN_USER_ROLE.TENANT_USER, new Set(aggregateTenantUserDeniedNavs));
			}

			if (!_.isNil(companyPersonaToDeniedNavsStateMap)) {
				const companyTeantAdminDeniedNavsState = companyPersonaToDeniedNavsStateMap.get(PLAN_USER_ROLE.TENANT_ADMIN);
				const companyTenantUserDeniedNavsState = companyPersonaToDeniedNavsStateMap.get(PLAN_USER_ROLE.TENANT_USER);

				if (!_.isNil(companyTeantAdminDeniedNavsState)) {
					angular.forEach(companyTeantAdminDeniedNavsState, function(nav) {
						if (!_.isNil(aggregateTenantAdminDeniedNavs) && !aggregateTenantAdminDeniedNavs.has(nav)) {
							aggregateTenantAdminDeniedNavs.add(nav);
						}
					});
				}

				if (!_.isNil(companyTenantUserDeniedNavsState)) {
					angular.forEach(companyTenantUserDeniedNavsState, function(nav) {
						if (!_.isNil(aggregateTenantUserDeniedNavs) && !aggregateTenantUserDeniedNavs.has(nav)) {
							aggregateTenantUserDeniedNavs.add(nav);
						}
					});
				}
			}
			aggregateCompanyPersonaToDeniedNavsStateMap.set(PLAN_USER_ROLE.TENANT_ADMIN, aggregateTenantAdminDeniedNavs);
			aggregateCompanyPersonaToDeniedNavsStateMap.set(PLAN_USER_ROLE.TENANT_USER, aggregateTenantUserDeniedNavs);
		};

		const updateDeniedNavsMaps = () => {
			if (!_.isNil(roleToDeniedNavs)) {
				for (const property in roleToDeniedNavs) {
					rolesToDeniedStateMap.set(property, new Set(roleToDeniedNavs[property]));
				}
			}

			//Update Global And Company Setting Map from navSettingFromAPI
			if (navSettingsFromAPI !== null && angular.isDefined(navSettingsFromAPI)) {
				let gNavSettings = _.get(navSettingsFromAPI, 'globalSettings');
				let cNavSettings = _.get(navSettingsFromAPI, 'companySettings');

				if (!_.isNil(gNavSettings)) {
					angular.forEach(gNavSettings, function(gNavSetting) {
						const userRole = gNavSetting.userRole;
						const deniedNavItemsString = gNavSetting.deniedNavItems;
						if (!_.isNil(deniedNavItemsString) && isGlobalNavSettingPresent === false) {
							isGlobalNavSettingPresent = true;
						}
						if (!_.isNil(deniedNavItemsString) && !_.isEmpty(deniedNavItemsString)) {
							globalPersonaToDeniedNavsStatesMap.set(userRole, new Set(deniedNavItemsString.split(',')));
						}
					});

					// Update Global Setting Map -> This is the case when navigation preferences are never set at Global level, the property of Restricted Nav items for persona are not present in GxGlobal param
					if (!isGlobalNavSettingPresent) {
						//update globalSetting map from roleToDeniedNavs
						if (!_.isNil(roleToDeniedNavs)) {
							for (const property in roleToDeniedNavs) {
								globalPersonaToDeniedNavsStatesMap.set(property, new Set(roleToDeniedNavs[property]));
							}
						}
					}
				}

				if (!_.isNil(cNavSettings)) {
					angular.forEach(cNavSettings, function(cNavSetting) {
						const userRole = cNavSetting.userRole;
						const deniedNavItemsString = cNavSetting.deniedNavItems;
						const includeNavItemsString = cNavSetting.includeNavItems;

						if (
							!_.isNil(deniedNavItemsString) &&
							!_.isEmpty(deniedNavItemsString) &&
							!_.isNil(companyPersonaToDeniedNavsStateMap)
						) {
							companyPersonaToDeniedNavsStateMap.set(userRole, new Set(deniedNavItemsString.split(',')));
						}

						if (
							!_.isNil(includeNavItemsString) &&
							!_.isEmpty(includeNavItemsString) &&
							!_.isNil(companyPersonaToIncludeNavsStateMap)
						) {
							companyPersonaToIncludeNavsStateMap.set(userRole, new Set(includeNavItemsString.split(',')));
						}
					});
				}
				if (self.subscriptionId) {
					computeAggregateCompanyPersonaToDeniedNavsStateMap();
				}
			}
		};

		// Utility function to localize the title of navs and its subchildren and initialize roles for each state
		const localizecvTitleAndInitializeRoles = function(navItem, parent) {
			if (navItem.cvTitle !== null && angular.isDefined(navItem.cvTitle)) {
				navItem.cvTitle = navItem.titleLocalized ? navItem.cvTitle : cvLoc(navItem.cvTitle);
				if (!angular.isArray(navItem.roles) || angular.isUndefined(navItem.roles)) {
					if (angular.isArray(parent.roles)) {
						navItem.roles = parent.roles;
					} else {
						navItem.roles = [
							PLAN_USER_ROLE.MSP_ADMIN,
							PLAN_USER_ROLE.MSP_USER,
							PLAN_USER_ROLE.TENANT_ADMIN,
							PLAN_USER_ROLE.TENANT_USER,
							PLAN_USER_ROLE.RESTRICTED_USER
						];
					}
				}
				if (angular.isArray(navItem.children) && navItem.children.length > 0) {
					navItem.children.forEach(function(child) {
						localizecvTitleAndInitializeRoles(child, navItem);
					});
				}
			}
		};

		const preProcessNavs = () => {
			navs.forEach(function(nav) {
				localizecvTitleAndInitializeRoles(nav, nav);
			});
			defaultNavs = angular.copy(navs); // This is used when we use reset to default.
			routes = angular.copy(navs); // We are making a copy here because when we get the changes in settings we will do the changes on this model.
		};

		const addRemoveRolesToRoutesIfNotPresentNew = function(deniedNavItemsList, individualRoute, parentRoute, userRole) {
			if (individualRoute.cvTitle && angular.isDefined(individualRoute.cvTitle)) {
				if (angular.isArray(individualRoute.children) && individualRoute.children.length > 0) {
					individualRoute.children.forEach(function(child) {
						addRemoveRolesToRoutesIfNotPresentNew(deniedNavItemsList, child, individualRoute, userRole);
					});
				}

				//All Child nodes are checked if it is not present in deniedNavItemsList and it doesnot have role, append that role
				if (
					individualRoute.state &&
					angular.isDefined(individualRoute) &&
					angular.isUndefined(individualRoute.children) &&
					individualRoute.showNavItem
				) {
					// if route is not present in denied nav items list, then add role to that state else if it is present then in denied nav Items and state has the role, then we need to remove it.

					if (!deniedNavItemsList.has(individualRoute.state)) {
						if (!angular.isArray(individualRoute.roles) || angular.isUndefined(individualRoute.roles)) {
							individualRoute.roles = [];
						}

						if (!individualRoute.roles.includes(userRole)) {
							individualRoute.roles.push(userRole);
							if (!angular.isArray(parentRoute.roles) || angular.isUndefined(parentRoute.roles)) {
								parentRoute.roles = [];
							}
							if (!parentRoute.roles.includes(userRole)) {
								parentRoute.roles.push(userRole);
							}
						}
					} else {
						if (
							angular.isArray(individualRoute.roles) &&
							individualRoute.roles.length >= 0 &&
							individualRoute.roles.includes(userRole)
						) {
							var index = individualRoute.roles.indexOf(userRole);
							if (index > -1) {
								individualRoute.roles.splice(index, 1);
							}

							if (
								angular.isDefined(parentRoute.children) &&
								angular.isArray(parentRoute.children) &&
								parentRoute.children.length > 0
							) {
								var removeTenantAdminRoleForParent = true;
								parentRoute.children.forEach(function(child) {
									if (angular.isArray(child.roles) && child.roles.includes(userRole)) {
										removeTenantAdminRoleForParent = false;
									}
								});
								if (removeTenantAdminRoleForParent) {
									var parentIndex = parentRoute.roles.indexOf(userRole);
									if (index > -1) {
										parentRoute.roles.splice(parentIndex, 1);
									}
								}
							}
						}
					}
				}
			}
		};

		const updateRolesBasedOnMap = map => {
			if (map !== null && map !== undefined) {
				map.forEach((value, key) => {
					if (angular.isArray(routes) && routes.length > 0) {
						routes.forEach(function(individualRoute) {
							if (!_.isNil(value)) {
								addRemoveRolesToRoutesIfNotPresentNew(value, individualRoute, individualRoute, key);
							}
						});
					}
				});
			}
		};

		/**
		 * This function will add remove roles for each route in routes based on navigation preferences set at global level plus company level
		 */
		const addRemoveRolesOnNavsBasedOnDeniedNavsInformation = () => {
			if (self.MSPGlobalMode) {
				updateRolesBasedOnMap(globalPersonaToDeniedNavsStatesMap);
			} else {
				updateRolesBasedOnMap(aggregateCompanyPersonaToDeniedNavsStateMap);
			}
		};

		// This is util function to tell whether or not child is allowed to be seen on tree for navigation preferences.
		const isStateOrAnySubStateIsInCludeNavItems = (nav, isPresent) => {
			if (isPresent == true) {
				return true;
			}
			if (angular.isUndefined(nav.children)) {
				if (!companyDeniedLeftNavTreeSet.has(nav.state)) {
					return true;
				}
			}

			if (angular.isDefined(nav.children)) {
				angular.forEach(nav.children, function(child) {
					isPresent |= isStateOrAnySubStateIsInCludeNavItems(child, isPresent);
				});
			}

			return isPresent;
		};

		/*
		 * We need to set the levels on each nav for having that hierarchy and each Nav should be a part of
		 * the array so in below function we do the following things:- 1. set the hierarchy level 2. Set the
		 * roles of the navItem. (Setting roles is nothing but setting the corresponding role of the navItem
		 * to true or false which is used in selecting the checkbox) 3. Push the content in model and continue
		 * checking for its children.
		 */

		const addLevelandModifyDataNew = (navItem, level) => {
			if (angular.isDefined(navItem)) {
				navItem.$$treeLevel = level;
				resetRoles(navItem);
				if (navItem.roles === null || navItem.roles === undefined) {
					setRoles(navItem);
				} else {
					if (navItem.roles.length > 0) {
						navItem.roles.forEach(function(role) {
							setRoles(navItem, role);
						});
					}
				}
				angular.isDefined(self.subscriptionId)
					? self.navsToShowForCompany.push(navItem)
					: self.navsToShow.push(navItem);
				if (angular.isArray(navItem.children)) {
					navItem.children.forEach(function(child) {
						if (child.showNavItem) {
							if (child.roles === null || child.roles === undefined) {
								child.roles = navItem.roles.slice();
							}
							if (self.MSPGlobalMode || self.MSPCompanyMode) {
								addLevelandModifyDataNew(child, level + 1);
							} else {
								if (child.roles) {
									if (child.roles.includes(self.userRole) || isStateOrAnySubStateIsInCludeNavItems(child, false)) {
										addLevelandModifyDataNew(child, level + 1);
									}
								} else {
									addLevelandModifyDataNew(child, level + 1);
								}
							}
						}
					});
				}
			}
		};

		// This function is used to setup the cvGrid data model for the first time and when we click reset to default. This basically tells which row to show and which not to show based on userRole

		const setupDefaultModelNew = () => {
			if (angular.isDefined(routes)) {
				routes.forEach(function(route) {
					if (route.showNavItem) {
						// If MSP admin is doing changes to navigation preferences be it global level or company level show all the navigation items
						if (self.MSPGlobalMode || self.MSPCompanyMode) {
							var level = 0;
							addLevelandModifyDataNew(route, level);
						} else {
							// This final denied navs states includes Global denied - company include states
							// If roles are defined then check mapping of UserRoles and NavRoles
							if (route.roles) {
								if (route.roles.includes(self.userRole) || isStateOrAnySubStateIsInCludeNavItems(route, false)) {
									var level = 0;
									addLevelandModifyDataNew(route, level);
								}
							}
							// Else if the route does not have roles defined then consider that it has roles
							else {
								var level = 0;
								addLevelandModifyDataNew(route, level);
							}
						}
					}
				});
			}
		};

		// This ng-Change event triggers when the indiviudal check boxes are ticked. What it does is when a check box is ticked or unticked , if the nav has children all the n level deep children will obey the change.
		self.selectAndUpdateTicks = function(navItem, roleName) {
			if (angular.isArray(navItem.children)) {
				if (angular.isDefined(navItem[roleName + 'atleastOneChildSelected'])) {
					navItem[roleName + 'atleastOneChildSelected'] = false;
				}
				navItem.children.forEach(function(childItem) {
					let allowUpdateOnChildItem = true;
					if (angular.isDefined(childItem.state) && childItem.state === 'navigationPreferences') {
						allowUpdateOnChildItem = angular.isDefined(roleName) && roleName !== 'CommcellAdmin';
					}
					if (allowUpdateOnChildItem) {
						childItem[roleName] = navItem[roleName];
					}
					if (angular.isArray(childItem.children)) {
						self.selectAndUpdateTicks(childItem, roleName);
					}
				});
			}
		};

		/**
		 * Creates global Settings opject to send to request
		 * @param {*} dataModelToUse
		 */
		const createAndUpdateGlobalSettings = dataModelToUse => {
			const gMSPAdminSetting = new NavSetting(PLAN_USER_ROLE.MSP_ADMIN, null, null);
			const gMSPUserSetting = new NavSetting(PLAN_USER_ROLE.MSP_USER, null, null);
			const gTenantAdminSetting = new NavSetting(PLAN_USER_ROLE.TENANT_ADMIN, null, null);
			const gTenantUserSetting = new NavSetting(PLAN_USER_ROLE.TENANT_USER, null, null);
			const gRestrictedUsersetting = new NavSetting(PLAN_USER_ROLE.RESTRICTED_USER, '', null);
			let globalSettings = [];
			if (angular.isDefined(dataModelToUse) && dataModelToUse.length > 0) {
				dataModelToUse.forEach(function(navItem) {
					if (!navItem.children) {
						// This is done to avaoid sending parents to denied nav Items list
						if (angular.isDefined(navItem.CommcellAdmin) && !navItem.CommcellAdmin) {
							if (_.isNil(gMSPAdminSetting.deniedNavItems)) {
								gMSPAdminSetting.deniedNavItems = navItem.state;
							} else {
								gMSPAdminSetting.deniedNavItems += ',' + navItem.state;
							}
						}
						if (angular.isDefined(navItem.CommcellUser) && !navItem.CommcellUser) {
							if (_.isNil(gMSPUserSetting.deniedNavItems)) {
								gMSPUserSetting.deniedNavItems = navItem.state;
							} else {
								gMSPUserSetting.deniedNavItems += ',' + navItem.state;
							}
						}
						if (angular.isDefined(navItem.TenantAdmin) && !navItem.TenantAdmin) {
							if (_.isNil(gTenantAdminSetting.deniedNavItems)) {
								gTenantAdminSetting.deniedNavItems = navItem.state;
							} else {
								gTenantAdminSetting.deniedNavItems += ',' + navItem.state;
							}
						}
						if (angular.isDefined(navItem.TenantUser) && !navItem.TenantUser) {
							if (_.isNil(gTenantUserSetting.deniedNavItems)) {
								gTenantUserSetting.deniedNavItems = navItem.state;
							} else {
								gTenantUserSetting.deniedNavItems += ',' + navItem.state;
							}
						}
						if (angular.isDefined(navItem.RestrictedUser) && !navItem.RestrictedUser) {
							if (_.isNil(gRestrictedUsersetting.deniedNavItems)) {
								gRestrictedUsersetting.deniedNavItems = navItem.state;
							} else {
								gRestrictedUsersetting.deniedNavItems += ',' + navItem.state;
							}
						}
					}
				});
			}

			globalSettings.push(
				gMSPAdminSetting,
				gMSPUserSetting,
				gTenantAdminSetting,
				gTenantUserSetting,
				gRestrictedUsersetting
			);
			return globalSettings;
		};

		const createAndUpdateCompanySettings = dataModelToUse => {
			let companySettings = [];

			const cTenantAdminSetting = new NavSetting(PLAN_USER_ROLE.TENANT_ADMIN, '', self.MSPCompanyMode ? '' : null);
			const cTenantUserSetting = new NavSetting(PLAN_USER_ROLE.TENANT_USER, '', '');

			if (angular.isDefined(dataModelToUse) && dataModelToUse.length > 0) {
				dataModelToUse.forEach(function(navItem) {
					if (!navItem.children) {
						// Updating Denied Navs property, At this level we only send the diff in denied navs for company, so we ensure that we send only those items which are not part of global denied, plus if tenant admin, not part of company include.
						// This is done to avoid sending parents to denied nav Items list
						if (
							angular.isDefined(navItem.TenantAdmin) &&
							!navItem.TenantAdmin &&
							((!_.isNil(globalPersonaToDeniedNavsStatesMap) &&
								!_.isNil(globalPersonaToDeniedNavsStatesMap.get(PLAN_USER_ROLE.TENANT_ADMIN)) &&
								!globalPersonaToDeniedNavsStatesMap.get(PLAN_USER_ROLE.TENANT_ADMIN).has(navItem.state)) ||
								(self.isTenantAdmin &&
									!_.isNil(companyPersonaToIncludeNavsStateMap) &&
									!_.isNil(companyPersonaToIncludeNavsStateMap.get(PLAN_USER_ROLE.TENANT_ADMIN)) &&
									companyPersonaToIncludeNavsStateMap.get(PLAN_USER_ROLE.TENANT_ADMIN).has(navItem.state)))
						) {
							if (_.isNil(cTenantAdminSetting.deniedNavItems) || _.isEmpty(cTenantAdminSetting.deniedNavItems)) {
								cTenantAdminSetting.deniedNavItems = navItem.state;
							} else {
								cTenantAdminSetting.deniedNavItems += ',' + navItem.state;
							}
						}
						if (
							angular.isDefined(navItem.TenantUser) &&
							!navItem.TenantUser &&
							((!_.isNil(globalPersonaToDeniedNavsStatesMap) &&
								!_.isNil(globalPersonaToDeniedNavsStatesMap.get(PLAN_USER_ROLE.TENANT_USER)) &&
								!globalPersonaToDeniedNavsStatesMap.get(PLAN_USER_ROLE.TENANT_USER).has(navItem.state)) ||
								(self.isTenantAdmin &&
									!_.isNil(companyPersonaToIncludeNavsStateMap) &&
									!_.isNil(companyPersonaToIncludeNavsStateMap.get(PLAN_USER_ROLE.TENANT_USER)) &&
									companyPersonaToIncludeNavsStateMap.get(PLAN_USER_ROLE.TENANT_USER).has(navItem.state)))
						) {
							if (_.isNil(cTenantUserSetting.deniedNavItems) || _.isEmpty(cTenantUserSetting.deniedNavItems)) {
								cTenantUserSetting.deniedNavItems = navItem.state;
							} else {
								cTenantUserSetting.deniedNavItems += ',' + navItem.state;
							}
						}
						// We update include navigation items if it is globally denied and in context of company it is allowed
						if (
							angular.isDefined(navItem.TenantUser) &&
							navItem.TenantUser &&
							!_.isNil(globalPersonaToDeniedNavsStatesMap) &&
							!_.isNil(globalPersonaToDeniedNavsStatesMap.get(PLAN_USER_ROLE.TENANT_USER)) &&
							globalPersonaToDeniedNavsStatesMap.get(PLAN_USER_ROLE.TENANT_USER).has(navItem.state)
						) {
							if (_.isNil(cTenantUserSetting.includeNavItems) || _.isEmpty(cTenantUserSetting.includeNavItems)) {
								cTenantUserSetting.includeNavItems = navItem.state;
							} else {
								cTenantUserSetting.includeNavItems += ',' + navItem.state;
							}
						}

						// Updating include Nav items property in case of MSPCompanyMode for Tenant Admin
						if (self.MSPCompanyMode) {
							if (
								angular.isDefined(navItem.TenantAdmin) &&
								navItem.TenantAdmin &&
								!_.isNil(globalPersonaToDeniedNavsStatesMap) &&
								!_.isNil(globalPersonaToDeniedNavsStatesMap.get(PLAN_USER_ROLE.TENANT_ADMIN)) &&
								globalPersonaToDeniedNavsStatesMap.get(PLAN_USER_ROLE.TENANT_ADMIN).has(navItem.state)
							) {
								if (_.isNil(cTenantAdminSetting.includeNavItems) || _.isEmpty(cTenantAdminSetting.includeNavItems)) {
									cTenantAdminSetting.includeNavItems = navItem.state;
								} else {
									cTenantAdminSetting.includeNavItems += ',' + navItem.state;
								}
							}
						}
					}
				});
			}

			companySettings.push(cTenantAdminSetting, cTenantUserSetting);
			return companySettings;
		};

		const updatePreferencesNew = savePrefernces => {
			let navSettingsR = null;
			let updateNavItemRequest = null;
			if (self.MSPGlobalMode) {
				//Send only Global Settings with only denied navs as part of update request.
				let globalSettings = createAndUpdateGlobalSettings(self.navsToShow);
				navSettingsR = new navSettings(globalSettings, null);
			} else {
				//Send Both Global and Company Settings(include and denied) as part of update request.
				let companySettings = createAndUpdateCompanySettings(self.navsToShowForCompany);
				navSettingsR = new navSettings(null, companySettings);
			}
			updateNavItemRequest = new UpdateNavItemsReq(navSettingsR);
			customizationService
				.setUpdateHidenNavList(
					updateNavItemRequest,
					angular.isDefined(self.subscriptionId) ? parseInt(self.subscriptionId) : 0
				)
				.success(function(data) {
					cvToaster.showSuccessMessage({
						message: savePrefernces ? cvLoc('info.savedPreferences') : cvLoc('info.resetPreferences')
					});
				})
				.error(function(data) {
					$log.error(data);
					cvToaster.showErrorMessage({
						message: savePreferences ? cvLoc('error.errorSavingPreferences') : cvLoc('error.resetting')
					});
				});
		};

		// This is helper function for handling parent ticks.

		self.checkChildrenAndUpdateTick = function(nav, role) {
			var navresult = true;
			var childresult = true;
			var atLeastOneChildSelected = false;

			nav.children.forEach(function(child) {
				if (child.showNavItem) {
					var subchildresult = true;
					if (angular.isArray(child.children) && child.children.length > 0) {
						subchildresult = subchildresult && self.checkChildrenAndUpdateTick(child, role);
						atLeastOneChildSelected = atLeastOneChildSelected || child[role + 'atleastOneChildSelected'];
						childresult = childresult && subchildresult;
					} else {
						childresult = childresult && child[role];
						atLeastOneChildSelected = atLeastOneChildSelected || child[role];
					}
					navresult = navresult && childresult;
				}
			});
			nav[role + 'atleastOneChildSelected'] = atLeastOneChildSelected;
			return navresult;
		};

		// This method is used to handle parent ticks based on children selection. If all children are selected , the parent will be ticked otherwise it will be unticked.

		const parentElementTicksHandler = () => {
			var dataModelForParentTick = angular.isDefined(self.subscriptionId) ? self.navsToShowForCompany : self.navsToShow;
			dataModelForParentTick.forEach(function(nav, index) {
				if (angular.isDefined(nav) && angular.isDefined(nav.children) && nav.children.length > 0) {
					if (angular.isUndefined(self.subscriptionId)) {
						nav.CommcellAdmin = self.checkChildrenAndUpdateTick(nav, 'CommcellAdmin');
						nav.CommcellUser = self.checkChildrenAndUpdateTick(nav, 'CommcellUser');
						nav.RestrictedUser = self.checkChildrenAndUpdateTick(nav, 'RestrictedUser');
					}
					nav.TenantAdmin = self.checkChildrenAndUpdateTick(nav, 'TenantAdmin');
					nav.TenantUser = self.checkChildrenAndUpdateTick(nav, 'TenantUser');
				}
			});
		};

		// This function is triggered when save is clicked
		self.saveCustomization = function() {
			$dialogs.confirm(cvLoc('label.save'), cvLoc('prompt.saveChanges'), {
				noFunction: function() {},

				yesFunction: function() {
					updatePreferencesNew(true);
					parentElementTicksHandler();
				}
			});
		};

		// This function is triggered when reset to default is clicked
		self.resetToDefault = function() {
			$dialogs.confirm(cvLoc('label.customizationReset'), cvLoc('prompt.resetToDefault'), {
				noFunction: function() {},

				yesFunction: function() {
					angular.isDefined(self.subscriptionId) ? (self.navsToShowForCompany = []) : (self.navsToShow = []);
					routes = angular.copy(defaultNavs);
					if (self.subscriptionId) {
						updateRolesBasedOnMap(companyResetToDefaultDeniedStateMap);
					} else {
						updateRolesBasedOnMap(rolesToDeniedStateMap);
					}
					setupDefaultModelNew();
					updatePreferencesNew(false);
					parentElementTicksHandler();
				}
			});
		};
		self.isDisabled = function(stateName) {
			if (stateName && stateName.length >= 1 && stateName === 'navigationPreferences') {
				return true;
			} else {
				return false;
			}
		};
		// Defining pageLinks for cvGrid
		self.cvPageLinks = [
			{
				label: cvLoc('label.customizationReset'),
				onclick: self.resetToDefault
			},
			{
				label: cvLoc('label.save'),
				onclick: self.saveCustomization // Open Modal for confirmation
			}
		];
		self.masterColumnDefs = [
			{ name: cvLoc('gridHeader.name'), field: 'cvTitle', width: '30%', headerCellClass: 'left-align' },
			{
				field: 'CommcellAdmin',
				displayName: cvLoc('label.commcelladmin'),
				cellTemplate:
					'<input type="checkbox" id="{{row.entity.state + \'CommcellAdmin\'}}"  class=""  data-ng-disabled="grid.appScope.isDisabled(row.entity.state)" data-ng-model="row.entity.CommcellAdmin" data-ng-change="grid.appScope.selectAndUpdateTicks(row.entity,\'CommcellAdmin\')" data-ng-class="{\'partial-selection\': !row.entity.CommcellAdmin && row.entity.CommcellAdminatleastOneChildSelected}" />' +
					'<label for="{{row.entity.state + \'CommcellAdmin\'}}">&nbsp;</label>'
			},
			{
				field: 'CommcellUser',
				displayName: cvLoc('label.commcelluser'),
				cellTemplate:
					'<input type="checkbox" id="{{row.entity.state + \'CommcellUser\'}}"  class=""  data-ng-model="row.entity.CommcellUser" data-ng-change="grid.appScope.selectAndUpdateTicks(row.entity,\'CommcellUser\')" data-ng-class="{\'partial-selection\': !row.entity.CommcellUser && row.entity.CommcellUseratleastOneChildSelected}" />' +
					'<label for="{{row.entity.state + \'CommcellUser\'}}">&nbsp;</label>'
			},
			{
				field: 'TenantAdmin',
				displayName: cvLoc('label.tenantadmin'),
				cellTemplate:
					'<input type="checkbox" id="{{row.entity.state + \'TenantAdmin\'}}"  data-ng-model="row.entity.TenantAdmin" data-ng-change="grid.appScope.selectAndUpdateTicks(row.entity,\'TenantAdmin\')"  class=""  data-ng-class="{\'partial-selection\': !row.entity.TenantAdmin && row.entity.TenantAdminatleastOneChildSelected}"/>' +
					'<label for="{{row.entity.state + \'TenantAdmin\'}}">&nbsp;</label>'
			},
			{
				field: 'TenantUser',
				displayName: cvLoc('label.tenantuser'),
				cellTemplate:
					'<input type="checkbox" id="{{row.entity.state + \'TenantUser\'}}"  class=""  data-ng-model="row.entity.TenantUser" data-ng-change="grid.appScope.selectAndUpdateTicks(row.entity,\'TenantUser\')" data-ng-class="{\'partial-selection\': !row.entity.TenantUser && row.entity.TenantUseratleastOneChildSelected}" />' +
					'<label for="{{row.entity.state + \'TenantUser\'}}">&nbsp;</label>'
			},
			{
				field: 'RestrictedUser',
				displayName: cvLoc('label.restricteduser'),
				cellTemplate:
					'<input type="checkbox" id="{{row.entity.state + \'RestrictedUser\'}}"  class="" data-ng-model="row.entity.RestrictedUser" data-ng-change="grid.appScope.selectAndUpdateTicks(row.entity,\'RestrictedUser\')" data-ng-class="{\'partial-selection\': !row.entity.RestrictedUser && row.entity.RestrictedUseratleastOneChildSelected}"/>' +
					'<label for="{{row.entity.state + \'RestrictedUser\'}}">&nbsp;</label>'
			}
		];

		self.tenantColumnDefs = [
			{ name: cvLoc('gridHeader.name'), field: 'cvTitle', width: '30%' },
			{
				field: 'TenantAdmin',
				displayName: cvLoc('label.tenantadmin'),
				cellTemplate:
					'<input type="checkbox" id="{{row.entity.state + \'TenantAdmin\'}}"  class="" data-ng-model="row.entity.TenantAdmin" data-ng-change="grid.appScope.selectAndUpdateTicks(row.entity,\'TenantAdmin\')" data-ng-class="{\'partial-selection\': !row.entity.TenantAdmin && row.entity.TenantAdminatleastOneChildSelected}"/>' +
					'<label for="{{row.entity.state + \'TenantAdmin\'}}">&nbsp;</label>'
			},
			{
				field: 'TenantUser',
				displayName: cvLoc('label.tenantuser'),
				cellTemplate:
					'<input type="checkbox" id="{{row.entity.state + \'TenantUser\'}}"  class="" data-ng-model="row.entity.TenantUser" data-ng-change="grid.appScope.selectAndUpdateTicks(row.entity,\'TenantUser\')"  data-ng-class="{\'partial-selection\': !row.entity.TenantUser && row.entity.TenantUseratleastOneChildSelected}"/>' +
					'<label for="{{row.entity.state + \'TenantUser\'}}">&nbsp;</label>'
			}
		];

		// GridOptions to create cvGrid
		self.gridOptions = {
			cvIsPageTitle: true,
			cvPageLinks: cv.isAdmin ? self.cvPageLinks : [],
			cvGridCssClass: 'grid-style users-grid ui-tree-grid navigation-preferences',
			cvIsSearchable: true,
			cvHasTitle: true,
			cvSearchHandler: function(searchtext) {
				if (self.gridApi && searchtext.length >= 1) {
					self.gridApi.treeBase.expandAllRows();
				} else {
					self.gridApi.treeBase.collapseAllRows();
				}
			},
			cvAppScope: self,
			// cvCompanyDropdown : cv.isMspAdmin && angular.isUndefined(self.subscriptionName) ? true : false,
			cvSearchFields: ['cvTitle'],
			cvInfoText: cvLoc('label.navigationPreferencesInfoText'),
			cvGridTitle: angular.isDefined(self.subscriptionName)
				? cvLoc('pageHeader.navcustomization') + ' - ' + self.subscriptionName
				: cvLoc('pageHeader.navcustomization'),
			cvGridDirectives: {
				uiGridTreeView: true,
				uiGridPagination: false
			},
			gridOptions: angular.extend(angular.copy(cvTableOptions.commonNgGridOptions), {
				data: cv.isAdmin
					? angular.isDefined(self.subscriptionId) || self.isTenantAdmin
						? 'navsToShowForCompany'
						: 'navsToShow'
					: [],
				enableSorting: true,
				enableFiltering: true,
				enableTreeView: true,
				showTreeExpandNoChildren: false,
				onRegisterApi: function(gridApi) {
					self.gridApi = gridApi;
				},
				enablePaginationControls: false,
				enableGridMenu: false,
				paginationPageSize: 100,
				columnDefs:
					angular.isDefined(self.subscriptionId) || self.isTenantAdmin ? self.tenantColumnDefs : self.masterColumnDefs
			})
		};

		// Add breadcrumbs

		var breadCrumbs = [];

		breadCrumbs.push({
			title: cvLoc('label.nav.masterCustomization'),
			link: '#nav/masterCustomization'
		});

		cvBreadcrumbsTabsFactory.addBreadCrumbs(breadCrumbs);
	}
]);
export default navCustomizationMod;
