import 'modules/navCustomization/js/services/customization.svc.js';
import 'adminConsole/js/services/reports.svc.js';
import 'vsa/js/services/subscriptions.svc.js';
import 'dlo/js/services/customization.svc.js';
import 'modules/navCustomization/js/factory/customization.factory.js';

import { navCustomizationModule } from 'common/js/modules';

var navCustomizationMod = navCustomizationModule;

navCustomizationMod.controller('initialLandingController', [
	'$log',
	'cvUtil',
	'$dialogs',
	'cvLoc',
	'cvTableOptions',
	'$stateParams',
	'customizationService',
	'customReportsService',
	'cvBreadcrumbsTabsFactory',
	'cvToaster',
	'$q',
	'$state',
	'subscriptionService',
	'customizationFactory',
	'tabService',
	'reportsDashboardService',
	'ReportsConstants',
	'DASHBOARD_LINKS',
	function(
		$log,
		cvUtil,
		$dialogs,
		cvLoc,
		cvTableOptions,
		$stateParams,
		customizationService,
		customReportsService,
		cvBreadcrumbsTabsFactory,
		cvToaster,
		$q,
		$state,
		subscriptionService,
		customizationFactory,
		tabService,
		reportsDashboardService,
		ReportsConstants,
		DASHBOARD_LINKS
	) {
		var self = this;
		self.isTenantAdmin = cv.isTenantAdmin;
		self.subscriptionId = angular.isDefined($stateParams.subscriptionId)
			? $stateParams.subscriptionId
			: self.isTenantAdmin
			? cv.orgId
			: $stateParams.copmanyId;
		self.subscriptionName = $stateParams.subscriptionName;
		self.dashBoardReports = [];

		const OVERVIEW_DASHBOARD = 'overviewDashboard';
		const TENANT_DASHBOARD = 'tenantDashboard';
		const VIRTUALIZATION_DASHBOARD = 'virtualizationDashboard';
		const APPLIANCE_DASHBOARD = 'applianceDashboard';
		const ORCHESTRATION_DASHBOARD = 'disasterRecoveryDashboard';
		const ENDPOINT_DASHBOARD = 'endpointDashboard';
		const APPLIANCE2_DASHBOARD = 'appliance2Dashboard';
		const ACTIVATE_DASHBOARD = 'activateDashboard';
		const ROLE_MSP_ADMIN = 'Role_Msp_Admin';
		const ROLE_MSP_USER = 'Role_MSP_User';
		const ROLE_TENANT_ADMIN = 'Role_Tenant_Admin';
		const ROLE_TENANT_USER = 'Role_Tenant_User';
		const ROLE_RESTRICTED_USER = 'Role_Restricted_User';
		const globalPersonaToDeniedNavsStatesMap = new Map();
		const companyPersonaToDeniedNavsStateMap = new Map();
		const companyPersonaToIncludeNavsStateMap = new Map();
		let navSettingsFromAPI = null;
		let roleToDeniedNavs = null;
		let isGlobalNavSettingPresent = false;
		const PLAN_USER_ROLE = {
			MSP_ADMIN: 'Role_Msp_Admin',
			MSP_USER: 'Role_MSP_User',
			TENANT_ADMIN: 'Role_Tenant_Admin',
			TENANT_USER: 'Role_Tenant_User',
			RESTRICTED_USER: 'Role_Restricted_User'
		};
		const isApplianceSetup =
			_.get(cvApp, 'csEnvironmentInfo.isApplianceCS', false) ||
			_.get(cvApp, 'csEnvironmentInfo.isCSWithApplianceNode', false) ||
			_.get(cvApp, 'csEnvironmentInfo.isRefArchitecture', false);
		const DASHBOARDS = {
			OVERVIEW_DASHBOARD: {
				state: OVERVIEW_DASHBOARD,
				url: DASHBOARD_LINKS.OVERVIEW,
				cvTitle: cvLoc('label.dashboard.overview'),
				showNavItem: true
			},
			TENANT_DASHBOARD: {
				state: TENANT_DASHBOARD,
				url: DASHBOARD_LINKS.TENANT,
				cvTitle: cvLoc('label.dashboard.tenant'),
				showNavItem: true
			},
			VIRTUALIZATION_DASHBOARD: {
				state: VIRTUALIZATION_DASHBOARD,
				url: DASHBOARD_LINKS.VIRTUALIZATION,
				cvTitle: cvLoc('label.dashboard.virtualization'),
				showNavItem: true
			},
			APPLIANCE_DASHBOARD: {
				state: APPLIANCE_DASHBOARD,
				url: DASHBOARD_LINKS.APPLIANCE,
				cvTitle: cvLoc('label.dashboard.appliance'),
				showNavItem: true
			},
			ORCHESTRATION_DASHBOARD: {
				state: ORCHESTRATION_DASHBOARD,
				url: DASHBOARD_LINKS.DISASTER_RECOVERY,
				cvTitle: cvLoc('label.dashboard.disasterrecovery'),
				showNavItem: true
			},
			ENDPOINT_DASHBOARD: {
				state: ENDPOINT_DASHBOARD,
				url: DASHBOARD_LINKS.ENDPOINT,
				cvTitle: cvLoc('label.dashboard.endpoint'),
				showNavItem: true
			},
			APPLIANCE2_DASHBOARD: {
				state: APPLIANCE2_DASHBOARD,
				url: DASHBOARD_LINKS.APPLIANCE2,
				cvTitle: cvLoc('label.dashboard.endpoint'),
				showNavItem: true
			},
			ACTIVATE_DASHBOARD: {
				state: 'dashboard',
				stateName: ACTIVATE_DASHBOARD,
				params: {
					dashboardId: 'activate'
				},
				url: DASHBOARD_LINKS.ACTIVATE,
				cvTitle: cvLoc('label.dashboard.activate'),
				showNavItem: true
			}
		};
		const roleToDeniedDashboardMap = new Map();
		roleToDeniedDashboardMap.set(
			ROLE_TENANT_ADMIN,
			new Set([OVERVIEW_DASHBOARD, APPLIANCE_DASHBOARD, APPLIANCE2_DASHBOARD, ORCHESTRATION_DASHBOARD])
		);
		roleToDeniedDashboardMap.set(
			ROLE_TENANT_USER,
			new Set([
				OVERVIEW_DASHBOARD,
				ORCHESTRATION_DASHBOARD,
				APPLIANCE_DASHBOARD,
				APPLIANCE2_DASHBOARD,
				VIRTUALIZATION_DASHBOARD,
				ENDPOINT_DASHBOARD
			])
		);
		roleToDeniedDashboardMap.set(
			ROLE_RESTRICTED_USER,
			new Set([
				OVERVIEW_DASHBOARD,
				ORCHESTRATION_DASHBOARD,
				APPLIANCE_DASHBOARD,
				APPLIANCE2_DASHBOARD,
				VIRTUALIZATION_DASHBOARD,
				ENDPOINT_DASHBOARD
			])
		);
		roleToDeniedDashboardMap.set(
			ROLE_MSP_USER,
			new Set([
				OVERVIEW_DASHBOARD,
				ORCHESTRATION_DASHBOARD,
				APPLIANCE_DASHBOARD,
				APPLIANCE2_DASHBOARD,
				VIRTUALIZATION_DASHBOARD,
				ENDPOINT_DASHBOARD
			])
		);

		tabService.init({
			tabs: customizationFactory.getTabsForState('initialLanding', self.subscriptionId, self.subscriptionName)
		});

		const initializeCompanyMaps = map => {
			for (const property in PLAN_USER_ROLE) {
				if (
					PLAN_USER_ROLE[property] === PLAN_USER_ROLE.TENANT_ADMIN ||
					PLAN_USER_ROLE[property] === PLAN_USER_ROLE.TENANT_USER
				) {
					map.set(PLAN_USER_ROLE[property], new Set());
				}
			}
		};

		const intializeGlobalMaps = () => {
			// This will be updated either from getHideNavSettings api or AppContext personaToDeniedNavsStateMap
			for (const property in PLAN_USER_ROLE) {
				globalPersonaToDeniedNavsStatesMap.set(PLAN_USER_ROLE[property], new Set());
			}
		};

		intializeGlobalMaps();
		if (self.subscriptionId) {
			initializeCompanyMaps(companyPersonaToIncludeNavsStateMap);
			initializeCompanyMaps(companyPersonaToDeniedNavsStateMap);
		}

		const updateDeniedNavsMaps = () => {
			//Update Global And Company Setting Map from navSettingFromAPI
			if (navSettingsFromAPI !== null && angular.isDefined(navSettingsFromAPI)) {
				let gNavSettings = _.get(navSettingsFromAPI, 'globalSettings');
				let cNavSettings = _.get(navSettingsFromAPI, 'companySettings');

				if (!_.isNil(gNavSettings)) {
					angular.forEach(gNavSettings, function(gNavSetting) {
						const userRole = gNavSetting.userRole;
						const deniedNavItemsString = gNavSetting.deniedNavItems;
						if (!_.isNil(deniedNavItemsString) && isGlobalNavSettingPresent === false) {
							isGlobalNavSettingPresent = true;
						}
						if (!_.isNil(deniedNavItemsString) && !_.isEmpty(deniedNavItemsString)) {
							globalPersonaToDeniedNavsStatesMap.set(userRole, new Set(deniedNavItemsString.split(',')));
						}
					});

					// Update Global Setting Map
					if (!isGlobalNavSettingPresent) {
						//update globalSetting map from roleToDeniedNavs
						if (!_.isNil(roleToDeniedNavs)) {
							for (const property in roleToDeniedNavs) {
								globalPersonaToDeniedNavsStatesMap.set(property, new Set(roleToDeniedNavs[property]));
							}
						}
					}
				}

				if (!_.isNil(cNavSettings)) {
					angular.forEach(cNavSettings, function(cNavSetting) {
						const userRole = cNavSetting.userRole;
						const deniedNavItemsString = cNavSetting.deniedNavItems;
						const includeNavItemsString = cNavSetting.includeNavItems;

						if (
							!_.isNil(deniedNavItemsString) &&
							!_.isEmpty(deniedNavItemsString) &&
							!_.isNil(companyPersonaToDeniedNavsStateMap)
						) {
							companyPersonaToDeniedNavsStateMap.set(userRole, new Set(deniedNavItemsString.split(',')));
						}

						if (
							!_.isNil(includeNavItemsString) &&
							!_.isEmpty(includeNavItemsString) &&
							!_.isNil(companyPersonaToIncludeNavsStateMap)
						) {
							companyPersonaToIncludeNavsStateMap.set(userRole, new Set(includeNavItemsString.split(',')));
						}
					});
				}
			}
		};

		// Helper function to avoid duplication of caode in self.preProcess. If the user is TenantAdmin push the route to navsToShowTenantAdmin else push the route to navsToShow

		self.pushRoute = function(route) {
			if (cv.isTenantAdmin) {
				if (self.navsToShowTenantAdmin === null || angular.isUndefined(self.navsToShowTenantAdmin)) {
					self.navsToShowTenantAdmin = [];
				}
				self.navsToShowTenantAdmin.push(route);
			}
			if (cv.isAdmin && !cv.isTenantAdmin) {
				if (self.navsToShow === null || angular.isUndefined(self.navsToShow)) {
					self.navsToShow = [];
				}
				self.navsToShow.push(route);
			}
		};

		// This tick property is used for setting a particular nav Item in overridePreferences code. This will facilitate updating the selected Nav Item in initial landing for the role in UI.
		// We set the result to true based on global setting and override the content based on company setting.
		self.updateTickBasedOnPreferences = function(navItem, role) {
			var result = false;
			if (angular.isObject(navItem) && angular.isDefined(navItem) && angular.isDefined(navItem.url)) {
				if (angular.isObject(self.navSettings) && angular.isDefined(self.navSettings)) {
					//creating url for comparison here after removing additional parameters and required parameters for exact comparison because /servers from api can match with /serversDashboard, /servers of hypervisors and /servers of AWS
					var comparisonURL = angular.copy(navItem.url);
					if (!comparisonURL.includes('/reportDetails')) {
						if (comparisonURL.includes(':')) {
							comparisonURL = comparisonURL.substring(0, navItem.url.indexOf(':'));
						}

						if (comparisonURL.includes('?')) {
							comparisonURL = comparisonURL.substring(0, comparisonURL.indexOf('?'));
						}
					}

					angular.forEach(self.navSettings, function(value, key) {
						if (key === 'globalSettings') {
							value.forEach(function(navSetting) {
								if (
									navSetting.userRole === role &&
									navSetting.defaultLandingPage &&
									navSetting.defaultLandingPage !== '' &&
									comparisonURL === navSetting.defaultLandingPage
								) {
									result = true;
								}
							});
						}
						if (self.subscriptionId && key === 'companySettings') {
							value.forEach(function(navSetting) {
								if (
									navSetting.userRole === role &&
									navSetting.defaultLandingPage &&
									navSetting.defaultLandingPage !== ''
								) {
									if (comparisonURL === navSetting.defaultLandingPage) {
										result = true;
									} else {
										result = false;
									}
								}
							});
						}
					});
				}
			}
			return result;
		};

		const isNotRoleRestrictedDashboardState = (stateName, role) => {
			if (!_.isNull(stateName) && !_.isUndefined(stateName)) {
				return !roleToDeniedDashboardMap.get(role).has(stateName);
			}
			return true;
		};
		const removeDashboardsNotApplicableForRole = (role, dataModelToReturn) => {
			if (!_.isNull(role) && !_.isUndefined(role)) {
				dataModelToReturn = dataModelToReturn.filter(item => {
					const stateName = item.stateName ? item.stateName : item.state;
					switch (role) {
						case ROLE_TENANT_ADMIN:
							return item && isNotRoleRestrictedDashboardState(stateName, ROLE_TENANT_ADMIN);
							break;
						case ROLE_TENANT_USER:
							return item && isNotRoleRestrictedDashboardState(stateName, ROLE_TENANT_USER);
							break;
						case ROLE_MSP_USER:
							return item && isNotRoleRestrictedDashboardState(stateName, ROLE_MSP_USER);
							break;
						case ROLE_RESTRICTED_USER:
							return item && isNotRoleRestrictedDashboardState(stateName, ROLE_RESTRICTED_USER);
							break;
						default:
							return true;
					}
				});
			}
			return dataModelToReturn;
		};

		//Helper function to override the global and company level denied Navs for user Role.What we do over here is we extract the deniedNavItems for given role and set the diabled property of nvItem to true if it is present in denied nav items list
		self.overridePreferences = function(role) {
			if (role && role.length >= 1) {
				let deniedNavItemsList = new Set(globalPersonaToDeniedNavsStatesMap.get(role));
				if (role == PLAN_USER_ROLE.TENANT_ADMIN || PLAN_USER_ROLE.TENANT_USER) {
					if (
						!_.isNil(companyPersonaToIncludeNavsStateMap) &&
						!_.isNil(companyPersonaToIncludeNavsStateMap.get(role))
					) {
						angular.forEach(companyPersonaToIncludeNavsStateMap.get(role), function(nav) {
							if (deniedNavItemsList.has(nav)) {
								deniedNavItemsList.delete(nav);
							}
						});
					}
					if (!_.isNil(companyPersonaToDeniedNavsStateMap) && !_.isNil(companyPersonaToDeniedNavsStateMap.get(role))) {
						angular.forEach(companyPersonaToDeniedNavsStateMap.get(role), function(nav) {
							if (!deniedNavItemsList.has(nav)) {
								deniedNavItemsList.add(nav);
							}
						});
					}
				}
				if (deniedNavItemsList.has('dashboard')) {
					for (const property in DASHBOARDS) {
						deniedNavItemsList.add(DASHBOARDS[property].state);
					}
				}

				let dataModelToReturn = cv.isTenantAdmin
					? angular.copy(self.navsToShowTenantAdmin)
					: angular.copy(self.navsToShow);
				if (dataModelToReturn && angular.isDefined(dataModelToReturn)) {
					dataModelToReturn = removeDashboardsNotApplicableForRole(role, dataModelToReturn);
					dataModelToReturn.forEach(function(navItem) {
						if (navItem.state && angular.isDefined(navItem.state)) {
							if (
								deniedNavItemsList &&
								angular.isDefined(deniedNavItemsList) &&
								deniedNavItemsList.has(navItem.state)
							) {
								navItem.disabled = true;
							}
							// if((role === ROLE_TENANT_USER || role === ROLE_RESTRICTED_USER) && (navItem.state === "overviewDashboard" || navItem.state === "tenantDashboard" || navItem.state === "virtualizationDashboard" || navItem.state === "orchestrationDashboard" || navItem.state === "applianceDashboard") ){
							// 	navItem.disabled = true;
							// }
						}
						if (navItem.url && angular.isDefined(navItem.url)) {
							navItem.ticked = self.updateTickBasedOnPreferences(navItem, role);
						}
					});
				}

				return dataModelToReturn;
			}
		};
		//Helper function for recursion
		const isAtleastOneChildVisibleHelper = (children, isOneChildVisible) => {
			if (isOneChildVisible === true) {
				return true;
			}
			if (!angular.isArray(children) || children.length === 0) {
				return false;
			}
			if (angular.isArray(children)) {
				children.forEach(child => {
					if (angular.isArray(child.children)) {
						isOneChildVisible = isAtleastOneChildVisibleHelper(child.children, isOneChildVisible);
					}
					if (!isOneChildVisible && child.showNavItem === true) {
						isOneChildVisible = true;
					}
				});
				return isOneChildVisible;
			}
		};

		self.isAtleastOneChildVisible = route => {
			let isOneChildVisible = false;
			isOneChildVisible = isAtleastOneChildVisibleHelper(route.children, isOneChildVisible);
			return isOneChildVisible;
		};

		//This method is helper method to preprocess the routes. Preprocess includes addition of ms(master Group) property if it has children which is used in I-stevens with hierarchy view.

		self.preProcess = function(route) {
			// If route has chidren, add additional Property msGroup:true for the route and iterate over children else directly push route.
			if (angular.isArray(route.children) && self.isAtleastOneChildVisible(route)) {
				route.msGroup = true;
				self.pushRoute(route);
				route.children.forEach(function(child) {
					if (cv.isTenantAdmin) {
						//If it is tenant Admin, process the child only if it is not present in deniedNavItemListTenantAdmin
						if (
							child.state &&
							angular.isDefined(child.state) &&
							!_.isNil(self.deniedNavItemsListTenantAdmin) &&
							!self.deniedNavItemsListTenantAdmin.has(child.state)
						) {
							self.preProcess(child);
						}
					}
					if (cv.isAdmin && !cv.isTenantAdmin) {
						self.preProcess(child);
					}
				});

				// After all the children are added to the datamodel based on role - tenantAdmin: navsToShowTenantAdmin & mspAdmin : navsToShow, adding additonal object msGroup:false to maintain tree structure.
				if (cv.isTenantAdmin) {
					self.navsToShowTenantAdmin.push({ msGroup: false });
				}
				if (cv.isAdmin && !cv.isTenantAdmin) {
					self.navsToShow.push({ msGroup: false });
				}
			} else {
				if (route.showNavItem) {
					self.pushRoute(route);
				}
			}
		};

		//Setting up navsToShow or navsToShowTenantAdmin
		self.setupDataModel = function() {
			if (self.routes && angular.isDefined(self.routes)) {
				// Below case is used when in tenantAdmin mode because , we show only those navs which are available to them, as against when we are seeing at MSP Admin, where we show all the navs and disable based on the navigation preferences
				if (cv.isTenantAdmin) {
					self.deniedNavItemsListTenantAdmin = new Set(
						globalPersonaToDeniedNavsStatesMap.get(PLAN_USER_ROLE.TENANT_ADMIN)
					);
					if (
						!_.isNil(companyPersonaToIncludeNavsStateMap) &&
						!_.isNil(companyPersonaToIncludeNavsStateMap.get(PLAN_USER_ROLE.TENANT_ADMIN))
					) {
						angular.forEach(companyPersonaToIncludeNavsStateMap.get(PLAN_USER_ROLE.TENANT_ADMIN), function(nav) {
							if (self.deniedNavItemsListTenantAdmin.has(nav)) {
								self.deniedNavItemsListTenantAdmin.delete(nav);
							}
						});
					}
				}
				self.routes.forEach(function(route) {
					if (route.cvTitle !== null && angular.isDefined(route.cvTitle) && route.showNavItem === true) {
						//Since we have all dashboard pages as the default landing page we are adding the dashboards manually as the children of parent Dashboard.
						if (route.state && angular.isDefined(route.state) && route.state === 'dashboard') {
							if (route.children === null || angular.isUndefined(route.children)) {
								route.children = [];
							}
							route.children.push(
								DASHBOARDS.OVERVIEW_DASHBOARD,
								DASHBOARDS.TENANT_DASHBOARD,
								DASHBOARDS.VIRTUALIZATION_DASHBOARD,
								DASHBOARDS.ORCHESTRATION_DASHBOARD,
								DASHBOARDS.ENDPOINT_DASHBOARD,
								DASHBOARDS.ACTIVATE_DASHBOARD
							);
							if (isApplianceSetup) {
								route.children.push(DASHBOARDS.APPLIANCE_DASHBOARD);
								route.children.push(DASHBOARDS.APPLIANCE2_DASHBOARD);
							}

							if (angular.isArray(self.dashBoardReports) && self.dashBoardReports.length >= 1) {
								self.dashBoardReports.forEach(function(dashboardReport) {
									route.children.push({
										state: dashboardReport.state,
										url: dashboardReport.route,
										cvTitle: dashboardReport.reportName,
										params: dashboardReport.params ? dashboardReport.params : undefined
									});
								});
							}
						}
						if (cv.isTenantAdmin) {
							// If we are having tenantAdmin mode and the route is not present in self.deniedNavItemsListTenantAdmin then only process the route.
							if (
								route.state &&
								angular.isDefined(route.state) &&
								!_.isNil(self.deniedNavItemsListTenantAdmin) &&
								!self.deniedNavItemsListTenantAdmin.has(route.state)
							) {
								self.preProcess(route);
							}
						}
						if (cv.isAdmin && !cv.isTenantAdmin) {
							self.preProcess(route);
						}
					}
				});
			}
		};

		// Utility function to localize the title of navs and its subchildren also setting default properties of ticked and disabled to false. This will be updated in override preferences Method
		self.localizecvTitleandUpdateTicks = function(navItem, parent) {
			//Removing aws from self.navs
			if (navItem.state === 'compute') {
				navItem.children = navItem.children.filter(child => {
					return child.state !== 'servers';
				});
			}

			if (navItem.cvTitle !== null && angular.isDefined(navItem.cvTitle)) {
				navItem.cvTitle = navItem.titleLocalized ? navItem.cvTitle : cvLoc(navItem.cvTitle);
				navItem.ticked = false;
				navItem.disabled = false;
				if (!navItem.roles || angular.isUndefined(navItem.roles)) {
					if (parent.roles && angular.isDefined(parent.roles)) {
						navItem.roles = angular.copy(parent.roles);
					} else {
						navItem.roles = [ROLE_MSP_ADMIN, ROLE_MSP_USER, ROLE_TENANT_ADMIN, ROLE_TENANT_USER, ROLE_RESTRICTED_USER];
					}
				}
			}

			if (angular.isArray(navItem.children)) {
				navItem.children.forEach(function(child) {
					self.localizecvTitleandUpdateTicks(child, navItem);
				});
			}
		};

		// This is the entry point into the controller. When the controller is loaded it first enters this piece.On Load we load two piece of data which we need for this controller.
		/*
		 * 1. naviagationList which can be set as default landig page 2. Data Model which needs to be set for
		 * cvGrid
		 *
		 * Once the navList is created we enable disable the navigations which are not allowed to them in
		 * navigation preferences.
		 */

		customizationService
			.getNavList(angular.isDefined(self.subscriptionId) ? parseInt(self.subscriptionId) : 0)
			.success(function(data) {
				self.navs = data.routes;

				//get custom dashboards and reports tagged as Dashboard
				let promises = [];
				promises.push(reportsDashboardService.getDataset(ReportsConstants.DASHBOARD_DATASET));
				promises.push(customReportsService.getReportsList('Dashboard'));

				$q.all(promises)
					.then(function(results) {
						if (results[0] && results[0].data) {
							let dashboards = results[0].data;
							if (dashboards.records) {
								const BUILT_IN_MASK = 128;
								angular.forEach(dashboards.records, function(dData) {
									let flag = dData[ReportsConstants.FLAGS_INDEX];
									if ((flag & BUILT_IN_MASK) == 0) {
										let dashboard = {
											state: 'dashboard',
											reportName: dData[ReportsConstants.REPORT_NAME_INDEX],
											route: '/dashboard/' + dData[ReportsConstants.USER_REPORT_ID_INDEX],
											params: {
												dashboardId: dData[ReportsConstants.USER_REPORT_ID_INDEX]
											},
											showNavItem: true
										};
										self.dashBoardReports.push(dashboard);
									}
								});
							}
						}

						if (results[1] && results[1].data) {
							let reports = results[1].data.reports;
							if (reports) {
								angular.forEach(reports, function(report) {
									let dashboard = {
										state: 'reportDetails',
										reportName: report.reportName,
										route: '/reportDetails?name=' + report.reportName + '&app=ADMIN_CONSOLE',
										params: {
											name: report.reportName,
											app: 'ADMIN_CONSOLE'
										},
										showNavItem: true
									};
									self.dashBoardReports.push(dashboard);
								});
							}
						}

						processNavList();
					})
					.catch(function(data) {
						$log.error('Error loading dashboards');
						processNavList();
					});
			})
			.error(function(data) {
				$log.error('Error loading Nav List');
				cvToaster.showErrorMessage({
					message: cvLoc('error.errorLoadingNavList')
				});
			});

		function processNavList() {
			//This is done to remove webConsole Links to be set as initialLanding Page
			var indexOfWC = self.navs.findIndex(item => item.state === 'webconsole');
			if (indexOfWC > 0) {
				self.navs.splice(indexOfWC, 1);
			}
			// We need to localize the title before storing in datamodel used for grid. So below iteration will do that
			self.navs.forEach(function(nav) {
				self.localizecvTitleandUpdateTicks(nav, nav);
			});

			self.routes = angular.copy(self.navs);

			const internalPromises = [];
			internalPromises.push(customizationService.getRoleToDeniedNavs());
			internalPromises.push(
				customizationService.getHideNavsList(angular.isDefined(self.subscriptionId) ? parseInt(self.subscriptionId) : 0)
			);
			$q.all(internalPromises)
				.then(function(results1) {
					roleToDeniedNavs = results1[0].data;
					navSettingsFromAPI = results1[1].data.navSettings;
					self.navSettings = results1[1].data.navSettings;
					updateDeniedNavsMaps();
					self.setupDataModel();
					self.dataModel = [
						{
							userRole: ROLE_TENANT_ADMIN,
							role: cvLoc('label.tenantadmin'),
							navigationList: self.overridePreferences(ROLE_TENANT_ADMIN)
						},
						{
							userRole: ROLE_TENANT_USER,
							role: cvLoc('label.tenantuser'),
							navigationList: self.overridePreferences(ROLE_TENANT_USER)
						}
					];

					if (cv.isAdmin && !cv.isTenantAdmin && !self.subscriptionId) {
						self.dataModel.splice(
							0,
							0,
							{
								userRole: ROLE_MSP_ADMIN,
								role: cvLoc('label.commcelladmin'),
								navigationList: self.overridePreferences(ROLE_MSP_ADMIN)
							},
							{
								userRole: ROLE_MSP_USER,
								role: cvLoc('label.commcelluser'),
								navigationList: self.overridePreferences(ROLE_MSP_USER)
							}
						);

						self.dataModel.push({
							userRole: ROLE_RESTRICTED_USER,
							role: cvLoc('label.restricteduser'),
							navigationList: self.overridePreferences(ROLE_RESTRICTED_USER)
						});
					}
				})
				.catch(function(data) {
					$log.error('Error loading interal promises');
				});
		}

		//Resetting the navigation to default. Here opertation should change based on
		/*
		 * 1. called from global page: set the tick property of each navigation item in navigation list to
		 * false, second if defaultLandingPage[0].url is set, reset. 2. called from company page: Set the tick
		 * property and defaultLAndingpage setting to that of MSP setting.(Pending)
		 */

		self.resetNavList = function(singleDataModel) {
			var globalUrlForRole;
			//If reset from companyLevel, set it to global defaultLandingPage
			if (angular.isDefined(self.subscriptionId) && !_.isNil(self.navSettings)) {
				angular.forEach(self.navSettings, function(value, key) {
					if (key === 'globalSettings') {
						value.forEach(function(indiRoleSetting) {
							if (
								indiRoleSetting.userRole === singleDataModel.userRole &&
								indiRoleSetting.defaultLandingPage &&
								angular.isDefined(indiRoleSetting.defaultLandingPage) &&
								indiRoleSetting.defaultLandingPage !== ''
							) {
								globalUrlForRole = indiRoleSetting.defaultLandingPage;
							}
						});
					}
				});
			}

			// Resetting the ticked property to false. If it is a company or TenantAdminMode we reset the settings to MSP Settings.
			if (
				singleDataModel.navigationList &&
				angular.isArray(singleDataModel.navigationList) &&
				singleDataModel.navigationList.length >= 1
			) {
				//This is done to avoid switching to same DefaultLanding State when reset is pressed twice
				var localNavigationList = angular.copy(singleDataModel.navigationList);
				localNavigationList.forEach(function(nav) {
					if (
						angular.isDefined(self.subscriptionId) &&
						angular.isDefined(globalUrlForRole) &&
						nav.url &&
						angular.isDefined(nav.url) &&
						nav.url.substring(0, globalUrlForRole.length) === globalUrlForRole
					) {
						nav.ticked = true;
					} else {
						nav.ticked = false;
					}
				});
				singleDataModel.navigationList = angular.copy(localNavigationList);
			}
			//resetting the url to ""
			if (
				angular.isArray(singleDataModel.defaultLandingPage) &&
				singleDataModel.defaultLandingPage.length === 1 &&
				angular.isObject(singleDataModel.defaultLandingPage[0]) &&
				angular.isDefined(singleDataModel.defaultLandingPage[0])
			) {
				if (
					angular.isDefined(singleDataModel.defaultLandingPage[0].url) &&
					singleDataModel.defaultLandingPage[0].url.length >= 1
				) {
					singleDataModel.defaultLandingPage[0].url = '';
					if (angular.isDefined(self.subscriptionId) && angular.isDefined(globalUrlForRole)) {
						singleDataModel.defaultLandingPage[0].url = globalUrlForRole;
					}
				}
			}
		};

		// Map which holds the default urls of state which has required paramters.
		self.stateToUrlMap = {
			windowsFsServers: '/fsServers?type=1',
			unixServers: '/fsServers?type=2',
			nasServers: '/fsServers?type=3',
			sharepoint: '/sharepoint/',
			replicationMonitor: '/replicationMonitor/',
			clientGroupDetails: '/clientGroupDetails/'
		};

		//This function helps set DefaultLanding, it accepts the paramter navSetting as input whose format is like below:
		/*
		 * navSetting : { userRole: String deniedNavItems : String(Comma separated string of denied navs)
		 * defaultLandingPage : String(url of page to set as defaul landin) }
		 */
		const setDefaultLanding = function(navSetting) {
			// Iterate over the dataModel and when the navSetting and defaultLandingSetting matches on userRole, update the defaultLandingPage string in the navSetting if the individual DataModel object has the url
			self.dataModel.forEach(function(defaultLandingSetting) {
				if (navSetting.userRole === defaultLandingSetting.userRole) {
					if (!navSetting.defaultLandingPage) {
						navSetting.defaultLandingPage = '';
					}
					navSetting.defaultLandingPage =
						defaultLandingSetting.defaultLandingPage &&
						defaultLandingSetting.defaultLandingPage.length === 1 &&
						angular.isDefined(defaultLandingSetting.defaultLandingPage[0].url)
							? defaultLandingSetting.defaultLandingPage[0].url
							: '';
					if (!navSetting.defaultLandingPage.includes('/reportDetails')) {
						// Once we have defaultLAndingPage string updated we have to make sure if it has any required parameters or optional parameters.If it has required parameters we need to update the url from the stateToURLMap since we cannot have url with required parameters.It will give hanging UI
						if (
							navSetting.defaultLandingPage.includes(':') &&
							angular.isObject(self.stateToUrlMap) &&
							angular.isDefined(defaultLandingSetting.defaultLandingPage[0].state)
						) {
							navSetting.defaultLandingPage = self.stateToUrlMap[defaultLandingSetting.defaultLandingPage[0].state];
						}
						//If url has optional parameters, we remove the optional parameters
						if (navSetting.defaultLandingPage.includes('?')) {
							navSetting.defaultLandingPage = navSetting.defaultLandingPage.substring(
								0,
								navSetting.defaultLandingPage.indexOf('?')
							);
						}
					}
				}
			});
		};

		// While we save the preferences we need to set the values of defaultLandingPage in navSetting and make a post request. We need to update the preferences on global level or company level.
		const submit = function(savePreferences) {
			let navSettings = {};
			if (angular.isUndefined(self.subscriptionId)) {
				navSettings['globalSettings'] = [
					{
						userRole: ROLE_MSP_ADMIN,
						defaultLandingPage: ''
					},
					{
						userRole: ROLE_MSP_USER,
						defaultLandingPage: ''
					},
					{
						userRole: ROLE_TENANT_ADMIN,
						defaultLandingPage: ''
					},
					{
						userRole: ROLE_TENANT_USER,
						defaultLandingPage: ''
					},
					{
						userRole: ROLE_RESTRICTED_USER,
						defaultLandingPage: ''
					}
				];
			} else {
				navSettings['companySettings'] = [
					{
						userRole: ROLE_TENANT_ADMIN,
						defaultLandingPage: ''
					},
					{
						userRole: ROLE_TENANT_USER,
						defaultLandingPage: ''
					}
				];
			}

			if (angular.isObject(navSettings) && angular.isDefined(navSettings)) {
				// We set the defaultLanding page of navSettings based on the dataModel which holds the defaulLanding information for different roles.While we set the defaultLanding page we will make sure that the denied nav items which we had converted to array while intial processing, we convert it back to string which is the required format for post data.
				angular.forEach(navSettings, function(value, key) {
					value.forEach(function(navSetting) {
						// Now we have to either update the companySettings or GlobalSettings defaultLanding infromation based on whether or not we are on companyPage/TenantAdmin mode or GlobalConfiguration page
						if (angular.isDefined(self.subscriptionId) && key === 'companySettings') {
							// This is helper method , which will set the defaulLandingPage string in navSetting. from data Model
							setDefaultLanding(navSetting);
						}

						if (angular.isUndefined(self.subscriptionId) && key === 'globalSettings') {
							setDefaultLanding(navSetting);
						}
					});
				});
			}
			const updatedNavItemRequest = { navSettings: angular.copy(navSettings) };

			customizationService
				.setUpdateHidenNavList(
					updatedNavItemRequest,
					angular.isDefined(self.subscriptionId) ? parseInt(self.subscriptionId) : 0
				)
				.success(function(data) {
					cvToaster.showSuccessMessage({
						message: savePreferences ? cvLoc('info.savedPreferences') : cvLoc('info.resetPreferences')
					});
				})
				.error(function(data) {
					$log.error(data);
					cvToaster.showErrorMessage({
						message: savePreferences ? cvLoc('error.errorSavingPreferences') : cvLoc('error.resetting')
					});
				});
		};
		/* This piece of code is executed when we click on Save button. */
		self.saveCustomization = function() {
			$dialogs.confirm(cvLoc('label.save'), cvLoc('prompt.saveChanges'), {
				noFunction: function() {},

				yesFunction: function() {
					// submit accepts boolean which notifies if we have to save from save option(true) or save post reset to default(false)
					submit(true);
				}
			});
		};

		// This function is triggered when reset to default is clicked
		self.resetToDefault = function() {
			$dialogs.confirm(cvLoc('label.customizationReset'), cvLoc('prompt.resetToDefault'), {
				noFunction: function() {},

				yesFunction: function() {
					if (self.dataModel && angular.isDefined(self.dataModel)) {
						self.dataModel.forEach(function(role) {
							//This utility function will be used to reset the preferences.
							self.resetNavList(role);
						});
					}
					// submit accepts boolean which notifies if we have to save from save option(true) or save post reset to default(false)
					submit(false);
				}
			});
		};
		self.valueSelected = function(data) {
			if ($state.href(data.state, data.params) == null) {
				cvToaster.showErrorMessage({
					message: cvLoc('warning.accessDeniedMessage')
				});
			}
		};

		// This is used for using istevens label
		self.localLang = cvUtil.getIStevenLocLabels();
		// Save and Reset to defaul links on page.
		self.cvPageLinks = [
			{
				label: cvLoc('label.customizationReset'),
				onclick: self.resetToDefault
			},
			{
				label: cvLoc('label.save'),
				onclick: self.saveCustomization // Open Modal for confirmation
			}
		];

		self.columnDefs = [
			{ displayName: cvLoc('label.landingUserType'), field: 'role', width: '30%', headerCellClass: 'left-align' },
			{
				field: 'navigationList',
				displayName: cvLoc('label.overrideinitialLanding'),
				cellTemplate:
					'<div class="col-xs-12 col-md-8 col-lg-8 padding-left-5 ">' +
					'<isteven-multi-select input-model="row.entity.navigationList" output-model="row.entity.defaultLandingPage" output-properties="url state" button-label="cvTitle" item-label="cvTitle" tick-property="ticked" class="nestedMultiSelect" id="defaultLanding" search-property="cvTitle" name="DefaultLandin" helper-elements="reset filter" max-labels="1" selection-mode="single" translation="grid.appScope.localLang" disable-property="disabled"  group-property="msGroup" on-item-click="grid.appScope.valueSelected(data)" " prevent-sort="true"></isteven-multi-select>' +
					'</div>'
			}
		];
		// We are using cv Grid over UI-Grid so in the below gridOptions the parameters starting with cv are used for CVGrid and gridOptions within self.gridOptions is for UI-Grid

		self.gridOptions = {
			cvIsPageTitle: true,
			cvIsSearchable: false,
			cvPageLinks: self.cvPageLinks,
			cvGridCssClass: 'grid-style nav-grid',
			cvHasTitle: true,
			cvAppScope: self,
			//cvCompanyDropdown : cv.isMspAdmin && angular.isUndefined(self.subscriptionName) ? true : false,
			cvInfoText: cvLoc('label.initalLandingInfoText'),
			cvGridTitle: angular.isDefined(self.subscriptionName)
				? cvLoc('label.nav.initialLanding') + ' - ' + self.subscriptionName
				: cvLoc('label.nav.initialLanding'),
			gridOptions: angular.extend(angular.copy(cvTableOptions.commonNgGridOptions), {
				data: 'dataModel',
				enableSorting: true,
				enableFiltering: true,
				showTreeExpandNoChildren: false,
				enablePaginationControls: false,
				enableGridMenu: false,
				paginationPageSize: 100,
				columnDefs: self.columnDefs
			})
		};

		// Add breadcrumbs

		var breadCrumbs = [];

		breadCrumbs.push({
			title: cvLoc('label.nav.masterCustomization'),
			link: '#nav/masterCustomization'
		});

		cvBreadcrumbsTabsFactory.addBreadCrumbs(breadCrumbs);
	}
]);
export default navCustomizationMod;
