<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv" %>
<div>
	<script nonce="${sessionScope.cspNonce}" >
	 	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
		<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
		<cv:cvMessages bundle="localization.nas"></cv:cvMessages>
		<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
		<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
		 <cv:cvMessages bundle="localization.snapArray"></cv:cvMessages>
	</script>

				<div class="form-group" data-ng-init="ctrl.initBackupConfig(backupMethod,backupMethod.appId)" data-ng-if="backupMethod.key !== 'NDMP' || (backupMethod.disabled && backupMethod.key === 'NDMP')">
                    <label class="col-xs-12 col-md-4 col-lg-4" for="backuptype">
                         <span for="{{backupMethod.key}}" data-ng-bind="backupMethod.key"></span>

                    </label>

                    <div class="col-xs-12 col-md-1 col-lg-1">
                     <toggle-control status="backupMethod.enabled || backupMethod.disabled ? 'enabled-activity' : 'disabled-activity'"
                         				 class="padding-left-5"
                          				 data-ng-class="{'disabled': backupMethod.disabled}"
                                         title="<cv:msg key="label.enableDisable" bundle="messages" />"
                                         data-ng-click="!backupMethod.disabled && (backupMethod.enabled = !backupMethod.enabled)">
                      </toggle-control>
                    </div>
               </div>
               <div class="backup-method-block" data-ng-if="backupMethod.enabled || (!backupMethod.disabled && backupMethod.key === 'NDMP')">
				   <!-- ==== Access Nodes Selection ==== -->
				   <div class="form-group margin-bottom-5 select-access-node" data-ng-if="backupMethod.key !== 'NDMP'">
						<div class="col-xs-12 col-md-4 col-lg-4">
							<label for="accessNodes">
								<span data-ng-if="!backupMethod.accessNodeOptions.showHelpText"><cv:msg key="label.accessNodes" bundle="servers"/></span>
								<span data-ng-if="backupMethod.accessNodeOptions.showHelpText"><cv-help-text help-text="'<cv:msg key="label.accessNodeInheritedFromMA" bundle="nas" />'"
									help-label="<cv:msg key="label.accessNodes" bundle="servers"/>" help-placement="right"></cv-help-text></span>
								<span class="optional-text"><cv:msg key="label.optional" bundle="restore"/></span>
							</label>
						</div>
						<cv-accessnode-dropdown class="col-xs-12 col-md-7 col-lg-7" directive-id="{{ backupMethod.key }}-accessnode-selection-dropdown" data-accessnodeoptions="backupMethod.accessNodeOptions" />

					</div>
	               	<div data-ng-if="backupMethod.key === 'CIFS'" class="form-group margin-bottom-0">
						<label data-ng-if="backupMethod.key === 'CIFS'" class="col-xs-12 col-md-4 col-lg-4" for="impersonateUser"><cv:msg key="label.cifsCrdentials" bundle="nas"/></label>
						<div class="col-xs-12 col-md-7 col-lg-7 inner-content">
							<span data-ng-if="ctrl.selectedCIFSUser" data-ng-bind="ctrl.selectedCIFSUser"></span>
							<span data-ng-if="!ctrl.selectedCIFSUser" data-ng-class="{'help-block': backupMethod.showErrors}"><cv:msg key="label.noUserSelected" bundle="servers"/></span>
						</div>
						<div class="col-xs-12 col-md-1 col-lg-1">
							<div class="page-details-box-links"><a data-ng-click="ctrl.impersonateCIFSUser(backupMethod.backupConfig)"> <cv:msg key="action.edit" bundle="snapArray"/></a></div>
						</div>
	               	</div>

	               		<div data-ng-if="backupMethod.key === 'NDMP'">
			               	<div class="form-group">
								<label class="col-xs-12 col-md-4 col-lg-4" for="ndmpLogin"><cv:msg key="label.ndmpLogin" bundle="nas" /></label>
								<div class="col-xs-12 col-md-7 col-lg-7">
									<input type="text" name="ndmpLogin" id="ndmpLogin" data-ng-model="ctrl.createPseudoClientRequest.clientInfo.nasClientProperties.ndmpServerDetails.ndmpCredentials.userName"/>
									<span class="help-block" data-ng-if="(backupMethod.showErrors || backupMethod.showNDMPUserLoginError) && !ctrl.createPseudoClientRequest.clientInfo.nasClientProperties.ndmpServerDetails.ndmpCredentials.userName"><cv:msg key="placeHolder.enterNDMPLoginHelpText" bundle="nas"/></span>
								</div>
							</div>
							<div class="form-group">
								<label class="col-xs-12 col-md-4 col-lg-4" for="ndmpPassword"><cv:msg key="label.ndmpPassword" bundle="nas" /></label>
								<div class="col-xs-12 col-md-7 col-lg-7">
									<input type="password" name="ndmpPassword" id="ndmpPassword" data-ng-model="ctrl.ndmpPassword" data-ng-blur="ctrl.updateNdmpPassword()"/>
									<span class="help-block" data-ng-if="(backupMethod.showErrors || backupMethod.showNDMPPasswordError) && !ctrl.ndmpPassword"><cv:msg key="placeHolder.enterNDMPPasswordHelpText" bundle="nas"/></span>
								</div>
							</div>
							<div class="form-group">
								<label class="col-xs-12 col-md-4 col-lg-4" for="ndmpPort"><cv:msg key="label.ndmpListenPort" bundle="nas" /></label>
								<div class="col-xs-12 col-md-7 col-lg-7">
									<input type="number" name="ndmpPort" id="ndmpPort"  data-ng-model="ctrl.createPseudoClientRequest.clientInfo.nasClientProperties.listenPort" data-ng-class="{'has-error': cv.addNasServerForm.needsAttention(addNasServerForm.ndmpPort)}" />
									<span class="help-block" data-ng-show="backupMethod.showErrors && !ctrl.createPseudoClientRequest.clientInfo.nasClientProperties.listenPort"><cv:msg key="placeHolder.enterNDMPListenPortHelpText" bundle="nas"/></span>
								</div>
								<span class="{{ctrl.previewErrorMessage.type}}">{{ctrl.previewErrorMessage.message}}</span>
							</div>
							<div class="form-group">
								<div class="col-xs-12 col-md-12 col-lg-12">
									<button type="button" data-ng-click="ctrl.previewNDMPServer()" class="btn btn-default pull-right cvBusyOnAjax margin-top-10 preview-button"><cv:msg key="label.preview" bundle="archiving"/></button>
								</div>
							</div>
					</div>

	               	<div class="form-group" data-ng-repeat="(contentKey, contentValue) in backupMethod.contents track by contentKey">
						<label class="col-xs-12 col-md-4 col-lg-4" for="backupContent" data-ng-bind="contentValue.label"></label>
						<div class="col-xs-12 col-md-7 col-lg-7 inner-content"  uib-popover-html="ctrl.contentPopOver(contentValue.label,contentValue.paths)"  popover-trigger="'mouseenter'">
								<ul class="content-paths crop">
									<li class="path" data-ng-repeat="path in contentValue.paths track by $index">{{path}}</li>
								</ul>
							</div>

						<div class="col-xs-12 col-md-1 col-lg-1" data-ng-if="contentKey === 'path'">
							<div class="page-details-box-links"><a data-ng-click="ctrl.selectContent(backupMethod)"> <cv:msg key="action.edit" bundle="snapArray"/></a></div>
						</div>
					</div>
	               	</div>
</div>