<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.scheduleJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.schedule"></cv:cvMessages>
	<cv:cvMessages bundle="localization.job"></cv:cvMessages>
	<cv:cvMessages bundle="localization.fs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.collections"></cv:cvMessages>
	<cv:cvMessages bundle="localization.users"></cv:cvMessages>
</script>
<div class="row">
	<div class="col-md-12">
		<h1 class="float-left" data-ng-bind="nasScDetails.subclientDetails.subClientEntity.subclientName" ></h1>
		<span class="server-message {{nasScDetails.serverMessage.type}}" data-ng-bind="nasScDetails.serverMessage.message" ></span>
		<span data-ng-if="nasScDetails.subclientDetails && nasScDetails.subclientDetails.commonProperties.isDefaultSubclient!=true"  data-ng-click="nasScDetails.deleteSubclient(nasScDetails.subclientDetails.subClientEntity)"><a class="page-action-item" href=""><cv:msg key="Delete" bundle="messages"/></a></span>
		<span data-ng-if="nasScDetails.subclientDetails"><a class="page-action-item" href="" data-ng-href="{{nasScDetails.getBackupHistoryUrl()}}"><cv:msg key="label.BackupHistory" bundle="clients" /></a></span>
		<span data-ng-if="nasScDetails.subclientDetails && nasScDetails.showRestoreOption()" data-uib-dropdown="" class="page-action-item">
			<a data-ng-click="nasScDetails.browseAndRestore(undefined)" class="ng-binding"><cv:msg key="header.restore" bundle="serversJs" /></a>
		</span>
	</div>
</div>
<div class="row">
	<div class="col-md-6">
		<cv-tile-component data-ac-id="nasSubclientDetails-heading_clientGeneral-clients" title='<cv:msg key="heading.clientGeneral" bundle="clients" />'  data-loader="nasScDetails.subclientDetails">
			<ul data-ng-if="nasScDetails.subclientDetails" class="group list-style-secondary">
				<li class="group" data-ng-if="nasScDetails.subclientDetails.subClientEntity.applicationId"><span class="pageDetailColumn"><cv:msg key="label.backupType" bundle="nas" /></span>
					 <span class="pageDetailColumn">{{nasScDetails.subclientDetails.subClientEntity.applicationId == 33 ? "CIFS" : (nasScDetails.subclientDetails.subClientEntity.applicationId == 29 ? "NFS" : "NDMP")}}</span></li></span>
				<li class="group"><span class="pageDetailColumn"><cv:msg key="label.backupEnabled" bundle="clients" /></span>
					<span class="pageDetailColumn">
						<toggle-control class="{{nasScDetails.backupEnabledStatusInfo}}" status="nasScDetails.backupEnabledStatusInfo" data-ng-click="nasScDetails.manageActivity()" title="Enable/disable <cv:msg key='label.backupEnabled' bundle='clients' />"></toggle-control>
					</span>
				</li>
				<li class="group"><span class="pageDetailColumn"><cv:msg key="header.lastBackup" bundle="devicesJs" /></span>
					<span data-ng-if='nasScDetails.subclientDetails.commonProperties.lastBackupTime!=0' class="pageDetailColumn"><div class="time crop" val="{{nasScDetails.subclientDetails.commonProperties.lastBackupTime}}"></div></span></li>
				<li class="group"><span class="pageDetailColumn"><cv:msg key="label.lastbackup.size" bundle="collections" /></span>
					<span class="pageDetailColumn" data-ng-bind="nasScDetails.subclientDetails.commonProperties.lastBackupSize | capacity"></span></li>
				<li class="group"><span class="pageDetailColumn"><cv:msg key="label.totalbackup.size" bundle="collections" /></span>
					<span class="pageDetailColumn"	data-ng-bind="nasScDetails.subclientDetails.commonProperties.totalBackupSize	| capacity"></span></li>
				<li class="group"><span class="pageDetailColumn"><cv:msg key="header.nextBackup" bundle="devicesJs" /></span>
					<span data-ng-if='nasScDetails.subclientDetails.commonProperties.nextBackupTime!=0' class="pageDetailColumn"><div class="time crop"	val="{{nasScDetails.subclientDetails.commonProperties.nextBackupTime}}"></div></span></li>
			</ul>
		</cv-tile-component>
		<cv-tile-component data-ng-show="nasScDetails.subclientDetails" title='<cv:msg key="label.snap" bundle="nas"/>'>
			<ul data-ng-if="nasScDetails.subclientDetails" class="group list-style-secondary">
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.snapEnabled" bundle="nas"/></span>
					<span class="pageDetailColumn">
						<toggle-control class="{{nasScDetails.snapEnabledStatusInfo}}" status="nasScDetails.snapEnabledStatusInfo" data-ng-click="nasScDetails.manageSnapSettings()" title="Enable/disable"></toggle-control>
					</span>
				</li>
				<li class="group" data-ng-if="nasScDetails.subclientDetails.commonProperties.snapCopyInfo.snapToTapeSelectedEngine">
					<span class="pageDetailColumn"><cv:msg key="label.snapEngine" bundle="nas"/></span>
					<span>
						<span
							data-ng-if="nasScDetails.subclientDetails.commonProperties.snapCopyInfo.snapToTapeSelectedEngine.snapShotEngineName"
							title="{{nasScDetails.subclientDetails.commonProperties.snapCopyInfo.snapToTapeSelectedEngine.snapShotEngineName}}">
							{{nasScDetails.subclientDetails.commonProperties.snapCopyInfo.snapToTapeSelectedEngine.snapShotEngineName}}
						</span>
					</span>
				</li>
			</ul>
			<div class="page-details-box-links"><a href="" data-ng-click="nasScDetails.showEditSnapSettings()"><cv:msg key="action.edit" bundle="settingsJs"/></a></div>
		</cv-tile-component>
		<cv-security-component entity-type='nasScDetails.entityType' generic-entity = 'nasScDetails.genericEntity' associations='nasScDetails.formattedSecurityAssociations' associations-loaded='nasScDetails.associationsLoaded'>
		</cv-security-component>
		<cv-tile-component data-ac-id="nasSubclientDetails-label_backup-collections" data-ng-show="nasScDetails.subclientDetails" title='<cv:msg key="label.backup" bundle="collections" />'>
			<ul class="serverBackupTile">
				<li><span class="page-details-box-links multiLinks">
					<ul>
						<li data-ng-if="nasScDetails.showBackup['backup']" class="restoreli"  data-ng-click="nasScDetails.showBackupOptions(nasScDetails.entityType,nasScDetails.genericEntity)"><a href=""><cv:msg key="action.backupNow" bundle="collections" /></a></li>
						<li><a data-ng-href="#jobs?collectionId={{nasScDetails.subclientDetails.subClientEntity.subclientId}}&collectionName={{nasScDetails.subclientDetails.subClientEntity.subclientName}}&jobType=Backup"><cv:msg key="action.jobs" bundle="servers" /></a></li>
					</ul>
				</span></li>
				<li data-ng-if="nasScDetails.showBackup['backup']">
					<p class="info-place-holder">	<cv:msg key="info.nobackupRunning" bundle="collections" /></p>
				</li>
				<li data-ng-if="nasScDetails.showBackup['submittingJob']">
					<p class="info-place-holder"><cv:msg key="info.submittingJob" bundle="collections" /></p>
				</li>
				<li data-ng-if="nasScDetails.backupJobs.length>0"><data-cv-job jobs='nasScDetails.backupJobs' show-backup='nasScDetails.showBackup'></data-cv-job></li>
			</ul>
		</cv-tile-component>
		<cv-tile-component data-ac-id="nasSubclientDetails-header_content-collections" data-ng-show="nasScDetails.subclientDetails" title='<cv:msg key="header.content" bundle="collections"/>' data-min-height="true">
			<span data-ng-if="nasScDetails.contentEntityDetails && !nasScDetails.contentEntityDetails.length"><p class="info-place-holder"><cv:msg key="label.noContent" bundle="clients" /></p></span>
				<ul class="list-style__row group " data-ng-repeat="contentEntity in nasScDetails.contentEntityDetails">
					<li> {{contentEntity.value}}
						<span data-ng-if="contentEntity.value == '\\'" class='laptop-content-help-text less-padding'> - &nbsp;<cv:msg key='label.allContents' bundle='profiles'/>
		    			</span>
		    		</li>
				</ul>
				<div data-ng-if="!nasScDetails.hasAssociatedPolicy" class="page-details-box-links"><a href="" data-ng-click="nasScDetails.manageSubclientContent()"><cv:msg key="action.edit" bundle="settingsJs"/></a></div>
		</cv-tile-component>
	</div>
	<div class="col-md-6">
		<cv-backup-history entity="nasScDetails.backupEntity" on-restore="nasScDetails.performFSRestore(job, fromTimeStr, toTimeStr)" ng-if="nasScDetails.showBackupHistoryCalendarView() && nasScDetails.isFileSystemAgent() && nasScDetails.subclientDetails && nasScDetails.subclientDetails.subClientEntity"></cv-backup-history>
	</div>
	<div class="col-md-6">
		<cv-entity-plan-policy-tiles data-cv-application-id="nasScDetails.applicationId" data-cv-subclient-id="subclientId" data-cv-client-id="nasScDetails.clientId" data-cv-subclient-name="nasScDetails.subclientDetails.subClientEntity.subclientName"
				data-cv-show-edit="true"  data-cv-show-plan="nasScDetails.isPlanEnabled()" data-cv-plan-entity="nasScDetails.planEntity"
				data-cv-show-schedule="nasScDetails.subclientDetails" data-cv-show-storage="nasScDetails.subclientDetails">
		</cv-entity-plan-policy-tiles>
		<cv-alert-component data-ng-show="nasScDetails.subclientDetails" alerts='nasScDetails.alerts'></cv-alert-component>
		<!-- Proxy Clients tile -->
		<cv-tile-component data-ac-id="nasSubclientDetails-label_proxy-servers" class="failedproxy" data-title='<cv:msg key="label.proxy" bundle="servers"/>' min-height="true" edit-text="reorderHelpText">
			<span class="server-message {{proxyMessage.type}}">{{proxyMessage.message}}</span>
			<div id="scroll-box" data-ng-class="{'limit-tile-component-height' : showMinHeight }" class="limit-tile-component-height">
				<ul class="list-style__row group"  data-ng-repeat="proxy in nasScDetails.subclientDetails.fsSubClientProp.backupConfiguration.backupDataAccessNodes">
					<li class="group" data-ng-if="nasScDetails.subclientDetails.fsSubClientProp.backupConfiguration.backupDataAccessNodes && nasScDetails.subclientDetails.fsSubClientProp.backupConfiguration.backupDataAccessNodes.length > 0">
						<span data-ng-if="proxy.clientId && proxy.clientName">
							<span data-ng-if="proxy.clientName" title="{{proxy.clientName}}">
								{{proxy.clientName}}
							</span>
							<span data-ng-if="proxy.clientGroupName" title="proxy.clientGroupName">{{proxy.clientGroupName}}<span class="parenthetical-text"><cv:msg key="indicator.group" bundle="collections"/></span></span>
						</span>
					</li>
				</ul>
				<ul  data-ng-if="! nasScDetails.subclientDetails.fsSubClientProp.backupConfiguration.backupDataAccessNodes">
					<li>
						<span class="pageDetailColumn full-width">
							<p class="info-place-holder"><cv:msg key="label.noProxyAdded" bundle="nas"/></p>
						</span>
					</li>
				</ul>
			</div>
			<div class="page-details-box-links">
				<a href="" data-ng-click="nasScDetails.showEditProxy()"><cv:msg key="action.edit" bundle="collections" /></a>
			</div>
		</cv-tile-component>
		<!-- END OF Proxy client -->

		<prepost-commands-tile ng-if="nasScDetails.subclientDetails && nasScDetails.applicationId && nasScDetails.clientIdForBrowse" subclient-details="nasScDetails.subclientDetails" subclient-id="nasScDetails.subclientId" application-id="nasScDetails.applicationId" client-id="nasScDetails.clientIdForBrowse"></prepost-commands-tile>
	</div>
</div>
