<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<div>
	<script nonce="${sessionScope.cspNonce}" >
		<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
		<cv:cvMessages bundle="localization.nas"></cv:cvMessages>
		<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
		<cv:cvMessages bundle="localization.subscriptions"></cv:cvMessages>
	</script>
	<div class="setup-title" data-ng-show="!addNasCtrl.nasServer.clientId">
		<h1>
		    <label for="NName">
				<cv:msg key="heading.AddNASServer" bundle="nas"/>
				<cv-help-component help-text="<cv:msg key="label.addNasHelpText" bundle="nas"/>"></cv-help-component>
			</label>
		</h1>
	</div>
	<div class="setup-title" data-ng-show="addNasCtrl.nasServer.clientId">
		<h1>
		    <label for="NName">
				<cv:msg key="heading.AddNASIDA" bundle="nas"/>
				<cv-help-component help-text="<cv:msg key="label.addNasSoftwareHelpText" bundle="nas"/>"></cv-help-component>
			</label>
		</h1>
	</div>
	<div class="setup-content">
		<span class="{{addNasCtrl.serverMessage.type}}" data-ng-bind="addNasCtrl.serverMessage.message"></span>
<form name="addNasServerForm" id="addNasServerForm" novalidate autocomplete="off" class="add-nas-form">
<div class="form-horizontal bootstrap-wrapper modal-margin">
		<div class="form-group">
			<label class="col-xs-12 col-md-4 col-lg-4" for="clientName"><cv:msg key="label.clientName" bundle="serversJs" /></label>
			<div class="col-xs-12 col-md-8 col-lg-8">
				<input autofocus type="text" name="clientName" id="clientName" data-ng-model="addNasCtrl.nasServer.clientName" data-ng-disabled="addNasCtrl.nasServer.disableClientName" data-ng-class="{'has-error': cv.addNasServerForm.needsAttention(addNasServerForm.clientName)}" data-ng-change="addNasCtrl.selectClientNameHelpText = false" required />
				<span class="help-block" data-ng-show="addNasCtrl.selectClientNameHelpText"><cv:msg key="error.clientName" bundle="serversJs" /></span>
			</div>
		</div>
		<div class="form-group">
			<label class="col-xs-12 col-md-4 col-lg-4" for="hostName"><cv:msg key="label.hostName" bundle="serversJs"/></label>
			<div class="col-xs-12 col-md-8 col-lg-8">
				<input type="text" name="hostName" id="hostName" data-ng-model="addNasCtrl.nasServer.hostName" data-ng-class="{'has-error': cv.addNasServerForm.needsAttention(addNasServerForm.hostName)}" data-ng-change="addNasCtrl.selectHostNameHelpText = false" required />
				<span class="help-block" data-ng-show="addNasCtrl.selectHostNameHelpText"><cv:msg key="error.hostName" bundle="serversJs" /></span>
			</div>
		</div>
		<div class="form-group">
			<label class="col-xs-12 col-md-4 col-lg-4" for="nasIda"><cv:msg key="label.backupType" bundle="nas"/></label>
			<div class="col-xs-12 col-md-8 col-lg-8 text-left">
			<div class="multiple-checkbox-group" data-ng-if="!addNasCtrl.nasServer.isNutanixClient">
				<input type="checkbox" name="nasIda" value="nasIda" id="nasIda" data-ng-model="addNasCtrl.nasServer.nasIda" data-ng-disabled="addNasCtrl.nasServer.disableNasIda" data-ng-change="addNasCtrl.renderDetectMA();addNasCtrl.showSelectBackupTypeHelpText=false" />
				<label for="nasIda"><cv:msg key="label.nas" bundle="nas"/></label>
			</div>
			<div class="multiple-checkbox-group">
				<input type="checkbox" name="windowsIda" value="windowsIda" id="windowsIda" data-ng-model="addNasCtrl.nasServer.windowsIda" data-ng-disabled="addNasCtrl.nasServer.disableWindowsIda" data-ng-click="addNasCtrl.showSelectBackupTypeHelpText=false" />
				<label for="windowsIda"><cv:msg key="label.cifs" bundle="nas"/></label>
			</div>
			<div class="multiple-checkbox-group">
				<input type="checkbox" name="unixIda" value="unixIda" id="unixIda" data-ng-model="addNasCtrl.nasServer.unixIda" data-ng-disabled="addNasCtrl.nasServer.disableUnixIda" data-ng-click="addNasCtrl.showSelectBackupTypeHelpText=false" />
				<label for="unixIda"><cv:msg key="label.nfs" bundle="nas"/></label>
			</div>
					<span class="help-block" data-ng-show="addNasCtrl.showSelectBackupTypeHelpText"><cv:msg key="placeHolder.selectIdaHelpText" bundle="nas"/></span>
			</div>
		</div>
		<div data-ng-show="!addNasCtrl.nasServer.disableNasIda && addNasCtrl.nasServer.nasIda">
		<div class="form-group">
			<label class="col-xs-12 col-md-4 col-lg-4" for="ndmpLogin"><cv:msg key="label.ndmpLogin" bundle="nas" /></label>
			<div class="col-xs-12 col-md-8 col-lg-8">
				<input autofocus type="text" name="ndmpLogin" id="ndmpLogin" data-ng-model="addNasCtrl.nasServer.ndmpLogin" data-ng-class="{'has-error': cv.addNasServerForm.needsAttention(addNasServerForm.ndmpLogin)}" data-ng-change="addNasCtrl.showEnterNdmpLoginHelpText= false" />
				<span class="help-block" data-ng-show="addNasCtrl.showEnterNdmpLoginHelpText"><cv:msg key="placeHolder.enterNDMPLoginHelpText" bundle="nas"/></span>
			</div>
		</div>
		<div class="form-group">
			<label class="col-xs-12 col-md-4 col-lg-4" for="ndmpPassword"><cv:msg key="label.ndmpPassword" bundle="nas" /></label>
			<div class="col-xs-12 col-md-8 col-lg-8">
				<input autofocus type="password" name="ndmpPassword" id="ndmpPassword" data-ng-model="addNasCtrl.nasServer.ndmpPassword" data-ng-class="{'has-error': cv.addNasServerForm.needsAttention(addNasServerForm.ndmpPassword)}" data-ng-change="addNasCtrl.showEnterNdmpPassHelpText = false"  />
				<span class="help-block" data-ng-show="addNasCtrl.showEnterNdmpPassHelpText"><cv:msg key="placeHolder.enterNDMPPasswordHelpText" bundle="nas"/></span>
			</div>
		</div>
		<div class="form-group">
			<label class="col-xs-12 col-md-4 col-lg-4" for="ndmpPort"><cv:msg key="label.ndmpListenPort" bundle="nas" /></label>
			<div class="col-xs-12 col-md-8 col-lg-8">
				<input autofocus type="number" name="ndmpPort" id="ndmpPort"  data-ng-model="addNasCtrl.nasServer.ndmpPort" data-ng-class="{'has-error': cv.addNasServerForm.needsAttention(addNasServerForm.ndmpPort)}" />
				<span class="help-block" data-ng-show="addNasCtrl.showEnterNdmpPortHelpText"><cv:msg key="placeHolder.enterNDMPListenPortHelpText" bundle="nas"/></span>
			</div>
		</div>
		<div class="form-group">
			<label class="col-xs-12 col-md-4 col-lg-4" for="detectMa"><cv:msg key="label.detectMa" bundle="nas" /><span class="optional-text"><cv:msg key="label.optional" bundle="subscriptions"/></span></label>
			<div class="col-xs-12 col-md-8 col-lg-8">
			<select id="detectMa" name="detectMa" data-ng-model="addNasCtrl.nasServer.detectMa" data-ng-class="{'has-error': cv.addNasServerForm.needsAttention(addNasServerForm.detectMa)}" class="modal-select ng-pristine ng-valid ng-valid-required ng-touched">
			    <option selected="selected" value="">{{addNasCtrl.detectMADropDownMsg}}</option>
			    <option data-ng-repeat="ma in addNasCtrl.nasServer.detectMAList" value="{{ma}}">
			        {{ma.clientName}}
			    </option>
			</select>
			<span class="help-block" data-ng-show="addNasCtrl.showEnterDetectMaHelpText"><cv:msg key="placeHolder.enterDetectMaHelpText" bundle="nas"/></span>
			</div>
		</div>
		</div>
</div>
			<div class="button-container">
				<button id="addNasServer_button_#3319" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="addNasCtrl.cancel()"><cv:msg key="Cancel" /></button>
				<button id="addNasServer_button_#8980" type="submit" class="btn btn-primary cvBusyOnAjax" data-ng-click="addNasCtrl.addNasServer()"><cv:msg key="Save"/></button>
			</div>
		</form>
	</div>
</div>
