<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv" %>
<div>
	<script nonce="${sessionScope.cspNonce}" >
	 	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
		<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
		<cv:cvMessages bundle="localization.nas"></cv:cvMessages>
		<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
		<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
		<cv:cvMessages bundle="localization.snapArray"></cv:cvMessages>
		<cv:cvEnum name="App.VendorType"></cv:cvEnum>
	</script>
	<div class="setup-title">
		<h1>
		    <label for="NName"> {{ctrl.clientParams.label}}
				<cv-help-component help-text="{{ctrl.clientParams.labelHelp}}"></cv-help-component>
			</label>
		</h1>
	</div>

	<div class="nas-file-storage-modal setup-content">
	<span class="{{ctrl.errorMessage.type}}" data-ng-bind="ctrl.errorMessage.message"></span>
	<form name="addFileStorageForm" id="addFileStorageForm" novalidate autocomplete="off" data-cv-submit="ctrl.createFileStorageServer()">
	 	<div class="form-horizontal bootstrap-wrapper modal-margin">
			<div class="form-group">
		          <label class="col-xs-12 col-md-4 col-lg-4"><cv:msg key="header.name" bundle="servers" /></label>
		          <div class="col-xs-12 col-md-7 col-lg-7">
		 			 <input autofocus id="clientName" type="text" class="col-xs-12 col-md-4 col-lg-4" data-ng-blur="ctrl.updateHostName()" data-ng-disabled="ctrl.editMode" data-ng-model="ctrl.createPseudoClientRequest.entity.clientName"  placeholder="<cv:msg key="label.serverDisplayName" bundle="nas"/>"/>
		             <span class="help-block padding-top-7" ng-if="ctrl.showErrors && ctrl.createPseudoClientRequest.entity.clientName.length === 0"><cv:msg key="option.clientName" bundle="clients"/> </span>
		          </div>
		    </div>

		     <div class="form-group" data-ng-if="ctrl.createPseudoClientRequest.clientInfo.clientAppType === 2">
				           	  <label class="col-xs-12 col-md-4 col-lg-4" for="array"> <cv:msg key="label.fileServerHost" bundle="servers"/></label>
				               <div class="col-xs-12 col-md-7 col-lg-7" >
				                   <isteven-multi-select input-model="ctrl.arrayList" output-model="ctrl.selectedArray" button-label="arrayName" id="nutanix-create-array"
				                                         item-label="arrayName" tick-property="selected"
				                                         class="isteven-multi-select user-group-select" id="nutanixArrays" name="array"
				                                         helper-elements="reset" selection-mode="single"
				                                         translation = "ctrl.arrayListLabel"
				                                         on-item-click="ctrl.updateFileServerHost(ctrl.selectedArray[0])"></isteven-multi-select>
				                   <span class="help-block padding-top-7" data-ng-show="(ctrl.showErrors || ctrl.selectHostNameError) && ctrl.selectedArray.length === 0"><cv:msg key="label.pleaseSelectHost" bundle="servers"/> </span>
				               </div>
				                <div class="col-xs-12 col-md-1 col-lg-1 add-array-button">
				                 	<a data-ng-click="ctrl.openAddArrayModal()">
						                 <cv:msg key="action.add" bundle="storage" />
						             </a>
				                 </div>
			</div>

		   <!-- ===== Host Name ===== -->
		    <div class="form-group" data-ng-if="ctrl.createPseudoClientRequest.clientInfo.clientAppType === 10 || ctrl.isNasServer">
		       <label class="col-xs-12 col-md-4 col-lg-4" for="hostName">
			       <span data-ng-if="ctrl.createPseudoClientRequest.clientInfo.clientAppType === 10"><cv:msg key="label.qumuloCluster" bundle="nas"/></span>
			       <span data-ng-if="ctrl.isNasServer"><cv:msg key="label.hostName" bundle="serversJs"/></span>
		       </label>

             <div class="col-xs-12 col-md-7 col-lg-7" >
             		<input id="hostName" type="text" class="col-xs-12 col-md-4 col-lg-4" placeholder="{{ctrl.hostNamPlaceholderText}}" data-ng-model="ctrl.createPseudoClientRequest.entity.hostName" data-ng-blur="ctrl.updateFileServerHost()"/>
             		<span class="help-block padding-top-7" data-ng-show="(ctrl.showErrors || ctrl.selectHostNameError) && !ctrl.createPseudoClientRequest.entity.hostName"><cv:msg key="label.pleaseSelectHost" bundle="servers"/> </span>
             		<span class="help-block padding-top-7" data-ng-show="ctrl.showHostNameFQDNError"><cv:msg key="label.errorFQDN" bundle="nas"/></span>
              </div>
           </div>
           <!-- ==== User credentials for the Qumulo Server ======= -->
            <div class="margin-bottom-10" data-ng-if="!ctrl.editMode && ctrl.createPseudoClientRequest.clientInfo.clientAppType === 10">
				<cv-credential-manager model="ctrl.model" show-credential="{{showCredential}}" input-name="ctrl.qumuloAttributes" password-complexity="1" form-name="addFileStorageForm" need-confirm=false></cv-credential-manager>
           </div>

                 <!-- ===== Plan Selection ===== -->
           <div class="form-group">
               <label class="col-xs-12 col-md-4 col-lg-4" for="plan"> <cv:msg key="label.profile" bundle="profiles"/> </label>
               <div class="col-xs-12 col-md-7 col-lg-7">
                  <cv-plan-summary-dropdown
                        input-model="ctrl.planList"
                        output-model="ctrl.selectedPlan"
                        item-label="'planName'"
                        tick-property="'selected'"
                        selection-mode="'single'"
                        button-label="'planName'"
                        id="nas-fs-plan"
                        directive-id="'nas-fileserver_isteven-multi-select_#687885'"
                        max-labels="1"
                        on-close="ctrl.updatePlan()">
                    </cv-plan-summary-dropdown>
                  <span class="help-block padding-top-7" data-ng-show="(ctrl.showErrors || ctrl.showPlanError)  && ctrl.selectedPlan.length === 0"><cv:msg key="label.selectPlan" bundle="servers"/> </span>
               </div>
           </div>
			<!-- ==== Backup configuration for CIFS | NFS ======= -->
			<div class="form-group margin-bottom-0 margin-top-10">
               <label class="col-xs-12 col-md-4 col-lg-4" for="backupType"> <cv:msg key="label.selectBackupMethods" bundle="nas"/> </label>
                <div class="col-xs-12 col-md-7 col-lg-7 inner-content"  data-ng-if="ctrl.selectBackupMethodError">
                    <span class="help-block"><cv:msg key="error.backupTyeSelect" bundle="nas"/></span>
            	</div>
            </div>


				<!-- Non Nas Server like Nutanix | Qumulo support only Network share protocols like CIFS | NDMP-->
			   <div data-ng-if="!ctrl.isNasServer" data-ng-repeat="backupMethod in ctrl.backupTypes track by $index">
					<div data-ng-include="'modules/nas/partials/protocol.jsp'"></div>
               </div>

				<!-- Nas Servers support both NDMP and Network share protocols like CIFS | NDMP -->
               	<div data-ng-if="ctrl.isNasServer">
               		<cv-plain-accordion  accordion-label="<cv:msg key="label.networkShareConfiguration" bundle="nas" />" collapsed="ctrl.status.networkShareCollapsed">

						 <!-- ===== File Server Host ===== -->
				         <div class="form-group" data-ng-if="ctrl.showFileServerHost">
				           	  <label class="col-xs-12 col-md-4 col-lg-4" for="array"> <cv:msg key="label.manageArray" bundle="nas"/><span class="optional-text"><cv:msg key="label.optional" bundle="subscriptions"/></span></label>
				                <div class="col-xs-12 col-md-7 col-lg-7 inner-content">
									 <span  data-ng-bind="ctrl.arrayName"></span>
								</div>
								<div class="col-xs-12 col-md-1 col-lg-1">
									<div class="page-details-box-links"><a data-ng-click="ctrl.openAddArrayModal()">
										<span data-ng-bind="ctrl.arrayActionLabel"></span></a>
									</div>
								</div>
						 </div>


	               		<div data-ng-repeat="backupMethod in ctrl.backupTypes track by $index" data-ng-if="backupMethod.key !== 'NDMP'">
							<div data-ng-include="'modules/nas/partials/protocol.jsp'"></div>
	               		</div>
					</cv-plain-accordion>

					<cv-plain-accordion  accordion-label="<cv:msg key="label.ndmpConfiguration" bundle="nas" />" collapsed="ctrl.status.ndmpCollapsed">
						<div data-ng-repeat="backupMethod in ctrl.backupTypes track by $index" data-ng-if="backupMethod.key === 'NDMP'">
							<div data-ng-include="'modules/nas/partials/protocol.jsp'"></div>
						</div>
					</cv-plain-accordion>

					<cv-plain-accordion
						accordion-label="<cv:msg key='label.migrateNas' bundle='nas' />"
						collapsed="ctrl.status.migrationCollapsed"
						ng-if="ctrl.filerMigration.isFeatureAvailable"
					>
						<div class="form-group">
							<label class="col-xs-4">
								<cv:msg key="label.nasServerMigration" bundle="nas" />
							</label>
							<div class="col-xs-8">
								<div id="toggle-container" class="cv-flex space-between vertical-center">
									<toggle-control
										status="ctrl.filerMigration.isEnabled ? 'enabled-activity' : 'disabled-activity'"
										title="<cv:msg key='label.enableDisable' bundle='messages' />"
										ng-click="ctrl.toggleFilerMigration()"
										disabled="!ctrl.filerMigration.isEnabled && ctrl.isInvalidMigrationPrerequisites"
									></toggle-control>
									<a
										href=""
										data-ng-if="ctrl.showMigrationConfigEditButton()"
										data-ng-click="ctrl.openMigrationConfigModal()"
										class="pull-right btn-edit-migration-config margin-right-15"
									>
										<cv:msg key="action.edit" bundle="collections" />
									</a>
								</div>
								<span
									class="col-xs-12 padding-top-10"
									ng-class="{
										'info-place-holder': !ctrl.filerMigration.isEnabled,
										'help-block': ctrl.filerMigration.isEnabled
									}"
									ng-if="ctrl.isInvalidMigrationPrerequisites || ctrl.isMismatchedMigrationProtocol"
									ng-bind="ctrl.migrationConfigErrorMessage"
								></span>
							</div>
						</div>
						<div ng-if="ctrl.filerMigration.isEnabled && ctrl.filerMigration.showConfigPreview">
							<cv-nas-migration-preview migration-config="ctrl.filerMigration.migrationConfig"></cv-nas-migration-preview>
						</div>
					</cv-plain-accordion>
				</div>

			</div>


   			<!-- =====SAVE AND CANCEL===== -->
         <div class="button-container">
             <button type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="ctrl.cancel()"><cv:msg key="Cancel"/></button>
             <button type="submit" class="btn btn-primary cvBusyOnAjax" ><cv:msg key="Save"/></button>
         </div>
	</form>
</div>
</div>