import { NAS_CONSTANTS } from '../constants';
import { acAppNasModule } from 'common/js/modules';

var nasMod = acAppNasModule;

nasMod.service('nasService', [
	'$http',
	'$q',
	'cvLoc',
	'cvUtil',
	'AppTypes',
	'clusterType',
	'EntityTypesUtil',
	function($http, $q, cvLoc, cvUtil, AppTypes, clusterTypeConstant, EntityTypesUtil) {
		this.createNASClient = function(obj) {
			return $http.post('addNASClient.do', {
				nasServerInfo: obj
			});
		};

		this.createNetworkShareClient = function(obj) {
			return $http.post('addNetworkShareClient.do', {
				nsServerInfo: obj
			});
		};

		this.addNetworkShareIda = function(obj) {
			return $http.post('addNetworkShareIda.do', {
				nasTurboFSReq: obj
			});
		};

		this.getNasBrowseContents = function(clientId, path, foldersOnly, nasBrowseOptions) {
			let browseParams = {
				clientId: clientId,
				browsePath: path
			};

			if (nasBrowseOptions && nasBrowseOptions.ndmpRequest) {
				browseParams.listenPort = nasBrowseOptions.ndmpRequest.listenPort;
				browseParams.planId = nasBrowseOptions.ndmpRequest.planId;
				browseParams.arrayMgmtId = nasBrowseOptions.ndmpRequest.arrayMgmtId;
				browseParams.ndmpServerDetails = nasBrowseOptions.ndmpRequest.ndmpServerDetails;
			}

			if (nasBrowseOptions && nasBrowseOptions.arrayInfo) {
				browseParams.arrayInfo = nasBrowseOptions.arrayInfo;
			}

			if (nasBrowseOptions.planId) {
				browseParams.planId = nasBrowseOptions.planId;
			}

			return $http.post('nasBrowseContents.do', {
				nasBrowseInfoReq: JSON.stringify(browseParams),
				foldersOnly: foldersOnly
			});
		};

		this.getNsAutoMountBrowseContentsFromClient = function(path, browseOptions) {
			var params = {
				method: 'GET',
				url: 'nsAutoMountBrowse.do',
				params: {
					clientId: browseOptions.proxy,
					path: path,
					interfacePath: browseOptions.interfacePath,
					nasClientId: browseOptions.proxy,
					userName: browseOptions.userName,
					password: browseOptions.password,
					enableAutoMountBrowse: browseOptions.enableAutomountBrowse,
					subclientId: browseOptions.subclientId,
					credentialId: browseOptions.credentialId,
					planId: browseOptions.planId,
					autoFindProxy: browseOptions.autoFindProxy,
					intelliSnapEnabled: browseOptions.intelliSnapEnabled,
					appTypeId: browseOptions.appId
				}
			};

			return $http(params);
		};

		this.manageSettings = function(activityInfo) {
			return $http.post('nasSubclientProperties.do', {
				type: activityInfo.type,
				action: activityInfo.action,
				serverId: 0,
				collectionId: activityInfo.subclientId
			});
		};

		this.getNasProxyList = function(subclientId, appType, clusterType, requestType, flags, client) {
			return $http({
				method: 'GET',
				url: 'nasProxyList.do',
				params: {
					subclientId: subclientId,
					appType: appType,
					clusterType: clusterType,
					requestType: requestType,
					flags,
					client: client ? JSON.stringify(client) : null
				}
			});
		};

		this.getAccessNodes = function(appType, clusterType) {
			return $http.get('nasAccessNodes.do?appType=' + appType + '&clusterType=' + clusterType);
		};

		this.updateNasSCSettings = function(obj, subclientId, isProxyUpdate = false) {
			let postMethod = isProxyUpdate ? 'nasProxySettings.do' : 'nasSCSettings.do';
			return $http.post(postMethod, {
				subclientInfo: obj,
				collectionId: subclientId
			});
		};

		this.updateClientSnapSettings = function(params) {
			return $http.post('setSnapSettings.do', {
				serverId: params.clientId,
				action: params.action
			});
		};

		this.refreshCache = function(serverId, subclientId) {
			return $http.post('refreshCache.do', {
				serverId: serverId,
				subclientId: subclientId
			});
		};

		this.getSubclientList = function(clientId, applicationId) {
			return $http({
				method: 'GET',
				url: 'nasSubclients.do',
				params: {
					clientId: clientId,
					applicationId: applicationId
				}
			});
		};

		this.createNasSubclient = function(params) {
			return $http.post('createNasSubclient.do', params);
		};

		this.getEligiblePlansForNASSubClient = function() {
			return $http.get('getPlansForNASSubClient.do');
		};

		this.getSnapEnginesForNAS = function(vendorId) {
			return $http({
				method: 'GET',
				url: 'nasSnapEngines.do',
				params: {
					vendorId: vendorId
				}
			});
		};

		this.createFileServerClient = function(params) {
			let proxyUrl = 'proxy/Client/' + params.serverType;
			return $http.post(proxyUrl, JSON.stringify(params.request), httpHeader['jsonDefaultHeader']);
		};

		this.updateFileServerClient = function(params) {
			let proxyUrl = 'proxy/Client/' + params.clientId + '/' + params.serverType;
			return $http.put(proxyUrl, JSON.stringify(params.request), httpHeader['jsonDefaultHeader']);
		};

		this.addOrUpdateFiLeServerClient = function(params) {
			if (params.clientId) {
				return this.updateFileServerClient(params);
			} else {
				return this.createFileServerClient(params);
			}
		};

		this.detectNDMPServer = function(request) {
			let proxyUrl = 'proxy/NASClient/DetectNDMPServer';
			let httpHeaders = httpHeader['jsonDefaultHeader'];
			httpHeaders.headers['EnumNames'] = true; // backend will return the enum name instead of int value. this way it will be easy to map from cvEnum object
			return $http.post(proxyUrl, JSON.stringify(request), httpHeaders);
		};

		this.createNutanixFileStorageClient = function(
			clientInfo,
			entity,
			backupConfigListArray,
			processingInstructionInfo,
			additionalObjects
		) {
			let createClient = '';
			const CreatePseudoClientRequest = {
				...(clientInfo && { clientInfo: clientInfo }),
				...(entity && { entity: entity })
			};

			let backupConfigList = [];

			if (backupConfigListArray[0]) {
				backupConfigList.push(backupConfigListArray[0]);
			}

			if (backupConfigListArray[1]) {
				backupConfigList.push(backupConfigListArray[1]);
			}

			let CreatePseudoClientWithBackupConfig = {
				createPseudoClientRequest: CreatePseudoClientRequest,
				backupConfigList: backupConfigList
			};

			this.createFileServerClient(CreatePseudoClientWithBackupConfig);
		};

		this.getProxyNodes = function(type, clientAppType) {
			if (
				type !== NAS_CONSTANTS.CIFS &&
				type !== NAS_CONSTANTS.NFS &&
				type !== NAS_CONSTANTS.GPFS &&
				type !== NAS_CONSTANTS.GLUSTERFS &&
				type !== NAS_CONSTANTS.LUSTREFS
			) {
				return;
			}

			let appType = AppTypes.UNIX_FILESYSTEM,
				clusterType = 4;
			if (type === NAS_CONSTANTS.CIFS) {
				appType = AppTypes.WINDOWS_FILESYSTEM;
				clusterType = 5;
			} else if (type === NAS_CONSTANTS.GPFS) {
				appType = AppTypes.DISTRIBUTED_APPS;
				clusterType = clusterTypeConstant.GPFS;
				clientAppType = 0;
			} else if (type === NAS_CONSTANTS.GLUSTERFS) {
				appType = AppTypes.DISTRIBUTED_APPS;
				clusterType = clusterTypeConstant.GLUSTERFS;
				clientAppType = 0;
			} else if (type === NAS_CONSTANTS.LUSTREFS) {
				appType = AppTypes.DISTRIBUTED_APPS;
				clusterType = clusterTypeConstant.LUSTREFS;
				clientAppType = 0;
			}

			let getProxyNodesUrl =
				'proxy/Client/DistributedApps?appType=' + appType + '&clusterType=' + clusterType + '&requestType=1';

			if (clientAppType) {
				getProxyNodesUrl = getProxyNodesUrl + '&clientAppType=' + clientAppType;
			}

			return $http.get(getProxyNodesUrl, httpHeader['jsonDefaultHeader']);
		};

		this.getNonAssociatedArrays = function(serverType) {
			let url = 'proxy/StorageArrays';
			if (serverType === NAS_CONSTANTS.NAS) {
				url += '?flags=2';
			}
			return $http.get(url, httpHeader['jsonDefaultHeader']);
		};

		this.updateNDMPProperties = function(nDMPServerRequest) {
			let proxyUrl = 'proxy/NASClient/NDMPServer/';
			return $http.put(proxyUrl, JSON.stringify(nDMPServerRequest), httpHeader['jsonDefaultHeader']);
		};

		/**
		 * @param {Number}
		 *            applicationId
		 * @param {Array
		 *            <String>} fieldList List of API fields to be retrieved
		 * @returns {Promise<Object>}
		 */
		this.getNASSourceListForMigration = (applicationId, fieldList) => {
			return $http.get(`${cv.contextPath}/proxy/Client`, {
				params: {
					Hiddenclients: false,
					propertylevel: 10,
					hideLaptopAndDummyClients: true,
					excludeInfrastructureClients: true,
					fq: `clientProperties.client.osInfo.osId:in:${EntityTypesUtil.getNasOSList().join(',')}`,
					fl: fieldList.join(','),
					applicationId
				},
				headers: { ...jsonHeader, mode: 'EdgeMode' }
			});
		};

		/**
		 * @param {Number}
		 *            applicationId
		 * @param {Number}
		 *            clientId
		 * @returns {Promise<Object>} Backup content for the client
		 */
		this.getBackupContent = (applicationId, clientId) => {
			return $http.get(`${cv.contextPath}/proxy/Client/BackupContent/${clientId}/${applicationId}`, {
				headers: jsonHeader
			});
		};

		/**
		 *
		 * @param {Number}
		 *            applicationId
		 * @param {Number}
		 *            clientId
		 * @param {Object}
		 *            migrationConfig Config object of type MigrateServerDetails
		 */
		this.migrateNASFiler = (applicationId, clientId, migrationConfig) => {
			return $http.post(
				`${cv.contextPath}/proxy/Client/MigrateServer/${clientId}/${applicationId}`,
				JSON.stringify(migrationConfig),
				{
					headers: jsonHeader
				}
			);
		};
	}
]);

export default nasMod;
