import 'adminConsole/js/controllers/activityControl.ctrl.js';
import 'adminConsole/js/services/subclients.svc.js';
import 'storage/js/services/storage.svc.js';
import 'adminConsole/js/controllers/backupSets.ctrl.js';
import 'adminConsole/js/controllers/fsSubclientContentDetails.ctrl.js';
import 'dlo/js/services/profile.svc.js';
import 'modules/nas/js/controllers/nasSubclientDetails.ctrl.js';
import 'modules/nas/js/controllers/nasClientDetails.ctrl.js';
import 'modules/nas/js/factory/nas.factory.js';
import 'modules/nas/js/services/nas.svc.js';
import { NAS_CONSTANTS } from 'modules/nas/js/constants';
import { acAppNasModule } from 'common/js/modules';

var nasMod = acAppNasModule;

// access nodes component : should fetch access nodes and groups and allow selection  of groups. we should allow for selection of sources

nasMod.directive('cvNasAccessnodesComponent', function() {
	return {
		restrict: 'E',
		link: function(scope, element, attrs) {
			scope.getAccessNodeTemplate = function() {
				return scope.accessnodeoptions.tileMode
					? appUtil.appRoot + 'modules/nas/partials/acceesNodesTileTemplate.jsp'
					: appUtil.appRoot + 'modules/nas/partials/accessNodeTemplate.jsp';
			};
		},
		template: '<div ng-include="getAccessNodeTemplate()"></div>',
		scope: {
			accessnodeoptions: '=',
			showError: '='
		},
		controller: [
			'$scope',
			'cvLoc',
			'cvUtil',
			'$uibModal',
			'nasService',
			'agentService',
			'clientGroupService',
			function($scope, cvLoc, cvUtil, $modal, nasService, agentService, clientGroupService) {
				$scope.resubmitted = {
					show: false
				};

				function getAccessnodeType(appId) {
					appId = parseInt(appId);
					switch (appId) {
						case 33:
							return NAS_CONSTANTS.CIFS;
						case 29:
							return NAS_CONSTANTS.NFS;
						case 64:
							return NAS_CONSTANTS.GPFS;
						default:
							return NAS_CONSTANTS.NDMP;
					}
				}

				if (!$scope.accessnodeoptions.type && $scope.accessnodeoptions.appId) {
					$scope.accessnodeoptions.type = getAccessnodeType($scope.accessnodeoptions.appId);
				}
				//pass show error from outer scope.
				$scope.accessnodeoptions.showerror = $scope.showError;

				$scope.contentPopOver = function(key, paths) {
					let html = `
			        <div class='list-call-out'>
			            <div class='call-out-title'><div>${key}</div></div>
			            <div class='list-container'>
			            	${paths
											.map(path =>
												path.clientGroupName
													? `<div class='list'><div class='list-text crop' title='${path.clientGroupName}'>${path.clientGroupName}<span class='parenthetical-text'>(group)</span></div></div>`
													: `<div class='list'><div class='list-text crop' title='${path.clientName}'>${path.clientName}</div></div>`
											)
											.join('')}
			            </div>
			        </div>`;
					return html;
				};

				$scope.showEditProxy = function() {
					$scope.modalInstance = $modal.open({
						templateUrl: appUtil.appRoot + 'vsa/partials/editProxyModal.jsp',
						backdrop: 'static',
						resolve: {
							sourcetype: function() {
								return $scope.accessnodeoptions.type;
							},
							clientAppType: function() {
								return $scope.accessnodeoptions.clientAppType;
							},
							backupDataAccessNodes: function() {
								return $scope.accessnodeoptions.backupDataAccessNodes;
							},
							applicationId: function() {
								return $scope.accessnodeoptions.appId;
							}
						},
						windowClass: 'backupOptionsDialog',
						controller: [
							'$scope',
							'$uibModalInstance',
							'cvLoc',
							'cvUtil',
							'sourcetype',
							'clientService',
							'backupDataAccessNodes',
							'clientAppType',
							'applicationId',
							'AppTypesUtil',
							function(
								$scope,
								$modalInstance,
								cvLoc,
								cvUtil,
								sourcetype,
								clientService,
								backupDataAccessNodes,
								clientAppType,
								applicationId,
								AppTypesUtil
							) {
								$scope.modalTitle = cvLoc('label.addProxyVSA');
								$scope.matchLength = {};
								$scope.pluralizeStrings = {
									'0': cvLoc('label.filter.noMatch'),
									one: cvLoc('label.filter.oneMatch'),
									other: `{} ${cvLoc('label.filter.nMatches')}`
								};
								$scope.showFilter = true;
								$scope.filterText = '';

								// Submit function
								$scope.editProxy = function() {
									backupDataAccessNodes = [];

									if (!AppTypesUtil.isClusterTypeFileSystem(applicationId, sourcetype)) {
										$scope.proxyServersGrouped.groups
											.filter(function(item) {
												return item.selected;
											})
											.map(function(item) {
												backupDataAccessNodes.push({
													_type_: 28,
													clientGroupId: item.groupId,
													clientGroupName: item.name,
													isGroup: true
												});
											});
									}

									$scope.proxyServersGrouped.notGroups
										.filter(function(item) {
											return item.selected;
										})
										.map(function(item) {
											backupDataAccessNodes.push({
												_type_: 3,
												clientId: item.clientId,
												clientName: item.clientName
											});
										});

									$modalInstance.close(backupDataAccessNodes);
								};

								$scope.serverMessage = cvUtil.emptyMsg();
								$scope.proxyServersGrouped = {
									groups: [],
									notGroups: []
								};

								if (AppTypesUtil.isClusterTypeFileSystem(applicationId, sourcetype)) {
									// remving groups for GPFS file system
									$scope.proxyServersGrouped = {
										notGroups: []
									};
								}

								// get client groups as common if source type is not gpfs

								if (!AppTypesUtil.isClusterTypeFileSystem(applicationId, sourcetype)) {
									clientGroupService
										.getClientGroups()
										.success(function(result) {
											let fetchedClientGroups = result;
											for (let i = 0; i < fetchedClientGroups.length; i++) {
												fetchedClientGroups[i].groupId = fetchedClientGroups[i].Id;
												fetchedClientGroups[i].id = i;
												fetchedClientGroups[i].isGroup = true;
												let possibleIndex = _.findIndex(backupDataAccessNodes, {
													clientGroupId: fetchedClientGroups[i].groupId
												});
												if (possibleIndex !== -1) {
													fetchedClientGroups[i].selected = true;
												}
												$scope.proxyServersGrouped.groups.push(fetchedClientGroups[i]);
											}
										})
										.error(function(e) {
											$scope.serverMessage = cvUtil.errMsg(e);
										});
								}

								let fetchClientsSuccess = function(data) {
									let fetchedClients = _.isArray(data) ? data : data.clients;
									for (let i = 0; i < fetchedClients.length; i++) {
										let clientEntityItem = fetchedClients[i];
										clientEntityItem.id = i;
										clientEntityItem.isGroup = false;
										clientEntityItem.name = clientEntityItem.clientName;

										let possibleIndex = _.findIndex(backupDataAccessNodes, { clientId: clientEntityItem.clientId });
										if (possibleIndex !== -1) {
											clientEntityItem.selected = true;
										}
										$scope.proxyServersGrouped.notGroups.push(clientEntityItem);
									}
								};

								if (sourcetype !== NAS_CONSTANTS.NDMP) {
									nasService
										.getProxyNodes(sourcetype, clientAppType)
										.success(fetchClientsSuccess)
										.error(function(errorMessage) {
											if (errorMessage != null) {
												$scope.serverMessage = cvUtil.errMsg(errorMessage.data);
												console.log(error);
												cvToaster.showErrorMessage({
													ttl: '10000',
													message: error.data
												});
											}
										});
								} else if (sourcetype === NAS_CONSTANTS.NDMP) {
									nasService
										.getNasProxyList(0, 64, 5, 2)
										.success(fetchClientsSuccess)
										.error(function(e) {
											$scope.serverMessage = cvUtil.errMsg(e);
										});
								}

								$scope.cancel = function() {
									$scope.serverMessage = cvUtil.emptyMsg();
									$modalInstance.dismiss();
								};

								// Filter functions
								$scope.filterOnChange = () => {
									_.forIn($scope.proxyServersGrouped, (value, key) => {
										$scope.matchLength[key] = 0;
										value.forEach(item => {
											if (item.name.toLowerCase().indexOf($scope.filterText.toLowerCase()) !== -1) {
												item.hide = false;
												$scope.matchLength[key]++;
											} else item.hide = true;
										});
									});
								};

								$scope.clearFilter = () => {
									if (!$scope.filterText || $scope.filterText.length === 0) return;
									$scope.filterText = '';
									$scope.filterOnChange();
								};

								$scope.updateFilterFocus = isSet => {
									$scope.focusFilter = isSet;
								};
							}
						]
					});

					$scope.updateErrorMessage = function() {
						if ($scope.accessnodeoptions.showerror !== null) {
							if ($scope.accessnodeoptions.backupDataAccessNodes.length > 0) {
								$scope.accessnodeoptions.showerror = false;
							} else {
								$scope.accessnodeoptions.showerror = true;
							}
						}
					};

					$scope.modalInstance.result.then(function(backupDataAccessNodes) {
						$scope.accessnodeoptions.backupDataAccessNodes = backupDataAccessNodes;
						// call the success function if it is passed.

						let entity = $scope.accessnodeoptions.entity;
						let handleSuccess = function(data) {
							if ($scope.accessnodeoptions.tileMode) {
								$state.forceReload();
							}
							$modalInstance.dismiss();
						};

						let handleError = function(errorMessage) {
							//$state.forceReload();
							if (errorMessage != null) {
								$scope.serverMessage = cvUtil.errMsg(errorMessage.data);
								cvToaster.showErrorMessage({
									ttl: '10000',
									message: error.data
								});
							}
							$modalInstance.dismiss();
						};

						if (_.isFunction($scope.accessnodeoptions.successFn)) {
							$scope.accessnodeoptions
								.successFn(backupDataAccessNodes)
								.success(handleSuccess)
								.error(handleError);
						}
					});
				};
			}
		]
	};
});

export default nasMod;
