import 'jobs/js/directives/cvJob.directive.js';
import 'adminConsole/js/directives/acDirectives.js';
import 'adminConsole/js/directives/cv-storage-policy.js';
import 'modules/nas/js/factory/nas.factory.js';
import 'capps/js/cappsUtil.js';
import 'dlo/js/services/globalExceptions.svc.js';
import 'adminConsole/js/controllers/security.ctrl.js';
import 'dlo/js/services/profile.svc.js';
import 'modules/schedule/js/factory/schedule.factory.js';
import 'adminConsole/js/controllers/backup.ctrl.js';
import 'vsa/js/services/schedules.svc.js';
import 'adminConsole/js/controllers/agents.ctrl.js';
import 'jobs/js/services/jobs.svc.js';
import 'adminConsole/js/controllers/rdsSubclientContentDetails.ctrl.js';
import 'adminConsole/js/controllers/fsSubclientContentDetails.ctrl.js';
import 'modules/nas/js/services/nas.svc.js';
import 'modules/ida/js/services/idaService.svc.js';
import 'adminConsole/js/services/backupSets.svc.js';
import 'adminConsole/js/services/clients.svc.js';
import 'storage/js/services/storage.svc.js';
import 'adminConsole/js/services/agents.svc.js';
import 'adminConsole/js/services/subclients.svc.js';
import 'adminConsole/js/factories/acBrowseUtils.factory.js';
import 'adminConsole/js/directives/prepost-commands-tile.directive.js';

import { acAppNasModule } from 'common/js/modules';

var nasMod = acAppNasModule;

var controllers = {};
var factories = {};

factories.nasSubclientFactory = [
	'subclientService',
	'agentService',
	'storageService',
	'$log',
	'AppTypes',
	'$dialogs',
	'cvLoc',
	'cvToaster',
	'$location',
	'$state',
	'AppTypesUtil',
	'clientService',
	'backupSetService',
	'idaService',
	'$q',
	'nasService',
	function(
		subclientService,
		agentService,
		storageService,
		$log,
		AppTypes,
		$dialogs,
		cvLoc,
		cvToaster,
		$location,
		$state,
		AppTypesUtil,
		clientService,
		backupSetService,
		idaService,
		$q,
		nasService
	) {
		var factory = {};

		factory.subclientDetail = {};
		factory.storagePoliciesList = [];
		factory.alerts = [];
		factory.backupEnabledStatusInfo = {};
		factory.contentEntityList = [];

		factory.getSubClientDetails = function(id) {
			return subclientService
				.getSubClientDetails(id)
				.success(function(data) {
					factory.subclientDetail = data;
					delete factory.backupEnabledStatusInfo;
					delete factory.snapEnabledStatusInfo;

					factory.contentEntityList = [];
				})
				.error(function(data) {
					$log.error('Error loading subclient detail');
				});
		};

		factory.getStoragePoliciesList = function() {
			return storageService
				.getStoragePoliciesList()
				.success(function(data) {
					factory.storagePoliciesList = data;
				})
				.error(function(data) {
					$log.error('Error loading storage policies list');
				});
		};

		factory.getSubClientAlerts = function(id) {
			return subclientService
				.getSubClientAlerts(id)
				.success(function(data) {
					factory.alerts = data;
				})
				.error(function(data) {
					$log.error('Error loading alerts for sub client');
				});
		};

		factory.saveStoragePolicy = function(subclientId, dataSpId, logSpId, applicationId, clientId, subclientName) {
			subclientService
				.updateStoragePolicyForSubclient(subclientId, dataSpId, logSpId, applicationId, clientId, subclientName)
				.success(function(data) {
					$log.info('Success');
				})
				.error(function(data) {
					$log.error('Error saving storage policy for sub client');
				});
		};

		factory.getBackupEnabledStatusInfo = function() {
			if (angular.isUndefined(factory.backupEnabledStatusInfo) && factory.subclientDetail) {
				factory.backupEnabledStatusInfo = factory.subclientDetail.commonProperties.enableBackup
					? 'enabled-activity'
					: 'disabled-activity';
			}
			return factory.backupEnabledStatusInfo;
		};

		factory.getSnapEnabledStatusInfo = function() {
			if (angular.isUndefined(factory.snapEnabledStatusInfo) && factory.subclientDetail) {
				factory.snapEnabledStatusInfo = factory.subclientDetail.commonProperties.snapCopyInfo.isSnapBackupEnabled
					? 'enabled-activity'
					: 'disabled-activity';
			}
			return factory.snapEnabledStatusInfo;
		};

		//

		factory.manageSnapSettings = function() {
			return nasService
				.manageSettings({
					type: 'snap',
					action: factory.snapEnabledStatusInfo == 'enabled-activity' ? 'disable' : 'enable',
					clientId: factory.subclientDetail.subClientEntity.clientId,
					applicationId: factory.subclientDetail.subClientEntity.applicationId,
					backupsetId: factory.subclientDetail.subClientEntity.backupsetId,
					instanceId: factory.subclientDetail.subClientEntity.instanceId,
					subclientId: factory.subclientDetail.subClientEntity.subclientId
				})
				.success(function(data) {
					if (data.errorCode == 0) {
						factory.snapEnabledStatusInfo =
							factory.snapEnabledStatusInfo == 'enabled-activity' ? 'disabled-activity' : 'enabled-activity';
					} else {
						$log.error('update Snap failed:' + data.errorString);
					}
				})
				.error(function(e) {
					$log.error('update Snap option activity failed', e);
				});
		};

		factory.manageBackupSettings = function() {
			// action =
			// (factory.backupEnabledStatusInfo=="enabled-activity")?"disable":"enable";
			return nasService
				.manageSettings({
					type: 'backup',
					action: factory.backupEnabledStatusInfo == 'enabled-activity' ? 'disable' : 'enable',
					clientId: factory.subclientDetail.subClientEntity.clientId,
					applicationId: factory.subclientDetail.subClientEntity.applicationId,
					backupsetId: factory.subclientDetail.subClientEntity.backupsetId,
					instanceId: factory.subclientDetail.subClientEntity.instanceId,
					subclientId: factory.subclientDetail.subClientEntity.subclientId
				})
				.success(function(data) {
					if (data.errorCode == 0) {
						factory.backupEnabledStatusInfo =
							factory.backupEnabledStatusInfo == 'enabled-activity' ? 'disabled-activity' : 'enabled-activity';
					} else {
						$log.error('update Enablebackup option activity failed: ' + data.errorString);
					}
				})
				.error(function(e) {
					$log.error('update Enablebackup option activity failed', e);
				});
		};

		factory.getContentEntityList = function() {
			if (factory.contentEntityList.length === 0 && factory.subclientDetail) {
				var applicationId = factory.subclientDetail.subClientEntity.applicationId;
				var contentListFromServer = factory.subclientDetail.content,
					tempContentList;

				var length = 0;
				if (contentListFromServer !== undefined) {
					length = contentListFromServer.length;
				}
				for (var index = 0; index < length; index++) {
					if (AppTypesUtil.isFileSystemAgent(applicationId) || AppTypesUtil.isNASAgent(applicationId)) {
						if (contentListFromServer[index].path) {
							tempContentList = {
								value: contentListFromServer[index].path
							};
							factory.contentEntityList[factory.contentEntityList.length] = tempContentList;
						} else if (contentListFromServer[index].subclientPolicyPath) {
							tempContentList = {
								value: contentListFromServer[index].subclientPolicyPath
							};
							factory.contentEntityList[factory.contentEntityList.length] = tempContentList;
						}
					}
				}
				if (
					AppTypesUtil.isWindowsFileSystem(applicationId) &&
					factory.subclientDetail.fsSubClientProp &&
					factory.subclientDetail.fsSubClientProp.backupSystemState
				) {
					tempContentList = {
						value: '[System state]'
					};
					factory.contentEntityList[factory.contentEntityList.length] = tempContentList;
				}
				return factory.contentEntityList;
			}
		};

		factory.deleteSubclient = function(subclientEntity, successCallBack) {
			var successCallBackFunction = successCallBack;
			if (successCallBackFunction === null) {
				successCallBackFunction = function() {
					$log.info(subclientEntity.subclientName + ' subclient deleted successfully');
					$state.forceReload();
				};
			}
			var callBackFunctions = {
				noFunction: function() {},
				yesFunction: function() {
					subclientService
						.deleteSubclient({
							genericEntity: angular.toJson(subclientEntity)
						})
						.success(successCallBackFunction)
						.error(function(errorMessage) {
							errorMessage = errorMessage !== null ? errorMessage : cvLoc('genericError');
							$log.error(errorMessage);
							cvToaster.showErrorMessage({
								ttl: '10000',
								message: errorMessage
							});
						});
				}
			};
			$dialogs.confirm(
				cvLoc('header.deleteSubclient'),
				cvLoc('label.confirmDeleteSubclient', '<b>' + subclientEntity.subclientName + '</b>'),
				callBackFunctions
			);
		};

		factory.backupSets = [];
		factory.defaultBackupSet = {};

		factory.getDefaultBackupSet = function(clientId, applicationId) {
			var deffered = $q.defer();

			agentService
				.getBackupSets(clientId, applicationId)
				.success(function(backupSetList) {
					factory.backupSets = backupSetList;
					factory.nasSubclients = [];

					backupSetList.forEach(function(backupSet) {
						// Populate Subclient of
						// Default Backupset only
						if (backupSet.commonBackupSet.isDefaultBackupSet) {
							factory.defaultBackupSet = backupSet.backupSetEntity;
							deffered.resolve();
							// return
							// backupSet.commonBackupSet;
						}
					});
				})
				.error(function() {
					$log.error('Error loading backupsets');
				});

			return deffered.promise;
		};

		return factory;
	}
]; // End of factory

nasMod.factory(factories);

controllers.nasSubclientDetails = [
	'$scope',
	'nasSubclientFactory',
	'fsSubclientContent',
	'rdsSubclientContent',
	'$stateParams',
	'cvLoc',
	'cvUtil',
	'cvBreadcrumbsTabsFactory',
	'cvTableOptions',
	'cvToaster',
	'jobService',
	'$log',
	'cvPageActionsFactory',
	'$state',
	'$rootScope',
	'agentFactory',
	'scheduleService',
	'cvSuperBreadcrumbData',
	'backupOptionsFactory',
	'AppTypes',
	'$filter',
	'scheduleUIFactory',
	'$dialogs',
	'profileService',
	'$location',
	'AppTypesUtil',
	'securityFactory',
	'$httpParamSerializer',
	'globalExceptionsService',
	'storageService',
	'CAPPS_CONSTANTS',
	'cappsUtil',
	'acBrowseUtils',
	'nasFactory',
	'$uibModal',
	function(
		$scope,
		nasSubclientFactory,
		fsSubclientContent,
		rdsSubclientContent,
		$stateParams,
		cvLoc,
		cvUtil,
		cvBreadcrumbsTabsFactory,
		cvTableOptions,
		cvToaster,
		jobService,
		$log,
		cvPageActionsFactory,
		$state,
		$rootScope,
		agentFactory,
		scheduleService,
		cvSuperBreadcrumbData,
		backupOptionsFactory,
		AppTypes,
		$filter,
		scheduleUIFactory,
		$dialogs,
		profileService,
		$location,
		AppTypesUtil,
		securityFactory,
		$httpParamSerializer,
		globalExceptionsService,
		storageService,
		CAPPS_CONSTANTS,
		cappsUtil,
		acBrowseUtils,
		nasFactory,
		$modal
	) {
		var self = this;

		self.serverMessage = cvUtil.infoMsgLoc('Loading');

		var subclientHasPlan = false;
		var plansAvailableInCS = false;
		var storageUnavailable = false;
		var showPlan = !!cvConfig.showPlan;

		$scope.subclientId = self.subclientId = $stateParams.subclientId;
		self.securityAssociationArray = [];
		self.associationsLoaded = false;
		self.alertsLoaded = self.isBackupSetSupportedLoaded = false;
		self.storagePoliciesLoaded = self.subclientDetailsLoaded = false;
		self.isInstanceSupportedLoaded = false;
		self.clientGroupName = $stateParams.clientGroupName;
		self.clientGroupId = $stateParams.clientGroupId;
		self.formattedSecurityAssociations = securityFactory.createSecurityAssociationsObject();

		nasSubclientFactory.getStoragePoliciesList().then(function() {
			self.storagePoliciesList = nasSubclientFactory.storagePoliciesList;
			self.storagePoliciesLoaded = true;
		});

		nasSubclientFactory.getSubClientAlerts($stateParams.subclientId).then(function() {
			self.alerts = nasSubclientFactory.alerts;
			if (self.alerts.length === 0) {
				self.noAlerts = true;
			} else {
				self.noAlerts = false;
			}
			self.alertsLoaded = true;
		});

		self.showBackup = {
			backup: true
		};

		var pagingOptions = {
			pageSize: 1,
			currentPage: 1
		};

		var sortOptions = {
			directions: [0],
			fields: ['jobId']
		};

		nasSubclientFactory.getSubClientDetails($stateParams.subclientId).then(function() {
			self.serverMessage = cvUtil.emptyMsg();
			self.subclientDetails = nasSubclientFactory.subclientDetail;
			self.backupEntity = {
				subclientId: self.subclientDetails.subClientEntity.subclientId,
				applicationId: self.subclientDetails.subClientEntity.applicationId
			};
			self.clientId = nasSubclientFactory.subclientDetail.subClientEntity.clientId;
			self.applicationId = nasSubclientFactory.subclientDetail.subClientEntity.applicationId;
			self.hasAssociatedPolicy =
				angular.isDefined(nasSubclientFactory.subclientDetail.commonProperties.associatedPolicy) &&
				angular.isDefined(nasSubclientFactory.subclientDetail.commonProperties.associatedPolicy.subclientPolicyId) &&
				nasSubclientFactory.subclientDetail.commonProperties.associatedPolicy.subclientPolicyId > 0
					? true
					: false;
			self.backupSetId = nasSubclientFactory.subclientDetail.subClientEntity.backupsetId;
			self.subclientId = nasSubclientFactory.subclientDetail.subClientEntity.subclientId;
			self.subclientName = nasSubclientFactory.subclientDetail.subClientEntity.subclientName;
			self.instanceId = nasSubclientFactory.subclientDetail.subClientEntity.instanceId;
			self.backupEnabledStatusInfo = nasSubclientFactory.getBackupEnabledStatusInfo();
			self.snapEnabledStatusInfo = nasSubclientFactory.getSnapEnabledStatusInfo();
			self.contentEntityDetails = nasSubclientFactory.getContentEntityList();
			self.isCloudApps = self.applicationId == 134 ? true : false;
			self.cloudAppsType = self.isCloudApps
				? nasSubclientFactory.subclientDetail.cloudAppsSubClientProp.instanceType
				: null;
			self.isDefaultSubclient = nasSubclientFactory.subclientDetail.commonProperties.isDefaultSubclient;
			self.entityType = 'SUBCLIENT_ENTITY';
			self.genericEntity = nasSubclientFactory.subclientDetail.subClientEntity;
			// dataBackupStoragePolicy will be an empty
			// object if storage policy is unavailable
			storageUnavailable =
				self.subclientDetails.commonProperties.storageDevice.dataBackupStoragePolicy.storagePolicyId === undefined;

			// entityType,genericEntity and
			// formattedSecurityAssociations are
			// required by security directive.
			var securityAssociations = self.subclientDetails.commonProperties.securityAssociations;
			self.formattedSecurityAssociations = securityFactory.formatSecurityAssociationsObject(securityAssociations);
			self.associationsLoaded = true;
			// hide if extendStoragePolicyRetention is
			// falsy
			self.hideFullBackupLevel =
				self.subclientDetails.fsSubClientProp && self.subclientDetails.fsSubClientProp.extendStoragePolicyRetention;

			// load plan
			if (self.subclientDetails.planEntity.planId) {
				subclientHasPlan = true;
				self.isScheduleEditable = false;
				self.planEntity = self.subclientDetails.planEntity;
			} else {
				subclientHasPlan = false;
				self.isScheduleEditable = true;
			}
			// check if have global exceptions
			if (
				self.subclientDetails.fsSubClientProp &&
				self.subclientDetails.fsSubClientProp.useGlobalFilters &&
				self.subclientDetails.fsSubClientProp.useGlobalFilters === 'ON'
			) {
				globalExceptionsService.getGlobalExceptions().success(function(data) {
					self.globalExceptions = data;
				});
			}

			// Prepost uses the first listed access node for browse
			self.clientIdForBrowse = _.get(
				self.subclientDetails,
				'fsSubClientProp.backupConfiguration.backupDataAccessNodes[0].clientId'
			);

			cvBreadcrumbsTabsFactory.clearBc();

			var breadCrumbs = [];
			var title = cvLoc('label.nav.servers');
			var link = '#/fsServers';
			if (self.clientGroupName) {
				breadCrumbs.push({
					title: title,
					link: link
				});
			}
			breadCrumbs.push({
				title: nasSubclientFactory.subclientDetail.subClientEntity.clientName,
				link: '#nasClientDetails/' + self.clientId
			});

			if (self.applicationId) {
				let link = '#fsAgentDetails/' + self.clientId + '/' + self.applicationId;
				let title = undefined;

				if (AppTypesUtil.isNASAgent(self.applicationId)) {
					title = cvLoc('label.nas');
				} else if (AppTypesUtil.isWindowsFileSystem(self.applicationId)) {
					title = cvLoc('label.windowsFileSystem');
				} else if (AppTypesUtil.isUnixFileSystem(self.applicationId)) {
					title = cvLoc('label.treenode.linuxFileSystem');
				}

				breadCrumbs.push({
					title: title,
					link: link
				});
			}

			cvBreadcrumbsTabsFactory.addBreadCrumbs(breadCrumbs);

			self.subclientDetailsLoaded = true;

			//Get Agent Details
			agentFactory.getAgentDetails(self.clientId, self.applicationId).then(function() {
				self.agentDetails = agentFactory.agentDetail;
			});

			// get storage pool for subclient
			if (
				self.subclientDetails.commonProperties.storageDevice.dataBackupStoragePolicy !== undefined &&
				self.subclientDetails.commonProperties.storageDevice.dataBackupStoragePolicy.storagePolicyId !== 1
			) {
				if (
					self.subclientDetails.commonProperties.storageDevice.dataBackupStoragePolicy.storagePolicyId !== undefined
				) {
					storageService
						.getStoragePolicyDetails(
							self.subclientDetails.commonProperties.storageDevice.dataBackupStoragePolicy.storagePolicyId
						)
						.success(function(data) {
							if (data.copy[0] && data.copy[0].useGlobalPolicy) {
								self.primaryStoragePoolInfo = {
									storagePoolName: data.copy[0].useGlobalPolicy.storagePolicyName,
									storagePoolId: data.copy[0].useGlobalPolicy.storagePolicyId,
									retentionInDays: data.copy[0].retentionRules.retainBackupDataForDays
								};
							}
							if (data.copy[1] && data.copy[1].useGlobalPolicy) {
								self.snapStorageInfo = {
									snapRecoveryPoints: data.copy[1].retentionRules.jobs
								};
								self.secondaryStoragePoolInfo = {
									storagePoolName: data.copy[1].useGlobalPolicy.storagePolicyName,
									storagePoolId: data.copy[1].useGlobalPolicy.storagePolicyId,
									retentionInDays: data.copy[1].retentionRules.retainBackupDataForDays
								};
							}

							self.showStoragePool =
								self.primaryStoragePoolInfo &&
								self.subclientDetails.planEntity &&
								self.subclientDetails.planEntity.planId
									? true
									: false;
						})
						.error(function() {
							$log.error('Failed to load SP details');
						});
				}
			}
		});

		profileService
			.getProfiles('MSP', true, 'Server')
			.success(function(data) {
				plansAvailableInCS = data.length > 0;
			})
			.error(function(e) {
				showPlan = false;
				plansAvailableInCS = false;
				self.serverMessage = cvUtil.errMsg(e);
			});

		var globalGridOptions = angular.copy(cvTableOptions.commonNgGridOptions);

		angular.extend(globalGridOptions, {
			data: 'contentEntityDetails',
			showGridFooter: true,
			columnDefs: [
				{
					field: 'contentEntityDetails.identifier',
					displayName: cvLoc('header.dbIdentifier'),
					cellTemplate: '<span class="crop">{{row.entity.identifier}}</span>',
					width: '40%'
				},
				{
					field: 'contentEntityDetails.region',
					displayName: cvLoc('header.regionName'),
					cellTemplate: '<span class="crop">{{row.entity.region}}</span>',
					width: '30%'
				},
				{
					field: 'contentEntityDetails.engine',
					displayName: cvLoc('header.engine'),
					cellTemplate: '<span class="crop">{{row.entity.engine}}</span>',
					width: '30%'
				}
			]
		});
		self.gridOptions = globalGridOptions;

		self.manageActivity = function() {
			nasSubclientFactory.manageBackupSettings().then(function() {
				self.backupEnabledStatusInfo = nasSubclientFactory.getBackupEnabledStatusInfo();
			});
		};

		self.manageSnapSettings = function() {
			nasSubclientFactory.manageSnapSettings().then(function() {
				self.snapEnabledStatusInfo = nasSubclientFactory.getSnapEnabledStatusInfo();
			});
		};

		self.jobFilterOptions = {
			clientId: undefined,
			subClientId: $stateParams.subclientId,
			jobType: 'Backup',
			update: false,
			pagingInfo: pagingOptions,
			sortOptions: sortOptions
		};
		self.getRunningBackup = function() {
			jobService.getJobsForEntity(
				self.jobFilterOptions,
				function(data) {
					self.backupJobs = [];
					for (var i = 0; i < data.jobs.length; i++) {
						if (data.jobs[i].jobSummary.percentComplete != 100) {
							self.backupJobs.push(data.jobs[i]);
						}
					}
				},
				function(e) {
					$log.error('backup job could not be retrieved for client');
				}
			);
		};
		self.getRunningBackup();

		self.manageSubclientContent = function() {
			fsSubclientContent.manageFSSubclientContentDetails(self.clientId, self.applicationId, self.globalExceptions);
		};

		self.showBackupOptions = function(entityType, genericEntity) {
			backupOptionsFactory
				.showBackupOptions(entityType, genericEntity, self.cloudAppsType, self.hideFullBackupLevel)
				.then(
					function(job) {
						$log.info('backup started');
						self.getRunningBackup();
					},
					function(jobRunning, resp) {
						if (!jobRunning) {
							$log.error('backup failed: status=', status, ', data=', resp);
						}
					}
				);
		};

		self.isEverythingLoaded = function() {
			if (
				self.alertsLoaded &&
				(self.isBackupSetSupportedLoaded || self.isInstanceSupportedLoaded) &&
				self.storagePoliciesLoaded &&
				self.subclientDetailsLoaded
			) {
				return true;
			} else {
				return false;
			}
		};

		self.getBackupHistoryUrl = function() {
			// returns link in this format:
			// #jobs?serverId=<serverId>&serverName=..... etc
			return (
				'#jobs?' +
				$httpParamSerializer({
					serverId: self.clientId,
					serverName: self.subclientDetails.subClientEntity.clientName,
					applicationId: self.applicationId,
					instanceId: self.instanceId,
					backupsetId: $stateParams.backupSetId,
					collectionId: self.subclientId,
					collectionName: self.subclientName,
					jobType: 'Backup',
					activeJobs: 0
				})
			);
		};

		self.getRestoreHistoryUrl = function() {
			// returns link in this format:
			// #jobs?serverId=<serverId>&serverName=..... etc
			return (
				'#jobs?' +
				$httpParamSerializer({
					serverId: self.clientId,
					serverName: self.subclientDetails.subClientEntity.clientName,
					applicationId: self.applicationId,
					instanceId: self.instanceId,
					backupsetId: $stateParams.backupSetId,
					collectionId: self.subclientId,
					collectionName: self.subclientName,
					jobType: 'Restore',
					activeJobs: 0
				})
			);
		};

		// Should be called only after self.subclientDetails is filled
		self.showRestoreOption = function() {
			if (AppTypesUtil.isFileSystemAgent(self.applicationId) || AppTypesUtil.isNASAgent(self.applicationId)) {
				return (
					self.subclientDetails.commonProperties.lastBackupTime !== 0 &&
					self.subclientDetails.commonProperties.indexingBackupSubClient === false
				);
			}
			return false;
		};

		self.browseAndRestore = function(bLiveBrowse) {
			var browseParams = {
				applicationId: self.applicationId,
				entityId: self.subclientId,
				entityType: 'SUBCLIENT_ENTITY',
				path: acBrowseUtils.getRootPathForBrowse(self.applicationId)
			};

			if (angular.isDefined(bLiveBrowse)) {
				browseParams.isLiveBrowse = bLiveBrowse;
			}

			$state.go('idaBrowse', browseParams);

			return;
		};

		self.deleteSubclient = function(subclientEntity) {
			var successCallBack = function() {
				$log.info(subclientEntity.subclientName + ' subclient deleted successfully');
				$location.path('nasClientDetails/' + subclientEntity.clientId);
			};
			nasSubclientFactory.deleteSubclient(subclientEntity, successCallBack);
		};

		self.isStorageAndScheduleEditable = function() {
			if (showPlan) {
				return !subclientHasPlan;
			}
			return true;
		};

		self.isPlanEnabled = function() {
			if (showPlan) {
				return (
					(self.subclientId && plansAvailableInCS && subclientHasPlan) ||
					(plansAvailableInCS && !subclientHasPlan && storageUnavailable)
				);
			}
			return false;
		};

		self.showEditProxy = function() {
			$modal
				.open({
					template: '<div ng-include src="\'modules/nas/partials/proxyPopup.jsp\'"></div>',
					backdrop: 'static',
					controller: 'nasProxyNodesController as editProxyCtrl',
					windowClass: 'small-size',
					resolve: {
						clientId: function() {
							return self.subclientId;
						},
						proxyList: function() {
							return self.subclientDetails.fsSubClientProp.backupConfiguration.backupDataAccessNodes;
						},
						subClientEntity: function() {
							return self.subclientDetails.subClientEntity;
						},
						accessnodeRequired: function() {
							return false;
						}
					}
				})
				.result.then(function(data) {});
		};

		self.showEditSnapSettings = function() {
			$modal
				.open({
					template: '<div ng-include src="\'modules/nas/partials/snapEnginePopup.jsp\'"></div>',
					backdrop: 'static',
					controller: 'nasSnapEngineController as editSnapEngineCtrl',
					resolve: {
						clientId: function() {
							return self.subclientId;
						},
						snapEngine: function() {
							return self.subclientDetails.commonProperties.snapCopyInfo.snapToTapeSelectedEngine;
						},
						subClientEntity: function() {
							return self.subclientDetails.subClientEntity;
						},
						fsSubClientProp: function() {
							return self.subclientDetails.fsSubClientProp;
						}
					}
				})
				.result.then(function(data) {});
		};

		self.showSnapOptions = function() {
			return true;
		};

		self.showBackupHistoryCalendarView = function() {
			return cvConfig.showBackupHistoryCalendarView;
		};

		if (self.showBackupHistoryCalendarView()) {
			self.performFSRestore = function performFSRestore(job, fromTimeStr, toTimeStr) {
				$state.go('idaBrowse', {
					applicationId: self.applicationId,
					entityId: self.subclientId,
					entityType: 'SUBCLIENT_ENTITY',
					path: acBrowseUtils.getRootPathForBrowse(self.applicationId),
					jobId: undefined,
					fromTime: fromTimeStr,
					toTime: toTimeStr
				});
			};

			self.isFileSystemAgent = function isFileSystemAgent() {
				return AppTypesUtil.isFileSystemAgent(self.applicationId);
			};
		}
	}
];

nasMod.controller('nasSnapEngineController', [
	'cvLoc',
	'nasService',
	'cvUtil',
	'snapEngine',
	'subClientEntity',
	'$uibModalInstance',
	'AppTypesUtil',
	'cvToaster',
	'$state',
	'fsSubClientProp',
	function(
		cvLoc,
		nasService,
		cvUtil,
		snapEngine,
		subClientEntity,
		$modalInstance,
		AppTypesUtil,
		cvToaster,
		$state,
		fsSubClientProp
	) {
		var self = this;
		self.localLang = cvUtil.getIStevenLocLabels();
		self.selectedSnapEngine = {
			name: snapEngine.snapShotEngineName,
			id: snapEngine.snapShotEngineId
		};
		self.selectionMode = 'single';
		self.helperElements = 'none filter';

		//getSnapEnginesForNAS

		nasService
			.getSnapEnginesForNAS(0)
			.success(function(data) {
				self.snapEngineList = data.map(function(item) {
					if (self.selectedSnapEngine && self.selectedSnapEngine.id == item.id) {
						item.selected = true;
					} else {
						item.selected = false;
					}
					return item;
				});
			})
			.error(function() {
				self.showSnapEngineErrorMessage = cvLoc('error.renderSnapEngineList');
			})
			.then(function() {});

		self.cancel = function() {
			self.serverMessage = cvUtil.emptyMsg();
			$modalInstance.dismiss();
		};

		self.validateSnapEngineSelection = function() {
			var isValid = self.snapEngine.some(function(curr) {
				return curr['selected'] === true;
			});

			self.showSnapEngineErrorMessage = !isValid;
			return isValid;
		};

		self.updateSnapEngineSettings = function() {
			var subclientInfo = {
				subClientEntity: subClientEntity,
				commonProperties: {
					snapCopyInfo: {
						isSnapBackupEnabled: true,
						snapToTapeSelectedEngine: {
							snapShotEngineId: self.selectedSnapEngine[0].id,
							snapShotEngineName: self.selectedSnapEngine[0].name,
							_type_: 110
						}
					}
				}
			};

			nasService
				.updateNasSCSettings(JSON.stringify(subclientInfo), subClientEntity.subclientId)
				.success(function(data) {
					$state.forceReload();
					$modalInstance.dismiss();
				})
				.error(function(data) {
					$state.forceReload();
					$modalInstance.dismiss();
				});
		};
	}
]);

nasMod.controller('nasProxyNodesController', [
	'cvLoc',
	'nasService',
	'cvUtil',
	'proxyList',
	'subClientEntity',
	'$uibModalInstance',
	'AppTypesUtil',
	'cvToaster',
	'$state',
	'clientService',
	'isArchiveClient',
	'accessnodeRequired',
	function(
		cvLoc,
		nasService,
		cvUtil,
		proxyList,
		subClientEntity,
		$modalInstance,
		AppTypesUtil,
		cvToaster,
		$state,
		clientService,
		isArchiveClient,
		accessnodeRequired
	) {
		var self = this;
		//self.serverMessage = cvUtil.infoMsgLoc('Loading');
		self.localLang = cvUtil.getIStevenLocLabels();
		self.localLang.nothingSelected = cvLoc('placeholder.proxy');
		self.selectedProxyList = proxyList;
		// For file system agents, hide the access node selector at start.
		self.showAccessNodes = !AppTypesUtil.isFileSystemAgent(subClientEntity.applicationId);

		var proxyMap = {};
		if (proxyList) {
			proxyList.forEach(function(item) {
				proxyMap[item.clientId] = item;
			});
		}

		// Variable for indexing v2 flag.
		let isIndexingV2 = false;

		clientService.getClientDetails(subClientEntity.clientId).then(
			function(result) {
				// Retrieve the value of indexing v2 property when client properties are loaded.
				isIndexingV2 = _.get(result, 'data.clientProps.isIndexingV2', false);
				/*
				 * For file system agents, if client is indexing v2 allow multinode selection as we support
				 * multinode backup. If the client is indexing v1 client then allow only single node
				 * selection. Once the correct mode and helper element is set show the access node selector.
				 */
				if (AppTypesUtil.isFileSystemAgent(subClientEntity.applicationId)) {
					self.selectionMode = isIndexingV2 ? 'multiple' : 'single';
					self.helperElements = isIndexingV2 ? 'all none reset filter' : 'none filter';
					self.showAccessNodes = true;
				}
			},
			function(error) {
				self.serverMessage = cvUtil.errMsgLoc('error');
				$log.error(error);
			}
		);

		self.proxyServers = [];

		if (AppTypesUtil.isNASAgent(subClientEntity.applicationId)) {
			self.appType = '64';
			self.clusterType = '5';
			self.requestType = '2';
			self.selectionMode = 'multiple';
			self.helperElements = 'all none reset filter';
		} else if (AppTypesUtil.isUnixFileSystem(subClientEntity.applicationId)) {
			// NAS and Network Share unix file system agent.
			self.appType = '64';
			self.clusterType = '4';
			self.requestType = '1';
		} else {
			// NAS and Network Share windows file system agent.
			self.appType = '64';
			self.clusterType = '5';
			self.requestType = '1';
		}

		nasService
			.getNasProxyList(0, self.appType, self.clusterType, self.requestType, isArchiveClient ? 131072 : undefined, {
				_type_: 3,
				clientId: _.get(subClientEntity, 'clientId'),
				clientName: _.get(subClientEntity, 'clientName')
			})
			.success(function(data) {
				self.proxyServers = data.map(function(item) {
					if (proxyMap[item.clientId]) {
						item.selected = true;
					} else {
						item.selected = false;
					}
					return item;
				});
			})
			.error(function() {
				self.showProxyNodesErrorMessage = cvLoc('error.renderProxyList');
			})
			.then(function() {});

		self.validateNodeSelection = function() {
			var isValid = self.proxyServers.some(function(curr) {
				return curr['selected'] === true;
			});

			self.showNodesErrorMessage = !isValid;
			return isValid;
		};

		self.cancel = function() {
			self.serverMessage = cvUtil.emptyMsg();
			$modalInstance.dismiss();
		};

		self.editProxy = function() {
			if (accessnodeRequired && _.get(self.selectedProxyList, 'length', 0) === 0) {
				self.serverMessage = cvUtil.errMsg(cvLoc('error.proxy'));
				return;
			}

			self.serverMessage = cvUtil.emptyMsg();

			var subclientInfo = {
				subClientEntity: subClientEntity,
				fsSubClientProp: {
					backupConfiguration: {
						backupDataAccessNodes: self.selectedProxyList
					}
				}
			};

			nasService
				.updateNasSCSettings(JSON.stringify(subclientInfo), subClientEntity.subclientId, true)
				.success(function(data) {
					$state.forceReload();
					$modalInstance.dismiss();
				})
				.error(function(data) {
					$state.forceReload();
					$modalInstance.dismiss();
				});
		};
	}
]);

nasMod.controller(controllers);

export default nasMod;
