import 'adminConsole/js/directives/cv-activity-control-component.js';
import 'adminConsole/js/directives/acDirectives.js';
import 'adminConsole/js/controllers/backup.ctrl.js';
import 'modules/nas/js/factory/nas.factory.js';
import 'capps/js/services/cappsClients.svc.js';
import 'adminConsole/js/controllers/activityControl.ctrl.js';
import 'adminConsole/js/controllers/security.ctrl.js';
import 'commonForAllAgents/js/controllers/generatePackage.ctrl.js';
import 'adminConsole/js/controllers/createBackupSet.ctrl.js';
import 'adminConsole/js/services/agents.svc.js';
import 'modules/nas/js/services/nas.svc.js';
import 'commonForAllAgents/js/controllers/reconfigureClient.ctrl.js';
import 'commonForAllAgents/js/controllers/updateSoftware.ctrl.js';
import 'commonForAllAgents/js/controllers/uninstallSoftware.ctrl.js';
import 'commonForAllAgents/js/services/clients.svc.js';
import 'adminConsole/js/services/clients.svc.js';
import 'adminConsole/js/factories/acBrowseUtils.factory.js';

import { acAppNasModule } from 'common/js/modules';

var nasMod = acAppNasModule;

var controllers = {};
var factories = {};

factories.nasAgentFactory = [
	'clientService',
	'cvToaster',
	'$log',
	'allAgentsService',
	'uninstallSoftwareFactory',
	'updateSoftwareFactory',
	'reconfigureClientFactory',
	'cvLoc',
	'$dialogs',
	'cvUtil',
	'$state',
	'$stateParams',
	'$q',
	'nasService',
	'agentService',
	function(
		clientService,
		cvToaster,
		$log,
		allAgentsService,
		uninstallSoftwareFactory,
		updateSoftwareFactory,
		reconfigureClientFactory,
		cvLoc,
		$dialogs,
		cvUtil,
		$state,
		$stateParams,
		$q,
		nasService,
		agentService
	) {
		var factory = {};
		factory.agentDetail = {};
		factory.clientId = 0;
		factory.nasSubclientsList = [];

		factory.getAgentDetails = function(cId, agentId) {
			return agentService
				.getAgentDetails(cId, agentId)
				.success(function(data) {
					factory.agentDetail = data;

					//Do this after clearing java side cache
					factory.activityControlOptions = []; //resetting as we got new agent details
				})
				.error(function(data) {
					$log.error('Error loading agent detail');
				});
		};

		factory.getAgentsRoles = function(clientId) {
			return clientService
				.getDloServerDetails(clientId)
				.success(function(data) {
					factory.roles = data.roles;
				})
				.error(function(data) {
					cvToaster.showErrorMessage({
						ttl: '5000', //5 sec
						message: 'Error loading roles'
					});
				});
		};

		factory.nasSubclientColDef = [
			{
				field: 'subClientEntity.subclientName',
				sort: {
					direction: 'asc',
					priority: 0
				},
				displayName: cvLoc('label.SubclientName'),
				cellTemplate:
					'<a class="crop" href="#/nasSubclientDetails/{{row.entity.subClientEntity.subclientId}}?clientGroupName=Servers">{{row.entity.subClientEntity.subclientName}}</a>',
				enableHiding: false,
				enableFiltering: true
			},
			{
				field: 'subClientEntity.applicationId',
				displayName: cvLoc('header.type'),
				cellTemplate:
					'<span class="crop">{{row.entity.subClientEntity.applicationId == 33 ? "CIFS" : (row.entity.subClientEntity.applicationId == 29 ? "NFS" : "NAS")}}</span>',
				width: '25%',
				enableFiltering: true
			},
			{
				field: 'subClientEntity',
				displayName: cvLoc('header.restore'),
				// Restore is not applicable for System created
				// subclient,IndexBackup,for index backup
				// data-ng-show="row.entity.commonProperties.lastBackupTime!=0
				// &&
				// row.entity.commonProperties.indexingBackupSubClient==false"
				//cellTemplate : '<span class="crop" data-ng-show="row.entity.commonProperties.lastBackupTime!=0" ><a href="#browseForAgents/{{row.entity.subClientEntity.applicationId}}/?subclientId={{row.entity.subClientEntity.subclientId}}">'
				//		+ cvLoc('header.restore') + '</a></span>',

				cellTemplate:
					'<span class="crop" data-ng-show="row.entity.commonProperties.lastBackupTime!=0 && row.entity.commonProperties.indexingBackupSubClient==false">' +
					'<a href="#idaBrowse/{{row.entity.subClientEntity. applicationId}}/{{row.entity.subClientEntity.subclientId}}?entityType=SUBCLIENT_ENTITY&path={{grid.appScope.getRootPath(row.entity.subClientEntity.applicationId)}}">' +
					cvLoc('header.restore') +
					'</a></span>',
				width: '25%',
				cvUserPref: 'restore',
				enableSorting: false,
				enableFiltering: false
			},
			{
				field: 'subClientEntity.subclientId.commonProperties',
				displayName: cvLoc('header.actions'),
				cellTemplate:
					'<div class="btn-group" uib-dropdown><a href class="uib-dropdown-toggle" uib-dropdown-toggle ng-disabled="disabled"><span class="grid-action-icon"></span></a><ul uib-dropdown-menu class="dropdown-menu" role="menu"><li><a href="" data-ng-class="{inheritedSecurityAssociation : (row.entity.commonProperties.enableBackup==false)}" ng-click="row.entity.commonProperties.enableBackup==false || grid.appScope.showBackupOptions(row.entity.subClientEntity,row.entity.fsSubClientProp && row.entity.fsSubClientProp.extendStoragePolicyRetention)">' +
					cvLoc('action.backup') +
					'</a></li><li><a class="crop" href="#jobs?serverId={{grid.appScope.clientId}}&serverName={{grid.appScope.backupSetDetails.backupSetEntity.clientName}}&applicationId={{grid.appScope.applicationId}}&collectionId={{row.entity.subClientEntity.subclientId}}&collectionName={{row.entity.subClientEntity.subclientName}}&jobType={{\'Backup\'}}&activeJobs=0">' +
					cvLoc('label.BackupHistory') +
					'</a></li><li data-ng-if="row.entity.commonProperties.isDefaultSubclient!=true"><a class="crop" href="" ng-click="grid.appScope.deleteSubclient(row.entity.subClientEntity)">' +
					cvLoc('Delete') +
					'</a></li></ul></div>',
				width: '15%',
				enableFiltering: false,
				enableSorting: false,
				enableHiding: false
			}
		];

		factory.renderNasSubclients = function(clientId, applicationId) {
			return nasService
				.getSubclientList(clientId, applicationId)
				.success(function(subclientList) {
					factory.nasSubclientsList = subclientList;
				})
				.error(function() {
					$log.error('Error loading backupsets');
				});
		};

		return factory;
	}
];

nasMod.factory(factories);

controllers.nasAgentDetails = [
	'nasAgentFactory',
	'createBackupSetFactory',
	'$stateParams',
	'cvLoc',
	'cvUtil',
	'cvBreadcrumbsTabsFactory',
	'$state',
	'cvTableOptions',
	'cvPageActionsFactory',
	'AppTypes',
	'$log',
	'generatePackageFactory',
	'AppTypesUtil',
	'securityFactory',
	'activityControlFactory',
	'ENTITY_TYPES',
	'cappsClientService',
	'CAPPS_CONSTANTS',
	'nasFactory',
	'backupOptionsFactory',
	'$httpParamSerializer',
	'acBrowseUtils',
	function(
		nasAgentFactory,
		createBackupSetFactory,
		$stateParams,
		cvLoc,
		cvUtil,
		cvBreadcrumbsTabsFactory,
		$state,
		cvTableOptions,
		cvPageActionsFactory,
		AppTypes,
		$log,
		generatePackageFactory,
		AppTypesUtil,
		securityFactory,
		activityControlFactory,
		ENTITY_TYPES,
		cappsClientService,
		CAPPS_CONSTANTS,
		nasFactory,
		backupOptionsFactory,
		$httpParamSerializer,
		acBrowseUtils
	) {
		var self = this;
		self.clientId = $stateParams.clientId;
		self.applicationId = $stateParams.applicationId;

		self.serverMessage = {
			message: cvUtil.infoMsgLoc('Loading').message,
			type: 'loader'
		};

		self.entityType = ENTITY_TYPES.APPTYPE_ENTITY;
		self.genericEntity = {
			clientId: parseInt($stateParams.clientId),
			applicationId: parseInt($stateParams.applicationId)
		};
		self.acParams = {
			entityType: self.entityType,
			genericEntity: self.genericEntity,
			activityControlOptionsObject: activityControlFactory.createActivityControlOptionsObject(),
			optionsLoaded: false
		};

		self.formattedSecurityAssociations = securityFactory.createSecurityAssociationsObject();
		self.associationsLoaded = false;
		//self.nasSubclientList = [];

		nasAgentFactory.getAgentDetails($stateParams.clientId, $stateParams.applicationId).then(function() {
			self.agentDetails = nasAgentFactory.agentDetail;

			//entityType,genericEntity and formattedSecurityAssociations are required by security directive.
			var securityAssociations = self.agentDetails.securityAssociations;
			self.formattedSecurityAssociations = securityFactory.formatSecurityAssociationsObject(securityAssociations);
			self.associationsLoaded = true;
			self.path = encodeURIComponent(acBrowseUtils.getRootPathForBrowse(self.applicationId));

			var activityControlOptionsFromServer = self.agentDetails.idaActivityControl.activityControlOptions;
			self.acParams.activityControlOptions = activityControlFactory.getActivityControlOptions(
				self.entityType,
				activityControlOptionsFromServer
			);
			self.acParams.optionsLoaded = true;

			// ######## Bread Crums Start

			breadCrumbs.push({
				title: nasAgentFactory.agentDetail.idaEntity.clientName,
				link: '#nasClientDetails/' + $stateParams.clientId
			});
			cvBreadcrumbsTabsFactory.clearBc();
			cvBreadcrumbsTabsFactory.addBreadCrumbs(breadCrumbs);

			// ######## Bread Crums
		});

		// Create NAS Subclient Pop-up
		self.createNASSubclient = function() {
			if (self.idaEntity.applicationId) {
				nasFactory.createNasSubclient({
					agentInfo: self.agentDetails
				});

				return;
			}
			$log.warn('Not implemented for applicationId:' + self.agentDetails.idaEntity.applicationId);
		};

		// ######## Subclient Details Start

		self.isNasSubclientsSupported = true;

		nasAgentFactory
			.renderNasSubclients($stateParams.clientId, $stateParams.applicationId ? $stateParams.applicationId : 0)
			.then(function() {
				self.nasSubclientList = nasAgentFactory.nasSubclientsList;
				self.serverMessage = cvUtil.emptyMsg();
			});

		self.idaEntity = {
			applicationId: 13
		};

		var globalGridOptions = angular.copy(cvTableOptions.commonNgGridOptions);

		var gridOptions = angular.extend(globalGridOptions, {
			data: 'nasSubclientList',
			showGridFooter: true,
			columnDefs: nasAgentFactory.nasSubclientColDef
		});

		self.gridOptions = {
			cvGridTitle: cvLoc('heading.Subclients'),
			cvIsPageTitle: false,
			cvTableName: 'subClientDetailsTable',
			cvSearchFields: ['idaEntity.appName'],
			cvAppScope: self,
			gridOptions: globalGridOptions
		};

		self.gridOptions.cvPageLinks = [
			{
				label: cvLoc('action.subclientCreation'),
				onclick: self.createNASSubclient,
				show: true
				//"allowSubclientCreation"
			}
		];

		self.gridOptions.cvSearchFields = [
			'subClientEntity.subclientName',
			'commonProperties.storageDevice.dataBackupStoragePolicy.storagePolicyName'
		];

		// ######## Subclient Details End

		self.showJobs = function() {
			var params = {
				serverId: self.clientId,
				serverName: self.clientDetails.client.clientEntity.clientName,
				activeJobs: 0
			};
			$state.go('jobs', params);
		};

		self.getBackupHistoryUrl = function() {
			//returns link in this format:  #jobs?serverId=<serverId>&serverName=..... etc
			return (
				'#jobs?' +
				$httpParamSerializer({
					serverId: self.agentDetails.idaEntity.clientId,
					serverName: self.agentDetails.idaEntity.clientName,
					applicationId: self.agentDetails.idaEntity.applicationId,
					jobType: 'Backup',
					activeJobs: 2,
					view: 'finishedJobs1'
				})
			);
		};

		self.getRestoreHistoryUrl = function() {
			//returns link in this format:  #jobs?serverId=<serverId>&serverName=..... etc
			return (
				'#jobs?' +
				$httpParamSerializer({
					serverId: self.agentDetails.idaEntity.clientId,
					serverName: self.agentDetails.idaEntity.clientName,
					applicationId: self.agentDetails.idaEntity.applicationId,
					jobType: 'Restore',
					activeJobs: 2,
					view: 'finishedJobs1'
				})
			);
		};

		self.getRootPath = function(applicationId) {
			return acBrowseUtils.getRootPathForBrowse(applicationId);
		};

		self.showBackupOptions = function(subclientEntity, hideFullBackupLevel) {
			var subclntEntity = {
				clientId: parseInt(subclientEntity.clientId),
				applicationId: parseInt(subclientEntity.applicationId),
				instanceId: parseInt(subclientEntity.instanceId),
				backupsetId: parseInt(subclientEntity.backupsetId),
				subclientId: parseInt(subclientEntity.subclientId)
			};
			var subclientEntityType = 'SUBCLIENT_ENTITY';
			backupOptionsFactory.showBackupOptions(subclientEntityType, subclntEntity, null, hideFullBackupLevel).then(
				function(job) {
					$log.info('backup started');
				},
				function(jobRunning, resp) {
					if (!jobRunning) {
						$log.error('backup failed: status=', status, ', data=', resp);
					}
				}
			);
		};

		// ######## Bread Crums Start
		var breadCrumbs = [];
		switch (cv.sessionContext.acApp) {
			case 'ADMIN_CONSOLE':
				if (!angular.isDefined(self.clientGroupId) || self.clientGroupId.toLowerCase() !== 'all') {
					breadCrumbs.push({
						title: cvLoc('label.nav.servers'),
						link: '#/fsServers'
					});
				}
				break;
			default:
				breadCrumbs.push({
					title: cvLoc('label.Clients'),
					link: '#servers'
				});
				break;
		}

		//		if (self.clientGroupName) {
		//			breadCrumbs.push({
		//				'title': self.clientGroupName,
		//				'link': '#clientGroupDetails/' + self.clientGroupId
		//			});
		//		}

		cvBreadcrumbsTabsFactory.addBreadCrumbs(breadCrumbs);

		// ######## Bread Crums
	}
];

nasMod.controller(controllers);

export default nasMod;
