<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.postgres"></cv:cvMessages>
	<cv:cvMessages bundle="localization.sybase"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
</script>

<script type="text/ng-template"  id="osUserTemplate.html">
     <!-- Unix and Windows -->
     <div class="form-group">
         <label class="col-xs-12 col-sm-5" for="username">
             <cv-help-text help-label="<cv:msg key="label.osUserName" bundle="oracle"/>" help-text="'<cv:msg key='info.Username' bundle='sybase' />'"></cv-help-text>
         </label>
         <div class="col-xs-12 col-sm-7">
             <input type="text" name="username" data-ng-model="sybaseInstance.instanceDetails.sybaseInstance.localAdministrator.userName" required />
             <span class="help-block" data-ng-show="cv.addSybaseInstance.needsAttention(addSybaseInstance.username)">
                 <cv:msg key="error.osUserName" bundle="oracle"/>
             </span>
         </div>
     </div>
     <!-- Windows password is required  -->
     <div class="form-group" data-ng-if="!sybaseInstance.isUnixClient">
         <label class="col-xs-12 col-sm-5" for="password">
         	<cv-help-text help-label="<cv:msg key="label.osPassword" bundle="oracle"/>" help-text="'<cv:msg key='info.osPassword' bundle='sybase' />'"></cv-help-text>
         </label>
         <div class="col-xs-12 col-sm-7">
             <input type="password" name="password"  data-ng-model="sybaseInstance.instanceDetails.sybaseInstance.localAdministrator.password"
              placeholder='{{ sybaseInstance.edit ? "<cv:msg key="placeholder.editUserPassword" bundle="users" />" : "" }}' data-ng-required="!sybaseInstance.edit" />
             <span class="help-block" data-ng-show="cv.addSybaseInstance.needsAttention(addSybaseInstance.password)">
                 <cv:msg key="error.osUserPassword" bundle="oracle"/>
             </span>
         </div>
     </div>
</script>

<div>
    <div class="setup-title">
		<h1 data-ng-show="!sybaseInstance.edit"><cv:msg key="action.AddInstance" bundle="sybase"/></h1>
		<h1 data-ng-show="sybaseInstance.edit"><cv:msg key="action.EditInstance" bundle="sybase"/></h1>
    </div>
	<span class="{{sybaseInstance.serverMessage.type}}" data-ng-bind="sybaseInstance.serverMessage.message"></span>
	<form name="addSybaseInstance" novalidate autocomplete="off" data-cv-submit="sybaseInstance.submitData()" data-cv-validate="sybaseInstance.validateInputs(addSybaseInstance)">
        	<div class="bootstrap-wrapper">
            	<div class="form-group" data-ng-if="sybaseInstance.addInstance">
					<label class="col-xs-12 col-sm-5" for="hostName">
						<cv:msg key="label.clientName" bundle="clients"/>
					</label>
					<div class="col-xs-12 col-sm-7 text-overflow-allowed" data-ng-disabled="asybaseInstance.editDialog">
						<cv-client-picker selected-clients="sybaseInstance.clientSelection.selectedClients" select-none-by-default="true" valide-client-selection="sybaseInstance.clientSelection.valideClientSelection" selection-changed="sybaseInstance.clientSelection.selectionChanged(clientEntity)"  app-id="5" ></cv-client-picker>
						<span class="help-block" data-ng-show="cv.addSybaseInstance.getAttempted() && !sybaseInstance.clientSelection.valideClientSelection" >
							<cv:msg key="option.clientName" bundle="clients"/>
						</span>
					</div>
				</div>
                <div class="form-group padding-bottom-10">
                    <label class="col-xs-12 col-sm-5" for="databaseName">
                    	<cv-help-text help-label="<cv:msg key="label.DatabaseName" bundle="saphana" />" help-text="'<cv:msg key='info.DatabaseName' bundle='sybase' />'"></cv-help-text>
                    </label>
                    <div class="col-xs-12 col-sm-7">
                        <input type="text" name="databaseName" data-ng-model="sybaseInstance.newInstanceName" required/>
                        <span class="help-block" data-ng-show="cv.addSybaseInstance.needsAttention(addSybaseInstance.databaseName)">
                            <cv:msg key="error.instanceName" bundle="sqlserver"/>
                        </span>
                    </div>
                </div>

				<div class="form-group" >
					<label class="col-xs-12 col-sm-5" for="plan"><cv:msg key="label.profile" bundle="profiles" /></label>
					<div class="col-xs-12 col-sm-7" data-ng-if="sybaseInstance.profileList">
						<cv-plan-summary-dropdown
							id="planSummarySelection"
							input-model="sybaseInstance.profileList"
							output-model="sybaseInstance.selectedProfileList"
							item-label="'name'"
							button-label="'name'"
							tick-property="'selected'"
							translation="sybaseInstance.localLang"
							group-property="'msGroup'"
							helper-elements="'filter'"
							selection-mode="'single'"
							on-close="sybaseInstance.parseIStevenOutput()">
						</cv-plan-summary-dropdown>
						<span class="help-block" data-ng-show="cv.addSybaseInstance.getAttempted() && sybaseInstance.showPlanError">
							<cv:msg key="error.selectPlan" bundle="profiles" />
						</span>
					</div>
				</div>
				<!--
                <span data-ng-if="!sybaseInstance.isShowPlan">
					<div class="form-group">
						<label class="col-xs-12 col-sm-5" for="logStoragePolicy">
							<cv:msg	key="header.logStoragePolicy" bundle="clients" />
						</label>
						<div class="col-xs-12 col-sm-7">
							<cv-isteven-single-select id-name="logStoragePolicy"
									input-model="sybaseInstance.libraries"
									binding-model="sybaseInstance.instanceDetails.sybaseInstance.defaultDatabaseStoragePolicy"
									track-field="storagePolicyId"
									label="storagePolicyName"
									tick-property="selected"
									place-holder='<cv:msg key="label.selectLogStoragePolicy" bundle="clients"/>'
									help-text='<cv:msg key="error.selectLogStoragePolicy" bundle="clients"/>'
									required = "true">
							</cv-isteven-single-select>
						</div>
					</div>
                </span> -->
				<uib-accordion close-others="false" class="text-left">
					<div uib-accordion-group data-is-open="sybaseInstance.openAccordian1">
						<uib-accordion-heading>
						<cv:msg key="title.connectionDetails" bundle="cloudStorageApp"/>
						<i class="float-right glyphicon" data-ng-class="{'glyphicon-chevron-down': sybaseInstance.openAccordian1, 'glyphicon-chevron-right': !sybaseInstance.openAccordian1}"></i>
						</uib-accordion-heading>
						<div class="form-group">
		                    <label class="col-xs-12 col-sm-5" for="saUsername">
		                    <cv-help-text help-label="<cv:msg key="label.SAUsername" bundle="sybase"/>" help-text="'<cv:msg key='info.SAUsername' bundle='sybase' />'"></cv-help-text>

		                    </label>
		                    <div class="col-xs-12 col-sm-7">
		                        <input type="text" name="saUsername" data-ng-model="sybaseInstance.instanceDetails.sybaseInstance.saUser.userName" required />
		                        <span class="help-block" data-ng-show="cv.addSybaseInstance.needsAttention(addSybaseInstance.saUsername)">
		                            <cv:msg key="error.SAUsername" bundle="sybase"/>
		                        </span>
		                    </div>
		                </div>
		                <div class="form-group">
		                    <label class="col-xs-12 col-sm-5" for="saPassword">
		                    	<cv-help-text help-label="<cv:msg key="label.SAPassword" bundle="sybase"/>" help-text="'<cv:msg key='info.SAPassword' bundle='sybase' />'"></cv-help-text>
		                    </label>
		                    <div class="col-xs-12 col-sm-7">
		                        <input type="password" name="saPassword" data-ng-model="sybaseInstance.instanceDetails.sybaseInstance.saUser.password"
		                        placeholder='{{ sybaseInstance.edit ? "<cv:msg key="placeholder.editUserPassword" bundle="users" />" : "" }}' data-ng-required="!sybaseInstance.edit" />
		                        <span class="help-block" data-ng-show="cv.addSybaseInstance.needsAttention(addSybaseInstance.saPassword)">
		                            <cv:msg key="error.SAPassword" bundle="sybase"/>
		                        </span>
		                    </div>
		                </div>
					</div>
					<div uib-accordion-group data-ng-if="(sybaseInstance.edit) || (!sybaseInstance.edit && !sybaseInstance.isUnixClient)" data-is-open="sybaseInstance.openAccordian2">
						<uib-accordion-heading>
						<cv:msg key="header.SybaseOptions" bundle="sybase"/>
						<i class="float-right glyphicon" data-ng-class="{'glyphicon-chevron-down': sybaseInstance.openAccordian2, 'glyphicon-chevron-right': !sybaseInstance.openAccordian2}"></i>
						</uib-accordion-heading>
						<span data-ng-if="sybaseInstance.edit">
							<div class="form-group">
			                    <label class="col-xs-12 col-sm-5" for="HomeDirectory">
			                    	<cv-help-text help-label="<cv:msg key="label.HomeDirectory" bundle="sybase"/>" help-text="'<cv:msg key='info.HomeDirectory' bundle='sybase' />'"></cv-help-text>
			                    </label>
			                    <div class="col-xs-12 col-sm-7">
			                        <div class="input-group" title="{{sybaseInstance.instanceDetails.sybaseInstance.sybaseHome}}">
			                            <input type="text" name="HomeDirectory" data-ng-model="sybaseInstance.instanceDetails.sybaseInstance.sybaseHome" required />
			                            <span class="input-group-btn">
			                                <cv-machine-browse button-label='<cv:msg key="label.browse" bundle="restore"/>' client-id='{{sybaseInstance.instance.clientId}}' result-function="sybaseInstance.sybaseHomeResuleFunction" can-create-folder="false"/>
			                            </span>
			                        </div>
			                        <span class="help-block" data-ng-show="cv.addSybaseInstance.needsAttention(addSybaseInstance.HomeDirectory)">
			                            <cv:msg key="error.HomeDirectory" bundle="sybase"/>
			                        </span>
			                    </div>
			                </div>
			                <div class="form-group">
			                    <label class="col-xs-12 col-sm-5" for="ConfigFile">
			                    	<cv-help-text help-label="<cv:msg key="label.ConfigFile" bundle="sybase"/>" help-text="'<cv:msg key='info.ConfigFile' bundle='sybase' />'"></cv-help-text>
			                    </label>
			                    <div class="col-xs-12 col-sm-7">
			                        <div class="input-group" title="{{sybaseInstance.instanceDetails.sybaseInstance.configFile}}">
			                            <input type="text" name="ConfigFile" data-ng-model="sybaseInstance.instanceDetails.sybaseInstance.configFile" required />
			                            <span class="input-group-btn">
			                                <cv-machine-browse button-label='<cv:msg key="label.browse" bundle="restore"/>' folders-only="false" client-id='{{sybaseInstance.instance.clientId}}' result-function="sybaseInstance.configFileResuleFunction" can-create-folder="false"/>
			                            </span>
			                        </div>
			                        <span class="help-block" data-ng-show="cv.addSybaseInstance.needsAttention(addSybaseInstance.ConfigFile)">
			                            <cv:msg key="error.ConfigFile" bundle="sybase"/>
			                        </span>
			                    </div>
			                </div>
			                <div class="form-group">
			                    <label class="col-xs-12 col-sm-5" for="SharedMemoryDir">
			                    	<cv-help-text help-label="<cv:msg key="label.SharedMemoryDir" bundle="sybase"/>" help-text="'<cv:msg key='info.SharedMemoryDir' bundle='sybase' />'"></cv-help-text>
			                    </label>
			                    <div class="col-xs-12 col-sm-7">
			                        <div class="input-group" title="{{sybaseInstance.instanceDetails.sybaseInstance.sharedMemoryDirectory}}">
			                            <input type="text" name="SharedMemoryDir" data-ng-model="sybaseInstance.instanceDetails.sybaseInstance.sharedMemoryDirectory"  required />
			                            <span class="input-group-btn" >
			                                <cv-machine-browse button-label='<cv:msg key="label.browse" bundle="restore"/>' client-id='{{sybaseInstance.instance.clientId}}' result-function="sybaseInstance.sharedMemoryDirectoryResuleFunction" can-create-folder="false"/>
			                            </span>
			                        </div>
			                         <span class="help-block" data-ng-show="cv.addSybaseInstance.needsAttention(addSybaseInstance.SharedMemoryDir)">
			                            <cv:msg key="error.SharedMemoryDir" bundle="sybase"/>
			                        </span>
			                    </div>
			                </div>
					        <div class="form-group">
			                    <label class="col-xs-12 col-sm-5" for="SybaseASE">
			                    	<cv-help-text help-label="<cv:msg key="label.SybaseASE" bundle="sybase"/>" help-text="'<cv:msg key='info.SybaseASE' bundle='sybase' />'"></cv-help-text>
			                    </label>
			                    <div class="col-xs-12 col-sm-7">
			                        <input type="text" name="SybaseASE" data-ng-model="sybaseInstance.instanceDetails.sybaseInstance.sybaseASE" required/>
			                        <span class="help-block" data-ng-show="cv.addSybaseInstance.needsAttention(addSybaseInstance.SybaseASE)">
			                            <cv:msg key="error.SybaseASE" bundle="sybase"/>
			                        </span>
			                    </div>
			                </div>
			                <div class="form-group">
			                    <label class="col-xs-12 col-sm-5" for="SybaseOCS">
			                    	<cv-help-text help-label="<cv:msg key="label.SybaseOCS" bundle="sybase"/>" help-text="'<cv:msg key='info.SybaseOCS' bundle='sybase' />'"></cv-help-text>
			                    </label>
			                    <div class="col-xs-12 col-sm-7">
			                        <input type="text" name="SybaseOCS" data-ng-model="sybaseInstance.instanceDetails.sybaseInstance.sybaseOCS" required/>
			                        <span class="help-block" data-ng-show="cv.addSybaseInstance.needsAttention(addSybaseInstance.SybaseOCS)">
			                            <cv:msg key="error.SybaseOCS" bundle="sybase"/>
			                        </span>
			                    </div>
			                </div>
							<div data-ng-include="'osUserTemplate.html'"> </div>

			                <div class="form-group" data-ng-if="sybaseInstance.edit">
			                    <label class="col-xs-12 col-sm-5" for="BlockSize">
			                     	<cv-help-text help-label="<cv:msg key="label.BlockSize" bundle="sybase"/>" help-text="'<cv:msg key='info.BlockSize' bundle='sybase' />'"></cv-help-text>
			                    </label>
			                    <div class="col-xs-12 col-sm-7">
			                        <input type="number" name="BlockSize" data-ng-model="sybaseInstance.instanceDetails.sybaseInstance.sybaseBlockSize" required/>
			                        <span class="help-block" data-ng-show="cv.addSybaseInstance.needsAttention(addSybaseInstance.BlockSize)">
			                            <cv:msg key="error.BlockSize" bundle="sybase"/>
			                        </span>
			                    </div>
			                </div>
		                </span>
		                <span data-ng-if="!sybaseInstance.edit">
		                	<div data-ng-include="'osUserTemplate.html'"> </div>
		                </span>
                	</div>
				</uib-accordion>
	        <div class="modal-footer">
	            <button id="sybaseCreateInstance_button_#8737" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="sybaseInstance.closeDialogBox()">
	                <cv:msg key="Cancel" bundle="messages"/>
	            </button>
	            <button id="sybaseCreateInstance_button_#9343" type="submit" class="btn btn-primary cvBusyOnAjax" data-ng-show="!sybaseInstance.edit" >
	            	<cv:msg key="Add" bundle="messages" />
	            </button>
				<button id="sybaseCreateInstance_button_#1546" type="submit" class="btn btn-primary cvBusyOnAjax" data-ng-show="sybaseInstance.edit" >
					<cv:msg key="Save" bundle="messages" />
				</button>
	        </div>
		</div>
    </form>
</div>
