<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
	<cv:cvMessages bundle="localization.schedule"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
</script>
<div class="bootstrap-wrapper">
	<div class="setup-title">
		<h1><cv:msg key="header.backupOptions" bundle="servers"/></h1>
	</div>
	<span class="{{backupController.serverMessage.type}} serverMessage">{{backupController.serverMessage.message}}</span>
	<form name="backupForm" data-cv-submit="backupController.startBackup()" >
	<div class="panel" >
		<div class="panel-body" data-ng-show="!backupController.backupMsg">
			<div class="form-group">
				<label class="col-xs-12 col-lg-12" >
					<cv:msg key="label.backupLevel" bundle="servers"/>
				</label>
			</div>
			<div class="form-group margin-left-25">
				<div class="col-xs-12 col-lg-12">
					<input type="radio" name="backupFull" id="backupFull" data-ng-model="backupController.backupType" value="FULL">
					<label for="backupFull">
						<cv:msg key="option.full" bundle="schedule"/>
					</label>
				</div>
			</div>

			<div class="form-group margin-left-25">
				<div class="col-xs-12 col-lg-12">
					<input type="radio" name="transactionlog" id="transactionlog" data-ng-model="backupController.backupType" value="INCREMENTAL">
					<label for="transactionlog">
						<cv:msg key="option.transactionlog" bundle="schedule"/>
					</label>

				</div>
			</div>

			<div class="form-group margin-left-25">
			<div class="col-xs-1 col-lg-1"></div>
				<div class="col-xs-11 col-lg-11">
					<input type="checkbox" name="doNotTruncateLogs" id="doNotTruncateLogs" data-ng-model="backupController.doNotTruncateLogs" data-ng-disabled="backupController.backupType!='INCREMENTAL'">
					<label for="doNotTruncateLogs">
						<cv:msg key="label.DoNotTruncateLogs" bundle="sybase"/>
					</label>
				</div>
			</div>

			<div class="form-group margin-left-25">
				<div class="col-xs-1 col-lg-1"></div>
				<div class="col-xs-11 col-lg-11">
					<input type="checkbox" name="skipFull" id="skipFull" data-ng-model="backupController.skipFull" data-ng-disabled="backupController.backupType!='INCREMENTAL'">
					<label for="skipFull">
						<cv:msg key="label.SkipFull" bundle="sybase"/>
					</label>
				</div>
			</div>
			<div class="form-group margin-left-25" data-ng-if="!backupController.isSnapEnabled">
				<div class="col-xs-12 col-lg-12">
					<input type="radio" name="cumulativeIncremental" id="cumulativeIncremental" data-ng-model="backupController.backupType" value="DIFFERENTIAL">
					<label for="cumulativeIncremental">
						<cv:msg key="label.CumulativeIncremental" bundle="sybase"/>
					</label>
				</div>
			</div>

			<div class="form-group">
				<div class="col-xs-12"><cv-alert-me selected="false" text="<cv:msg key='label.notifyUserOnJobCompletion' bundle='messages'/>"></cv-alert-me></div>
			</div>
		</div>
	</div>

	<div class="modal-footer">
		<button id="sybaseBackupOptionsModal_button_#5883" type="button" class="btn btn-primary cvBusyOnAjax" data-ng-show="backupMsg" data-ng-click="backupController.cancel()"><cv:msg key="OK" bundle="messages"/></button>
		<button id="sybaseBackupOptionsModal_button_#3011" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-show="!backupController.backupMsg" data-ng-click="backupController.cancel()"><cv:msg key="Cancel" bundle="messages"/></button>
		<button id="sybaseBackupOptionsModal_button_#7563" type="submit" class="btn btn-primary cvBusyOnAjax"  data-ng-class="{'busy':loading}" data-ng-show="!backupController.backupMsg" ><cv:msg key="OK" bundle="messages"/></button>
	</div>
	</form>
</div>
