<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.sqlserver"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1>
		<cv:msg key="label.EditContent" bundle="fs" />
	</h1>
</div>
<div class="setup-content user-edit-content sql-edit-content">
	<span class="serverMessage {{editContentMessage.type}}"
		data-ng-bind="editContentMessage.message"></span>
	<form name="mssqlSubclientContentForm" class="edit-users-grid-form"
		data-cv-submit="modifySubclientContent()" autocomplete="off"
		novalidate>

		<div data-ng-if="showFilterTab"
			class="bootstrap-wrapper accordion-tab">
			<div class="form-group row modal-list">
				<div class="col-xs-12 col-md-12 col-lg-12">

					<cv-tabset-component control="tabControls" element="cvtile"
						default-tab="defaultTab"> <!--     Content tab   -->
					<cv-tab
						tabname="<cv:msg key="header.content" bundle="collections" />"
						data-ng-selected="onTabSelected()">

					<div class="margin-top-10 text-left ">
						<i
							class="glyphicon glyphicon-info-sign tile-tooltip display-inline no-left-padding"></i>
						<span><cv:msg key="help.backupAllDatabase"
								bundle="sqlserver" /></span>
					</div>

					<div class="panel-group" data-ng-if="gridOptions">
						<div class="panel">
							<cv-grid cv-grid-options="gridOptions"></cv-grid>
						</div>
					</div>
					</cv-tab> <!--     Exclusions tab   --> <cv-tab
						tabname="<cv:msg key="label.Exclusions" bundle="fs" />"
						data-ng-selected="onTabSelected()">
					<div class="exclusion-grid-wrapper">
						<div class="content-custom-path-wrapper">
							<input type="text"
								placeholder="<cv:msg key="label.enterNamePattern" bundle="sqlserver" />"
								class="content-custom-path" ng-model="model.excludePattern" />
							<i class="input-icon-right glyphicon glyphicon-plus"
								data-ng-click="addExcludePattern()"
								title="<cv:msg key='action.AddClient' bundle='clients' />"></i>
						</div>
						<div data-ng-if="exclusionsGridOptions" id="selectContentForm">
							<cv-grid cv-grid-options="exclusionsGridOptions"
								class="bottom-grid-fix"></cv-grid>
						</div>
					</div>
					</cv-tab> </cv-tabset-component>
				</div>
			</div>
		</div>

		<div class="panel-group" data-ng-if="!showFilterTab">
			<div class="panel">
				<div class="panel-body">
					<cv-grid cv-grid-options="gridOptions"></cv-grid>
				</div>
			</div>
		</div>

		<div class="button-container">
			<button id="sqlUpdateSubclientContent_button_#0865" type="button"
				class="btn btn-default cvBusyOnAjax setup-btn--hidden"
				data-ng-click="closeModal()">
				<cv:msg key="Cancel" bundle="messages" />
			</button>
			<button id="sqlUpdateSubclientContent_button_#1963" type="submit"
				class="btn btn-primary cvBusyOnAjax">
				<cv:msg key="OK" bundle="messages" />
			</button>
		</div>

	</form>
</div>
