<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>
</script>
<form
	data-ng-submit="cvBrowseSearchController.dropdownOpen = false; cvBrowseSearchController.prepareForSearch(); cvBrowseSearchController.onSearch({searchTerm: searchTerm});">
	<div data-uib-dropdown data-auto-close="disabled"
		class="bootstrap-wrapper"
		data-is-open="cvBrowseSearchController.dropdownOpen">
		<input type="text" class="search-field" data-uib-dropdown-toggle
			data-ng-attr-title="{{searchTerm}}" data-ng-model="searchTerm"
			data-ng-change="cvBrowseSearchController.initializeSearchParams()"
			placeholder="<cv:msg key="label.search" bundle="search"></cv:msg>..." />
		<span
			data-ng-click="searchTerm = ''; cvBrowseSearchController.initializeSearchParams(); cvBrowseSearchController.dropdownOpen = false; cvBrowseSearchController.onSearch({searchTerm: searchTerm})"
			data-uib-tooltip="<cv:msg key="label.clear" bundle="search"></cv:msg>"
			class="form-control-clear glyphicon glyphicon-remove form-control-feedback"></span>
		<div id="search-filter-dropdown" class="dropdown-menu"
			data-uib-dropdown-menu>
			<div class="scrollable">
				<div class="col-xs-12">
					<div class="form-group">
						<label for="from"><cv:msg key="label.from" bundle="search"></cv:msg></label>
						<input type="text" id="from"
							data-ng-model="cvBrowseSearchController.searchParams.from"
							data-ng-blur="cvBrowseSearchController.formatSearch()" />
					</div>
				</div>
				<div class="col-xs-12">
					<div class="form-group">
						<label for="to"><cv:msg key="label.to" bundle="search"></cv:msg></label>
						<input type="text" id="to"
							data-ng-model="cvBrowseSearchController.searchParams.to"
							data-ng-blur="cvBrowseSearchController.formatSearch()" />
					</div>
				</div>
				<div class="col-xs-12">
					<div class="form-group">
						<label for="subject"><cv:msg key="label.subject"
								bundle="search"></cv:msg></label> <input type="text"
							data-ng-model="cvBrowseSearchController.searchParams.subject"
							data-ng-blur="cvBrowseSearchController.formatSearch()"
							id="subject" />
					</div>
				</div>
				<div class="col-xs-12">
					<div class="form-group">
						<label for="folder"><cv:msg key="label.folder"
								bundle="search"></cv:msg></label> <input type="text" id="folder"
							data-ng-model="cvBrowseSearchController.searchParams.folder"
							data-ng-blur="cvBrowseSearchController.formatSearch()" />
					</div>
				</div>
				<div class="col-xs-12">
					<div class="form-group">
						<input type="checkbox" id="hasAttachment"
							data-ng-model="cvBrowseSearchController.searchParams.hasAttachment"
							data-ng-change="cvBrowseSearchController.formatSearch()" /> <label
							for="hasAttachment"><cv:msg key="label.hasAttachment"
								bundle="search"></cv:msg></label>
					</div>
				</div>
				<div class="col-xs-12">
					<div class="form-group">
						<label for="operation"><cv:msg key="label.mailSize"
								bundle="search"></cv:msg></label> <select id="operation"
							data-ng-model="cvBrowseSearchController.searchParams.operation"
							data-ng-change="cvBrowseSearchController.formatSearch()">
							<option value=">" selected><cv:msg
									key="label.greaterThan" bundle="search"></cv:msg></option>
							<option value="<"><cv:msg key="label.lessThan"
									bundle="search"></cv:msg></option>
						</select> <input type="number" id="amount"
							data-ng-model="cvBrowseSearchController.searchParams.amount"
							data-ng-blur="cvBrowseSearchController.formatSearch()" /> <select
							id="units"
							data-ng-model="cvBrowseSearchController.searchParams.units"
							data-ng-options="value for value in cvBrowseSearchController.sizeOptions"
							data-ng-change="cvBrowseSearchController.formatSearch()">
						</select>
					</div>
				</div>
				<div class="col-xs-12">
					<div class="form-group">
						<label for="contains"><cv:msg key="label.contains"
								bundle="search"></cv:msg></label> <input type="text"
							data-ng-model="cvBrowseSearchController.searchParams.contains"
							data-ng-blur="cvBrowseSearchController.formatSearch()"
							id="contains" />
					</div>
				</div>
				<div class="col-xs-12">
					<div class="form-group">
						<label for="received"><cv:msg key="label.received"
								bundle="search"></cv:msg></label> <select id="received"
							data-ng-model="cvBrowseSearchController.searchParams.received"
							data-ng-options="value for value in cvBrowseSearchController.receivedOptions track by value"
							data-ng-change="cvBrowseSearchController.formatSearch();cvBrowseSearchController.receivedChanged();">
						</select>
					</div>
				</div>
				<div
					data-ng-if="cvBrowseSearchController.searchParams.received === cvBrowseSearchController.timeRangeLabel">
					<div class="col-xs-12">
						<div class="form-group">
							<label for="fromTime"><cv:msg key="label.from"
									bundle="search"></cv:msg></label>
							<div class="calendar-wrapper date-picker">
								<input type="text" id="fromTime" name="fromTime"
									data-ng-change="cvBrowseSearchController.onFromDateChanged()"
									class="date-box cursor-pointer"
									data-datetime-picker="MM/dd/yyyy"
									placeholder="<cv:msg key="label.clickToSelectADate" bundle="search"></cv:msg>"
									data-ng-model="cvBrowseSearchController.searchParams.fromTime"
									data-datepicker-options="cvBrowseSearchController.fromDateOptions"
									data-is-open="cvBrowseSearchController.isFromTimeDatePickerOpen"
									data-enable-time="false"
									data-when-closed="cvBrowseSearchController.formatSearch()"
									data-ng-click="cvBrowseSearchController.isFromTimeDatePickerOpen = true"
									readonly />
							</div>
						</div>
					</div>
					<div class="col-xs-12">
						<div class="form-group">
							<label for="toTime"><cv:msg key="label.to"
									bundle="search"></cv:msg></label>
							<div class="calendar-wrapper date-picker">
								<input type="text" id="toTime" name="toTime"
									data-ng-change="cvBrowseSearchController.onToDateChanged()"
									class="date-box cursor-pointer"
									data-datetime-picker="MM/dd/yyyy"
									placeholder="<cv:msg key="label.clickToSelectADate" bundle="search"></cv:msg>"
									data-ng-model="cvBrowseSearchController.searchParams.toTime"
									data-datepicker-options="cvBrowseSearchController.toDateOptions"
									data-is-open="cvBrowseSearchController.isToTimeDatePickerOpen"
									data-when-closed="cvBrowseSearchController.formatSearch()"
									data-enable-time="false"
									data-ng-click="cvBrowseSearchController.isToTimeDatePickerOpen = true"
									readonly />
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="col-xs-12 search-button-container">
				<div class="form-group">
					<button id="searchBox_button_#6538" class="btn btn-block btn-primary" type="submit"> 
						<cv:msg key="label.search" bundle="search"></cv:msg>
					</button>
				</div>
			</div>
		</div>
	</div>
</form>
