<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.scheduleJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.schedule"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restoreJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
</script>
<script type="text/ng-template" id="saphanaRestoreTemplate.html">
	<cv-restore-streams help-text="<cv:msg key="help.saphanaNoOfStreams" bundle="saphana"/>" left-class="col-xs-12 col-sm-6" right-class="col-xs-12 col-sm-6" streams="restoreData.globalOptions.streams"/>
	<div class="form-group">
		<label class="col-xs-12 col-sm-12">
			<cv:msg key="label.recover" bundle="oracle"/>
		</label>
	</div>
	<div class="form-group">
		<div class="col-xs-12 col-sm-6 padding-left-50" >
			<input type="radio" id="PointInTime" name="PointInTime" data-ng-change="recoveryTypeChanged(restoreData.globalOptions.backupType)"
				data-ng-model="restoreData.globalOptions.backupType" value="2" />
			<label for="PointInTime" >
				<cv:msg key="label.upTo" bundle="saphana"/>
			</label>
		</div>
		<div class="col-xs-12 col-sm-6" data-ng-disabled="restoreData.globalOptions.backupType!=2" >
			<cv-date-time-picker max-date="restoreData.globalOptions.maxPit" date-time-Value="restoreData.globalOptions.time" ></cv-date-time-picker>
			<span class="help-block" data-ng-show="cv.restoreForm.needsAttention(restoreForm.dateTimeValue) || pitError">
				<cv:msg key="error.pit" bundle="oracle" />
			</span>
		</div>
	</div>
	<div class="form-group">
		<div class="col-xs-12 col-sm-6 padding-left-50">
			<input id="backupPrefix" name="backupPrefix" type="radio" data-ng-model="restoreData.globalOptions.backupType" value="0" data-ng-change="recoveryTypeChanged(restoreData.globalOptions.backupType)" />
			<label  for="backupPrefix" >
				<cv:msg key="label.useBackupPrefix" bundle="saphana"/>
			</label>
		</div>
		<div class="col-xs-12 col-sm-6" data-ng-disabled="restoreData.globalOptions.backupType!=0">
			<input type="text" id="backupPrefixValue" name="backupPrefixValue" data-ng-model="restoreData.globalOptions.backupPrefixValue"
				data-ng-required="restoreData.globalOptions.backupType==0 " />
			<span class="help-block" data-ng-show="cv.restoreForm.needsAttention(restoreForm.backupPrefixValue)">
				<cv:msg key="error.BackupPrefix" bundle="saphana"/>
			</span>
		</div>
	</div>
	<div class="form-group">
		<div class="col-xs-12 col-sm-6 padding-left-50">
			<input id="backupId" name="backupId" type="radio" data-ng-model="restoreData.globalOptions.backupType" value="1" data-ng-change="recoveryTypeChanged(restoreData.globalOptions.backupType)" />
			<label  for="backupId" >
				<cv:msg key="label.useingInternalId" bundle="saphana"/>
			</label>
		</div>
		<div class="col-xs-12 col-sm-6" data-ng-disabled="restoreData.globalOptions.backupType!=1">
			<input type="text" id="backupIdValue" name="backupIdValue" data-ng-model="restoreData.globalOptions.backupIdValue"
				data-ng-required="restoreData.globalOptions.backupType==1 " />
			<span class="help-block" data-ng-show="cv.restoreForm.needsAttention(restoreForm.backupIdValue)">
				<cv:msg key="error.BackupId" bundle="saphana"/>
			</span>
		</div>
	</div>
	<div class="form-group">
	<uib-accordion  close-others="true" class="text-left" data-ng-init="accordionOpen = false">
	<div uib-accordion-group data-is-open="accordionOpen">
		<uib-accordion-heading>
		<cv:msg key="label.advanced.options" bundle="restore" />
		<i class="float-right glyphicon" data-ng-class="{'glyphicon-chevron-down': accordionOpen, 'glyphicon-chevron-right': !accordionOpen}"></i>
		</uib-accordion-heading>
		<cv-copy-precedence entity-type='entityType' entity-id='entityId'
			label='<cv:msg key="label.restoreFromCopy" bundle="restore"/>' copy-precedence-int='restoreData.globalOptions.copyPrec'></cv-copy-precedence>
		<div class="form-group">
			<div class="col-xs-12">
				<toggle-control status="restoreData.globalOptions.restoreCatalog==true?'enabled-activity':'disabled-activity'"
		  	 	data-ng-click="restoreCatalogSelected()" id="restoreCatalog" name="restoreCatalog"
		  	 	title="<cv:msg key="label.restoreCatalogTime" bundle="saphana"/>">
				 </toggle-control>
		 		<label for="restoreCatalog" title="<cv:msg key="label.restoreCatalogTime" bundle="saphana"/>">
					<cv:msg key="label.restoreCatalogTime" bundle="saphana"/>
				</label>
			</div>
		</div>
		<div class="form-group" data-ng-if="restoreData.globalOptions.restoreCatalog">
			<div class="col-xs-12 col-sm-6 padding-left-50" >
				<input type="radio" id="rcPointInTime" name="rcPointInTime"
					data-ng-model="restoreData.globalOptions.restoreCatalogType" value="1" />
				<label for="rcPointInTime" title="<cv:msg key="label.PointInTime" bundle="saphana"/>" >
					<cv:msg key="label.PointInTime" bundle="saphana"/>
				</label>
			</div>
			<div class="col-xs-12 col-sm-6" data-ng-disabled="restoreData.globalOptions.restoreCatalogType!=1" >
				<cv-date-time-picker picker-id="RestoreCtl" max-date="restoreData.globalOptions.maxPit" date-time-Value="restoreData.globalOptions.restoreCatalogTime" ></cv-date-time-picker>
				<span class="help-block" data-ng-show="cv.restoreForm.needsAttention(restoreForm.dateTimeValueRestoreCtl) || pitRestoreCtlError">
					<cv:msg key="error.pit" bundle="oracle" />
				</span>
			</div>
		</div>
		<div class="form-group" data-ng-if="restoreData.globalOptions.restoreCatalog">
			<div class="col-xs-12 col-sm-6 padding-left-50">
				<input id="relativeToSysdate" name="relativeToSysdate" type="radio" data-ng-model="restoreData.globalOptions.restoreCatalogType" value="0" data-ng-change="restoreCatalogTypeChanged(restoreData.globalOptions.restoreCatalogType)" />
				<label  for="relativeToSysdate" >
					<cv:msg key="label.relativeToSysdate" bundle="saphana"/>
				</label>
			</div>
			<div class="col-xs-12 col-sm-2" data-ng-disabled="restoreData.globalOptions.restoreCatalogType!=0">
				<input type="number" id="relativeToSysdateValue" name="relativeToSysdateValue" max="1000" min="1" data-ng-model="restoreData.globalOptions.relativeToSysdateValue"
					data-ng-required="restoreData.globalOptions.restoreCatalogType==0 " />
			</div>
			<div class="col-xs-12 col-sm-3" data-ng-disabled="restoreData.globalOptions.restoreCatalogType!=0">
				<select id="relativeToSysdateDays" name="relativeToSysdateDays" data-ng-model="restoreData.globalOptions.relativeToSysdateDays"
					data-ng-options="dayNode as dayNode for dayNode in dayTypeList">
				</select>
			</div>
			<span class="help-block" data-ng-show="cv.restoreForm.needsAttention(restoreForm.relativeToSysdate)">
				<cv:msg key="error.BackupPrefix" bundle="saphana"/>
			</span>
		</div>
		<div class="form-group">
			<div class="col-xs-12 col-sm-6" >
				<input id="checkAccess" name="checkAccess" data-ng-model="restoreData.globalOptions.checkAccess" type="checkbox">
				<label for="checkAccess" >
					<cv:msg key="label.CheckAccess" bundle="saphana"/>
				</label>
			</div>
			<div class="col-xs-12 col-sm-6" data-ng-disabled="restoreData.globalOptions.backupType!=2">
				<input id="initializeLogArea" name="initializeLogArea" data-ng-model="restoreData.globalOptions.initializeLogArea" type="checkbox">
				<label for="initializeLogArea" >
					<cv:msg key="label.InitializeLogArea" bundle="saphana"/>
				</label>
			</div>
		</div>
		<div class="form-group">
			<div class="col-xs-12 col-lg-12" >
				<input id="useDeltaBackups" name="useDeltaBackups" data-ng-model="restoreData.globalOptions.deltaBackup" type="checkbox">
				<label for="useDeltaBackups" >
					<cv:msg key="label.useDeltaBackups" bundle="saphana"/>
				</label>
			 </div>
		</div>
		<div class="form-group" data-ng-if="tabControls.getCurrentTabId() == 0 && isSnapBackupEnabled">
			<div class="col-xs-12 col-sm-12">
				<input id="hardwareRevert" name="hardwareRevert" data-ng-model="restoreData.globalOptions.hardwareRevert" type="checkbox">
				<label for="hardwareRevert">
					<cv-help-text help-label="<cv:msg key="label.hardwareRevert" bundle="saphana" />" help-text="'<cv:msg key="help.hardwareRevert" bundle="saphana" />'"></cv-help-text>
				</label>
			</div >
		</div>
	</div>
	</uib-accordion>
	</div>
	<div class="form-group">
    	<div class="col-xs-12">
    		<cv-alert-me selected="false" text="<cv:msg key='label.notifyUserOnJobCompletion' bundle='messages'/>"></cv-alert-me>
    	</div>
	</div>

</script>
<div class="bootstrap-wrapper">
	<div class="setup-title">
		<h1>
			<cv:msg key="label.restoreOpts" bundle="restore" />
		</h1>
	</div>
	<span class="{{serverMessage.type}}" data-ng-bind="serverMessage.message"></span>
	<form name="restoreForm" novalidate data-cv-submit="doRestore()" autocomplete="off">
		<div class="modal-body">
			<div id="modern-tab" class="tab-2">
				<cv-tabset-component control='tabControls' default-tab="'owner'">
					<cv-tab tabname='<cv:msg key="label.restoreInPlace" bundle="restore" />' help-text='<cv:msg key="label.sapInPlaceHelp" bundle="saphana" />'
					 data-ng-selected="onTabChanged()">
						<div data-ng-if="tabControls.getCurrentTabId() == 0">
							<div class="form-group">
								<label class="col-xs-12 col-sm-6" for="destinationServer">
									<cv:msg key="label.oracleVmDestinationServer" bundle="restore" />
								</label>
								<label class="col-xs-12 col-sm-6 label-as-input">
									<a target="_blank" ng-href="#clientDetails/{{entity.clientId}}">{{entity.displayName}}</a>
								</label>
							</div>
							<div class="form-group">
								<label class="col-xs-12 col-sm-6" for="destinationInstance">
									<cv:msg key="label.destInstance" bundle="oracle" />
								</label>
								<label class="col-xs-12 col-sm-6 label-as-input">
									<a target="_blank" ng-href="#databaseDetails/{{entity.instanceId}}">{{entity.instanceName}}</a>
								</label>
							</div>
							<div class="form-group" data-ng-if="isMultiNodeApp">
								<label class="col-xs-12 col-sm-6">
									<cv:msg key="label.destinationDatabase" bundle="saphana" />
								</label>
								<label class="col-xs-12 col-sm-6" data-ng-show="isBackupSetRestore">
									<a target="_blank" ng-href="#dbBackupsetDetails/{{entity.backupsetId}}">{{entity.backupsetName}}</a>
								</label>
								<div class="col-xs-12 col-sm-6" data-ng-if="!isBackupSetRestore">
									<select id="databaseName" name="databaseName" data-ng-model="restoreData.globalOptions.databaseName" data-ng-required="!isBackupSetRestore"
									 data-ng-change="updateSourceDB(restoreData.globalOptions.databaseName)" data-ng-options="backupSet.backupSetEntity.backupsetName as backupSet.backupSetEntity.backupsetName for backupSet in sourceBackupsetDataList |orderBy:'backupSetEntity.backupsetName'">
									</select>
									<span class="help-block" data-ng-show="cv.restoreForm.needsAttention(restoreForm.databaseName)">
										<cv:msg key="error.sourceDatabase" bundle="saphana" />
									</span>
								</div>
							</div>
							<div data-ng-include="'saphanaRestoreTemplate.html'"> </div>
						</div>
					</cv-tab>
					<cv-tab tabname="<cv:msg key="label.OOPRestore" bundle="restore" />" help-text='<cv:msg key="label.sapOutOfPlaceHelp" bundle="saphana" />'
					 data-ng-selected="onTabChanged()">
						<div data-ng-if="tabControls.getCurrentTabId() == 1">
							<div class="form-group" data-ng-if="isMultiNodeApp">
								<label class="col-xs-12 col-sm-6">
									<cv:msg key="label.sourceDatabase" bundle="saphana" />
								</label>
								<div class="col-xs-12 col-sm-6" >
									<label data-ng-show="isBackupSetRestore">
										{{restoreData.globalOptions.databaseName}}
									</label>
									<div  data-ng-if="!isBackupSetRestore">
										<select id="databaseName" name="databaseName" data-ng-model="restoreData.globalOptions.databaseName" data-ng-required="!isBackupSetRestore"
										 data-ng-change="updateSourceDB(restoreData.globalOptions.databaseName)" data-ng-options="backupSet.backupSetEntity.backupsetName as backupSet.backupSetEntity.backupsetName for backupSet in sourceBackupsetDataList |orderBy:'backupSetEntity.backupsetName'">
										</select>
										<span class="help-block" data-ng-show="cv.restoreForm.needsAttention(restoreForm.databaseName)">
											<cv:msg key="error.sourceDatabase" bundle="saphana" />
										</span>
									</div>
								</div>
							</div>
							<div class="form-group">
								<label class="col-xs-12 col-sm-6">
									<cv:msg key="label.oracleVmDestinationServer" bundle="restore" />
								</label>
								<div class="col-xs-12 col-sm-6">
									<select id="destinationclient" name="destinationclient" data-ng-model="restoreData.globalOptions.destinationServer.clientId"
									 data-ng-options="sp.clientId as sp.displayName for sp in restoreData.globalOptions.destinationServerList|orderBy:'displayName'"
									 data-ng-change="updateInstcesModel(restoreData.globalOptions.destinationServer.clientId)" required>
										<option value="">
											<cv:msg key="placeholder.DestinationClient" bundle="saphana" />
										</option>
									</select>
									<span class="help-block" data-ng-show="cv.restoreForm.needsAttention(restoreForm.destinationclient)">
										<cv:msg key="error.DestinationClient" bundle="restore" />
									</span>
								</div>
							</div>
							<div class="form-group">
								<label class="col-xs-12 col-sm-6">
									<cv:msg key="label.destinationInstance" bundle="saphana" />
								</label>
								<div class="col-xs-12 col-sm-6">
									<select id="destinationDatabase" name="destinationDatabase" data-ng-model="restoreData.globalOptions.destinationInstanceId" data-ng-change="instanceSelected(restoreData.globalOptions.destinationInstanceId)"
									 data-ng-options="ins.instance.instanceId as ins.instance.instanceName disable when shouldDisableInstance(ins.instance.instanceId) for ins in restoreData.globalOptions.destinationInstances|orderBy:'instance.instanceName'"
									 required>
										<option value="">
											<cv:msg key="placeholder.destinationInstance" bundle="saphana" />
										</option>
									</select>
									<span class="help-block" data-ng-show="cv.restoreForm.needsAttention(restoreForm.destinationDatabase)">
										<cv:msg key="error.DestinationInstance" bundle="restore" />
									</span>
								</div>
							</div>
							<div class="form-group" data-ng-if="isMultiNodeApp">
								<label class="col-xs-12 col-sm-6">
									<cv:msg key="label.destinationDatabase" bundle="saphana" />
								</label>
								<div class="col-xs-12 col-sm-6">
									<select id="databaseId" name="databaseId" data-ng-model="restoreData.globalOptions.backupsetId" data-ng-required="true" data-ng-change="setBackupSetInfo(restoreData.globalOptions.backupsetId)"
									 data-ng-options="backupSet.backupSetEntity.backupsetId as backupSet.backupSetEntity.backupsetName disable when shouldDisableBackupset(backupSet.backupSetEntity.backupsetId) for backupSet in backupsetList |orderBy:'backupSetEntity.backupsetName'">
										<option value="">
											<cv:msg key="placeholder.DestinationDatabase" bundle="saphana" />
										</option>
									</select>
									<span class="help-block" data-ng-show="cv.restoreForm.needsAttention(restoreForm.databaseId)">
										<cv:msg key="error.dbName" bundle="oracle" />
									</span>
								</div>
							</div>
							<div class="form-group">
								<label class="col-xs-12 col-sm-6" for="dataDir">
									<cv:msg key="label.hanaDataDirectory" bundle="saphana" />
									<cv-help-component help-text="<cv:msg key="help.hanaDataDirectory" bundle="saphana"/>"></cv-help-component>
								</label>
								<div class="col-xs-12 col-sm-6">
									<div class="input-group">
										<input type="text" id="dataDir" name="dataDir" data-ng-model="restoreData.globalOptions.dataDir" />
										<span class="input-group-btn">
											<cv-machine-browse button-label='<cv:msg key="label.browse" bundle="restore"/>' client-id='{{restoreData.globalOptions.instanceInfo.saphanaInstance.DBInstances[0].clientId}}'
											 result-function="dataDirPathResuleFunction" />
										</span>
									</div>
									<span class="help-block" data-ng-show="cv.restoreForm.needsAttention(restoreForm.dataDir)">
										<cv:msg key="error.hanaDataDirectory" bundle="saphana" />
									</span>
								</div>
							</div>
							<div data-ng-include="'saphanaRestoreTemplate.html'">
							</div>
						</div>
					</cv-tab>
					<div data-ng-init="afterTabInit()"></div>
				</cv-tabset-component>
			</div>
		</div>
		<div class="modal-footer">
			<button id="sapHanaRestoreOptions_button_#1947" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="closeModal()">
				<cv:msg key="Cancel" bundle="messages" />
			</button>
			<button id="sapHanaRestoreOptions_button_#7980" class="btn btn-primary cvBusyOnAjax" type="submit">
				<cv:msg key="Submit" bundle="messages" />
			</button>
		</div>
	</form>
</div>