<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.sqlserver"></cv:cvMessages>
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.saphana"></cv:cvMessages>
	<cv:cvMessages bundle="localization.dbs"></cv:cvMessages>
</script> 
<div class="setup-title">
	<h1 > <cv:msg key="heading.EditBackupset" bundle="clients"/></h1>
	<span class="server-message {{serverMessage.type}}" data-ng-bind="serverMessage.message"></span>
</div>
<div class="bootstrap-wrapper" >
	<form name="addHanaServer" novalidate autocomplete="off" data-cv-submit="saveModel()">	
		<div class="panel">
			<div class="panel-body" >
				<div class="form-group">
					<label for="osUsername" class="col-xs-12 col-lg-6" >
						<cv:msg key="label.OsUsername" bundle="saphana"/>
					</label>
					<div class="col-xs-12 col-lg-6">
						<input type="text" required name="osUsername" id="osUsername" data-ng-model="sapBacstInfo.SAPHANAUser.userName" placeholder='<cv:msg key="label.OsUsername" bundle="saphana"/> ' />
						<span class="help-block" data-ng-show="cv.addHanaServer.needsAttention(addHanaServer.osUsername)">
							<cv:msg key="error.OsUsername" bundle="saphana"/>
						</span>			
					</div>
				</div>	
				<div class="form-group">
					<div class="col-xs-6 col-lg-6">
						<input type="radio" data-ng-model="sapBacstInfo.isUseHDBStoreKey" value="true" id="hdbStorekey" name="hdbStorekey" >
						<label for="hdbStorekey" >
							<cv:msg key="label.HdbStorekey" bundle="saphana"/>
						</label>
					</div>
					<div class="col-xs-12 col-lg-6" data-ng-disabled="sapBacstInfo.isUseHDBStoreKey == 'false' ">
						<input type="text" name="hdbStorekey" data-ng-model="sapBacstInfo.hdbuserstorekey"
							placeholder='<cv:msg key="label.HdbStorekey" bundle="saphana"/>'
							data-ng-required="sapBacstInfo.isUseHDBStoreKey == 'true' " />
						<span class="help-block" data-ng-show="cv.addHanaServer.needsAttention(addHanaServer.hdbStorekey)">
							<cv:msg key="error.HdbStorekey" bundle="saphana"/>
						</span>			
					</div>
				</div>	
				<div class="form-group">
					<div class="col-xs-6 col-lg-6">
						<input type="radio" data-ng-model="sapBacstInfo.isUseHDBStoreKey" value="false" id="DBUser" name="DBUser">
						<label for="DBUser" >
							<cv:msg key="label.userName" bundle="users"/>
						</label>
					</div>
					<div class="col-xs-12 col-lg-6" data-ng-disabled="sapBacstInfo.isUseHDBStoreKey == 'true' " >
						<input type="text" name="dbUsername" id="dbUsername" data-ng-model="sapBacstInfo.dbUser.userName"
								placeholder='<cv:msg key="label.userName" bundle="users"/>'
								data-ng-required="sapBacstInfo.isUseHDBStoreKey == 'false'" />
						<span class="help-block" data-ng-show="cv.addHanaServer.needsAttention(addHanaServer.dbUsername)">
							<cv:msg key="error.userName" bundle="users"/>
						</span>
					</div>
				</div>
				<div class="form-group">					
					<div class="col-xs-6 col-lg-6">						
						<label style="margin-left: 15px;" for="dbUsername" >
							<cv:msg key="label.DbPassword" bundle="saphana"/>
						</label>
					</div>
					<div class="col-xs-12 col-lg-6" data-ng-disabled="sapBacstInfo.isUseHDBStoreKey == 'true' " >
						 <input type="password" name="dbPassword" id="dbPassword" data-ng-model="sapBacstInfo.dbUser.dbUserPassword"
							placeholder='<cv:msg key="label.DbPassword" bundle="saphana"/>'
							data-ng-required="sapBacstInfo.isUseHDBStoreKey  == 'false'" />
						<span class="help-block" data-ng-show="cv.addHanaServer.needsAttention(addHanaServer.dbPassword)">
							<cv:msg key="error.DbPassword" bundle="saphana"/>
						</span>	
					</div>
				</div>	
			</div>
		</div>
		<div class="modal-footer" >
			<button id="sapHanaCreateBackupsetModal_button_#8517" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="closeModal()"> 
				<cv:msg key="Cancel" bundle="messages" />
			</button>
			<button id="sapHanaCreateBackupsetModal_button_#6055" type="submit" class="btn btn-primary cvBusyOnAjax" > 
				<span><cv:msg key="Save" bundle="messages" /> </span>
			</button>
		</div>
	</form>	
</div>
