<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.job"></cv:cvMessages>
	<cv:cvMessages bundle="localization.saphana"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restoreJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.oracle"></cv:cvMessages>
</script>
<script type="text/ng-template"  id="sapORestoreTemplate.html">

				<cv-restore-streams streams="sapORestore.model.streams"/>

				<div class="form-group">
					<label class="col-xs-12 col-sm-5">
						<cv:msg key="label.restore" bundle="oracle"/>
					</label>
				</div>
				<div class="form-group">

					<div class="col-xs-12 col-sm-11 col-sm-offset-1">
						<input type="checkbox" id="database" name="database" data-ng-model="sapORestore.model.database" data-ng-disabled="!sapORestore.isInplace" />
						<label for="database"><cv:msg key="label.database" bundle="oracle" /></label>
					</div>
				</div>
				<div class="form-group">

					<div class="col-xs-12 col-sm-11 col-sm-offset-1">
						<input type="checkbox" id="controlFile" name="controlFile" data-ng-model="sapORestore.model.controlFile" data-ng-disabled="!sapORestore.isInplace"/>
						<label for="controlFile"><cv:msg key="label.controlfile" bundle="oracle" /></label>
					</div>
				</div>
				<div class="form-group">
					<div class="col-xs-12 col-sm-11 col-sm-offset-1">
						<input type="checkbox" id="archiveLog" name="archiveLog" data-ng-model="sapORestore.model.archiveLog" data-ng-disabled="!sapORestore.isInplace"/>
						<label for="archiveLog"><cv:msg key="label.sapArchiveLog" bundle="oracle" /></label>
					</div>
				</div>
                <div class="form-group" ng-hide="!sapORestore.isInplace">
					<div class="col-xs-12 col-sm-11 col-sm-offset-1">
						<input type="checkbox" id="useSnapRevert" name="useSnapRevert" data-ng-model="sapORestore.model.useSnapRevert"/>
						<label for="useSnapRevert"><cv:msg key="label.useSnapRevert" bundle="oracle" /></label>
					</div>
				</div>
				<div class="form-group">
					<label class="col-xs-12 col-sm-12" for="pitType">
						 <cv:msg key="label.recoverTo" bundle="oracle"/>
					</label>
				</div>
				<div class="form-group">
					<div class="col-xs-12 col-sm-11 col-sm-offset-1">
						<input type="radio" data-ng-model="sapORestore.model.pitType" value="CURRENT_TIME" id="currentTime" name="pitType" data-ng-change="sapORestore.pitTypeChanged()"/>
						<label for="currentTime"><cv:msg key="label.currentTime" bundle="oracle"/></label>
					</div>
				</div>
				<div class="form-group">
					<div class="col-xs-12 col-sm-4 col-sm-offset-1">
						<input type="radio" data-ng-model="sapORestore.model.pitType" value="PIT" id="pit" name="pitType" data-ng-change="sapORestore.pitTypeChanged()"/>
						<label for="pit"><cv:msg key="label.pit" bundle="oracle" /></label>
					</div>
					<div class="col-xs-1 col-sm-7" data-ng-disabled='(sapORestore.model.pitType !== "PIT")'>
						<cv-date-time-picker date-format="sapORestore.pitTimeFormat" date-time-Value="sapORestore.model.pitDate" ></cv-date-time-picker>
						<span class="help-block" data-ng-show="cv.restoreForm.needsAttention(restoreForm.dateTimeValue) || sapORestore.pitError">
							<cv:msg key="error.pit" bundle="oracle" />
						</span>
					</div>
				</div>

</script>


<div class="bootstrap-wrapper" >
	<div class="modal-header">
		<h1 > <cv:msg key="label.restoreOpts" bundle="restore"/></h1>
	</div>
	<span class="{{sapORestore.serverMessage.type}}" data-ng-bind="sapORestore.serverMessage.message"></span>
	<form name="restoreForm" class="form-horizontal" novalidate data-cv-submit="sapORestore.submit()" autocomplete="off">
		<div class="panel">
			<div class="panel-body">
			<div id="modern-tab" class="tab-2">

				<cv-tabset-component control='sapORestore.tabControls' default-tab='sapORestore.defaultTab' on-select="sapORestore.onTabChangedBind">
					<cv-tab tabname='<cv:msg key="label.restoreInPlace" bundle="restore" />' tabid="IN_PLACE" class="padding-top-10">
						<div data-ng-if="sapORestore.isInplace">
							<div class="form-group">
								<label class="col-xs-12 col-sm-5" for="destinationServer">
									<cv:msg key="label.oracleVmDestinationServer" bundle="restore"/>
								</label>
								<label class="col-xs-12 col-sm-7 label-as-input">
									<a target="_blank" ng-href="#clientDetails/{{sapORestore.entity.clientId}}">{{sapORestore.entity.displayName}}</a>
								</label>
							</div>
							<div class="form-group" class="padding-top-10">
								<label class="col-xs-12 col-sm-5" for="destinationInstance">
									<cv:msg key="label.destInstance" bundle="oracle"/>
								</label>
								<label class="col-xs-12 col-sm-7 label-as-input">
									<a target="_blank" ng-href="#databaseDetails/{{sapORestore.entity.instanceId}}">{{sapORestore.entity.instanceName}}</a>
								</label>
							</div>
							<div data-ng-include="'sapORestoreTemplate.html'"> </div>
						</div>
					</cv-tab>

					<cv-tab tabname='<cv:msg key="label.databaseCopy" bundle="oracle" />' tabid='OUT_OF_PLACE' class="padding-top-10">
						<div data-ng-if="!sapORestore.isInplace">
								<div class="form-group" >
									<label class="col-xs-12 col-sm-5" for="destinationServer">
										<cv:msg key="label.oracleVmDestinationServer" bundle="restore"/>
									</label>
									<div class="col-xs-12 col-sm-7">
										<isteven-multi-select id="sapORestore_destinationServer"
								 			directive-id="destinationServer"
											input-model="sapORestore.destinationServerList"
											output-model="sapORestore._selectedDestinationServers"
											button-label="displayName"
											item-label="displayName"
											translation="sapORestore.serverLoc"
											tick-property="selected"
											class="isteven-multi-select user-group-select"
											selection-mode="single"
											on-close="sapORestore.destinationServerChanged()"
											is-required = "true"
											helper-elements="filter">
										</isteven-multi-select>
										<span class="help-block" data-ng-show="cv.restoreForm.needsAttention(restoreForm.destinationServer)">
				                        	<cv:msg key="error.oracleVmDestinationServer" bundle="restore"/>
				                       	</span>
									</div>
								</div>
								<div class="form-group" >
									<label class="col-xs-12 col-sm-5" for="destinationInstance">
										<cv:msg key="label.destInstance" bundle="oracle"/>
									</label>
									<div class="col-xs-12 col-sm-7">
										<isteven-multi-select id="sapORestore_destinationInstance"
								 			directive-id="destinationInstance"
											input-model="sapORestore.destinationInstanceList"
											output-model="sapORestore._selectedDestinationInstances"
											button-label="instanceName"
											item-label="instanceName"
											translation="sapORestore.instanceLoc"
											tick-property="selected"
											class="isteven-multi-select user-group-select"
											selection-mode="single"
											on-close="sapORestore.destinationInstanceChanged()"
											is-required = "true"
											helper-elements="filter">
										</isteven-multi-select>
										<span class="help-block" data-ng-show="cv.restoreForm.needsAttention(restoreForm.destinationInstance)">
				                        	<cv:msg key="error.destInstance" bundle="oracle"/>
				                       	</span>
									</div>
								</div>

								<div data-ng-include="'sapORestoreTemplate.html'" ></div>
						</div>
					</cv-tab>
				</cv-tabset-component>
			</div>
		</div>
		</div>
		<div class="panel">
			<div class="panel-body">
				<div class="form-group">
					<div class="col-xs-12">
						<cv-alert-me selected="false" text="<cv:msg key='label.notifyUserOnJobCompletion' bundle='messages'/>"></cv-alert-me>
					</div>
				</div>
			</div>
		</div>
		<div class="modal-footer">
			<button id="sapORestoreOptions_button_cancel" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="sapORestore.cancel()"><cv:msg key="Cancel" bundle="messages"/></button>
			<button id="sapORestoreOptions_button_submit" class="btn btn-primary cvBusyOnAjax" type="submit" ><cv:msg key="Submit" bundle="messages"/></button>
		</div>
	</form>
</div>
