<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
		<cv:cvMessages bundle="localization.fs"></cv:cvMessages>
		<cv:cvMessages bundle="localization.job"></cv:cvMessages>
		<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
		<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
		<cv:cvMessages bundle="localization.oracle"></cv:cvMessages>
</script>
<script type="text/ng-template"  id="browseTree_item_renderer.html">
	<div data-ng-class="{selected: item.isSelected}">
		<button data-ng-class="item.state | lowercase" data-ng-click="sapOSub.folderDrilledDown(item,$event)"></button>
 		<span data-ng-click="sapOSub.folderSelected(item)">{{item.label}}</span>
	</div>
    <div class="children" data-ng-class="item.state">
         <div class="browse-item" data-ng-repeat="item in item.children" data-ng-include="'browseTree_item_renderer.html'"></div>
    </div>
</script>
<div class="bootstrap-wrapper" >
	<div class="setup-title">
		<h1>{{sapOSub.header}}</h1>
	</div>
	<span class="{{sapOSub.serverMessage.type}}" data-ng-bind="sapOSub.serverMessage.message"></span>
	<form name="sapOSubForm" class="form-horizontal" novalidate autocomplete="off" data-cv-submit="sapOSub.submit()" >
		<div class="panel">
			<div class="panel-body">
				<div class="form-group" data-ng-if="!sapOSub.isEdit">
					<label for="subclientName" class="col-xs-12 col-sm-5" >
						<cv:msg key="label.SubclientName" bundle="clients" />
					</label>
					<div class="col-xs-12 col-sm-7">
						<input type="text" name="subclientName" id="subclientName"
								data-ng-model="sapOSub.model.subclientName" required autofocus />
						<span class="help-block" data-ng-show="cv.sapOSubForm.needsAttention(sapOSubForm.subclientName)">
							<cv:msg key="error.subclientName" bundle="clients" />
						</span>
					</div>
				</div>
				<div class="form-group" data-ng-if="!sapOSub.isEdit">
					<div class="col-xs-12">
						<cv-entity-plan-policy-select data-ng-if="sapOSub.planPolicyModel" data-cv-model="sapOSub.planPolicyModel"
								data-cv-show-plan="sapOSub.showPlan" data-cv-app-id="sapOSub.entity.applicationId" data-cv-client-id="sapOSub.entity.clientId" data-cv-wrapper-class="'form-group row'"
								no-bootstrap-wrapper-class="true"
								data-cv-label-class="'col-xs-12 col-sm-5'" data-cv-select-class="'col-xs-12 col-sm-7'"
								cv-hide-policy-toggle-option="true">
						</cv-entity-plan-policy-select>
					</div>
				</div>

				<div class="form-group" data-ng-if="!sapOSub.isEdit">
					<label for="numberBackupStreams" class="col-xs-12 col-sm-5" >
						<cv:msg key="label.numberBackupStreams" bundle="oracle" />
					</label>
					<div class="col-xs-12 col-sm-7">
						<input id="numberBackupStreams" name="numberBackupStreams"
								 required type="number" data-ng-model="sapOSub.model.numberOfBackupStreams" min="1" max="100" data-ng-maxlength="3" />
						<span class="help-block" data-ng-show="cv.sapOSubForm.needsAttention(sapOSubForm.numberBackupStreams)">
							<cv:msg key="error.numberBackupStreams" bundle="oracle" />
						</span>
					</div>
				</div>

				<div class="form-group" data-ng-if="sapOSub.isEdit !== 'BACKUP DEVICE'">
					<div class="col-xs-12">
						<input type="checkbox" id="selectiveOnlineFull" name="selectiveOnlineFull" data-ng-model="sapOSub.model.selectiveOnlineFull" data-ng-change="sapOSub.selectiveOnlineFullChanged()" />
						<label for="selectiveOnlineFull" >
							<cv:msg key="label.selectiveOnlineFull" bundle="oracle" />
						</label>
					</div>
				</div>
				<div class="form-group" data-ng-if="sapOSub.isEdit !== 'BACKUP DEVICE'">
					<div class="col-xs-12">
						<input type="checkbox" id="dataBackup" name="dataBackup" data-ng-model="sapOSub.model.dataBackup" data-ng-change="sapOSub.offlineDataSelected()"  data-ng-disabled="sapOSub.model.selectiveOnlineFull"/>
						<label for="dataBackup" >
							<cv:msg key="label.dataBackup" bundle="oracle" />
						</label>
					</div>
				</div>
				<div class="form-group" data-ng-if="sapOSub.isEdit !== 'BACKUP DEVICE'" data-ng-disabled="(!sapOSub.model.dataBackup || sapOSub.model.selectiveOnlineFull)" >
					<div class="col-xs-12 col-sm-2 col-sm-offset-1">
						<input type="radio" id="onlineData" value="ONLINE_DB" data-ng-model="sapOSub.model.backupMode" data-ng-change="sapOSub.backupModeChanged()"/>
						<label for="onlineData" >
							<cv:msg key="label.onlineData" bundle="oracle" />
						</label>
					</div>
					<div class="col-xs-12 col-sm-3">
							<input type="radio" id="onlineSubset" value="ONLINE_SUBSET_DB" data-ng-model="sapOSub.model.backupMode" data-ng-change="sapOSub.backupModeChanged()"/>
						<label for="onlineSubset">
							<cv:msg key="label.onlineSubset" bundle="oracle" />
						</label>
					</div>
					<div class="col-xs-12 col-sm-2">
						<input type="radio" id="offlineData" value="OFFLINE_DB" data-ng-model="sapOSub.model.backupMode" data-ng-change="sapOSub.backupModeChanged()" />
						<label for="offlineData"  >
							<cv:msg key="label.offlineData" bundle="oracle" />
						</label>
					</div>
					<div class="col-xs-12 col-sm-4">
						<input type="radio" id="consistentOnline" value="ONLINE_CONSISTENT_DB" data-ng-model="sapOSub.model.backupMode" data-ng-change="sapOSub.backupModeChanged()" />
						<label for="consistentOnline"  >
							<cv:msg key="label.consistentOnline" bundle="oracle" />
						</label>
					</div>
				</div>


				<div class="form-group" data-ng-show="(sapOSub.model.dataBackup && sapOSub.model.backupMode === 'ONLINE_SUBSET_DB')" >
					<div class="col-xs-12 col-sm-1">
					</div>
					<div class="col-xs-12 col-sm-11 margin-top-10">
						<div  class="browse-tree" data-ng-class="sapOSub.tree.state">
							 <div class="browse-item">
								<div data-ng-class="{selected: sapOSub.tree.isSelected}" >
									<button id="sapOSubForm_button_tree" data-ng-class="sapOSub.tree.state | lowercase" data-ng-click="sapOSub.folderDrilledDown(sapOSub.tree,$event)"></button>
									<span data-ng-click="sapOSub.folderSelected(sapOSub.tree)">{{sapOSub.tree.label}}</span>
									<div data-ng-repeat="item in sapOSub.tree.children" class="browse-item" data-ng-include="'browseTree_item_renderer.html'"></div>
								</div>
							</div>
						</div>
					</div>
				</div>


				<div class="form-group" data-ng-if="!sapOSub.isEdit || sapOSub.isEdit === 'BACKUP DEVICE'" >
					<div class="col-xs-12">
						<label><cv:msg key="label.backupDevice" bundle="oracle" /></label>
					</div>
				</div>
				<div class="form-group" data-ng-if="!sapOSub.isEdit || sapOSub.isEdit === 'BACKUP DEVICE'">
					<div class="col-xs-12 col-sm-2 col-sm-offset-1">
						<input type="radio" id="utilFile" value="UTIL_FILE" data-ng-model="sapOSub.model.backupDevice" />
						<label for="utilFile" >
							<cv:msg key="label.utilFile" bundle="oracle" />
						</label>
					</div>
					<div class="col-xs-12 col-sm-3" data-ng-hide="sapOSub.model.snapEnabled" >
						<input type="radio" id=rmanUtil value="RMAN_UTIL" data-ng-model="sapOSub.model.backupDevice" />
						<label for="rmanUtil" >
							<cv:msg key="label.rmanUtil" bundle="oracle" />
						</label>
					</div>
					<div class="col-xs-12 col-sm-3" data-ng-hide="sapOSub.model.snapEnabled" >
						<input type="radio" id=utilFileOnline value="UTIL_FILE_ONLINE" data-ng-model="sapOSub.model.backupDevice" />
						<label for="utilFileOnline" >
							<cv:msg key="label.utilFileOnline" bundle="oracle" />
						</label>
					</div>

				</div>
				<div class="form-group" data-ng-if="sapOSub.isEdit !== 'BACKUP DEVICE'" data-ng-show="!sapOSub.model.dataBackup || sapOSub.model.backupMode !== 'OFFLINE_DB'">
					<div class="col-xs-12">
						<input type="checkbox" id="logBackup" name="logBackup" data-ng-model="sapOSub.model.logBackup" data-ng-disabled="sapOSub.model.selectiveOnlineFull"/>
						<label for="logBackup" >
							<cv:msg key="label.logBackup" bundle="oracle" />
						</label>
					</div>
				</div>
				<div class="form-group" data-ng-if="sapOSub.isEdit !== 'BACKUP DEVICE'" data-ng-show="!sapOSub.model.dataBackup || sapOSub.model.backupMode !== 'OFFLINE_DB'" data-ng-disabled="!sapOSub.model.logBackup" >
					<div class="col-xs-12 col-sm-5 col-sm-offset-1">
						<input  type="checkbox" id="deleteArchiveLogs" name="deleteArchiveLogs" data-ng-model="sapOSub.model.archiveDelete" />
						<label for="deleteArchiveLogs" >
							<cv:msg key="label.deleteArchiveLogs" bundle="oracle" />
						</label>
					</div>
					<div class="col-xs-12 col-sm-6">
						<input  type="checkbox" id="createSecondCopy" name="createSecondCopy" data-ng-model="sapOSub.model.createSecondCopy" />
						<label for="createSecondCopy" >
							<cv:msg key="label.createSecondCopyForLogs" bundle="oracle" />
						</label>
					</div>
				</div>

				<%-- <div class="form-group" data-ng-hide="sapOSub.model.enableLightScript">
					<div class="col-xs-12 margin-top-15">
						<label for="lightScript" >
							<cv:msg key="label.lightsOutScript" bundle="oracle" />
						</label>
					</div>
				</div> --%>

			</div>
		</div>
		<div class="modal-footer" >
			<button id="sapOSubFrom_button_cancel" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="sapOSub.cancel()"><cv:msg key="Cancel" bundle="messages" /></button>
			<button id="sapOSubFrom_button_submit" type="submit" class="btn btn-primary cvBusyOnAjax" >
				<span data-ng-if="sapOSub.isEdit"><cv:msg key="Save" bundle="messages" /></span>
				<span data-ng-if="!sapOSub.isEdit"><cv:msg key="Add" bundle="messages" /></span>
			</button>
		</div>
	</form>
</div>
