<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
		<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
		<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
		<cv:cvMessages bundle="localization.dbs"></cv:cvMessages>
		<cv:cvMessages bundle="localization.mySql"></cv:cvMessages>
		<cv:cvMessages bundle="localization.sqlserver"></cv:cvMessages>
		<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
</script>
<div>
	<div class="setup-title">
		<h1>
			<cv:msg key="label.AddDatabaseGroup" bundle="mySql" />
		</h1>
	</div>
	<span class="{{pgSubclient.serverMessage1.type}}" data-ng-bind="pgSubclient.serverMessage1.message"></span>
    <form name="addPostgreSQLSubclient" novalidate autocomplete="off" data-cv-submit="pgSubclient.createSubclient()" class="edit-users-grid-form">
        <div class="bootstrap-wrapper">
                <div class="form-group">
                    <label class="col-xs-12 col-sm-6" for="subclientName">
                        <cv:msg key="label.DatabaseGroupName" bundle="mySql" />
                    </label>
                    <div class="col-xs-12 col-sm-6">
                        <input type="text" name="subclientName" data-ng-model="pgSubclient.subclientInfo.subClientEntity.subclientName" data-ng-required="true" autofocus />
                         <span class="help-block" data-ng-show="cv.addPostgreSQLSubclient.needsAttention(addPostgreSQLSubclient.subclientName)">
                            <cv:msg key="error.DatabaseGroupName" bundle="mySql" />
                        </span>
                    </div>
                </div>
                <!-- cv select to toggle plan n plocy list -->
                <div class="form-group padding-bottom-0">
						<cv-entity-plan-policy-select
							data-ng-if="pgSubclient.planPolicyModel"
							data-cv-model="pgSubclient.planPolicyModel"
							data-cv-show-plan="pgSubclient.showPlan"
							data-cv-app-id="pgSubclient.subclientInfo.subClientEntity.applicationId"
							data-cv-client-id="pgSubclient.subclientInfo.subClientEntity.clientId"
							data-cv-wrapper-class="'form-group row padding-bottom-0'"
							no-bootstrap-wrapper-class="true"
							data-cv-label-class="'col-xs-12 col-sm-6'"
							data-cv-select-class="'col-xs-12 col-sm-6'"
							cv-hide-policy-toggle-option="true">
						</cv-entity-plan-policy-select>
				</div>
                <div class="form-group">
                    <label class="col-xs-12 col-sm-6" for="numberBackupStreams">
                        <cv:msg key="label.numberBackupStreams" bundle="oracle"/>
                    </label>
                    <div class="col-xs-12 col-sm-6">
                        <input type="number" id="numberBackupStreams" name="numberBackupStreams" min="1" max="100" data-ng-model="pgSubclient.subclientInfo.numberBackupStreams" required />
                        <span class="help-block" data-ng-show="cv.addPostgreSQLSubclient.needsAttention(addPostgreSQLSubclient.numberBackupStreams)">
                            <cv:msg key="error.numberBackupStreams" bundle="oracle" />
                        </span>
                    </div>
                </div>
                <div class="form-group">
                    <div class="col-xs-12">
                        <input type="checkbox" id="collectObjectList" name="collectObjectList" data-ng-model="pgSubclient.subclientInfo.collectObjectListDuringBackup"/>
                        <label for="collectObjectList">
                            <cv:msg key="label.CollectObjectList" bundle="postgres"/>
                        </label>
                    </div>
                </div>
				<div class="padding-left-10 padding-right-10">
					<cv-grid cv-grid-options="gridOptions"></cv-grid>
				</div>
            </div>
        <div class="modal-footer">
            <button id="postgresCreateSubclient_button_#5772" type="button" class="btn" data-ng-click="pgSubclient.cancel()">
                <cv:msg key="Cancel" bundle="messages"/>
            </button>
            <button id="postgresCreateSubclient_button_#5807" type="submit" class="btn btn-primary cvBusyOnAjax">
                <cv:msg key="Add" bundle="messages"/>
            </button>
        </div>
    </form>
</div>
