<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
	<cv:cvMessages bundle="localization.schedule"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.saphana"></cv:cvMessages>
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
</script>
<div class="bootstrap-wrapper">
	<div class="setup-title">
		<h1><cv:msg key="header.backupOptions" bundle="servers"/></h1>
	</div>
	<span class="{{serverMessage.type}} serverMessage">{{serverMessage.message}}</span>
	<form name="backupForm" data-cv-submit="startBackup()" >
	<div class="panel" >
		<div class="panel-body" data-ng-show="!backupMsg">
			<div class="form-group">
				<label class="col-xs-12" >
					<cv:msg key="label.backupLevel" bundle="servers"/>
				</label>
			</div>
			<div class="form-group margin-left-25">
				<div class="col-xs-12">
					<input type="radio" name="backupFull" id="backupFull" ng-model="backupType" value="FULL" data-ng-change="updateFlags()">
					<label for="backupFull">
						<cv:msg key="option.full" bundle="schedule"/>
					</label>
				</div>
			</div>

			<!--For FS backups-->
			<div data-ng-show="otherOptions.subclientTypeFlag>=1">
				<div class="form-group margin-left-25">
					<div class="col-xs-12">
						<input type="radio" name="incremental" id="incremental" ng-model="backupType" value="INCREMENTAL" data-ng-change="updateFlags()">
						<label for="incremental">
							<cv:msg key="option.incremental" bundle="schedule"/>
						</label>
					</div>
				</div>

				<div class="form-group margin-left-25">
					<div class="col-xs-1 col-lg-1"></div>
					<div class="col-xs-2 col-lg-2">
						<input id="log" type="checkbox" ng-model="log" ng-init="log=true" ng-disabled="log" data-ng-change="updateFlags()">
						<label for="log">
							<cv:msg key="label.LOG" bundle="mySql"/>
						</label>
					</div>
					<!--For block level-->
					<div class="col-xs-2 col-lg-2" data-ng-show="otherOptions.subclientTypeFlag==7">
						<input id="data" type="checkbox" ng-model="incrementalDataWithLogs" ng-disabled="backupType!='INCREMENTAL'" data-ng-change="updateFlags()">
						<label for="data">
							<cv:msg key="label.DATA" bundle="mySql"/>
						</label>
					</div>
				</div>
				<!--For block level-->
				<div class="form-group margin-left-25" data-ng-show="otherOptions.subclientTypeFlag==7">
					<div class="col-xs-12">
						<input type="radio" name="synthetic" id="synthetic" ng-model="backupType" value="SYNTHETIC_FULL" data-ng-change="updateFlags()">
						<label for="synthetic">
							<cv:msg key="option.synthfull" bundle="schedule"/>*
						</label>
					</div>
				</div>
			</div>

			<div class="form-group">
				<div class="col-xs-12"><cv-alert-me selected="false" text="<cv:msg key='label.notifyUserOnJobCompletion' bundle='messages'/>"></cv-alert-me></div>
			</div>
		</div>
	</div>

	<div class="modal-footer">
		<button id="postgresBackupOptionsModal_button_#0319" type="button" class="btn btn-primary cvBusyOnAjax" data-ng-show="backupMsg" data-ng-click="cancel()">
			<cv:msg key="OK" bundle="messages" />
		</button>
		<button id="postgresBackupOptionsModal_button_#5967" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-show="!backupMsg" data-ng-click="cancel()">
			<cv:msg key="Cancel" bundle="messages" />
		</button>
		<button id="postgresBackupOptionsModal_button_#3822" type="submit" class="btn btn-primary cvBusyOnAjax" data-ng-class="{'busy':loading}" data-ng-show="!backupMsg" >
			<cv:msg key="OK" bundle="messages" />
		</button>
	</div>
	</form>
</div>