<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
		<cv:cvMessages bundle="localization.job"></cv:cvMessages>
		<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
		<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
		<cv:cvMessages bundle="localization.oracle"></cv:cvMessages>
</script>
<script type="text/ng-template"  id="browseTree_item_renderer.html">
	<div data-ng-class="{selected: isNodeSelected(item)}">
		<button id="oracleCreateSubclient_button_#2588"  data-ng-class="item.state | lowercase" data-ng-click="folderDrilledDown(item,$event)"></button>
 		<span data-ng-click="folderSelected(item)">{{item.label}}</span>
	</div>
    <div class="children" data-ng-class="item.state">
         <div class="browse-item" data-ng-repeat="item in item.children" data-ng-include="'browseTree_item_renderer.html'"></div>
 			<!--<a data-ng-class="{hidePlease :!item.partiallyLoaded}" data-ng-click="loadMore(item)">More</a>-->
    </div>
</script>
<div class="bootstrap-wrapper" >
	<div class="setup-title">
		<h1><cv:msg key="action.subclientCreation" bundle="clients" /></h1>
	</div>
	<span class="{{serverMessage.type}}" data-ng-bind="serverMessage.message"></span>
	<form name="createSubclientForm" class="form-horizontal" novalidate autocomplete="off" data-cv-submit="createSubclient()" >
		<div class="panel">
			<div class="panel-body">
				<div class="form-group">
					<label for="subclientName" class="col-xs-12 col-sm-5" >
						<cv:msg key="label.SubclientName" bundle="clients" />
					</label>
					<div class="col-xs-12 col-sm-7">
						<input type="text" name="subclientName" id="subclientName"
								data-ng-model="entity.subclientName" required autofocus />
						<span class="help-block" data-ng-show="cv.createSubclientForm.needsAttention(createSubclientForm.subclientName)">
							<cv:msg key="error.subclientName" bundle="clients" />
						</span>
					</div>
				</div>
				<div class="form-group">
					<div class="col-xs-12">
						<cv-entity-plan-policy-select data-ng-if="planPolicyModel" data-cv-model="planPolicyModel"
								data-cv-show-plan="showPlan" data-cv-app-id="entity.applicationId" data-cv-client-id="entity.clientId" data-cv-wrapper-class="'form-group row'"
								no-bootstrap-wrapper-class="true"
								data-cv-label-class="'col-xs-12 col-sm-5'" data-cv-select-class="'col-xs-12 col-sm-7'"
								cv-hide-policy-toggle-option="true">
						</cv-entity-plan-policy-select>
					</div>
				</div>
				<div class="form-group"  data-ng-if="!isOracleRac">
					<label for="numberBackupStreams" class="col-xs-12 col-sm-5" >
						<cv:msg key="label.numberBackupStreams" bundle="oracle" />
					</label>
					<div class="col-xs-12 col-sm-7 text-overflow-allowed">
						<input data-ng-class="{'has-error': cv.createSubclientForm.needsAttention(createSubclientForm.numberBackupStreams)}" id="numberBackupStreams" name="numberBackupStreams"
								 required type="number" data-ng-model="subclientInfo.numberBackupStreams" min="1" max="100" data-ng-maxlength="3" />
						<span class="help-block" data-ng-show="cv.createSubclientForm.needsAttention(createSubclientForm.numberBackupStreams)">
							<cv:msg key="error.numberBackupStreams" bundle="oracle" />
						</span>
					</div>
				</div>

				<div class="form-group">
					<div class="col-xs-12">
						<input type="checkbox" id="selectiveOnlineFull" name="selectiveOnlineFull" data-ng-model="subclientInfo.selectiveOnlineFull" data-ng-change="selectiveOnlineFullChanged()" />
						<label for="selectiveOnlineFull" >
							<cv:msg key="label.selectiveOnlineFull" bundle="oracle" />
						</label>
					</div>
				</div>
				<div class="form-group" >
					<div class="col-xs-12">
						<input type="checkbox" id="dataBackup" name="dataBackup" data-ng-model="subclientInfo.dataBackup" data-ng-change="offlineDataSelected()"  data-ng-disabled="subclientInfo.selectiveOnlineFull"/>
						<label for="dataBackup" >
							<cv:msg key="label.dataBackup" bundle="oracle" />
						</label>
					</div>
				</div>
				<div class="form-group" data-ng-disabled="(!subclientInfo.dataBackup || subclientInfo.selectiveOnlineFull)" >
					<div class="col-xs-12 col-sm-1">
					</div>
					<div class="col-xs-12 col-sm-3">
						<input type="radio" id="onlineData" value="0" data-ng-model="subclientInfo.backupMode" data-ng-change="offlineDataSelected()"/>
						<label for="onlineData" >
							<cv:msg key="label.onlineData" bundle="oracle" />
						</label>
					</div>
					<div class="col-xs-12 col-sm-3">
							<input type="radio" id="onlineSubset" value="1" data-ng-model="subclientInfo.backupMode" data-ng-change="onlineSubsetSelected()"/>
						<label for="onlineSubset">
							<cv:msg key="label.onlineSubset" bundle="oracle" />
						</label>
					</div>
					<div class="col-xs-12 col-sm-3">
						<input type="radio" id="offlineData" value="2" data-ng-model="subclientInfo.backupMode" data-ng-change="offlineDataSelected()" />
						<label for="offlineData"  >
							<cv:msg key="label.offlineData" bundle="oracle" />
						</label>
					</div>
				</div>
				<div class="form-group" data-ng-show="(subclientInfo.dataBackup && subclientInfo.backupMode == 1)" >
					<div class="col-xs-12 col-sm-1">
					</div>
					<div class="col-xs-12 col-sm-11 margin-top-10">
						<div  class="browse-tree" data-ng-class="item.state">
							 <div class="browse-item">
								<div data-ng-class="{selected: isNodeSelected(tree)}" >
									<button id="oracleCreateSubclient_button_#0326" data-ng-class="tree.state | lowercase" data-ng-click="folderDrilledDown(tree,$event)"></button>
									<span class="padding-right-50" data-ng-click="folderSelected(tree)">{{tree.label}}</span>
									<a title="<cv:msg key="label.refreshTableSpace" bundle="oracle" />" data-ng-click="loadChildren(tree,true)" >
										<i class="k-icon k-i-refresh"></i>
									</a>
								</div>
								<div class="children" data-ng-class="tree.state">
									<div data-ng-repeat="item in tree.children" class="browse-item" data-ng-include="'browseTree_item_renderer.html'"></div>
								</div>
							</div>
						</div>
					</div>
				</div>
				<div class="form-group" data-ng-show="(subclientInfo.dataBackup && subclientInfo.backupMode != 2) || !subclientInfo.dataBackup">
					<div class="col-xs-12">
						<input type="checkbox" id="logBackup" name="logBackup" data-ng-model="subclientInfo.logBackup" data-ng-disabled="subclientInfo.selectiveOnlineFull"/>
						<label for="logBackup" >
							<cv:msg key="label.logBackup" bundle="oracle" />
						</label>
					</div>
				</div>
				<div class="form-group" data-ng-show="(subclientInfo.dataBackup && subclientInfo.backupMode != 2) || !subclientInfo.dataBackup" data-ng-disabled="(!subclientInfo.logBackup || subclientInfo.selectiveOnlineFull)" >
					<div class="col-xs-12 col-sm-1">
					</div>
					<div class="col-xs-12 col-sm-11">
						<input  type="checkbox" id="deleteArchiveLogs" name="deleteArchiveLogs" data-ng-model="subclientInfo.archiveDelete" />
						<label for="deleteArchiveLogs" >
							<cv:msg key="label.deleteArchiveLogs" bundle="oracle" />
						</label>
					</div>
				</div>
				<div class="form-group" data-ng-hide="subclientInfo.enableLightScript">
					<div class="col-xs-12 margin-top-15">
						<label for="lightScript" >
							<cv:msg key="label.lightsOutScript" bundle="oracle" />
						</label>
					</div>
				</div>


				<div class="row"  data-ng-if="isOracleRac">
					<!-- not shown during creation -->
					<div class="col-xs-12" data-ng-show="false">

						<uib-accordion  close-others="true" class="text-left" data-ng-init="accordionOpen = false">
						<div uib-accordion-group data-is-open="accordionOpen">
							<uib-accordion-heading>
							<cv:msg key="label.noOfStreams" bundle="job" />
							<i class="float-right glyphicon" data-ng-class="{'glyphicon-chevron-down': accordionOpen, 'glyphicon-chevron-right': !accordionOpen}"></i>
							</uib-accordion-heading>
					    	<cv-rac-manage-streams hide-title="true" entity="entity" get-streams-func="getStreamsFunc">
					    	</cv-rac-manage-streams>
					    </div>
					    </uib-accordion>
					</div>
				</div>
			</div>
		</div>
		<div class="modal-footer" >
			<button id="oracleCreateSubclient_button_#7662" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="cancel()"><cv:msg key="Cancel" bundle="messages" /></button>
			<button id="oracleCreateSubclient_button_#3047" type="submit" class="btn btn-primary cvBusyOnAjax" ><cv:msg key="Save" bundle="messages" /></button>
		</div>
	</form>
</div>
