<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
		<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
		<cv:cvMessages bundle="localization.oracle"></cv:cvMessages>
</script>

<div class="bootstrap-wrapper">
	<div class="setup-title">
		<h1>
			<span data-ng-hide="oLogicalDumpCtrl.editing"> <cv:msg key="action.subclientCreation" bundle="clients" /> </span>
			<span data-ng-show="oLogicalDumpCtrl.editing"> <cv:msg key="label.EditContent" bundle="fs"/></span>
		</h1>
	</div>
	<span class="{{oLogicalDumpCtrl.serverMessage.type}} serverMessage">{{oLogicalDumpCtrl.serverMessage.message}}</span>
	<form name="createSubclientForm" novalidate autocomplete="off" data-cv-submit="oLogicalDumpCtrl.createSubclient()" >
		<div class="panel" >
			<div class="panel-body" >
				<div class="form-group" data-ng-if="!oLogicalDumpCtrl.editing">
					<label class="col-xs-12 col-lg-6">
						<cv:msg key="label.SubclientName" bundle="clients" />
					</label>
					<div class="col-xs-12 col-lg-6" >
						<input type="text" name="subclientName" id="subclientName" data-ng-model="oLogicalDumpCtrl.entity.subclientName" required autofocus />
						<span class="help-block" data-ng-show="cv.createSubclientForm.needsAttention(createSubclientForm.subclientName)">
							<cv:msg key="error.subclientName" bundle="clients" />
						</span>
					</div>
				</div>
				<div class="form-group" data-ng-if="!oLogicalDumpCtrl.editing">
					<div class="col-xs-12 col-lg-12">
						<cv-entity-plan-policy-select
								data-ng-if="oLogicalDumpCtrl.planPolicyModel"
								data-cv-model="oLogicalDumpCtrl.planPolicyModel"
								data-cv-show-plan="oLogicalDumpCtrl.showPlan"
								data-cv-app-id="oLogicalDumpCtrl.entity.applicationId"
								data-cv-client-id="oLogicalDumpCtrl.entity.clientId"
								data-cv-wrapper-class="'form-group row'"
								data-cv-label-class="'col-xs-12 col-sm-6 col-lg-6 col-md-6'"
								data-cv-select-class="'col-xs-12 col-sm-6 col-lg-6 col-md-6'"
								cv-hide-policy-toggle-option="true">
						</cv-entity-plan-policy-select>
					</div>
				</div>
				<div class="form-group" data-ng-if="!oLogicalDumpCtrl.editing">
					<label class="col-xs-12 col-lg-6">
						<cv:msg key="label.numberBackupStreams" bundle="oracle" />
					</label>
					<div class="col-xs-12 col-lg-6">
						<input data-ng-class="{'has-error': cv.createSubclientForm.needsAttention(createSubclientForm.numberBackupStreams)}" id="numberBackupStreams" name="numberBackupStreams"
								 required type="number" data-ng-model="oLogicalDumpCtrl.subclientInfo.numberBackupStreams" min="1" max="100" data-ng-maxlength="3" />
						<span class="help-block" data-ng-show="cv.createSubclientForm.needsAttention(createSubclientForm.numberBackupStreams)">
							<cv:msg key="error.numberBackupStreams" bundle="oracle" />
						</span>
					</div>
				</div>
				<div class="form-group" data-ng-if="false">
					<label class="col-xs-12 col-lg-6">
						<cv:msg key="label.database" bundle="oracle" />
					</label>
					<div class="col-xs-12 col-lg-6" >
						<cv-isteven-single-select id-name="schemaDatabase"
							binding-model="oLogicalDumpCtrl.selectedSchemaDatabase"
							input-model="oLogicalDumpCtrl.schemaDatabaseOptions"
							track-field="schema"
							label="schema"
							tick-property="selected"
							on-change="oLogicalDumpCtrl.updateDatabase()"
							place-holder='<fmt:message key="help.schema" />' >
						</cv-isteven-single-select>
					</div>
				</div>
				<div class="form-group" >
					<div class="col-xs-12 col-lg-6 margin-top-15">
						<label for="exportMode">
							<cv:msg key="label.exprotMode" bundle="oracle" />
						</label>
					</div>
					<div class="col-xs-6 col-lg-3 margin-top-15">
						<input type="radio" name="fullDB" id="fullDB" value="0" data-ng-change="oLogicalDumpCtrl.updateExportMode()"  data-ng-model="oLogicalDumpCtrl.subclientInfo.exportMode" />
						<label for="fullDB">
							<cv:msg key="label.fullDatabase" bundle="oracle" />
						</label>
					</div>
					<div class="col-xs-6 col-lg-3 margin-top-15">
						<input  type="radio" id="schemaMode" name="schemaMode" value="1" data-ng-change="oLogicalDumpCtrl.updateExportMode()" data-ng-model="oLogicalDumpCtrl.subclientInfo.exportMode" />
						<label for="offlineData">
							<cv:msg key="label.schema" bundle="oracle" />
						</label>
					</div>
				</div>
			</div>
			<div class="form-group" data-ng-if=" oLogicalDumpCtrl.subclientInfo.exportMode === '1' ">
				<div class="col-xs-12 col-lg-12 browse-tree select-vms">
					<div class="browse-item" data-ng-if="!oLogicalDumpCtrl.schemaOptions">
						<p><cv:msg key="label.noResultsFound" bundle="messagesJs"/></p>
					</div>
					<div class="padding-bottom-20">
						<label class="margin-left-15"> <cv:msg key="label.schemaSelection" bundle="oracle" /> </label>
						<a class="group select-clear-all " data-ng-click="oLogicalDumpCtrl.updateSelection(false)"> <cv:msg key="label.clearAll" bundle="collections"/></a>
						<a class="group select-clear-all " data-ng-click="oLogicalDumpCtrl.updateSelection(true)"><cv:msg key="label.selectAll" bundle="collections"/></a>
					</div>
					<span class="help-block margin-left-15" data-ng-show="oLogicalDumpCtrl.errors.schema">
						<cv:msg key="error.schemaSelection" bundle="oracle" />
					</span>
					<div data-ng-if="oLogicalDumpCtrl.schemaOptions" data-ng-repeat="schema in oLogicalDumpCtrl.schemaOptions" class="browse-item margin-left-0" >
						<div class="{{schema.selectedState}}">
							<span data-ng-click="oLogicalDumpCtrl.toggleSelectedState(schema)" title="{{schema.schema}}">{{schema.schema}}</span>
						</div>
					</div>
				</div>
			</div>
			<div class="panel-body form-group padding-top-0" data-ng-if="!oLogicalDumpCtrl.editing">
				<label class="col-xs-12 col-lg-6">
					<cv:msg key="label.stagingPath" bundle="oracle" />
				</label>
				<div class="col-xs-12 col-lg-6" >
					<input type="text" name="stagingPath" id="stagingPath" data-ng-model="oLogicalDumpCtrl.subclientInfo.dumpDir" required autofocus />
					<span class="help-block" data-ng-show="cv.createSubclientForm.needsAttention(createSubclientForm.stagingPath)">
						<cv:msg key="error.stagingPath" bundle="oracle" />
					</span>
				</div>
			</div>
		</div>
		<div class="modal-footer" >
			<button id="oLogicalDumpCtrl_button_#4626" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="oLogicalDumpCtrl.closeModal()">
				<cv:msg key="Cancel" bundle="messages" />
			</button>
			<button id="oLogicalDumpCtrl_button_#5209" type="submit" class="btn btn-primary cvBusyOnAjax" >
				<span data-ng-hide="oLogicalDumpCtrl.editing">
					<cv:msg key="Add" bundle="messages" />
				</span>
				<span data-ng-show="oLogicalDumpCtrl.editing">
					<cv:msg key="Save" bundle="messages" />
				</span>
			</button>
		</div>
	</form>
</div>