<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.collections"></cv:cvMessages>
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.sqlserver"></cv:cvMessages>
	<cv:cvMessages bundle="localization.oracle"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
</script>
<div class="bootstrap-wrapper" >
	<div class="modal-header">
		<h1 data-ng-hide="editDialog"><cv:msg key="pageHeader.createServer" bundle="oracle"/> </h1>
		<h1 data-ng-show="editDialog"><cv:msg key="pageHeader.editServer" bundle="oracle"/> </h1>
	</div>
	<form name="Oracleinstance" class="form-horizontal" novalidate data-cv-submit="createInstance()" autocomplete="off" class="add-collection-form">
		<span class="{{serverMessage.type}}" data-ng-bind="serverMessage.message"></span>
		<div>
		<div class="panel">
			<div class="panel-body">
				<div class="form-group" data-ng-if="addInstance">
					<label class="col-xs-12 col-lg-5" for="hostName">
						<cv:msg key="label.clientName" bundle="clients"/>
					</label>
					<div class="col-xs-12 col-lg-7 text-overflow-allowed" data-ng-disabled="editDialog">
						<cv-client-picker select-none-by-default="true" selected-clients="clientSelection.selectedClients" valide-client-selection="clientSelection.valideClientSelection" selection-changed="clientSelection.selectionChanged(clientEntity)" app-id="22"  ></cv-client-picker>
						<span class="help-block" data-ng-show="cv.Oracleinstance.getAttempted() && !clientSelection.valideClientSelection" >							
							<cv:msg key="option.clientName" bundle="clients"/>
						</span> 
					</div>
				</div>
				<div class="form-group">
					<label class="col-xs-12 col-lg-5" for="hostName">
						<cv:msg key="label.oracleSid" bundle="oracle"/>
					</label>
					<div class="col-xs-12 col-lg-7">
						<input type="text" id="instanceName" name="instanceName"  
							data-ng-model="instanceEntity.instanceName" required/>
						<span class="help-block" data-ng-show="cv.Oracleinstance.needsAttention(Oracleinstance.instanceName);" >
							<cv:msg key="error.oracleSid" bundle="oracle"/>
						</span> 
					</div>
				</div>
				<div data-ng-if="!clientDetailsLoaded">
					<cv-reports-show-loader show-loader="true"/>
				</div>
				<span data-ng-if="isDbThinClient && clientDetailsLoaded">
					<div class="form-group">
						<label class="col-xs-12 col-lg-5" for="storagePolicy">
							<cv:msg key="header.storagePolicy" bundle="clients"/>
						</label>
						<div class="col-xs-12 col-lg-7">
							<!--  <select id="storagePolicy" name="storagePolicy"
								data-ng-model="dataModel.storagePolicyId" required
								data-ng-options="sp.storagePolicyId as sp.storagePolicyName for sp in libraries">
							<option value=""><cv:msg key="label.selectStoragePolicy" bundle="clients" /></option>
							</select> -->
							<cv-isteven-single-select id-name="storagePolicy"
								input-model="libraries"
								binding-model="dataModel.storagePolicyId"
								binding-field="storagePolicyId"
								track-field="storagePolicyId"
								label="storagePolicyName"
								tick-property="selected"
								place-holder='<cv:msg key="label.selectStoragePolicy" bundle="clients" />'
								help-text='<cv:msg key="error.selectStoragePolicy" bundle="clients" />'
								required = "true">
							</cv-isteven-single-select> 
						</div>
					</div>
					<div class="form-group">
						<label class="col-xs-12 col-lg-5" for="physicalClients">
							<cv:msg key="label.proxies" bundle="sqlserver"/>
						</label>
						<div class="col-xs-12 col-lg-7">
							<isteven-multi-select
				   				  input-model="physicalClients"
				   				  output-model="selectedClients"
				  				  button-label="clientName"
				  				  item-label="clientName"
				   				  tick-property="ticked"
				   				  class="isteven-multi-select user-group-select"
				   				  id="physicalClients"
				   				  name="physicalClients"
				   				  helper-elements="all none reset filter"
				   				  max-labels="1"
				   				  translation="locForProxies"
				   				  on-item-click="validateClientSelection()"
				   				  on-select-none="validateClientSelection()"
				   				  on-select-all="validateClientSelection()"
				   				  on-reset="validateClientSelection()"
				   				  ng-cloak>
							</isteven-multi-select>  
							<span class="help-block" data-ng-show="showAddServerErrorMessage"><cv:msg key="placeholder.dbPhysicalClients" bundle="dbs"/></span>
						</div>
					</div>
				</span>
				<span data-ng-if="!isDbThinClient && clientDetailsLoaded">
						<div class="form-group" >
						
							<label class="col-xs-12 col-lg-5" for="plan">
								<cv:msg key="label.profile" bundle="profiles"/>
							</label>
						
							<div class="col-xs-12 col-lg-7" data-ng-init="initAfterLocalization()">
								<isteven-multi-select id="oracleCreateInstance_isteven-multi-select_#9446"  
									input-model="profileList"
									output-model="oraCI.selectedProfileList"
									button-label="name" 
									item-label="name" 
									translation="localLang"
									tick-property="selected"
									class="isteven-multi-select user-group-select" 
									selection-mode="single"
									helper-elements="filter"
									on-close="parseIStevenOutput()"
									group-property="msGroup">
								</isteven-multi-select>
								<span class="help-block" data-ng-show="cv.Oracleinstance.getAttempted() && showPlanError"><cv:msg key="error.selectPlan" bundle="profiles"/></span>
							</div>
						</div>
				<div class="form-group">
					<label class="col-xs-12 col-lg-5" for="oracleHome">
						<cv:msg key="label.oracleHome" bundle="oracle"/>
					</label>
					<div  class="col-xs-12 col-lg-7">
						<div class="input-group">
							<input type="text" id="oracleHome" name="oracleHome" data-ng-required="true" data-ng-model="instInfo.oracleHome"/>
							<span class="input-group-btn">
								<cv-machine-browse button-label='<cv:msg key="label.browse" bundle="restore"/>' 
									client-id='{{instanceEntity.clientId}}' result-function="oraHomeResuleFunction"/>
							</span>
						</div>
						<span class="help-block" data-ng-show="cv.Oracleinstance.needsAttention(Oracleinstance.oracleHome);" >
							<cv:msg key="error.oracleHome" bundle="oracle"/>
						</span> 
					</div>
				</div>
				
				<div class="form-group">
					<label class="col-xs-12 col-lg-12" >
						<cv:msg key="label.ConnectionString" bundle="oracle" />
					</label>
				</div>
				<div class="form-group connection-string">
					<input id="dbUserName" name="dbUserName" type="text" placeholder='<cv:msg key="label.userName" bundle="users"/>' data-ng-model="instInfo.sqlConnect.userName" data-ng-change="validateConnectString()">
					<label for="dbPassword" > / </label>
					<input id="dbPassword" name="dbPassword" type="password" placeholder='<cv:msg key="label.password" bundle="users"/>' data-ng-model="instInfo.password" data-ng-change="validateConnectString()">
					<label for="dbPassword"> @ </label>
					<input id="dbInstanceName" name="dbInstanceName" type="text" placeholder='<cv:msg key="label.serviceName" bundle="oracle"/>' data-ng-model="instInfo.sqlConnect.domainName" data-ng-change="validateConnectString()">
					<span class="help-block ng-hide" data-ng-show="cv.Oracleinstance.getAttempted() &&  !isConnectValidate">
						<cv:msg key="error.connectString" bundle="oracle"/>
					</span> 
				</div>
				<%-- <div class="form-group">
					<div class="col-xs-12 col-lg-12">
						<input id="useCatalog" name="useCatalog" type="checkbox" data-ng-model="instInfo.useCatalog" >
						<label  for="useCatalog">
							<cv:msg key="label.useCatalog" bundle="oracle" />
						</label>
					</div>
				</div> --%>
				<div class="form-group" >
					<div class="col-xs-12">
						<toggle-control status="useCatalogStatus" data-ng-click="toggleUseCatalog()"></toggle-control>
						<!-- <input type="checkbox" name="showSelected" id="showSelected" data-ng-model="editSECtrl.enableSnapshot" /> -->
						<label><cv:msg key='label.useCatalog' bundle='oracle'/></label>
					</div>
				</div>
				
				<div class="form-group connection-string" data-ng-show="instInfo.useCatalog">
					<input class="userName" id="catalogUserName" name="catalogUserName" type="text" placeholder='<cv:msg key="label.userName" bundle="users"/>' 
					data-ng-model="instInfo.catalogConnect.userName" data-ng-change="validateCatalogString()">
					<label for="catalogPassword" > 
						/ 
					</label>
					<input class="password" id="catalogPassword" name="catalogPassword" type="password" placeholder='<cv:msg key="label.password" bundle="users"/>' 
					data-ng-model="instInfo.catalogConnect.cvPassword" data-ng-change="validateCatalogString()">
					<label for="catalogPassword">
						 @
					 </label>
					<input class="instance" id="catalogInstanceName" name="catalogInstanceName" type="text" placeholder='<cv:msg key="label.serviceName" bundle="oracle"/>' 
					data-ng-model="instInfo.catalogConnect.domainName" data-ng-change="validateCatalogString()">
					<span class="help-block ng-hide" data-ng-show="cv.Oracleinstance.getAttempted() && !isCatalogValidate">
						<cv:msg key="error.catalogConnect" bundle="oracle"/>
					</span> 
				</div>
				
		
				</span>
			</div>
		</div>
		<uib-accordion  data-ng-if="!isDbThinClient && clientDetailsLoaded && editDialog" close-others="true" class="text-left" data-ng-init="accordionOpen = (instInfo.osUserName || instInfo.osUserPassword || instInfo.TNSAdminPath)">
				<div uib-accordion-group data-is-open="accordionOpen">
					<uib-accordion-heading>
					<cv:msg key="label.advanced" bundle="clients"/>
					<i class="float-right glyphicon" data-ng-class="{'glyphicon-chevron-down': accordionOpen, 'glyphicon-chevron-right': !accordionOpen}"></i>
					</uib-accordion-heading>
					<div class="form-group">
						<label class="col-xs-12 col-lg-5" for="osUserName">
							<cv:msg key="label.osUserName" bundle="oracle"/>
						</label>
						<div class="col-xs-12 col-lg-7">
							<input type="text" id="osUserName" name="osUserName" 
							data-ng-model="instInfo.osUserName"  placeholder="<cv:msg key="label.optional" bundle="oracle"/>"/>
							<span class="help-block" data-ng-show="cv.Oracleinstance.needsAttention(Oracleinstance.osUserName);" >
								<cv:msg key="error.osUserName" bundle="oracle"/>
							</span>
						</div>
					</div>
					<div class="form-group" data-ng-if="!isUnixClient">
						<label class="col-xs-12 col-lg-5" for="osUserPassword">
							<cv:msg key="label.osPassword" bundle="oracle"/>
						</label>
						<div class="col-xs-12 col-lg-7">
							<input type="password" id="osUserPassword" name="osUserPassword" 
							data-ng-model="instInfo.osUserPassword" placeholder="<cv:msg key="label.optional" bundle="oracle"/>"/>
							<span class="help-block" data-ng-show="cv.Oracleinstance.needsAttention(Oracleinstance.osUserPassword);" >
								<cv:msg key="error.osUserPassword" bundle="oracle"/>
							</span> 
						</div>
					</div>
					
					<div class="form-group">
						<label class="col-xs-12 col-lg-5" for="tnsAdminFolder">
							<cv:msg key="label.tnsAdminFolder" bundle="oracle"/>
							
						</label>
						<div  class="col-xs-12 col-lg-7">
							<div class="input-group">
								<input type="text" id="tnsAdminFolder" name="tnsAdminFolder" data-ng-model="instInfo.TNSAdminPath" placeholder="<cv:msg key="label.optional" bundle="oracle"/>"/>
								<span class="input-group-btn">
									<cv-machine-browse button-label='<cv:msg key="label.browse" bundle="restore"/>' 
										client-id='{{instanceEntity.clientId}}' result-function="tnsAdminFolderResultFunction"/>
								</span>
							</div>
							<span class="help-block" data-ng-show="cv.Oracleinstance.needsAttention(Oracleinstance.tnsAdminFolder);" >
								<cv:msg key="error.tnsAdminFolder" bundle="oracle"/>
							</span> 
						</div>
					</div>
			    </div>
			</uib-accordion>
		</div>
		<div class="modal-footer">
	  		<button id="oracleCreateInstance_button_#7931" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="closeDialogBox()"> 
	  			<cv:msg key="Cancel" bundle="messages"/>
  			</button>
	  		<button id="oracleCreateInstance_button_#6629" type="submit" class="btn btn-primary cvBusyOnAjax" >  
	  			<span data-ng-hide="editDialog" > <cv:msg key="Add" bundle="messages"/> </span>
	  			<span data-ng-show="editDialog" > <cv:msg key="Save" bundle="messages"/> </span>
	  		</button>
		</div>
	</form>
</div>
				
				