<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
	<cv:cvMessages bundle="localization.schedule"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1><cv:msg key="header.backupOptions" bundle="servers"/></h1>
</div>
<div class="bootstrap-wrapper">
	<form name="backupForm" data-cv-submit="startBackup()" >
	<span class="{{serverMessage.type}} serverMessage">{{serverMessage.message}}</span>
	<div class="panel" data-ng-show="!backupMsg">
		<div class="panel-body">
			<div class="form-group">
				<label class="col-xs-12"><cv:msg key="label.backupLevel" bundle="servers"/></label>
			</div>

			<div class="form-group">
				<div class="col-xs-offset-1 col-xs-11">
					<input name="backupType" id="fullBackup" type="radio" data-ng-model="model.backupType" value="FULL">
					<label for="fullBackup">
						<cv:msg key="option.full" bundle="schedule"/>
					</label>
				</div>
			</div>

			<div class="form-group" data-ng-if="showIncremental">
				<div class="col-xs-offset-1 col-xs-11">
					<input name="backupType" id="incrementalBackup" type="radio" data-ng-model="model.backupType" value="INCREMENTAL">
					<label for="incrementalBackup">
						<cv:msg key="option.incremental" bundle="schedule"/>
					</label>
				</div>
			</div>

			<div class="form-group" data-ng-if="showCumulative">
				<div class="col-xs-offset-2 col-xs-10" data-ng-disabled="(model.backupType !== 'INCREMENTAL')">
					<input  type="checkbox" id="cumulative" name="cumulative" data-ng-model="model.cumulative" />
					<label for="cumulative"><cv:msg key="label.cumulative" bundle="oracle" /></label>
				</div>
			</div>
			<div class="col-xs-12">
			<cv-alert-me selected="false" text="<cv:msg key='label.notifyUserOnJobCompletion' bundle='messages'/>"></cv-alert-me>
		</div>
		</div>

	</div>

	<div class="modal-footer">
		<button id="oracleBackupOptions_button_#3721" type="button" class="btn btn-primary cvBusyOnAjax" data-ng-show="backupMsg" data-ng-click="cancel()"><cv:msg key="OK" bundle="messages"/></button>
		<button id="oracleBackupOptions_button_#2414" type="button" class="btn" data-ng-show="!backupMsg" data-ng-click="cancel()"><cv:msg key="Cancel" bundle="messages"/></button>
		<button data-ng-show="showPreview" id="oracleBackupOptions_button_CustomScript" type="button" class="btn" data-ng-click="viewScriptPreview()"><cv:msg key="label.preview" bundle="oracle"/></button>
		<button id="oracleBackupOptions_button_#2611" type="submit" class="btn btn-primary cvBusyOnAjax"  data-ng-class="{'busy':loading}" data-ng-show="!backupMsg" ><cv:msg key="OK" bundle="messages"/></button>
	</div>
	</form>
</div>