<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
		<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
		<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
		<cv:cvMessages bundle="localization.postgres"></cv:cvMessages>
		<cv:cvMessages bundle="localization.collections"></cv:cvMessages>
		<cv:cvMessages bundle="localization.sqlserver"></cv:cvMessages>
		<cv:cvMessages bundle="localization.mySql"></cv:cvMessages>
		<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
</script>
<div>
	<div class="setup-title">
		<h1>
			<cv:msg key="label.AddDatabaseGroup" bundle="mySql" />
		</h1>
	</div>
	<span class="{{mySqlSubclient.serverMessage1.type}}"
		data-ng-bind="mySqlSubclient.serverMessage1.message"></span>
	<form name="addMySQLSubclient" novalidate autocomplete="off"
		data-cv-submit="mySqlSubclient.createSubclient()"
		class="edit-users-grid-form">
		<div class="bootstrap-wrapper">
				<div class="form-group">
					<label class="col-xs-12 col-sm-6" for="subclientName"> <cv:msg
							key="label.DatabaseGroupName" bundle="mySql" />
					</label>
					<div class="col-xs-12 col-sm-6">
						<input type="text" name="subclientName"
							data-ng-model="mySqlSubclient.subclientInfo.subClientEntity.subclientName"
							required autofocus />
						<span class="help-block" data-ng-show="cv.addMySQLSubclient.needsAttention(addMySQLSubclient.subclientName)">
							<cv:msg key="error.DatabaseGroupName" bundle="mySql" />
						</span>
					</div>
				</div>
				<div class="form-group padding-bottom-0">
						<cv-entity-plan-policy-select
							data-ng-if="mySqlSubclient.planPolicyModel"
							data-cv-model="mySqlSubclient.planPolicyModel"
							data-cv-show-plan="mySqlSubclient.showPlan"
							data-cv-app-id="mySqlSubclient.subclientInfo.subClientEntity.applicationId"
							data-cv-client-id="mySqlSubclient.subclientInfo.subClientEntity.clientId"
							data-cv-wrapper-class="'form-group row padding-bottom-0'"
							no-bootstrap-wrapper-class="true"
							data-cv-label-class="'col-xs-12 col-sm-6'"
							data-cv-select-class="'col-xs-12 col-sm-6'"
							cv-hide-policy-toggle-option="true">
						</cv-entity-plan-policy-select>
				</div>
				<div class="form-group">
                    <label class="col-xs-12 col-sm-6" for="numberBackupStreams">
                        <cv:msg key="label.numberBackupStreams" bundle="oracle"/>
                    </label>
                    <div class="col-xs-12 col-sm-6">
                        <input type="number" id="numberBackupStreams" name="numberBackupStreams" min="1" max="100" data-ng-model="mySqlSubclient.subclientInfo.numberOfBackupStreams" required/>
                        <span class="help-block" data-ng-show="cv.addMySQLSubclient.needsAttention(addMySQLSubclient.numberBackupStreams)">
                           <cv:msg key="error.numberBackupStreams" bundle="oracle" />
                        </span>
                    </div>
                </div>

				<div class="form-group padding-left-10 padding-right-10">
					<cv-grid cv-grid-options="gridOptions"></cv-grid>
				</div>
			<!-- Standby options -->
			<div data-ng-show="mySqlSubclient.isStandbyApplicable">
				<uib-accordion close-others="true" class="text-left">
				<div uib-accordion-group data-is-open="accordion2.open">
					<uib-accordion-heading> <cv:msg key="heading.ProxySettings" bundle="mySql" />
					<i class="float-right glyphicon"
						data-ng-class="{'glyphicon-chevron-down': accordion2.open, 'glyphicon-chevron-right': !accordion2.open}"></i>
					</uib-accordion-heading>
					<div class="form-group">
						<div class="col-xs-12">
							<input id="isProxyEnabled" class="" type="checkbox" data-ng-model="mySqlSubclient.subclientInfo.proxySettings.isProxyEnabled"/>
							<label for="isProxyEnabled"><cv:msg key="label.EnableStandbyBackup" bundle="postgres" /></label>
						</div>
					</div>
					<div class="form-group">
						<label class="col-xs-12 col-sm-6" for="standbyInstance" data-ng-disabled="!mySqlSubclient.subclientInfo.proxySettings.isProxyEnabled">
							<cv:msg key="label.ProxyInstance" bundle="mySql" />
						</label>
						<label class="col-xs-12 col-sm-6" for="standbyInstance" data-ng-disabled="!mySqlSubclient.subclientInfo.proxySettings.isProxyEnabled">
							{{mySqlSubclient.standByInstanceDispalyValue}}
						</label>
					</div>
					<div class="form-group">
						<div class="col-xs-12">
							<input id="runLogBackupsOnSource" class="" type="checkbox" data-ng-model="mySqlSubclient.subclientInfo.proxySettings.isFailOverToProduction"
							data-ng-disabled="!mySqlSubclient.subclientInfo.proxySettings.isProxyEnabled"/>
							<label for="runLogBackupsOnSource"><cv:msg key="label.UseSource" bundle="mySql" /></label>
						</div>
					</div>
				</div>
				</uib-accordion>
			</div>
		</div>
		<div class="modal-footer">
			<button id="mySqlCreateSubclient_button_#1117" type="button" class="btn"
				data-ng-click="mySqlSubclient.cancel()">
				<cv:msg key="Cancel" bundle="messages" />
			</button>
			<button id="mySqlCreateSubclient_button_#7734" type="submit" class="btn btn-primary cvBusyOnAjax">
				<cv:msg key="Add" bundle="messages" />
			</button>
		</div>
	</form>
</div>
