<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
	<cv:cvMessages bundle="localization.schedule"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
</script>
<div class="bootstrap-wrapper">
	<div class="setup-title">
		<h1><cv:msg key="header.backupOptions" bundle="servers"/></h1>
	</div>
	<span class="{{backupController.serverMessage.type}} serverMessage">{{backupController.serverMessage.message}}</span>
	<form name="backupForm" data-cv-submit="backupController.startBackup()" >
	<div class="panel" >
		<div class="panel-body" data-ng-show="!backupController.backupMsg">
			<div class="form-group">
				<label class="col-xs-12 col-lg-12" >
					<cv:msg key="label.backupLevel" bundle="servers"/>
				</label>
			</div>
			<div class="form-group margin-left-25">
				<div class="col-xs-12 col-lg-12" data-ng-class="{'margin-bottom-15': backupController.isCloudDB}">
					<input type="radio" name="backupFull" id="backupFull" data-ng-model="backupController.backupType" value="FULL" data-ng-change="backupController.updateFlags()">
					<label for="backupFull">
						<cv:msg key="option.full" bundle="schedule"/>
					</label>
				</div>
			</div>
			<div data-ng-if="!backupController.isCloudDB">
				<div class="form-group margin-left-25">
					<div class="col-xs-12 col-lg-12">
						<input type="radio" name="backupIncre" id="backupIncre" data-ng-model="backupController.backupType" value="INCREMENTAL" data-ng-change="backupController.updateFlags()">
						<label for="backupIncre">
							<cv:msg key="option.incremental" bundle="schedule"/>
						</label>
					</div>
				</div>
				<div class="form-group margin-left-25" data-ng-show="backupController.isUseBlockLevelBackup">
					<div class="col-xs-1 col-lg-1"></div>
					<div class="col-xs-2 col-lg-2">
						<input type="checkbox" name="log" id="log" data-ng-model="backupController.dummyLog" data-ng-disabled="true" data-ng-change="backupController.updateFlags()">
						<label for="log">
							<cv:msg key="label.LOG" bundle="mySql"/>
						</label>
					</div>
					<div class="col-xs-2 col-lg-2">
						<input type="checkbox" name="data" id="data" data-ng-model="backupController.incrementalDataWithLogs" data-ng-change="backupController.updateFlags()">
						<label for="data">
							<cv:msg key="label.DATA" bundle="mySql"/>
						</label>
					</div>
				</div>
				<div class="form-group margin-left-25" data-ng-show="backupController.isUseBlockLevelBackup">
					<div class="col-xs-12 col-lg-12">
						<input type="radio" name="synthfull" id="synthfull" data-ng-model="backupController.backupType" value="SYNTHETIC_FULL" data-ng-change="backupController.updateFlags()">
						<label for="synthfull">
							<cv:msg key="option.synthfull" bundle="schedule"/>
						</label>
					</div>
				</div>
				<div class="form-group" data-ng-if="!backupController.isProxyEnabled && !backupController.isMEBSelected">
					<div class="col-xs-12 col-lg-12">
						<input type="checkbox" name="doNotTruncateLog" id="doNotTruncateLog" data-ng-model="backupController.doNotTruncateLog">
						<label for="doNotTruncateLog">
							<cv:msg key="label.DoNotTruncateLog" bundle="mySql"/>
						</label>
					</div>
				</div>
				<div class="form-group" data-ng-if="backupController.isProxyEnabled">
					<div class="col-xs-12 col-lg-12">
						<input type="checkbox" name="TruncateLogsOnSource" id="TruncateLogsOnSource" data-ng-model="backupController.truncateLogsOnSource">
						<label for="TruncateLogsOnSource">
							<cv:msg key="label.TruncateLogsOnSource" bundle="mySql"/>
						</label>
					</div>
				</div>
			</div>
			<div class="form-group">
				<div class="col-xs-12"><cv-alert-me selected="false" text="<cv:msg key='label.notifyUserOnJobCompletion' bundle='messages'/>"></cv-alert-me></div>
			</div>
		</div>
	</div>

	<div class="modal-footer">
		<button id="mySqlBackupOptionsModal_button_#0108" type="button" class="btn btn-primary cvBusyOnAjax" data-ng-show="backupMsg" data-ng-click="backupController.cancel()"><cv:msg key="OK" bundle="messages"/></button>
		<button id="mySqlBackupOptionsModal_button_#0774" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-show="!backupController.backupMsg" data-ng-click="backupController.cancel()"><cv:msg key="Cancel" bundle="messages"/></button>
		<button id="mySqlBackupOptionsModal_button_#8875" type="submit" class="btn btn-primary cvBusyOnAjax"  data-ng-class="{'busy':loading}" data-ng-show="!backupController.backupMsg" ><cv:msg key="OK" bundle="messages"/></button>
	</div>
	</form>
</div>
