<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<fmt:setBundle basename="localization.messages" var="common" />
<fmt:bundle basename="localization.oracle">
<div>
	<div class="setup-title">
		<h1>
			<label>
				{{modCtrl.modalOptions.headerText}}
				<cv-help-component help-text="<fmt:message key="help.maskingPolicyRunModal" />"></cv-help-component>
			</label>
		</h1>
	</div>
	<div class="setup-content remove-top-padding">
		<form id="runMaskingPolicyForm" name="runMaskingPolicyForm" novalidate cv-submit="modCtrl.modalOptions.ok()">
			<span class="serverMessage {{modCtrl.serverMessage.type}}" data-ng-bind="modCtrl.serverMessage.message"></span>
			<label for="client"><fmt:message key="label.destClient" />
				<isteven-multi-select
					input-model="modCtrl.clientOptions"
					output-model="modCtrl.selectedClient"
					item-label="clientName"
					button-label="clientName"
					tick-property="checked"
					helper-elements="filter"
					selection-mode="single"
					class="isteven-multi-select isteven-multi-select-arrow-fix user-group-select"
					name="client"
					id="client"
					max-labels="1"
					on-item-click="modCtrl.updateInstances()"
					translation="modCtrl.istevenSelectText">
				</isteven-multi-select>
				
				<!--  hidden inputs to enforce required validation on models -->
				<input type="text" style="display: none" data-ng-model="modCtrl.selectedClient" name="client" required />
				<span class="help-block" data-ng-show="cv.runMaskingPolicyForm.needsAttention(runMaskingPolicyForm.client)">
					<fmt:message key="help.destClient" />
				</span>
			</label>
			
			<label for="instance"><fmt:message key="label.destInstance" />
				<isteven-multi-select
					input-model="modCtrl.instanceNames"
					output-model="modCtrl.selectedInstance"
					item-label="name"
					button-label="name"
					tick-property="checked"
					helper-elements="filter"
					selection-mode="single"
					class="isteven-multi-select isteven-multi-select-arrow-fix user-group-select"
					name="instance"
					id="instance"
					max-labels="1"
					translation="modCtrl.istevenSelectText">
				</isteven-multi-select>
				
				<input type="text" style="display: none" data-ng-model="modCtrl.selectedInstance" name="instance" required />
				<span class="help-block" data-ng-show="cv.runMaskingPolicyForm.needsAttention(runMaskingPolicyForm.instance)">
					<fmt:message key="help.destInstance" />
				</span>
			</label>
			
			<label for="policy"><fmt:message key="label.maskingPolicyName" />
				<isteven-multi-select
					input-model="modCtrl.policyNames"
					output-model="modCtrl.selectedPolicy"
					item-label="name"
					button-label="name"
					tick-property="checked"
					helper-elements="filter"
					selection-mode="single"
					class="isteven-multi-select isteven-multi-select-arrow-fix user-group-select"
					name="policy"
					id="policy"
					max-labels="1"
					translation="modCtrl.istevenSelectText">
				</isteven-multi-select>
				
				<input type="text" style="display: none" data-ng-model="modCtrl.selectedPolicy" name="policy" required />
				<span class="help-block" data-ng-show="cv.runMaskingPolicyForm.needsAttention(runMaskingPolicyForm.policy)">
					<fmt:message key="help.maskingPolicy" />
				</span>
			</label>
			<div class="button-container">
				<button id="maskingRunModal_button_#2408" class="btn btn-default cvBusyOnAjax" type="button" data-ng-click="modCtrl.modalOptions.close()"> 
			  		{{modCtrl.modalOptions.closeButtonText}}
		  		</button>
		  		<button id="maskingRunModal_button_#7750" class="btn btn-primary cvBusyOnAjax" type="submit"> 
		  			{{modCtrl.modalOptions.actionButtonText}}
				</button>
			</div>
		</form>
	</div>
</div>
</fmt:bundle>