<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.sqlserver"></cv:cvMessages>
	<cv:cvMessages bundle="localization.oracle"></cv:cvMessages>
	<cv:cvMessages bundle="localization.db2"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1 data-ng-hide="informixNewInstance.editDialog"><cv:msg key="heading.addInformixInstance" bundle="informix"/></h1>
	<h1 data-ng-show="informixNewInstance.editDialog"><cv:msg key="heading.updateInformixInst" bundle="informix"/> </h1>
</div>
<div class="bootstrap-wrapper " >
	<form name="createInstanceForm" novalidate data-cv-submit="informixNewInstance.createInstance()" autocomplete="off">
		<span class="{{informixNewInstance.serverMessage.type}}" data-ng-bind="informixNewInstance.serverMessage.message"></span>
		<div class="panel panel-default">
			<div class="panel-body">
				<div class="form-group" data-ng-if="informixNewInstance.addInstance">
					<label class="col-xs-12 col-lg-5" for="hostName">
						<cv:msg key="label.clientName" bundle="clients"/>
					</label>
					<div class="col-xs-12 col-lg-7 text-overflow-allowed" data-ng-disabled="informixNewInstance.editDialog">
						<cv-client-picker select-none-by-default="true" selected-clients="informixNewInstance.clientSelection.selectedClients" valide-client-selection="informixNewInstance.clientSelection.valideClientSelection" selection-changed="informixNewInstance.clientSelection.selectionChanged(clientEntity)" app-id="3"  ></cv-client-picker>
						<span class="help-block" data-ng-show="cv.createInstanceForm.getAttempted() && !informixNewInstance.clientSelection.valideClientSelection" >
							<cv:msg key="option.clientName" bundle="clients"/>
						</span>
					</div>
				</div>
				<div class="form-group">
					<label class="col-xs-12 col-lg-5" for="instanceName">
						<cv:msg key="label.instanceName" bundle="clients"/>
					</label>
					<div class="col-xs-12 col-lg-7" data-ng-disabled="informixNewInstance.editDialog">
						<input type="text" id="instanceName" name="instanceName"  data-ng-model="informixNewInstance.instanceEntity.instanceName" required/>
						<span class="help-block" data-ng-show="cv.createInstanceForm.needsAttention(createInstanceForm.instanceName);" >
							<cv:msg key="error.instanceName" bundle="sqlserver"/>
						</span>
					</div>
				</div>
				<div class="form-group" >
					<label class="col-xs-12 col-lg-5" for="plan"><cv:msg key="label.profile" bundle="profiles" /></label>
					<div class="col-xs-12 col-lg-7" data-ng-if="informixNewInstance.profileList">
						<cv-plan-summary-dropdown
							id="planSummarySelection"
							input-model="informixNewInstance.profileList"
							output-model="informixNewInstance.selectedProfileList"
							item-label="'name'"
							button-label="'name'"
							tick-property="'selected'"
							translation="localLang"
							group-property="'msGroup'"
							helper-elements="'filter'"
							selection-mode="'single'"
							on-close="informixNewInstance.parseIStevenOutput()">
						</cv-plan-summary-dropdown>
						<span class="help-block" data-ng-show="cv.createInstanceForm.getAttempted() && informixNewInstance.showPlanError">
							<cv:msg key="error.selectPlan" bundle="profiles" />
						</span>
					</div>
				</div>
				<div class="form-group">
					<label class="col-xs-12 col-lg-5" for="dbUsername">
						<cv:msg key="label.userName" bundle="users"/>
					</label>
					<div class="col-xs-12 col-lg-7">
						<input type="text" id="dbUsername" name="dbUsername" data-ng-model="informixNewInstance.instInfo.dbUserName" required />
						<span class="help-block" data-ng-show="cv.createInstanceForm.needsAttention(createInstanceForm.dbUsername);" >
							<cv:msg key="error.userName" bundle="users"/>
						</span>
						<span class="help-block" data-ng-show="cv.createInstanceForm.getAttempted() && informixNewInstance.errorWindowsUser" >
							<cv:msg key="error.informixUser" bundle="informix"/>
						</span>
					</div>
				</div>
				 <div class="form-group" data-ng-if="!informixNewInstance.isUnixClient">
					<label class="col-xs-12 col-lg-5" for="dbUserPassword">
						<cv:msg key="label.password" bundle="users"/>
					</label>
					<div class="col-xs-12 col-lg-7">
						<input type="password" id="dbUserPassword" name="dbUserPassword" placeholder='{{ informixNewInstance.editDialog ? "<cv:msg key="placeholder.editUserPassword" bundle="users" />" : "" }}'
						data-ng-model="informixNewInstance.instInfo.dbUserPassword" data-ng-required="informixNewInstance.editDialog !== true"/>
						<span class="help-block" data-ng-show="cv.createInstanceForm.needsAttention(createInstanceForm.dbUserPassword);" >
							<cv:msg key="error.password" bundle="users"/>
						</span>
					</div>
				</div>
				<div class="form-group">
					<label class="col-xs-12 col-lg-5" for="dbHome">
						<cv:msg key="label.informixHome" bundle="informix"/>
					</label>
					<div  class="col-xs-12 col-lg-7">
						<div class="input-group">
							<input type="text" id="dbHome" name="dbHome" data-ng-required="true" data-ng-model="informixNewInstance.instInfo.dbHome"/>
							<span class="input-group-btn">
								<cv-machine-browse button-label='<cv:msg key="label.browse" bundle="restore"/>' can-create-folder='false'
									client-id='{{informixNewInstance.instanceEntity.clientId}}' result-function="informixNewInstance.dbHomeResuleFunction"/>
							</span>
						</div>
						<span class="help-block" data-ng-show="cv.createInstanceForm.needsAttention(createInstanceForm.dbHome);" >
							<cv:msg key="error.homeLocation" bundle="informix"/>
						</span>
					</div>
				</div>
				<div class="form-group">
					<label class="col-xs-12 col-lg-5" for="onconfigFile">
						<cv:msg key="label.onconfigFile" bundle="informix"/>
					</label>
					<div  class="col-xs-12 col-lg-7">
						<div class="input-group">
							<input type="text" id="onconfigFile" name="onconfigFile" data-ng-required="true" data-ng-model="informixNewInstance.instInfo.onConfigFile"/>
							<span class="input-group-btn">
								<cv-machine-browse button-label='<cv:msg key="label.browse" bundle="restore"/>' folders-only='false' can-create-folder='false'
									client-id='{{informixNewInstance.instanceEntity.clientId}}' result-function="informixNewInstance.oncOnfigFileResuleFunction"/>
							</span>
						</div>
						<span class="help-block" data-ng-show="cv.createInstanceForm.needsAttention(createInstanceForm.onconfigFile);" >
							<cv:msg key="error.onconfigFile" bundle="informix"/>
						</span>
					</div>
				</div>
				<div class="form-group">
					<label class="col-xs-12 col-lg-5" for="sqlHostsFile">
						<span data-ng-show="informixNewInstance.isUnixClient">
							<cv:msg key="label.sqlHostsFile" bundle="informix"/>
						</span>
						<span data-ng-hide="informixNewInstance.isUnixClient">
							<cv-help-text help-label="<cv:msg key="label.sqlHostsFile" bundle="informix"/>" help-text="'<cv:msg key="help.sqlHostsFile" bundle="informix"/>'"></cv-help-text>
						</span>
					</label>
					<div  class="col-xs-12 col-lg-7">
						<div class="input-group">
							<input type="text" id="sqlHostsFile" name="sqlHostsFile" data-ng-required="informixNewInstance.isUnixClient" data-ng-model="informixNewInstance.instInfo.sqlHostfile"/>
							<span class="input-group-btn">
								<cv-machine-browse button-label='<cv:msg key="label.browse" bundle="restore"/>' folders-only='false' can-create-folder='false'
									client-id='{{informixNewInstance.instanceEntity.clientId}}' result-function="informixNewInstance.SqlHostsFileResuleFunction"/>
							</span>
						</div>
						<span class="help-block" data-ng-show="cv.createInstanceForm.needsAttention(createInstanceForm.sqlHostsFile);" >
							<cv:msg key="error.sqlHostsFile" bundle="informix"/>
						</span>
					</div>
				</div>
			</div>
		</div>
		<div class="modal-footer">
	  		<button id="db2CreateInstance_button_#1825" type="button" class="btn cvBusyOnAjax" data-ng-click="informixNewInstance.closeDialogBox()">
	  			<cv:msg key="Cancel" bundle="messages"/>
  			</button>
	  		<button id="db2CreateInstance_button_#8782" type="submit" class="btn btn-primary cvBusyOnAjax" >
	  			<span data-ng-hide="informixNewInstance.editDialog" > <cv:msg key="Add" bundle="messages"/> </span>
	  			<span data-ng-show="informixNewInstance.editDialog" > <cv:msg key="Save" bundle="messages"/> </span>
	  		</button>
		</div>
	</form>
</div>
