<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
	<cv:cvMessages bundle="localization.schedule"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
</script>
<div class="bootstrap-wrapper">
	<div class="setup-title">
		<h1><cv:msg key="header.backupOptions" bundle="servers"/></h1>
	</div>
	<span class="{{informixBackupOptions.serverMessage.type}} serverMessage">{{informixBackupOptions.serverMessage.message}}</span>
	<form name="backupForm" data-cv-submit="informixBackupOptions.startBackup()" >
	<div class="panel" >
		<div class="panel-body" data-ng-show="!informixBackupOptions.backupMsg">
			<div class="form-group">
				<label class="col-xs-12 col-lg-12" >
					<cv:msg key="label.backupLevel" bundle="servers"/>
				</label>
			</div>
			<div class="form-group margin-left-25">
				<div class="col-xs-12 col-lg-12">
					<input type="radio" name="backupFull" id="backupFull" data-ng-model="informixBackupOptions.backupType" value="FULL">
					<label for="backupFull">
						<cv:msg key="option.full" bundle="schedule"/>
					</label>
				</div>
			</div>
			<div class="form-group margin-left-25" data-ng-hide="informixBackupOptions.isLogOnly || informixBackupOptions.isSnapEnabled">
				<div class="col-xs-12 col-lg-12">
					<input type="radio" name="backupIncre" id="backupIncre" data-ng-model="informixBackupOptions.backupType" value="INCREMENTAL">
					<label for="backupIncre">
						<cv:msg key="option.incremental" bundle="schedule"/>
					</label>
				</div>
			</div>
			<div class="col-xs-12 padding-top-20">
				<cv-alert-me selected="false" text="<cv:msg key='label.notifyUserOnJobCompletion' bundle='messages'/>"></cv-alert-me>
			</div>
		</div>
	</div>

	<div class="modal-footer">
		<button id="informixBackupOptions_button_#3409" type="button" class="btn btn-primary cvBusyOnAjax" data-ng-show="informixBackupOptions.backupMsg" data-ng-click="informixBackupOptions.cancel()"><cv:msg key="OK" bundle="messages"/></button>
		<button id="informixBackupOptions_button_#9351" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-show="!informixBackupOptions.backupMsg" data-ng-click="informixBackupOptions.cancel()"><cv:msg key="Cancel" bundle="messages"/></button>
		<button id="informixBackupOptions_button_#9309" type="submit" class="btn btn-primary cvBusyOnAjax"  data-ng-class="{'busy':informixBackupOptions.loading}" data-ng-show="!informixBackupOptions.backupMsg" ><cv:msg key="OK" bundle="messages"/></button>
	</div>
	</form>
</div>