<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.restoreJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
	<cv:cvMessages bundle="localization.oracle"></cv:cvMessages>
	<cv:cvMessages bundle="localization.browseJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
	<cv:cvMessages bundle="localization.browse"></cv:cvMessages>
	<cv:cvMessages bundle="localization.sqlserver"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.dbs"></cv:cvMessages>
    <cv:cvMessages bundle="localization.capps"></cv:cvMessages>
    <cv:cvMessages bundle="localization.clients"></cv:cvMessages>
    <cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
    <cv:cvMessages bundle="localization.mySql"></cv:cvMessages>
    <cv:cvMessages bundle="localization.bigData"></cv:cvMessages>
    <cv:cvMessages bundle="localization.informix"></cv:cvMessages>
    <cv:cvMessages bundle="localization.cloudStorageAppJs"></cv:cvMessages>
    <cv:cvMessages bundle="localization.sybase"></cv:cvMessages>
    <cv:cvMessages bundle="localization.settingsJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.migrate"></cv:cvMessages>
	<cv:cvMessages bundle="localization.capps"></cv:cvMessages>
	<cv:cvMessages bundle="localization.search"></cv:cvMessages>
</script>
<script type="text/ng-template"  id="browseTree_item_renderer.html">
	<div data-ng-class="{selected: item==selectedItem}" class="crop">
		<button id="idaBrowse_button_#3994" data-ng-class="item.state | lowercase" data-ng-click="folderDrilledDown(item)"></button>
 		<span class="crop" data-ng-click="folderSelected(item)" data-ng-bind="item.label" title="{{item.label}}"></span>
	</div>
    <div class="children" data-ng-class="item.state">
         <div class="browse-item" data-ng-repeat="item in item.children" data-ng-include="'browseTree_item_renderer.html'"></div>
 			<a data-ng-show="item.partiallyLoaded===true && !hideLoadMore()" data-ng-click="loadMore(item)"><cv:msg key="label.showMore" bundle="browse" /></a>
    </div>
</script>
<script type="text/ng-template"  id="breadcrumbItem">
 	<a ng-hide="$last" data-ng-click="folderSelected(item.node)">{{item.display}}</a>
	<span ng-show="$last">{{item.display}}</span>
</script>
<h1 class="page-title"><cv:msg key="label.backupContent" bundle="restore" /></h1>
<!-- tree rendering thing  -->
<span class="mailbox-browse-for-restore browse-for-restore margin-bottom no-checkboxes " >
	<div data-ng-hide="{{hideTree}}" >
		<div class="browse-tree" >
			<div data-ng-class="{selected: tree==selectedItem}" class="browse-item">
				<button id="idaBrowse_button_#6932"  data-ng-class="tree.state | lowercase" data-ng-click="folderDrilledDown(tree)"></button>
				<span data-ng-click="folderSelected(tree)" data-ng-bind="tree.label"></span>
				<div data-ng-repeat="item in tree.children" class="browse-item" data-ng-include="'browseTree_item_renderer.html'"></div>
			</div>
		</div>
	</div>
	<div  data-ng-class="'browse-table'" >
		<div id="browseActions" class="browse-actions">
			<span data-ng-disabled="!restoreAllowed" data-ng-class="{'disabled inline-block': !restoreAllowed }">
				<a data-ng-if="createRecoveryPoint && createRecoveryPoint == 1" href="" data-ng-click="doShowRestoreDialog()" class="btn btn-primary">
		    		<cv:msg key="label.createRecoveryPoint" bundle="exchange" />
		    	</a>

		    	<a data-ng-if="createRecoveryPoint != 1 && !isMigrate" href="" data-ng-click="doShowRestoreDialog()" class="btn btn-primary">
		    		<cv:msg key="label.restore" bundle="restore" />
		    	</a>

		    	<a data-ng-if="isMigrate" data-ng-click="doCloudMigrate()" class="btn btn-primary">
		    		<cv:msg key="label.migrate" bundle="migrate" />
		    	</a>
	    	</span>
			<span data-ng-if="showClusterViewToggle">
				<cv-toggle toggle-name="showDbViewToggle" toggle-label="label.clusterView" help-text="helpText.clusterView" value="dummyModel.clusterView" on-click="switchViews()"></cv-toggle>
			</span>
			<span class="uib-dropdown page-action-item-right-margin" on-toggle="toggled(open)" data-ng-if="showDBsTableViewToggle" uib-dropdown>
                  <a href class="uib-dropdown-toggle" uib-dropdown-toggle>
                    {{databaseContentView}} <span class="dropdownArrow"></span>
                  </a>
                  <ul uib-dropdown-menu class="dropdown-menu">
                    <li> <a href="" data-ng-click="switchDBsTableViews(false)"><cv:msg key="label.tablespaceView" bundle="oracle"/></a></li>
                    <li><a href="" data-ng-click="switchDBsTableViews(true)"><cv:msg key="label.tableView" bundle="oracle"/></a></li>
                  </ul>
            </span>
  		   	<div data-ng-if="clusterType==='HADOOP' && !isHBase" id="showDeletedItemsMenu" class="btn-group  margin-left-20 margin-bottom-5" data-ng-disabled="deletedMenuClicked">
  		   		<span class="dropdown cv-main-bar-dropdown-menu menu" data-uib-dropdown>
						<a href="" class="uib-dropdown-toggle main-tab-menu-toggle dropdown-toggle" data-uib-dropdown-toggle aria-haspopup="true" aria-expanded="false">
				<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor" width="20" height="20"><path d="M10.1 0C4.6-.1.1 4.4 0 9.9s4.4 10 9.9 10.1 10-4.4 10.1-9.9v-.2C19.9 4.5 15.5.1 10.1 0zm0 18.9c-5 0-9-4-9-9s4-9 9-9 9 4 9 9-4 9-9 9z"></path><path d="M6.1 8.8h2v2h-2zM9.1 8.8h2v2h-2zM12.1 8.8h2v2h-2z"></path></svg>
				</a>
				<ul uib-dropdown-menu class="dropdown-menu margin-top-5">
				<li><a href="" data-ng-click="options.showDeletedItems = !options.showDeletedItems;showDeletedItems(options.showDeletedItems)">
						<span data-ng-if="!options.showDeletedItems"><cv:msg key="label.showDeletedItems" bundle="browse"/></span><span data-ng-if="options.showDeletedItems"><cv:msg key="label.hideDeletedItems" bundle="browse"/></span></a></li>
				</ul>
				</span>
			</div>

            <span class="uib-dropdown page-action-item-right-margin" on-toggle="toggled(open)" data-ng-if="showMongoDBClusterViewToggle" uib-dropdown>
                  <a href class="uib-dropdown-toggle" uib-dropdown-toggle>
                    {{replicaSetView}} <span class="dropdownArrow"></span>
                  </a>
                  <ul uib-dropdown-menu class="dropdown-menu">
                    <li> <a href="" data-ng-click="switchMongoDBReplicasetView(false)"><cv:msg key="label.browseFilter.restoreCollections" bundle="bigData"/></a></li>
                    <li><a href="" data-ng-click="switchMongoDBReplicasetView(true)"><cv:msg key="label.browseFilter.restorecluster" bundle="bigData"/></a></li>
                  </ul>
            </span>
			<span class="search-widget-wrapper search-filter" data-ng-if="showSearch">
				<input type="search" class="search-field" placeholder="<cv:msg key='label.search' bundle='messages' />" title="<cv:msg key='label.search' bundle='messages' />" id="search-field" data-ng-model="search.text" data-ng-change="onSearchTextChange()" />
				<span data-ng-click="clearSearch()"
						class="form-control-clear glyphicon glyphicon-remove form-control-feedback"
						title="<cv:msg key='label.clear' bundle='messages' />"></span>
			</span>
			<div id="searchBox" class="cv-search-box search-widget-wrapper dropdown browse-search" data-ng-if="clusterType==='HADOOP'">
			    <cv-search-box ng-if="searchModel" query="searchModel.query" on-search="onSearch(query, fields)" custom-class="searchModel.customClass" field-defs="searchModel.fieldDefs" data-show-in-url="false"></cv-search-box>
		    </div>
	     	<div class="page-action-item">
				<span class="uib-dropdown page-action-item-right-margin" on-toggle="toggled(open)" uib-dropdown>
				      <a href class="uib-dropdown-toggle" uib-dropdown-toggle>
				      	{{timeRangeLabel}} <span class="dropdownArrow"></span>
				      </a>
				      <ul uib-dropdown-menu class="dropdown-menu">
				        <li ><a href="" data-ng-click="resultFunction({})"><cv:msg key="Show_latest_backups" bundle="browse"/></a></li>
				        <li cv-date-time heading-label="<cv:msg key="label.toTime" bundle="messages"/>" show-from-time=false result-function="resultFunction" ><a href=""><cv:msg key="Show_backups_specific_date" bundle="browse"/></a></li>
				        <li data-ng-show="showFromTimeSelection()" cv-date-time heading-label="<cv:msg key="label.toTime" bundle="messages"/>" show-from-time=true result-function="resultFunction" ><a href=""><cv:msg key="Show_backups_date_range" bundle="browse"/></a></li>
				      </ul>
			   </span>
			</div>
			<div class="page-action-item" data-ng-show="showCopyPrecedence">
				<span class="uib-dropdown" on-toggle="toggled(open)" uib-dropdown>
					<a href class="uib-dropdown-toggle" uib-dropdown-toggle>{{copyPrecedenceLabel}}<span class="dropdownArrow right"></span></a>
					<ul data-uib-dropdown-menu class="dropdown-menu">
						<li role="menuitem"  data-ng-click="setSelectedCopy(0,defaultCopyPrecedenceLabel)" title="{{copyPrecedenceIdLabel}}:0"><a href>{{defaultCopyPrecedenceLabel}}</a></li>
						<li role="menuitem" ng-repeat="copy in storage.copy | orderBy: 'copyPrecedence'" data-ng-click="setSelectedCopy(copy.copyPrecedence,copy.StoragePolicyCopy.copyName)" title="{{copyPrecedenceIdLabel}}: {{copy.copyPrecedence}}, {{getCopyTypeInfo(copy.copyType)}}">
						<a href>{{copyPrecedencePrefix}} {{copy.StoragePolicyCopy.copyName}}</a></li>
					</ul>
				</span>
			</div>
	     </div>
	    <!-- <div data-cv-breadcrumb data-ng-model="breadcrumbModel" item-template="'breadcrumbItem'"></div> -->
	     <ul class="breadcrumb" >
			<span class="breadcrumbPathLabel">&nbsp;</span>
			   <li ng-repeat="item in breadcrumbModel"  >
				   <a ng-hide="$last" data-ng-click="folderSelected(item.node)">{{item.display}}</a>
				   <span ng-show="$last">{{item.display}}</span>
				</li>
		</ul>
		<%-- <cv-grid cv-grid-options="gridOptions"></cv-grid>  --%>
		<div id="browseTable" data-ng-hide="browseData && browseData.length==0" data-ui-grid="gridOptions" data-ui-grid-pagination data-ui-grid-selection
						 data-ui-grid-auto-resize data-cv-ui-grid-resize class="grid-style users-grid bottom-grid-fix">
						<span data-cv-loading-spinner data-ng-model="browseData"></span>
		</div>
		<div data-ng-show="browseData && browseData.length==0" class="error horz-center extra-top-padding" data-ng-bind="errorMessageToShow"/>
	</div>
</span>
