<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.dbs"></cv:cvMessages>
</script>
<div class="modal-header">
	<h4 ><cv:msg key="pageHeader.discoverInstances" bundle="dbs"/></h4>
</div>
<div class="bootstrap-wrapper form-horizontal" >
	<form name="discoverInstancesFrom" novalidate cv-hide-api data-cv-submit="discoverInstanceList()" autocomplete="off">
		<span class="{{serverMessage.type}}" data-ng-bind="serverMessage.message"></span>
		<div class="panel-body">
			<div class="form-group">
				<label class="col-xs-12 col-lg-5" for="agentTypeSelection">
					<cv:msg key="label.dbEngine" bundle="dbs"/>
				</label>
				<div class="col-xs-12 col-lg-7">
					<select id="agentTypeSelection" name="agentTypeSelection"	data-ng-model="dataModel.appId" required data-ng-change="appTypeChanged()"
						data-ng-options="apps.appId as apps.appName for apps in supportAgents">
					</select>
					<span class="help-block" data-ng-show="cv.discoverInstancesFrom.needsAttention(discoverInstancesFrom.agentTypeSelection);" >
						<cv:msg key="error.dbName" bundle="oracle"/>
					</span>
				</div>
			</div>
			<div class="form-group">
				<label class="col-xs-12 col-lg-5" for="hostName">
					<cv:msg key="label.clientName" bundle="clients"/>
				</label>
				<div class="col-xs-12 col-lg-7 text-overflow-allowed" data-ng-if="dataModel.showClientSelection">
					<cv-client-picker selected-clients="clientSelection.selectedClients" valide-client-selection="clientSelection.valideClientSelection" selection-changed="clientSelection.selectionChanged(clientEntity)" app-id="{{dataModel.appId}}"  ></cv-client-picker>
					<span class="help-block" data-ng-show="cv.discoverInstancesFrom.getAttempted() && !clientSelection.valideClientSelection" >
						<cv:msg key="option.clientName" bundle="clients"/>
					</span>
				</div>
			</div>
		</div>
		<div class="modal-footer">
	  		<button id="discoverInstances_Cancel_button" type="button" class="btn cvBusyOnAjax" data-ng-click="closeDialogBox()">
	  			<cv:msg key="Cancel" bundle="messages"/>
  			</button>
	  		<button id="discoverInstances_Discover_button" type="submit" class="btn btn-primary cvBusyOnAjax" data-ng-class="{'busy': dataModel.loading}">
	  			<span > <cv:msg key="label.discover" bundle="sqlserver"/> </span>
	  		</button>
		</div>
	</form>
</div>
