<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
    <cv:cvMessages bundle="localization.sybase"></cv:cvMessages>
</script>

<div>
	<!-- Destination client  -->
	<div class="form-group padding-top-20 margin-bottom-10">
		<label class="col-xs-12 col-sm-4" for="destinationClient2">
			<cv:msg key="label.DestinationClient" bundle="saphana"/>
		</label>
		<div class="col-xs-12 col-sm-8">
			<cv-isteven-single-select id-name="destinationClient2"
				input-model="dbRestoreToDisk.dbRestoreToDiskData.destinationTargetClients"
				binding-model="dbRestoreToDisk.dbRestoreToDiskData.selectedClient"
				track-field="clientId"
				label="displayName"
				tick-property="selected"
				place-holder='<cv:msg key="placeholder.DestinationClient" bundle="saphana"/>'
				help-text='<cv:msg key="placeholder.DestinationClient" bundle="saphana"/>'
				data-ng-required = "dbRestoreToDisk.isRestoreToDisk()">
			</cv-isteven-single-select>
		</div>
	</div>
	<!-- Jobs for selection  -->
	<div class="form-group">
		<label for="jobs" class="col-xs-12 col-lg-4">
			<cv:msg	key="label.jobs" bundle="sybase" />
		</label>
		<div class="col-xs-12 col-lg-8">
		    <isteven-multi-select
		    	id="jobs"
		        input-model="dbRestoreToDisk.dbRestoreToDiskData.jobList"
		        output-model="dbRestoreToDisk.dbRestoreToDiskData.selectedJobs"
		        class="isteven-multi-select user-group-select isteven-summary-dropdown"
		        html-template="true"
		        button-label="jobId"
		        item-label="template"
		        directive-id="templates"
		        tick-property="selected"
		        helper-elements="filter"
		        translation="dbRestoreToDisk.localLang">
		    </isteven-multi-select>
			<span class="help-block"
				data-ng-show="cv.restoreForm.getAttempted() && dbRestoreToDisk.isShowJobError()">
				<cv:msg key="placeholder.job" bundle="sybase" />
			</span>
		</div>
	</div>
	<!-- Destination restore path -->
	<div class="form-group">
		<div class="col-xs-12 col-sm-4">
			<label for="DestinationFolder"> <cv:msg key="label.DestinationFolder" bundle="mySql" /></label>
		</div>
		<div class="col-xs-12 col-sm-8">
			<div class="input-group"
				title="{{dbRestoreToDisk.dbRestoreToDiskData.path}}">
				<input type="text" name="DestinationFolder" id="DestinationFolder"
					data-ng-model="dbRestoreToDisk.dbRestoreToDiskData.path"
					data-ng-required = "dbRestoreToDisk.isRestoreToDisk()"/>
				<span class="input-group-btn" data-ng-disabled="dbRestoreToDisk.isDisableBrowse()">
					<cv-machine-browse button-label='<cv:msg key="label.browse" bundle="restore"/>'
						client-id='{{dbRestoreToDisk.dbRestoreToDiskData.selectedClient.clientId}}'
						result-function="dbRestoreToDisk.browseResultFunction" />
				</span>
			</div>
			<span class="help-block"
				data-ng-show="cv.restoreForm.needsAttention(restoreForm.DestinationFolder)">
				<cv:msg key="error.DestinationFolder" bundle="mySql" />
			</span>
		</div>
	</div>
	<!-- Impersonate options -->
	<div>
		<div class="form-group">
			<div class="col-xs-12">
				<toggle-control status="dbRestoreToDisk.dbRestoreToDiskData.impersonateEnabledStatus" data-ng-click="dbRestoreToDisk.toggleImpersonation()"></toggle-control>
				<label>	<cv:msg key='label.impersonateUser' bundle='restore'/>
					<span class="optional-text"><cv:msg key="label.optional" bundle="subscriptions" /></span>
				</label>
			</div>
		</div>
		<div class="panel-body padding-top-5" data-ng-if="dbRestoreToDisk.dbRestoreToDiskData.useImpersonation">
			<div class="form-group">
				<label class="col-xs-12 col-sm-4"><cv:msg key="label.username" bundle="restore" /> </label>
				<div class="col-xs-12 col-sm-8">
					<input type="text" name="impersonateUserName"
						data-ng-model="dbRestoreToDisk.dbRestoreToDiskData.impersonateUserName"
						data-ng-required="dbRestoreToDisk.isRestoreToDisk() && dbRestoreToDisk.dbRestoreToDiskData.useImpersonation" />
					<span class="help-block" data-ng-show="dbRestoreToDisk.dbRestoreToDiskData.useImpersonation && cv.restoreForm.needsAttention(restoreForm.impersonateUserName)">
						<cv:msg key="error.userNameRequired" bundle="restore" />
					</span>
				</div>
			</div>
			<div class="form-group">
				<label class="col-xs-12 col-sm-4"><cv:msg key="label.password" bundle="restore" /> </label>
				<div class="col-xs-12 col-sm-8">
					<input type="password" name="impersonatePassword"
						data-ng-model="dbRestoreToDisk.dbRestoreToDiskData.impersonatePassword"
						data-ng-required="dbRestoreToDisk.isRestoreToDisk() && dbRestoreToDisk.dbRestoreToDiskData.useImpersonation" />
					<span class="help-block" data-ng-show="dbRestoreToDisk.dbRestoreToDiskData.useImpersonation && cv.restoreForm.needsAttention(restoreForm.impersonatePassword)">
							<cv:msg key="error.uncPasswordRequired" bundle="restore" />
					</span>
				</div>
			</div>
		</div>
	</div>

	<div class="global-options remove-border-padding padding-top-10">
		<cv-alert-me selected="false" text="
			<cv:msg key='label.notifyUserOnJobCompletion' bundle='messages'/>">
		</cv-alert-me>
	</div>
</div>
