<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.oracle"></cv:cvMessages>
	<cv:cvMessages bundle="localization.db2"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1 data-ng-hide="db2dpfNewInstance.editDialog"><cv:msg key="heading.CreateDB2DPFInstance" bundle="db2"/></h1>
	<h1 data-ng-show="db2dpfNewInstance.editDialog"><cv:msg key="heading.editDB2DPFInstance" bundle="db2"/></h1>
</div>
<div class="bootstrap-wrapper form-horizontal" >
	<form name="createInstanceForm" novalidate data-cv-submit="db2dpfNewInstance.createInstance()" autocomplete="off">
		<span class="{{db2dpfNewInstance.db2dpfServerMessage.type}}" data-ng-bind="db2dpfNewInstance.db2dpfServerMessage.message"></span>
		<div class="panel panel-default">
			<div class="panel-body">
				<div class="form-group" data-ng-if="db2dpfNewInstance.addInstance">
					<label class="col-xs-12 col-lg-5" for="hostName">
						<cv:msg key="label.db2MultiNode" bundle="db2"/>
					</label>
					<div class="col-xs-12 col-lg-7 text-overflow-allowed">
						<input type="text" id="newServer" name="newServer"  data-ng-model="db2dpfNewInstance.instanceEntity.clientName" required/>
						<span class="help-block" data-ng-show="cv.createInstanceForm.needsAttention(createInstanceForm.newServer) || db2dpfNewInstance.showServerNameError" >
							<span data-ng-show="db2dpfNewInstance.showServerNameError"> {{db2dpfNewInstance.showServerNameMesage}} </span>
							<span data-ng-hide="db2dpfNewInstance.showServerNameError"> <cv:msg key="option.db2MultiNode" bundle="db2"/> </span>
						</span>
					</div>
				</div>
				<div class="form-group">
					<label class="col-xs-12 col-lg-5" for="instanceName">
						<cv:msg key="label.instanceName" bundle="clients"/>
					</label>
					<div class="col-xs-12 col-lg-7">
						<input type="text" id="instanceName" name="instanceName"  data-ng-model="db2dpfNewInstance.instanceEntity.instanceName" data-ng-change="db2dpfNewInstance.updateUserName()" required/>
						<span class="help-block" data-ng-show="cv.createInstanceForm.needsAttention(createInstanceForm.instanceName);" >
							<cv:msg key="error.dbName" bundle="oracle"/>
						</span>
					</div>
				</div>
				<div class="form-group" >
					<label class="col-xs-12 col-lg-5" for="plan"><cv:msg key="label.profile" bundle="profiles" /></label>
					<div class="col-xs-12 col-lg-7" data-ng-if="db2dpfNewInstance.profileList">
						<cv-plan-summary-dropdown
							id="planSummarySelection"
							input-model="db2dpfNewInstance.profileList"
							output-model="db2dpfNewInstance.selectedProfileList"
							item-label="'name'"
							button-label="'name'"
							tick-property="'selected'"
							translation="localLang"
							group-property="'msGroup'"
							helper-elements="'filter'"
							selection-mode="'single'"
							on-close="db2dpfNewInstance.parseIStevenOutput()">
						</cv-plan-summary-dropdown>
						<span class="help-block" data-ng-show="cv.createInstanceForm.getAttempted() && db2dpfNewInstance.showPlanError">
							<cv:msg key="error.selectPlan" bundle="profiles" />
						</span>
					</div>
				</div>
				<div class="form-group">
					<label class="col-xs-12 col-lg-5" >
						<cv:msg key="label.db2UserAccount" bundle="db2"/>
					</label>
				</div>
				<div class="form-group">
					<div class="col-xs-12 col-lg-1">
					</div>
					<label class="col-xs-12 col-lg-4" for="dbUsername">
						<cv:msg key="label.userName" bundle="users"/>
					</label>
					<div class="col-xs-12 col-lg-7">
						<input type="text" id="dbUsername" name="dbUsername" data-ng-model="db2dpfNewInstance.instInfo.dbUserName" required />
						<span class="help-block" data-ng-show="cv.createInstanceForm.needsAttention(createInstanceForm.dbUsername);" >
							<cv:msg key="error.userName" bundle="users"/>
						</span>
					</div>
				</div>
				 <div class="form-group" >
				 	<div class="col-xs-12 col-lg-1">
					</div>
					<label class="col-xs-12 col-lg-4" for="dbUserPassword">
						<cv:msg key="label.password" bundle="users"/>
					</label>
					<div class="col-xs-12 col-lg-7">
						<input type="password" id="dbUserPassword" name="dbUserPassword" placeholder='{{ db2dpfNewInstance.editDialog ? "<cv:msg key="placeholder.editUserPassword" bundle="users" />" : "" }}'
						data-ng-model="db2dpfNewInstance.instInfo.dbUserPassword" data-ng-required="db2dpfNewInstance.editDialog !== true"/>
						<span class="help-block" data-ng-show="cv.createInstanceForm.needsAttention(createInstanceForm.dbUserPassword);" >
							<cv:msg key="error.password" bundle="users"/>
						</span>
					</div>
				</div>

				<div class="form-group" >
					<div class="col-xs-12 col-lg-12" >
						<cv-db2-partition-nodes inst-info ="db2dpfNewInstance.instInfo" ></cv-db2-partition-nodes>
					</div>
				</div>
			</div>
		</div>
		<div class="modal-footer">
	  		<button id="db2dpfCreateInstance_Cancel_button" type="button" class="btn cvBusyOnAjax" data-ng-click="db2dpfNewInstance.closeDialogBox()">
	  			<cv:msg key="Cancel" bundle="messages"/>
  			</button>
	  		<button id="db2dpfCreateInstance_Save_button" type="submit" class="btn btn-primary cvBusyOnAjax" >
	  			<span data-ng-hide="db2dpfNewInstance.editDialog" > <cv:msg key="Add" bundle="messages"/> </span>
	  			<span data-ng-show="db2dpfNewInstance.editDialog" > <cv:msg key="Save" bundle="messages"/> </span>
	  		</button>
		</div>
	</form>
</div>
