<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.sqlserver"></cv:cvMessages>
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.saphana"></cv:cvMessages>
	<cv:cvMessages bundle="localization.dbs"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1>
		<span data-ng-hide="db2CreateBackupset.editDialog" > <cv:msg key="heading.CreateNewDatabase" bundle="db2"/> </span>
		<span data-ng-show="db2CreateBackupset.editDialog" > <cv:msg key="heading.updateDB2Database" bundle="db2"/> </span>
	</h1>
</div>
<div class="bootstrap-wrapper" >
	<form name="addDB2Database" class="form-horizontal" novalidate autocomplete="off" data-cv-submit="db2CreateBackupset.createDatabase()">
		<span class="server-message {{db2CreateBackupset.serverMessage.type}}" data-ng-bind="db2CreateBackupset.serverMessage.message"></span>
		<div class="panel">
			<div class="panel-body" >
				<div class="form-group">
					<label for="databaseName" class="col-xs-12 col-lg-5" >
						<cv-help-text help-label="<cv:msg key="label.dbName" bundle="oracle"/>" help-text="'<cv:msg key="help.db2DBName" bundle="db2"/>'"></cv-help-text>
					</label>
					<div class="col-xs-12 col-lg-7" data-ng-disabled="db2CreateBackupset.editDialog">
						<input type="text" required name="databaseName" id="databaseName" data-ng-model="db2CreateBackupset.backupsetEntity.databaseName"
							placeholder='<cv:msg key="label.dbName" bundle="oracle"/>' />
						<span class="help-block" data-ng-show="cv.addDB2Database.needsAttention(addDB2Database.databaseName) || db2CreateBackupset.databaseNameError">
							<span data-ng-hide="db2CreateBackupset.databaseNameError"><cv:msg key="error.dbName" bundle="oracle"/></span>
							<span data-ng-show="db2CreateBackupset.databaseNameError" data-ng-bind="db2CreateBackupset.db2DBNameChrects" ></span>
						</span>
					</div>
				</div>
				<div class="form-group">
					<label for="databasePlan" class="col-xs-12 col-lg-5" >
						<cv:msg key="label.profile" bundle="profiles"/>
					</label>
					<div class="col-xs-12 col-lg-7" data-ng-if="db2CreateBackupset.profileList">
						<cv-plan-summary-dropdown
							id="db2PlanSummarySelection"
							input-model="db2CreateBackupset.profileList"
							output-model="db2CreateBackupset.selectedProfileList"
							item-label="'name'"
							button-label="'name'"
							tick-property="'selected'"
							translation="localLang"
							group-property="'msGroup'"
							helper-elements="'filter'"
							selection-mode="'single'"
							on-close="db2CreateBackupset.parseIStevenOutput()">
						</cv-plan-summary-dropdown>
						<span class="help-block" data-ng-show="cv.addDB2Database.getAttempted() && db2CreateBackupset.showPlanError">
							<cv:msg key="error.selectPlan" bundle="profiles" />
						</span>
					</div>
				</div>
				<div class="form-group" data-ng-if="db2CreateBackupset.editDialog">
					<div class="col-xs-12">
						<toggle-control status="db2CreateBackupset.useSQLConnect==true?'enabled-activity':'disabled-activity'"
	              				data-ng-click="db2CreateBackupset.useSQLConnectSelected()"
	              				title="<cv:msg key="label.useSQLConnect" bundle="db2"/>" >
	           			</toggle-control>
						<label for="useSQLConnect" title="<cv:msg key="label.useSQLConnect" bundle="db2"/>">
							<cv:msg key="label.useSQLConnect" bundle="db2"/>
						</label>
					</div>
				</div>
				<div class="form-group" data-ng-if="db2CreateBackupset.useSQLConnect">
					<label for="dbUserName" class="col-xs-12 col-lg-5 padding-left-40" >
						<cv:msg key="label.userName" bundle="users"/>
					</label>
					<div class="col-xs-12 col-lg-7">
						<input type="text" required name="dbUserName" id="dbUserName" data-ng-model="db2CreateBackupset.db2SqlConnectInfo.userName" />
						<span class="help-block" data-ng-show="cv.addDB2Database.needsAttention(addDB2Database.dbUserName)">
							<cv:msg key="error.userName" bundle="users"/>
						</span>
					</div>
				</div>
				<div class="form-group" data-ng-if="db2CreateBackupset.useSQLConnect">
					<label for="dbPassword" class="col-xs-12 col-lg-5 padding-left-40" >
						<cv:msg key="label.password" bundle="users"/>
					</label>
					<div class="col-xs-12 col-lg-7">
						<input type="password" name="dbPassword" id="dbPassword" data-ng-model="db2CreateBackupset.db2SqlConnectInfo.dbPassword" placeholder='{{ db2CreateBackupset.editDialog ? "<cv:msg key="placeholder.editUserPassword" bundle="users" />" : "" }}' />
						<span class="help-block" data-ng-show="cv.addDB2Database.needsAttention(addDB2Database.dbPassword)">
							<cv:msg key="error.password" bundle="users"/>
						</span>
					</div>
				</div>
			</div>
		</div>
		<div class="modal-footer" >
			<button id="db2CreateBackupset_button_close" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="db2CreateBackupset.closeDialogBox()">
				<cv:msg key="Cancel" bundle="messages" />
			</button>
			<button id="db2CreateBackupset_button_save" type="submit" class="btn btn-primary cvBusyOnAjax" >
				<span data-ng-hide="db2CreateBackupset.editDialog" > <cv:msg key="Add" bundle="messages"/> </span>
	  			<span data-ng-show="db2CreateBackupset.editDialog" > <cv:msg key="Save" bundle="messages"/> </span>
			</button>
		</div>
	</form>
</div>
