<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.collections"></cv:cvMessages>
	<cv:cvMessages bundle="localization.oracle"></cv:cvMessages>
	<cv:cvMessages bundle="localization.browseJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
	<cv:cvMessages bundle="localization.browse"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.capps"></cv:cvMessages>
	<cv:cvMessages bundle="localization.job"></cv:cvMessages>
	<cv:cvMessages bundle="localization.search"></cv:cvMessages>
</script>
<script type="text/ng-template"  id="browseTree_item_renderer.html">
	<div data-ng-class="{selected: item==comIdaBrCtl.selectedItem}" class="crop">
		<button id="commonIdaBrowse_button_#5080"  data-ng-hide="item.entityType === comIdaBrCtl.node_mailbox" data-ng-class="item.state | lowercase" data-ng-click="comIdaBrCtl.treeItemToggle(item)" ></button> 
		<span data-ng-show="item.entityType === comIdaBrCtl.node_mailbox" class="mailboxIcon" data-ng-click="comIdaBrCtl.treeItemToggle(item)"></span>
 		<span class="crop" data-ng-click="comIdaBrCtl.treeItemSelected(item)" data-ng-bind="item.label" title="{{item.label}}"></span>
	</div>
    <div class="children" data-ng-class="item.state">
         <div class="browse-item" data-ng-repeat="item in item.children" data-ng-include="'browseTree_item_renderer.html'"></div>
 			<a data-ng-show="item.partiallyLoaded===true" data-ng-click="comIdaBrCtl.loadMore(item)"><cv:msg key="label.showMore" bundle="browse" /></a>
    </div>
</script>
<script type="text/ng-template"  id="breadcrumbItem">
     <a data-ng-hide="$last" data-ng-click="item.browseEntity(item.node)">{{item.display}}</a>
    <span data-ng-show="$last">{{item.display}}</span>
</script>
<%-- This is the page message to display any error --%>
<span class="server-message {{comIdaBrCtl.pageMessage.type}}">{{comIdaBrCtl.pageMessage.message}}</span>
<div data-ng-show="comIdaBrCtl.browseModel">
  <h1 class="page-title" data-ng-hide="comIdaBrCtl.bTreeOnly === true" data-ng-if="!comIdaBrCtl.hideTitle()"><cv:msg key="label.backupContent" bundle="restore" /></h1>
  <span class="mailbox-browse-for-restore browse-for-restore margin-bottom  no-checkboxes" data-ng-if="!comIdaBrCtl.pageMessage.message">
	<!-- Root node. expandable to list of Users. Users expandable to show all folders. Drill down folders. -->
<span data-cv-loading-spinner data-ng-model="comIdaBrCtl.hideLoading"></span>
	<div class="browse-tree common-ida-browse-tree" data-ng-if="!comIdaBrCtl.hideTree()">
	<span class="server-message {{comIdaBrCtl.treeMessage.type}}">{{comIdaBrCtl.treeMessage.message}}</span>
		<div class="browse-item">
				<div data-ng-class="{selected: comIdaBrCtl.tree==comIdaBrCtl.selectedItem}" class="crop">
					<button id="commonIdaBrowse_button_#8779"  data-ng-hide="comIdaBrCtl.tree.entityType === comIdaBrCtl.node_mailbox" data-ng-class="comIdaBrCtl.tree.state | lowercase" data-ng-click="comIdaBrCtl.treeItemToggle(comIdaBrCtl.tree)"></button> 
					<span data-ng-show="comIdaBrCtl.tree.entityType === comIdaBrCtl.node_mailbox" class="mailboxIcon" data-ng-click="comIdaBrCtl.treeItemToggle(item)"></span>
					<span class="crop" data-ng-click="comIdaBrCtl.treeItemSelected(comIdaBrCtl.tree)" data-ng-bind="comIdaBrCtl.tree.label" title="{{comIdaBrCtl.tree.label}}"></span>
				</div>
				<div class="children" data-ng-class="comIdaBrCtl.tree.state">
					<div data-ng-repeat="item in comIdaBrCtl.tree.children" class="browse-item" data-ng-include="'browseTree_item_renderer.html'"></div>
				</div>
		</div>
		<a data-ng-show="comIdaBrCtl.tree.partiallyLoaded===true" data-ng-click="comIdaBrCtl.loadMore(comIdaBrCtl.tree)"><cv:msg key="label.showMore" bundle="browse" /></a>
	</div>
	<div  class="browse-table" data-ng-class="{'full-width-table': comIdaBrCtl.hideTree()}"  data-ng-hide="comIdaBrCtl.bTreeOnly === true" >
	<!-- Contents of selected item in left navigation.
	If root node is selected, show list of users
	If user is selected, show list of folders
	If folder is selected, show mails in the folder-->
	<span class="server-message {{comIdaBrCtl.tableMessage.type}}">{{comIdaBrCtl.tableMessage.message}}</span>
<!-- 		<div data-ng-show="comIdaBrCtl.selectedRows" > -->
<!-- 			<ul> -->
<!-- 				<li data-ng-repeat="model in comIdaBrCtl.selectedRows"> -->
<!-- 					<span>{{model.label}} {{model.path}}</span> -->
<!-- 				</li> -->
<!-- 			</ul> -->
<!-- 		</div> -->
	    <span id="browseActions" data-ng-if="!comIdaBrCtl.hideActions()">
	    		<span class="browse-input" data-ng-if="comIdaBrCtl.isSalesforceRecordRestore() && comIdaBrCtl.browseModel.salesforceTables">
		            <label  class="select-label">
						<b><cv:msg key="label.sfObject" bundle="capps"/></b>
						<select name="salesforceTable" data-ng-model="comIdaBrCtl.browseModel.salesforceTable" data-ng-change="comIdaBrCtl.tableItemSelected(comIdaBrCtl.browseModel.salesforceTable)" data-ng-options="tableItem.label for tableItem in comIdaBrCtl.browseModel.salesforceTables">
						</select>
					</label>
	    		</span>
	            <a href="" data-ng-if="!comIdaBrCtl.browseModel.isCompare" data-ng-click="comIdaBrCtl.doShowRestoreDialog()" class="btn btn-primary" data-ng-disabled="!comIdaBrCtl.restoreAllowed ">
	                <cv:msg key="label.restore" bundle="restore" />
	            </a>
	            <a href="" data-ng-if="comIdaBrCtl.showDownloadOption()" data-ng-click="comIdaBrCtl.doDownload()" class="btn btn-primary" data-ng-disabled="!comIdaBrCtl.restoreAllowed || comIdaBrCtl.selectedRows.length !== 1">
	                <cv:msg key="label.download" bundle="servers" />
	            </a>
	            <a href="" data-ng-if="!comIdaBrCtl.browseModel.isCompare && comIdaBrCtl.isSalesforceRecordRestore()" data-ng-click="comIdaBrCtl.doExport()" class="btn btn-primary" data-ng-disabled="!comIdaBrCtl.restoreAllowed ">
	                <cv:msg key="label.download" bundle="servers" />
	            </a>
	            <a href="" data-ng-if="comIdaBrCtl.browseModel.isCompare" data-ng-click="comIdaBrCtl.doShowCompareDialog()" class="btn btn-primary" data-ng-disabled="!comIdaBrCtl.isCompareAllowed()">
	                <cv:msg key="action.compare" bundle="capps" />
	            </a>
	            <div class="page-action-item" data-ng-if="comIdaBrCtl.cvIsAdvSearch">
                     <div data-ng-if="comIdaBrCtl.refreshAdvancedSearch">
                     	<cv-search-box query="comIdaBrCtl.cvAdvSearchOptions.query" on-search="comIdaBrCtl.cvAdvSearchOptions.onSearch(query, fields)" field-defs="comIdaBrCtl.cvAdvSearchOptions.fieldDefs" input-hint-text="{{comIdaBrCtl.searchInputPlaceHolderText}}"></cv-search-box>
                     </div>
                     <div data-ng-if="!comIdaBrCtl.refreshAdvancedSearch">
                     	<cv-search-box query="comIdaBrCtl.cvAdvSearchOptions.query" on-search="comIdaBrCtl.cvAdvSearchOptions.onSearch(query, fields)" field-defs="comIdaBrCtl.cvAdvSearchOptions.fieldDefs" input-hint-text="{{comIdaBrCtl.searchInputPlaceHolderText}}"></cv-search-box>
                     </div>
	            </div>
	             <div class="page-action-item">
	                <span class="uib-dropdown page-action-item-right-margin" on-toggle="toggled(open)" uib-dropdown>
	                      <a href class="uib-dropdown-toggle" uib-dropdown-toggle>
	                          {{comIdaBrCtl.timeRangeLabel}} <span class="dropdownArrow"></span>
	                      </a>
	                      <ul uib-dropdown-menu class="dropdown-menu">
	                        <li ><a href="" data-ng-click="comIdaBrCtl.updateTimeRange({})"><cv:msg key="Show_latest_backups" bundle="browse"/></a></li>
	                        <li cv-date-time heading-label="To Time" show-from-time=false result-function="comIdaBrCtl.updateTimeRange" skip-cv-utc-conversion="comIdaBrCtl.browseModel.skipCvUtcConversion"><a href=""><cv:msg key="Show_backups_specific_date" bundle="browse"/></a></li>
	                        <li cv-date-time heading-label="To Time" show-from-time=true result-function="comIdaBrCtl.updateTimeRange" skip-cv-utc-conversion="comIdaBrCtl.browseModel.skipCvUtcConversion"><a href=""><cv:msg key="Show_backups_date_range" bundle="browse"/></a></li>
	                      </ul>
	               </span>
	            </div>
	            <div class="page-action-item" data-ng-show="comIdaBrCtl.selectedItem.entityType == comIdaBrCtl.node_mail_folder">
	                <span class="uib-dropdown page-action-item-right-margin" on-toggle="toggled(open)" uib-dropdown>
	                 <a href="" class="uib-dropdown-toggle" uib-dropdown-toggle>
	                          <cv:msg key="label.browse.sorted.by" bundle="capps" params="{{comIdaBrCtl.currentSortParameters.MAILBOX_FOLDER.localeKey}}"/>
	                          <span data-ng-show="comIdaBrCtl.currentSortParameters.MAILBOX_FOLDER.sortOrder == 'asc'">&#x21E7;</span>
	                          <span data-ng-show="comIdaBrCtl.currentSortParameters.MAILBOX_FOLDER.sortOrder == 'desc'" >&#x21E9;</span>
	                      </a>
	                      <ul uib-dropdown-menu class="dropdown-menu">
	                        <li data-ng-repeat="sortOption in comIdaBrCtl.browseModel.externalSortOptions">
                                <a href="" data-ng-click="comIdaBrCtl.externalSortClicked(sortOption)"> {{sortOption.localeKey}}</a>
	                        </li>
	                      </ul>
	               </span>
	            </div>
	            <div class="page-action-item" data-ng-if="comIdaBrCtl.browseModel.showShowDeletedFiles">
	                <span class="uib-dropdown page-action-item-right-margin" on-toggle="toggled(open)" uib-dropdown>
	                      <a href class="uib-dropdown-toggle" uib-dropdown-toggle>
	                          {{comIdaBrCtl.showDeletedFilesLabel()}} <span class="dropdownArrow"></span>
	                      </a>
	                      <ul uib-dropdown-menu class="dropdown-menu">
	                        <li ><a href="" data-ng-click="comIdaBrCtl.toggleShowDeletedFiles(true)">{{comIdaBrCtl.browseModel.showDeletedFilesLabels.trueLabel}}</a></li>
	                        <li ><a href="" data-ng-click="comIdaBrCtl.toggleShowDeletedFiles(false)">{{comIdaBrCtl.browseModel.showDeletedFilesLabels.falseLabel}}</a></li>
	                      </ul>
	               </span>
	            </div>

	            <div class="page-action-item" data-ng-if="comIdaBrCtl.browseModel.showIncludeMetadata">
	                <span class="uib-dropdown page-action-item-right-margin" on-toggle="toggled(open)" uib-dropdown>
	                      <a href class="uib-dropdown-toggle" uib-dropdown-toggle>
	                          {{comIdaBrCtl.includeMetadataLabel()}} <span class="dropdownArrow"></span>
	                      </a>
	                      <ul uib-dropdown-menu class="dropdown-menu">
	                        <li ><a href="" data-ng-click="comIdaBrCtl.toggleIncludeMetadata(true)">{{comIdaBrCtl.browseModel.includeMetadataLabels.trueLabel}}</a></li>
	                        <li ><a href="" data-ng-click="comIdaBrCtl.toggleIncludeMetadata(false)">{{comIdaBrCtl.browseModel.includeMetadataLabels.falseLabel}}</a></li>
	                      </ul>
	               </span>
	            </div>
	            <div class="page-action-item" data-ng-if="comIdaBrCtl.browseModel.showQueryOptions">
	                <span class="uib-dropdown page-action-item-right-margin" on-toggle="toggled(open)" uib-dropdown>
	                      <a href class="uib-dropdown-toggle" uib-dropdown-toggle>
	                          {{comIdaBrCtl.queryOptionsLabel()}} <span class="dropdownArrow"></span>
	                      </a>
	                      <ul uib-dropdown-menu class="dropdown-menu">
	                        <li ><a href="" data-ng-click="comIdaBrCtl.toggleQueryOptions('LATEST')">{{comIdaBrCtl.browseModel.queryOptionsLabels.LatestLabel}}</a></li>
	                        <li ><a href="" data-ng-click="comIdaBrCtl.toggleQueryOptions('ALL')">{{comIdaBrCtl.browseModel.queryOptionsLabels.AllLabel}}</a></li>
	                        <li ><a href="" data-ng-click="comIdaBrCtl.toggleQueryOptions('DELETED')">{{comIdaBrCtl.browseModel.queryOptionsLabels.DeletedLabel}}</a></li>
	                      </ul>
	               </span>
	            </div>
	            <div class="page-action-item" data-ng-if="comIdaBrCtl.browseModel.showWhereCondition">
	                <span class="uib-dropdown page-action-item-right-margin" on-toggle="toggled(open)" uib-dropdown>
	                      <a href class="uib-dropdown-toggle" uib-dropdown-toggle>
	                          {{comIdaBrCtl.whereConditionLabel()}} <span class="dropdownArrow"></span>
	                      </a>
	                      <ul uib-dropdown-menu class="dropdown-menu">
	                        <li ><a href="" data-ng-click="comIdaBrCtl.toggleWhereCondition(true)">{{comIdaBrCtl.browseModel.whereConditionLabels.trueLabel}}</a></li>
	                        <li ><a href="" data-ng-click="comIdaBrCtl.toggleWhereCondition(false)">{{comIdaBrCtl.browseModel.whereConditionLabels.falseLabel}}</a></li>
	                      </ul>
	               </span>
	            </div>
	    </span>
		<span data-ng-if="!comIdaBrCtl.hideTree() && comIdaBrCtl.showCustomBreadcrumbs()">
				<ul class="breadcrumb" >
		            <span class="breadcrumbPathLabel"></span>
		               <li data-ng-repeat="item in comIdaBrCtl.breadcrumbModel"  >
		                   <a data-ng-hide="$last" data-ng-click="comIdaBrCtl.breadcrumbItemSelected(item.node)">{{item.display}}</a>
		                   <span data-ng-show="$last">{{item.display}}</span>
		                </li>
		        </ul>
	    </span>
<!-- 		<div data-ng-show="!browseData" class="error horz-center extra-top-padding" data-ng-bind="comIdaBrCtl.errorMessageToShow"></div> -->
		<div data-ng-if="!comIdaBrCtl.useCVGrid()" data-ng-show="browseData && browseData.length === 0" class="horz-center extra-top-padding"><span><cv:msg key="label.noBrowseContent" bundle="capps" /></span></div>
		<div data-ng-if="!comIdaBrCtl.useCVGrid()" data-ng-show="browseData && browseData.length > 0" data-ui-grid="comIdaBrCtl.gridOptions" data-ui-grid-pagination data-ui-grid-selection data-ui-grid-auto-resize data-cv-ui-grid-resize
							  class="grid-style users-grid">
		</div>
		<cv-grid data-ng-if="comIdaBrCtl.useCVGrid() && browseData" data-ng-show="!comIdaBrCtl.tableMessage.message" cv-grid-options="comIdaBrCtl.cvGridOptions">
		</cv-grid>
	</div>
  </span>
</div>
